/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import java.io.Serializable;
import java.security.PrivateKey;
import org.sourceid.saml20.domain.DecryptionPolicy;
import org.sourceid.saml20.domain.EncryptionPolicy;

public class EncryptionSettings
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String decryptionKeyAlias;
    private PkCert decryptionPkCert;
    private String secondaryDecryptionKeyAlias;
    private PkCert secondaryDecryptionPkCert;
    private Cert encryptionCert;
    private EncryptionPolicy encryptionPolicy = new EncryptionPolicy();
    private DecryptionPolicy decryptionPolicy = new DecryptionPolicy();

    public PrivateKey getDecryptionKey() {
        return this.decryptionPkCert != null ? this.decryptionPkCert.getPrivateKey() : null;
    }

    public PrivateKey getSecondaryDecryptionKey() {
        return this.secondaryDecryptionPkCert != null ? this.secondaryDecryptionPkCert.getPrivateKey() : null;
    }

    public PkCert getDecryptionPkCert() {
        return this.decryptionPkCert;
    }

    public void setDecryptionPkCert(PkCert decryptionPkCert) {
        this.decryptionPkCert = decryptionPkCert;
    }

    public String getDecryptionKeyAlias() {
        return this.decryptionKeyAlias;
    }

    public void setDecryptionKeyAlias(String decryptionKeyAlias) {
        this.decryptionKeyAlias = decryptionKeyAlias;
    }

    public Cert getEncryptionCert() {
        return this.encryptionCert;
    }

    public void setEncryptionCert(Cert encryptionCert) {
        this.encryptionCert = encryptionCert;
    }

    public EncryptionPolicy getEncryptionPolicy() {
        return this.encryptionPolicy;
    }

    public DecryptionPolicy getDecryptionPolicy() {
        return this.decryptionPolicy;
    }

    public String getSecondaryDecryptionKeyAlias() {
        return this.secondaryDecryptionKeyAlias;
    }

    public void setSecondaryDecryptionKeyAlias(String secondaryDecryptionKeyAlias) {
        this.secondaryDecryptionKeyAlias = secondaryDecryptionKeyAlias;
    }

    public PkCert getSecondaryDecryptionPkCert() {
        return this.secondaryDecryptionPkCert;
    }

    public void setSecondaryDecryptionPkCert(PkCert secondaryDecryptionPkCert) {
        this.secondaryDecryptionPkCert = secondaryDecryptionPkCert;
    }

    public EncryptionSettings clone() {
        EncryptionSettings clone = new EncryptionSettings();
        clone.decryptionKeyAlias = this.decryptionKeyAlias;
        clone.decryptionPkCert = this.decryptionPkCert != null ? new PkCert(this.decryptionPkCert) : null;
        clone.secondaryDecryptionKeyAlias = this.secondaryDecryptionKeyAlias;
        clone.secondaryDecryptionPkCert = this.secondaryDecryptionPkCert != null ? new PkCert(this.secondaryDecryptionPkCert) : null;
        clone.encryptionCert = this.encryptionCert != null ? new Cert(this.encryptionCert) : null;
        clone.encryptionPolicy = this.encryptionPolicy != null ? this.encryptionPolicy.clone() : null;
        clone.decryptionPolicy = this.decryptionPolicy != null ? this.decryptionPolicy.clone() : null;
        return clone;
    }
}

