/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.JDBCHelper;
import com.pingidentity.common.util.PropertyInfo;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.datasource.info.internal.JdbcInfo;
import org.sourceid.saml20.domain.datasource.tag.DataSourceTagUtil;
import org.sourceid.saml20.domain.datasource.tag.JdbcInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.JdbcTagConfig;

public class JdbcDataSource
extends DataSource
implements Cloneable,
Serializable {
    public static final String PF_DEFAULT_DATASTORE = "PFDefaultDS";
    public static final String PROVISIONER_DATASTORE = "ProvisionerDS";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(JdbcDataSource.class);
    public static final int DEFAULT_MIN_POOL_SIZE = 10;
    public static final int DEFAULT_MAX_POOL_SIZE = 100;
    public static final int DEFAULT_BLOCKING_TIMEOUT = 5000;
    public static final int DEFAULT_IDLE_TIMEOUT = 5;
    public static final String PARAM_NAME_FILTER = "filter";
    public static final String PARAM_NAME_TABLE = "tableName";
    public static final String PARAM_NAME_SCHEMA = "schema";
    public static final String PARAM_NAME_STORED_PROC = "storedProcedure";
    public static final String PARAM_NAME_COLUMN_NAMES = "columnNames";
    public static final String COLUMN_NAME_DELIMITER = ",";
    public static final String DATABASE_TYPE_CUSTOM = "Custom";
    private final JdbcInfo jdbcInfo = new JdbcInfo();
    private boolean available;
    private int minPoolSize = 10;
    private int maxPoolSize = 100;
    private int blockingTimeoutMillis = 5000;
    private int idleTimeoutMinutes = 5;
    private String checkValidConnectionSql = null;
    private String databaseType = "Custom";
    private boolean isMultiValueAttrsAllowed = true;
    private static final String SQL_SERVER_DRIVER_CLASSNAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String ORACLE_DRIVER_CLASSNAME = "oracle.jdbc.OracleDriver";
    private static final String MYSQL_DRIVER_CLASSNAME = "com.mysql.jdbc.Driver";
    private static final String POSTGRES_DRIVER_CLASSNAME = "org.postgresql.Driver";

    @Override
    public void setId(String id) {
        this.setJndiName(id);
    }

    public String getJndiName() {
        return this.getId();
    }

    public void setJndiName(String jndiName) {
        super.setId(jndiName);
        this.jdbcInfo.setJndiName(jndiName);
    }

    public String getConnectionUrlForNode() {
        JdbcInstanceIdentifier jdbcInstanceIdentifier = DataSourceTagUtil.findMatchingDataSource(this, (List<String>)PropertyInfo.getPingFederateNodeTags());
        return jdbcInstanceIdentifier.getJdbcUrl();
    }

    public String getConnectionUrl() {
        return this.jdbcInfo.getConnectionUrl();
    }

    public void setConnectionUrl(String connectionUrl) {
        this.jdbcInfo.setConnectionUrl(connectionUrl);
    }

    public String getDriverClass() {
        return this.jdbcInfo.getDriverClass();
    }

    public void setDriverClass(String driver) {
        this.jdbcInfo.setDriverClass(driver);
    }

    public String getPassword() {
        return this.jdbcInfo.getPassword();
    }

    public void setPassword(String password) {
        this.jdbcInfo.setPassword(password);
    }

    public String getUserName() {
        return this.jdbcInfo.getUserName();
    }

    public void setUserName(String userid) {
        this.jdbcInfo.setUserName(userid);
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public int getBlockingTimeoutMillis() {
        return this.blockingTimeoutMillis;
    }

    public void setBlockingTimeoutMillis(int blockingTimeoutMillis) {
        this.blockingTimeoutMillis = blockingTimeoutMillis;
    }

    public String getCheckValidConnectionSql() {
        return this.checkValidConnectionSql;
    }

    public void setCheckValidConnectionSql(String checkValidConnectionSql) {
        this.checkValidConnectionSql = checkValidConnectionSql;
    }

    public int getIdleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.idleTimeoutMinutes = idleTimeoutMinutes;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    @Override
    public String toString() {
        return this.jdbcInfo.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSchemas() {
        assert (this.available);
        ArrayList<String> schemas = new ArrayList<String>();
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = new JDBCHelper(this.getJndiName(), this);
            ResultSet resultSet = jdbcHelper.getSchemas();
            while (resultSet.next()) {
                schemas.add(resultSet.getString("TABLE_SCHEM"));
            }
            schemas.sort(String::compareToIgnoreCase);
        }
        catch (Exception e) {
            log.error((Object)("Request for schemas from " + this.getJndiName() + " failed. Error: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return schemas;
    }

    public List<String> getTables() {
        return this.getTables(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTables(String tableSchemaPattern) {
        assert (this.available);
        ArrayList<String> tableNames = new ArrayList<String>();
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = new JDBCHelper(this.getJndiName(), this);
            String[] tableTypes = new String[]{"TABLE", "SYSTEM TABLE", "VIEW"};
            ResultSet resultSet = jdbcHelper.getTablesByTableType(tableSchemaPattern, tableTypes);
            while (resultSet.next()) {
                String name = resultSet.getString("TABLE_NAME");
                if (name.startsWith("/")) continue;
                tableNames.add(name);
            }
            tableNames.sort(String::compareToIgnoreCase);
        }
        catch (Exception e) {
            log.error((Object)("Request for table list from " + this.getJndiName() + " failed. Error: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUnsortedColumns(String tableSchemaPattern, String tableNamePattern) {
        assert (this.available);
        ArrayList<String> colNames = new ArrayList<String>();
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = new JDBCHelper(this.getJndiName(), this);
            ResultSet resultSet = jdbcHelper.getColumns(tableSchemaPattern, tableNamePattern);
            while (resultSet.next()) {
                String resultSetSchemaName = resultSet.getString("TABLE_SCHEM");
                String resultSetTableName = resultSet.getString("TABLE_NAME");
                if ((tableSchemaPattern != null || resultSetSchemaName != null) && !resultSetSchemaName.equals(tableSchemaPattern) || (tableNamePattern != null || resultSetTableName != null) && !resultSetTableName.equals(tableNamePattern)) continue;
                colNames.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Request for columns list from " + this.getJndiName() + " failed. Error: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return colNames;
    }

    public List<String> getColumns(String tableSchemaPattern, String tableNamePattern) {
        List<String> colNames = this.getUnsortedColumns(tableSchemaPattern, tableNamePattern);
        colNames.sort(String::compareToIgnoreCase);
        return colNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultInfo> getUnsortedColumnsWithMetadata(String tableSchemaPattern, String tableNamePattern) {
        assert (this.available);
        ArrayList<ResultInfo> columns = new ArrayList<ResultInfo>();
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = new JDBCHelper(this.getJndiName(), this);
            ResultSet resultSet = jdbcHelper.getColumns(tableSchemaPattern, tableNamePattern);
            while (resultSet.next()) {
                ResultInfo info = new ResultInfo();
                info.setColumnName(resultSet.getString("COLUMN_NAME"));
                info.setDataType(resultSet.getInt("DATA_TYPE"));
                String typeName = resultSet.getString("TYPE_NAME");
                info.setTypeName(typeName);
                info.setColumnSize(resultSet.getInt("COLUMN_SIZE"));
                if (typeName.contains("identity") || "TIMESTAMP".equalsIgnoreCase(typeName)) {
                    info.setSystemManaged(true);
                }
                info.setNullable(resultSet.getString("IS_NULLABLE"));
                info.setOrdinalPosition(resultSet.getInt("ORDINAL_POSITION"));
                columns.add(info);
            }
        }
        catch (Exception e) {
            log.error((Object)("Request for columns list from " + this.getJndiName() + " failed. Error: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return columns;
    }

    public List<String> getColumns(String tableNamePattern) {
        return this.getColumns(null, tableNamePattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStoredProceduresForSchema(String schema) {
        JDBCHelper jdbcHelper = null;
        ArrayList<String> procedureNames = new ArrayList<String>();
        try {
            jdbcHelper = new JDBCHelper(this.getJndiName(), this);
            ResultSet resultSet = jdbcHelper.getStoredProceduresForSchema(schema);
            while (resultSet.next()) {
                String rawStoredProcedureName = resultSet.getString("PROCEDURE_NAME");
                String[] tokens = rawStoredProcedureName.split(";");
                String actualName = tokens[0];
                if (StringUtils.isBlank((String)actualName)) continue;
                procedureNames.add(actualName);
            }
            procedureNames.sort(String::compareToIgnoreCase);
        }
        catch (Exception e) {
            log.error((Object)("Request for stored procedure list from " + this.getJndiName() + " failed. Error: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return procedureNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultInfo> getUnsortedStoredProcedureColumnsWithMetadata(String schema, String storedProcedureName) {
        JDBCHelper jdbcHelper = null;
        ArrayList<ResultInfo> procedures = new ArrayList<ResultInfo>();
        try {
            jdbcHelper = new JDBCHelper(this.getJndiName(), this);
            ResultSet resultSet = jdbcHelper.getStoredProcedureColumns(schema, storedProcedureName);
            while (resultSet.next()) {
                int colType = resultSet.getInt("COLUMN_TYPE");
                if (colType != 1 && colType != 2) continue;
                ResultInfo info = new ResultInfo();
                info.setStoredProcedureName(resultSet.getString("PROCEDURE_NAME"));
                info.setColumnName(resultSet.getString("COLUMN_NAME"));
                info.setDataType(resultSet.getInt("DATA_TYPE"));
                info.setTypeName(resultSet.getString("TYPE_NAME"));
                info.setColumnSize(resultSet.getInt("PRECISION"));
                info.setNullable(resultSet.getString("IS_NULLABLE"));
                info.setOrdinalPosition(resultSet.getInt("ORDINAL_POSITION"));
                procedures.add(info);
            }
        }
        catch (Exception e) {
            log.error((Object)("Request for stored procedure list from " + this.getJndiName() + " failed. Error: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return procedures;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public JdbcDataSource getClone() {
        try {
            return (JdbcDataSource)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDataSourceType() {
        return DataSource.DSType.JDBC.getName();
    }

    @Override
    public DataSource.DSType getDSType() {
        return DataSource.DSType.JDBC;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    @Override
    public String getDescription() {
        String generatedDesc = "TODO";
        if (DATABASE_TYPE_CUSTOM.equalsIgnoreCase(this.databaseType)) {
            generatedDesc = StringUtils.isBlank((String)this.description) ? this.getConnectionUrl() : this.description;
        }
        return generatedDesc;
    }

    public boolean isEmbeddedHsqldb() {
        JdbcInstanceIdentifier jdbcInstanceIdentifier = DataSourceTagUtil.findMatchingDataSource(this, (List<String>)PropertyInfo.getPingFederateNodeTags());
        String connectionUrl = jdbcInstanceIdentifier.getJdbcUrl();
        return connectionUrl != null && connectionUrl.startsWith("jdbc:hsqldb:") && connectionUrl.contains("ProvisionerDefaultDB");
    }

    public boolean hasExpressProvSupport() {
        return this.isSqlServerDriver();
    }

    public boolean isSqlServerDriver() {
        return SQL_SERVER_DRIVER_CLASSNAME.equalsIgnoreCase(this.getDriverClass());
    }

    public boolean isOracleDriver() {
        return ORACLE_DRIVER_CLASSNAME.equalsIgnoreCase(this.getDriverClass());
    }

    public boolean isMySqlDriver() {
        return MYSQL_DRIVER_CLASSNAME.equalsIgnoreCase(this.getDriverClass());
    }

    public boolean isPostgresDriver() {
        return POSTGRES_DRIVER_CLASSNAME.equalsIgnoreCase(this.getDriverClass());
    }

    public boolean isMultiValueAttributesAllowed() {
        return this.isMultiValueAttrsAllowed;
    }

    public void setMultiValueAttributesAllowed(boolean multiValueAttrsAllowed) {
        this.isMultiValueAttrsAllowed = multiValueAttrsAllowed;
    }

    public List<JdbcTagConfig> getJdbcTagConfigList() {
        return this.jdbcInfo.getJdbcTagConfigList();
    }

    public void setJdbcTagConfigList(List<JdbcTagConfig> jdbcTagConfigList) {
        this.jdbcInfo.setJdbcTagConfigList(jdbcTagConfigList);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcDataSource object = (JdbcDataSource)o;
        if (this.getDataSourceType() != object.getDataSourceType()) {
            return false;
        }
        if (this.jdbcInfo != null ? !this.jdbcInfo.equals(object.jdbcInfo) : object.jdbcInfo != null) {
            return false;
        }
        if (this.available != object.available) {
            return false;
        }
        if (this.minPoolSize != object.minPoolSize) {
            return false;
        }
        if (this.maxPoolSize != object.maxPoolSize) {
            return false;
        }
        if (this.blockingTimeoutMillis != object.blockingTimeoutMillis) {
            return false;
        }
        if (this.idleTimeoutMinutes != object.idleTimeoutMinutes) {
            return false;
        }
        if (this.checkValidConnectionSql != null ? !this.checkValidConnectionSql.equals(object.checkValidConnectionSql) : object.checkValidConnectionSql != null) {
            return false;
        }
        if (this.isMultiValueAttrsAllowed != object.isMultiValueAttrsAllowed) {
            return false;
        }
        return this.databaseType.equals(object.getDatabaseType());
    }

    @Override
    public int hashCode() {
        int result = this.databaseType.hashCode();
        result = 32 * result + (this.available ? 1 : 0);
        result = 32 * result + this.minPoolSize;
        result = 32 * result + this.maxPoolSize;
        result = 32 * result + this.blockingTimeoutMillis;
        result = 32 * result + this.idleTimeoutMinutes;
        result = 32 * result + (this.checkValidConnectionSql != null ? this.checkValidConnectionSql.hashCode() : 0);
        result = 32 * result + (this.jdbcInfo != null ? this.jdbcInfo.hashCode() : 0);
        result = 32 * result + (this.isMultiValueAttrsAllowed ? 1 : 0);
        return result;
    }
}

