/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.Substituter;
import com.pingidentity.common.util.ldap.ConnectionInfo;
import com.pingidentity.common.util.ldap.LDAPPasswordPolicy;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import com.pingidentity.common.util.ldap.passwordvalidator.LDAPPasswordPolicyViolationException;
import com.pingidentity.lightning.rawldap.internal.model.DirectLdapSearchesThenOpRequest;
import com.pingidentity.lightning.rawldap.internal.model.DirectLdapSearchesThenOpResponse;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.account.AccountUnlockablePasswordCredential;
import com.pingidentity.sdk.locale.Message;
import com.pingidentity.sdk.password.AttributeLookupException;
import com.pingidentity.sdk.password.AttributeRetrievablePasswordCredential;
import com.pingidentity.sdk.password.ChangeablePasswordCredential;
import com.pingidentity.sdk.password.PasswordChangeResult;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordPolicyRequirementResetException;
import com.pingidentity.sdk.password.PasswordResetException;
import com.pingidentity.sdk.password.PasswordValidationException;
import com.pingidentity.sdk.password.RecoverableUsername;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import com.pingidentity.sdk.password.UsernameRecoveryException;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.SearchRequest;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.StringSubstituter;
import org.sourceid.common.Util;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.LdapAuthenticationErrorFieldDescriptor;
import org.sourceid.saml20.adapter.gui.LdapDatastoreFieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.LDAPPasswordCredentialValidatorResult;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class LDAPUsernamePasswordCredentialValidator
implements PasswordCredentialValidator,
ChangeablePasswordCredential,
ResettablePasswordCredential,
AccountUnlockablePasswordCredential,
RecoverableUsername,
ServiceInformation,
AttributeRetrievablePasswordCredential {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String TYPE = "LDAP Username Password Credential Validator";
    private static final String DESCRIPTION = "This password credential validator provides a means of verifying credentials stored in a directory server via the LDAP protocol. Additional user attributes from the directory can also be returned by this PCV by adding the desired attribute names to the Extended Contract.";
    private static final String AUTHN_ERRORS_TABLE_NAME = "Authentication Error Overrides";
    private static final String AUTH_ERRORS_TABLE_DESCR = "A table of LDAP authentication error codes and customized matching expressions that will match the error code to an LDAP error message.  These entries override the default individual mappings of messages to codes.  Use the localization features to customize the error messages displayed to end users.";
    private static final String ERROR_ID_FIELD_NAME = "Error";
    private static final String ERROR_ID_FIELD_DESCR = "";
    private static final String MATCH_EXPR_FIELD_NAME = "Match Expression";
    private static final String MATCH_EXPR_FIELD_DESCR = "The expression matched against the LDAP error message returned by the server.";
    private static final String MSG_KEY_FIELD_NAME = "Message Properties Key";
    private static final String MSG_KEY_FIELD_DESCR = "If you have chosen the 'Use Message Properties Key' Error type, enter a key or text here. If not, leave this value empty. For proper localization, a matching key should be present in the message localization file. Otherwise, the text here will be displayed.";
    private static final int COUNT_LIMIT = 1;
    private static final String FIELD_SEARCH_FILTER_TRIM_USERNAME_SPACES = "Trim Username Spaces For Search";
    private static final String FIELD_SEARCH_FILTER = "Search Filter";
    private static final String FIELD_SEARCH_BASE = "Search Base";
    private static final String FIELD_MAIL_SEARCH_FILTER = "Mail Search Filter";
    private static final String FIELD_LDAP_DATA_SOURCE = "LDAP Datastore";
    private static final String FIELD_SCOPE = "Scope of Search";
    private static final String FIELD_DISPLAY_NAME_ATTRIBUTE = "Display Name Attribute";
    private static final String FIELD_EMAIL_ATTRIBUTE = "Mail Attribute";
    private static final String FIELD_SMS_ATTRIBUTE = "SMS Attribute";
    private static final String FIELD_MAIL_VERIFIED_ATTRIBUTE = "Mail Verified Attribute";
    private static final String FIELD_ACCOUNT_DISABLED_ATTRIBUTE = "Account Disabled Attribute";
    private static final String FIELD_PINGID_USERNAME_ATTRIBUTE = "PingID Username Attribute";
    private static final String FIELD_USERNAME_ATTRIBUTE = "Username Attribute";
    private static final String FIELD_ENABLE_PING_DIR_DETAILED_PWD_REQ_MSG = "Enable PingDirectory Detailed Password Policy Requirement Messaging";
    private static final String ONE_LEVEL_TYPE = "One Level";
    private static final String SUBTREE_TYPE = "Subtree";
    private static final String FIELD_ENABLE_CASE_SENSITIVE = "Case-Sensitive Matching";
    private static final String FIELD_EXPECT_PASSWORD_EXPIRED_CONTROL = "Expect Password Expired Control";
    private static final String SEARCH_FILTER_TRIM_USERNAME_SPACES_DESCR = "Removes leading and trailing spaces from the username used in the search filter and in the returned username attribute.";
    private static final String LDAP_DATA_SOURCE_DESCR = "Select the LDAP Datastore.";
    private static final String SEARCH_FILTER_DESCR = "You may use ${username} as part of the query. Example (for Active Directory): sAMAccountName=${username}.";
    private static final String MAIL_SEARCH_FILTER_DESCR = "For username recovery, you may use ${mail} as part of the query. Example (for Active Directory): mail=${mail}.";
    private static final String SEARCH_BASE_DESCR = "The location in the directory from which the LDAP search begins.";
    private static final String DISPLAY_NAME_ATTRIBUTE_DESCR = "For password reset, account unlock and username recovery, the LDAP attribute used for personalizing messages to the user. Default: displayName.";
    private static final String EMAIL_ATTRIBUTE_DESCR = "For password reset, the LDAP attribute containing the email address used for notifications and email based password reset. Note that the attribute should correspond to the attribute specified in 'Mail Search Filter'. Default: mail.";
    private static final String SMS_ATTRIBUTE_DESCR = "For password reset, the LDAP attribute containing the phone number to use for SMS based password reset.";
    private static final String PINGID_USERNAME_ATTRIBUTE_DESCR = "For password reset, the LDAP attribute containing the username to use for PingID based password reset.";
    private static final String USERNAME_ATTRIBUTE_DESCR = "For username recovery, the LDAP attribute containing the username to send to the user. Note that the attribute should correspond to the attribute specified in 'Search Filter'.";
    private static final String MAIL_VERIFIED_ATTRIBUTE_DESCR = "For password reset, account unlock and username recovery, the boolean LDAP attribute indicating that the user's email address has been verified.";
    private static final String ACCOUNT_DISABLED_ATTRIBUTE_DESCR = "For password reset and account unlock, the boolean LDAP attribute that indicates whether the user's account is disabled. For example, 'ds-pwp-account-disabled' is the default PingDirectory attribute. PingFederate does not use this field's value when Microsoft Active Directory is the datastore.";
    private static final String ENABLE_PING_DIR_DETAILED_PWD_REQ_MSG_DESCR = "For password change via a PCV backed by PingDirectory, enable detailed password policy violation messages to be returned to the presentation layer, such as the HTML Form Adapter.";
    private static final String EXPECT_PASSWORD_EXPIRED_CONTROL_DESCR = "Whether the LDAP Datastore is expected to return the Password Expired Control when valid credentials are presented but the user's password has expired. If this is the case, then PingFederate can use the presence of this control in the bind response to the distinguish the case of expired password with valid credentials from expired password with invalid credentials.";
    private static final boolean DEFAULT_VALUE_ENABLE_PING_DIR_DETAILED_PWD_REQ = false;
    private static final String DESC_ENABLE_CASE_SENSITIVE = "Allows case-sensitive expression and LDAP error matching.";
    private static final String DN = "DN";
    private static final boolean DEFAULT_VALUE_ENABLE_CASE_SENSITIVE = true;
    private static final String DEFAULT_VALUE_DISPLAY_NAME_ATTRIBUTE = "displayName";
    private static final String DEFAULT_EMAIL_ATTRIBUTE = "mail";
    private static final RequiredFieldValidator REQUIRED_FIELD_VALIDATOR = new RequiredFieldValidator();
    private static final String USER_NOT_FOUND = "User not found";
    public static final String ERROR_MSG_PASSWORD_CONSTRAINT = "forgot-password-change.doesNotMatchPasswordConstraint";
    private Configuration configuration = null;
    private final PluginDescriptor descriptor;
    private List<CustomAuthorizationError> customAuthnErrors = new ArrayList<CustomAuthorizationError>();
    private boolean enableCaseSensitiveMatch = true;
    private boolean enablePingDirectoryDetailedPwdReqField = true;

    public LDAPUsernamePasswordCredentialValidator() {
        GuiConfigDescriptor guiDescriptor = new GuiConfigDescriptor();
        guiDescriptor.setDescription(DESCRIPTION);
        this.addConfigurationFields(guiDescriptor);
        this.descriptor = new PluginDescriptor(TYPE, (ConfigurablePlugin)this, guiDescriptor, "1.1");
        HashSet<String> attributes = new HashSet<String>();
        attributes.add("username");
        attributes.add(DN);
        attributes.add("givenName");
        attributes.add(DEFAULT_EMAIL_ATTRIBUTE);
        this.descriptor.setAttributeContractSet(attributes);
        this.descriptor.setSupportsExtendedContract(true);
        this.descriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public String getServiceName() {
        return "ldap-credential-validator";
    }

    public void configure(Configuration configuration) {
        Field caseSensitiveField;
        this.configuration = configuration;
        this.customAuthnErrors = new ArrayList<CustomAuthorizationError>();
        Table authErrorTable = configuration.getTable(AUTHN_ERRORS_TABLE_NAME);
        if (authErrorTable != null && authErrorTable.getRows() != null) {
            for (Row authErrorRow : authErrorTable.getRows()) {
                String errorId = authErrorRow.getFieldValue(ERROR_ID_FIELD_NAME);
                String expr = authErrorRow.getFieldValue(MATCH_EXPR_FIELD_NAME);
                String msgKey = authErrorRow.getFieldValue(MSG_KEY_FIELD_NAME);
                CustomAuthorizationError customAuthnError = new CustomAuthorizationError(errorId, expr, msgKey);
                this.customAuthnErrors.add(customAuthnError);
            }
        }
        if ((caseSensitiveField = configuration.getField(FIELD_ENABLE_CASE_SENSITIVE)) != null) {
            this.enableCaseSensitiveMatch = caseSensitiveField.getValueAsBoolean();
        }
        String sourceId = configuration.getFieldValue(FIELD_LDAP_DATA_SOURCE);
        try {
            LdapDataSource ldapDataSource = this.getDataSourceHelper(sourceId);
            if (ldapDataSource.isPingDirectoryOrPingDSType()) {
                this.enablePingDirectoryDetailedPwdReqField = configuration.getBooleanFieldValue(FIELD_ENABLE_PING_DIR_DETAILED_PWD_REQ_MSG, false);
            }
        }
        catch (RuntimeException e) {
            this.log.debug((Object)e.getLocalizedMessage());
        }
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.descriptor;
    }

    public GuiConfigDescriptor addConfigurationFields(GuiConfigDescriptor descriptor) {
        TableDescriptor authnErrorsTable = new TableDescriptor(AUTHN_ERRORS_TABLE_NAME, AUTH_ERRORS_TABLE_DESCR);
        descriptor.addTable(authnErrorsTable);
        TextFieldDescriptor matchExpressionField = new TextFieldDescriptor(MATCH_EXPR_FIELD_NAME, MATCH_EXPR_FIELD_DESCR);
        matchExpressionField.addValidator((FieldValidator)new RequiredFieldValidator());
        matchExpressionField.setSize(50);
        matchExpressionField.addValidator(this.getExpressionValidator());
        authnErrorsTable.addRowField((FieldDescriptor)matchExpressionField);
        LdapAuthenticationErrorFieldDescriptor errorCodeField = new LdapAuthenticationErrorFieldDescriptor(ERROR_ID_FIELD_NAME, ERROR_ID_FIELD_DESCR);
        errorCodeField.addValidator((FieldValidator)new RequiredFieldValidator());
        authnErrorsTable.addRowField((FieldDescriptor)errorCodeField);
        TextFieldDescriptor msgKeyField = new TextFieldDescriptor(MSG_KEY_FIELD_NAME, MSG_KEY_FIELD_DESCR);
        authnErrorsTable.addRowField((FieldDescriptor)msgKeyField);
        authnErrorsTable.addValidator(this::authnErrorOverrideTableRowValidator);
        LdapDatastoreFieldDescriptor fieldDescriptor = new LdapDatastoreFieldDescriptor(FIELD_LDAP_DATA_SOURCE, LDAP_DATA_SOURCE_DESCR);
        fieldDescriptor.addValidator((FieldValidator)REQUIRED_FIELD_VALIDATOR);
        descriptor.addField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor(FIELD_SEARCH_BASE, SEARCH_BASE_DESCR);
        fieldDescriptor.addValidator((FieldValidator)REQUIRED_FIELD_VALIDATOR);
        descriptor.addField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor(FIELD_SEARCH_FILTER, SEARCH_FILTER_DESCR);
        fieldDescriptor.addValidator((FieldValidator)REQUIRED_FIELD_VALIDATOR);
        descriptor.addField((FieldDescriptor)fieldDescriptor);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> scopes = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        scopes.add(new AbstractSelectionFieldDescriptor.OptionValue(ONE_LEVEL_TYPE, ONE_LEVEL_TYPE));
        scopes.add(new AbstractSelectionFieldDescriptor.OptionValue(SUBTREE_TYPE, SUBTREE_TYPE));
        fieldDescriptor = new RadioGroupFieldDescriptor(FIELD_SCOPE, ERROR_ID_FIELD_DESCR, scopes);
        fieldDescriptor.setDefaultValue(SUBTREE_TYPE);
        descriptor.addField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor(FIELD_DISPLAY_NAME_ATTRIBUTE, DISPLAY_NAME_ATTRIBUTE_DESCR);
        fieldDescriptor.setDefaultValue(DEFAULT_VALUE_DISPLAY_NAME_ATTRIBUTE);
        descriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor(FIELD_EMAIL_ATTRIBUTE, EMAIL_ATTRIBUTE_DESCR);
        fieldDescriptor.setDefaultValue(DEFAULT_EMAIL_ATTRIBUTE);
        descriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor(FIELD_SMS_ATTRIBUTE, SMS_ATTRIBUTE_DESCR);
        descriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor(FIELD_PINGID_USERNAME_ATTRIBUTE, PINGID_USERNAME_ATTRIBUTE_DESCR);
        descriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor(FIELD_MAIL_SEARCH_FILTER, MAIL_SEARCH_FILTER_DESCR);
        descriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor(FIELD_USERNAME_ATTRIBUTE, USERNAME_ATTRIBUTE_DESCR);
        descriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        CheckBoxFieldDescriptor trimUsernameSpacesCheckBoxField = new CheckBoxFieldDescriptor(FIELD_SEARCH_FILTER_TRIM_USERNAME_SPACES, SEARCH_FILTER_TRIM_USERNAME_SPACES_DESCR);
        trimUsernameSpacesCheckBoxField.setDefaultValue(true);
        trimUsernameSpacesCheckBoxField.setDefaultForLegacyConfig(Boolean.toString(false));
        descriptor.addAdvancedField((FieldDescriptor)trimUsernameSpacesCheckBoxField);
        fieldDescriptor = new TextFieldDescriptor(FIELD_MAIL_VERIFIED_ATTRIBUTE, MAIL_VERIFIED_ATTRIBUTE_DESCR);
        descriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor(FIELD_ACCOUNT_DISABLED_ATTRIBUTE, ACCOUNT_DISABLED_ATTRIBUTE_DESCR);
        descriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new CheckBoxFieldDescriptor(FIELD_ENABLE_PING_DIR_DETAILED_PWD_REQ_MSG, ENABLE_PING_DIR_DETAILED_PWD_REQ_MSG_DESCR);
        fieldDescriptor.setDefaultValue(Boolean.TRUE.toString());
        fieldDescriptor.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        descriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        CheckBoxFieldDescriptor enableCaseSensitiveField = new CheckBoxFieldDescriptor(FIELD_ENABLE_CASE_SENSITIVE, DESC_ENABLE_CASE_SENSITIVE);
        enableCaseSensitiveField.setDefaultValue(true);
        enableCaseSensitiveField.setDefaultForLegacyConfig(Boolean.toString(true));
        descriptor.addField((FieldDescriptor)enableCaseSensitiveField);
        CheckBoxFieldDescriptor expectPasswordExpiredControlField = new CheckBoxFieldDescriptor(FIELD_EXPECT_PASSWORD_EXPIRED_CONTROL, EXPECT_PASSWORD_EXPIRED_CONTROL_DESCR);
        expectPasswordExpiredControlField.setDefaultValue(false);
        expectPasswordExpiredControlField.setDefaultForLegacyConfig(Boolean.toString(false));
        descriptor.addAdvancedField((FieldDescriptor)expectPasswordExpiredControlField);
        descriptor.addValidator(this::checkConfiguration);
        return descriptor;
    }

    private FieldValidator getExpressionValidator() {
        return new FieldValidator(){
            private static final long serialVersionUID = 20121113L;

            public void validate(Field field) throws ValidationException {
                try {
                    String value = field.getValue();
                    Util.wildCardMatch(LDAPUsernamePasswordCredentialValidator.ERROR_ID_FIELD_DESCR, value, true);
                }
                catch (PatternSyntaxException ex) {
                    throw new ValidationException("Invalid match expression " + field.getValue());
                }
            }
        };
    }

    public AttributeMap processPasswordCredential(String username, String password) throws PasswordValidationException {
        if (StringUtils.isBlank((String)password)) {
            return null;
        }
        LdapDataSource datasource = this.getDataSource();
        try {
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
            LDAPUtilOptions ldapOptions = this.buildLdapOptions(username, true, datasource.getLdapType().toString());
            DirectLdapSearchesThenOpRequest combinedRequests = this.buildSearchThenOperationRequest(username, password, ldapOptions);
            DirectLdapSearchesThenOpResponse combinedResponses = ldapUtil.searchesThenOp(combinedRequests);
            return this.dealWithCombinedResponses(ldapUtil, combinedResponses, datasource, ldapOptions, username);
        }
        catch (NamingException e) {
            LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getByExplanation(this, e.getExplanation(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
            result.raiseException(e, datasource.getId(), result.getResultEnum());
            return null;
        }
    }

    private AttributeMap dealWithCombinedResponses(LDAPUtil ldapUtil, DirectLdapSearchesThenOpResponse combinedResponses, LdapDataSource dataSource, LDAPUtilOptions ldapOptions, String username) {
        try {
            AttributeMap userAttributes = ldapUtil.processSearchesThenOpResponse(combinedResponses, dataSource, ldapOptions, this.isTrimUsernameSpacesConfigured(), username);
            if (userAttributes == null) {
                LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getByEnum(this, AuthenticationResultEnum.USER_NOT_FOUND);
                result.raiseException(dataSource.getId(), result.getResultEnum());
            }
            return userAttributes;
        }
        catch (NamingException e) {
            LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getByExplanation(this, e.getExplanation(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
            result.raiseException(e, dataSource.getId(), result.getResultEnum());
            return null;
        }
    }

    private LDAPUtilOptions buildLdapOptions(String username, boolean isPasswordPendingNotifiable, String ldapServerType) {
        String usernameForFilter = this.isTrimUsernameSpacesConfigured() ? LDAPUtil.stripSpaces(username) : username;
        String filter = this.substituteFilter(LDAPUtil.encodeFilter(usernameForFilter));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("search " + filter));
        }
        HashSet<String> attrsNames = new HashSet<String>(this.configuration.getAdditionalAttrNames());
        attrsNames.add("Subject DN");
        attrsNames.add("givenName");
        attrsNames.add(this.getMailAttribute());
        LDAPPasswordPolicy passwordPolicyType = LDAPPasswordPolicy.canonicalName(ldapServerType);
        if (passwordPolicyType != null && isPasswordPendingNotifiable) {
            attrsNames.add(passwordPolicyType.getUserPasswordPolicyDnAttributeName());
            attrsNames.add(passwordPolicyType.getPasswordChangeTimeAttributeName());
            if (passwordPolicyType.equals((Object)LDAPPasswordPolicy.AD_PSO_TYPE)) {
                attrsNames.add("msDS-UserPasswordExpiryTimeComputed");
            }
            if (passwordPolicyType.equals((Object)LDAPPasswordPolicy.PING_DIRECTORY_ID_TYPE) || passwordPolicyType.equals((Object)LDAPPasswordPolicy.PING_DS_ID_TYPE)) {
                attrsNames.add("ds-pwp-state-json");
            }
        }
        String[] attributeNames = attrsNames.toArray(new String[0]);
        String searchBase = this.getSearchBase();
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(searchBase, filter, this.getSearchScope());
        ldapOptions.setAttributes(attributeNames);
        ldapOptions.setCount(1);
        ldapOptions.setExpectPasswordExpiryControl(this.isExpectPasswordExpiredControl());
        return ldapOptions;
    }

    private DirectLdapSearchesThenOpRequest buildSearchThenOperationRequest(String username, String password, LDAPUtilOptions ldapOptions) {
        try {
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
            DirectLdapSearchesThenOpRequest directLdapSearchesThenOpRequest = new DirectLdapSearchesThenOpRequest();
            SearchRequest searchRequest = ldapUtil.buildAttributesOfMatchingObjectsSearchRequest(ldapOptions);
            directLdapSearchesThenOpRequest.setSearchRequests(new SearchRequest[]{searchRequest});
            LDAPRequest authenticateRequest = ldapUtil.buildAuthenticateRequest(username, password);
            directLdapSearchesThenOpRequest.setPostSearchRequest(authenticateRequest);
            return directLdapSearchesThenOpRequest;
        }
        catch (NamingException e) {
            LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getByExplanation(this, e.getExplanation(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
            result.raiseException(e, this.getDataSource().getId(), result.getResultEnum());
            return null;
        }
    }

    private String getFilter() {
        return this.configuration.getFieldValue(FIELD_SEARCH_FILTER);
    }

    private String getMailFilter() {
        return this.configuration.getFieldValue(FIELD_MAIL_SEARCH_FILTER);
    }

    private String substituteFilter(String username) {
        String filter;
        try {
            filter = Substituter.substituteValues(this.getFilter(), Collections.singletonMap("username", username));
        }
        catch (StringSubstituter.UnRecognizedKeyException e) {
            throw new PasswordValidationException("Incorrect filter: " + this.getFilter() + ". Filter may only contain ${username} variable for substitution");
        }
        return filter;
    }

    private String substituteMailFilter(String mail) {
        String filter;
        try {
            filter = Substituter.substituteValues(this.getMailFilter(), Collections.singletonMap(DEFAULT_EMAIL_ATTRIBUTE, mail));
        }
        catch (StringSubstituter.UnRecognizedKeyException e) {
            throw new UsernameRecoveryException("Incorrect filter: " + this.getMailFilter() + ". Filter may only contain ${mail} variable for substitution");
        }
        return filter;
    }

    public String getSearchBase() {
        return this.configuration.getFieldValue(FIELD_SEARCH_BASE);
    }

    private int getSearchScope() {
        if (ONE_LEVEL_TYPE.equals(this.configuration.getFieldValue(FIELD_SCOPE))) {
            return 1;
        }
        return 2;
    }

    public String getNameAttribute() {
        String displayNameAttribute = this.configuration.getFieldValue(FIELD_DISPLAY_NAME_ATTRIBUTE);
        if (StringUtils.isNotBlank((String)displayNameAttribute)) {
            return displayNameAttribute;
        }
        return DEFAULT_VALUE_DISPLAY_NAME_ATTRIBUTE;
    }

    public String getUsernameAttribute() {
        return this.configuration.getFieldValue(FIELD_USERNAME_ATTRIBUTE);
    }

    public String getMailVerifiedAttribute() {
        return this.configuration.getFieldValue(FIELD_MAIL_VERIFIED_ATTRIBUTE);
    }

    public ResettablePasswordCredential.AccountEnabledStatus getAccountEnabledStatus(AttributeMap attributeMap) {
        LdapDataSource dataSource = this.getDataSource();
        if (dataSource.isActiveDirectoryType()) {
            Boolean adUserDisabled = this.isAdUserDisabled(attributeMap);
            if (adUserDisabled == null) {
                return ResettablePasswordCredential.AccountEnabledStatus.UNDEFINED;
            }
            return adUserDisabled != false ? ResettablePasswordCredential.AccountEnabledStatus.DISABLED : ResettablePasswordCredential.AccountEnabledStatus.ENABLED;
        }
        String accountDisabledAttribute = this.configuration.getFieldValue(FIELD_ACCOUNT_DISABLED_ATTRIBUTE);
        if (StringUtils.isNotBlank((String)accountDisabledAttribute)) {
            return Boolean.parseBoolean(attributeMap.getSingleValue(accountDisabledAttribute)) ? ResettablePasswordCredential.AccountEnabledStatus.DISABLED : ResettablePasswordCredential.AccountEnabledStatus.ENABLED;
        }
        return ResettablePasswordCredential.AccountEnabledStatus.UNDEFINED;
    }

    public String getMailAttribute() {
        String mail = this.configuration.getFieldValue(FIELD_EMAIL_ATTRIBUTE);
        if (StringUtils.isNotBlank((String)mail)) {
            return mail;
        }
        return DEFAULT_EMAIL_ATTRIBUTE;
    }

    public String getSmsAttribute() {
        return this.configuration.getFieldValue(FIELD_SMS_ATTRIBUTE);
    }

    public String getPingIdUsernameAttribute() {
        return this.configuration.getFieldValue(FIELD_PINGID_USERNAME_ATTRIBUTE);
    }

    public LdapDataSource getDataSource() {
        String sourceId = this.configuration.getFieldValue(FIELD_LDAP_DATA_SOURCE);
        return this.getDataSourceHelper(sourceId);
    }

    private LdapDataSource getDataSourceHelper(String sourceId) {
        DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
        LdapDataSource ldapDataSource = dataSourceManager.getLdapDataSource(sourceId);
        if (ldapDataSource == null) {
            throw new RuntimeException("No LDAP Data Source with id " + sourceId);
        }
        return ldapDataSource;
    }

    private ConnectionInfo getConnectionInfo() {
        return this.getDataSource().getConnectionInfo();
    }

    public void checkConfiguration(Configuration configuration) throws ValidationException {
        LinkedList<String> errorsList = new LinkedList<String>();
        try {
            LDAPUtil.checkFilter(configuration.getFieldValue(FIELD_SEARCH_FILTER));
        }
        catch (ValidationException e) {
            errorsList.addAll(e.getErrorMessages());
        }
        try {
            LDAPUtil.checkMailFilter(configuration.getFieldValue(FIELD_MAIL_SEARCH_FILTER));
        }
        catch (ValidationException e) {
            errorsList.addAll(e.getErrorMessages());
        }
        boolean caseSensitive = true;
        Field caseSensitiveField = configuration.getField(FIELD_ENABLE_CASE_SENSITIVE);
        if (caseSensitiveField != null) {
            caseSensitive = caseSensitiveField.getValueAsBoolean();
        }
        Table authErrorTable = configuration.getTable(AUTHN_ERRORS_TABLE_NAME);
        this.checkTableConfig(errorsList, caseSensitive, authErrorTable, MATCH_EXPR_FIELD_NAME);
        if (!errorsList.isEmpty()) {
            throw new ValidationException(errorsList);
        }
    }

    private void checkTableConfig(List<String> errorList, boolean caseSensitive, Table authErrorTable, String matchExprFieldName) {
        if (authErrorTable != null && authErrorTable.getRows() != null) {
            HashMap<String, Boolean> expressionsErrorReportedMap = new HashMap<String, Boolean>();
            for (Row authErrorRow : authErrorTable.getRows()) {
                String expr = authErrorRow.getFieldValue(matchExprFieldName);
                if (!caseSensitive) {
                    expr = expr.toLowerCase();
                }
                if (expressionsErrorReportedMap.containsKey(expr) && !((Boolean)expressionsErrorReportedMap.get(expr)).booleanValue()) {
                    errorList.add("Duplicate expression: '" + authErrorRow.getFieldValue(matchExprFieldName) + "'.");
                    expressionsErrorReportedMap.put(expr, true);
                }
                if (expressionsErrorReportedMap.containsKey(expr)) continue;
                expressionsErrorReportedMap.put(expr, false);
            }
        }
    }

    private void authnErrorOverrideTableRowValidator(FieldList fieldsInRow) throws ValidationException {
        LinkedList<String> errorList = new LinkedList<String>();
        String errorId = fieldsInRow.getFieldValue(ERROR_ID_FIELD_NAME);
        if (!"use.message.properties.key".equals(errorId) && StringUtils.isNotEmpty((String)fieldsInRow.getFieldValue(MSG_KEY_FIELD_NAME))) {
            errorList.add("You have entered a value in 'Message Properties Key'. If you wish to use this value please choose 'Use Message Properties Key' from the Error drop-down. Otherwise, clear the 'Message Properties Key' to use the predefined message.");
        }
        if ("use.message.properties.key".equals(errorId) && StringUtils.isEmpty((String)fieldsInRow.getFieldValue(MSG_KEY_FIELD_NAME))) {
            errorList.add("Please enter a value in the 'Message Properties Key' input box when using the 'Use Message Properties Key' Error type.");
        }
        if (!errorList.isEmpty()) {
            throw new ValidationException(errorList);
        }
    }

    private String getDistinguishedNameFromUserAttributes(String username) {
        AttributeMap userAttributes = this.getAttributesWithUsername(username, false);
        return this.getDistinguishedName(userAttributes);
    }

    private String getDistinguishedName(AttributeMap attributes) {
        AttributeValue attributeValue = (AttributeValue)attributes.remove((Object)"Subject DN");
        return attributeValue != null ? attributeValue.getValue(null) : null;
    }

    private AttributeMap getAttributesWithUsername(String username, boolean isPasswordPendingNotifiable) {
        try {
            String ldapType = this.getDataSource().getLdapType().toString();
            LDAPUtilOptions ldapOptions = this.buildLdapOptions(username, isPasswordPendingNotifiable, ldapType);
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
            List<AttributeMap> searchResults = ldapUtil.getUserAttributesForMatchingObjects(ldapOptions, ldapType, this.isTrimUsernameSpacesConfigured(), username);
            if (Util.isEmpty(searchResults) || searchResults.size() > 1) {
                if (searchResults.size() > 1) {
                    this.log.error((Object)"User lookup returned more than one LDAP entry");
                }
                LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getByEnum(this, AuthenticationResultEnum.USER_NOT_FOUND);
                result.raiseException(this.getDataSource().getId(), result.getResultEnum());
            }
            return searchResults.get(0);
        }
        catch (NamingException e) {
            LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getByExplanation(this, e.getExplanation(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
            result.raiseException(e, this.getDataSource().getId(), result.getResultEnum());
            return null;
        }
    }

    private boolean isTrimUsernameSpacesConfigured() {
        return this.configuration.getBooleanFieldValue(FIELD_SEARCH_FILTER_TRIM_USERNAME_SPACES);
    }

    private boolean isExpectPasswordExpiredControl() {
        return this.configuration.getBooleanFieldValue(FIELD_EXPECT_PASSWORD_EXPIRED_CONTROL);
    }

    public PasswordChangeResult changePassword(String username, String oldPassword, String newPassword, Map<String, Object> inParameters) {
        LdapDataSource dataSource = this.getDataSource();
        try {
            LDAPUtil ldapUtil = LDAPUtil.newInstance(dataSource.getConnectionInfo(), (ServiceInformation)this);
            LdapName dName = new LdapName(this.getDistinguishedNameFromUserAttributes(username));
            ldapUtil.changePassword(dName, oldPassword, newPassword, dataSource, this.enablePingDirectoryDetailedPwdReqField);
        }
        catch (NamingException e) {
            LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getByExplanation(this, e.getMessage(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
            result.raiseException(e, dataSource.getId(), result.getResultEnum());
        }
        catch (LDAPPasswordPolicyViolationException e) {
            String exceptionMsg = "LDAPPasswordPolicyViolationException while calling changePassword. LDAP server response from '" + this.getDataSource().getDescription() + "': " + e.getMessage();
            this.log.debug((Object)exceptionMsg);
            throw LDAPUtil.convertLDAPPasswordPolicyViolationException(exceptionMsg, e);
        }
        return new PasswordChangeResult();
    }

    public boolean isPasswordChangeable() {
        boolean isPasswordChangeable = false;
        LdapDataSource dataSource = this.getDataSource();
        try {
            isPasswordChangeable = LDAPUtil.isPasswordChangeable(dataSource);
        }
        catch (Exception e) {
            LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getByExplanation(this, e.getMessage(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
            result.raiseException(e, dataSource.getId(), result.getResultEnum());
        }
        return isPasswordChangeable;
    }

    public AttributeMap getUserAttributes(String username) {
        AttributeMap userAttributes;
        try {
            userAttributes = this.getAttributesWithUsername(username, true);
        }
        catch (PasswordValidationException passwordValidationException) {
            throw new AttributeLookupException("Unable to retrieve attributes for " + username + ".", (Throwable)passwordValidationException);
        }
        if (userAttributes == null) {
            throw new AttributeLookupException("Failed to retrieve attributes for " + username + ".");
        }
        return userAttributes;
    }

    public boolean isPendingPasswordExpiryNotifiable() {
        return true;
    }

    public boolean isChangePasswordEmailNotifiable() {
        return true;
    }

    public AttributeMap findUser(String username) throws PasswordResetException {
        AttributeMap searchResultsMap;
        String usernameForFilter = this.isTrimUsernameSpacesConfigured() ? LDAPUtil.stripSpaces(username) : username;
        String filter = this.substituteFilter(LDAPUtil.encodeFilter(usernameForFilter));
        int searchScope = this.getSearchScope();
        String ldapMailAttribute = this.getMailAttribute();
        try {
            this.log.debug((Object)("FindUser - Querying LDAP with this searchbase: " + this.getSearchBase()));
            this.log.debug((Object)("FindUser - Querying LDAP with this searchfilter: " + filter));
            this.log.debug((Object)("FindUser - Querying LDAP with this searchscope: " + searchScope));
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.getSearchBase(), filter, searchScope);
            HashSet<String> requestedAttributesSet = new HashSet<String>();
            requestedAttributesSet.add(ldapMailAttribute);
            requestedAttributesSet.add(this.getNameAttribute());
            requestedAttributesSet.add(this.getSmsAttribute());
            requestedAttributesSet.add(this.getPingIdUsernameAttribute());
            requestedAttributesSet.add(this.getMailVerifiedAttribute());
            requestedAttributesSet.add("givenName");
            requestedAttributesSet.addAll(this.configuration.getAdditionalAttrNames());
            if (this.getDataSource().isActiveDirectoryType()) {
                requestedAttributesSet.add("userAccountControl");
                requestedAttributesSet.add("msDS-UserAccountDisabled");
            } else if (StringUtils.isNotBlank((String)this.configuration.getFieldValue(FIELD_ACCOUNT_DISABLED_ATTRIBUTE))) {
                requestedAttributesSet.add(this.configuration.getFieldValue(FIELD_ACCOUNT_DISABLED_ATTRIBUTE));
            }
            String[] requestedAttributes = (String[])requestedAttributesSet.stream().filter(StringUtils::isNotEmpty).toArray(String[]::new);
            ldapOptions.setAttributes(requestedAttributes);
            searchResultsMap = ldapUtil.getAttributesOfMatchingObject(ldapOptions);
            if (searchResultsMap == null || searchResultsMap.isEmpty()) {
                this.log.debug((Object)"FindUser - User does not exist in the LDAP");
                throw new PasswordResetException(false, "User not found: " + username);
            }
            this.log.debug((Object)"FindUser - User exists in the LDAP");
        }
        catch (NamingException ex) {
            throw new PasswordResetException(false, "User not found: " + username);
        }
        if (searchResultsMap.containsKey((Object)ldapMailAttribute)) {
            searchResultsMap.putIfNotPresent(DEFAULT_EMAIL_ATTRIBUTE, (AttributeValue)searchResultsMap.get((Object)ldapMailAttribute));
        }
        searchResultsMap.put("username", usernameForFilter);
        return searchResultsMap;
    }

    public List<AttributeMap> findUsersByMail(String mail) throws UsernameRecoveryException {
        List<AttributeMap> searchResultMaps;
        String filter = this.substituteMailFilter(LDAPUtil.encodeFilter(mail));
        int searchScope = this.getSearchScope();
        try {
            this.log.debug((Object)("FindUser - Querying LDAP with this searchbase: " + this.getSearchBase()));
            this.log.debug((Object)("FindUser - Querying LDAP with this searchfilter: " + filter));
            this.log.debug((Object)("FindUser - Querying LDAP with this searchscope: " + searchScope));
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.getSearchBase(), filter, searchScope);
            HashSet<String> requestedAttributesSet = new HashSet<String>();
            requestedAttributesSet.add(this.getUsernameAttribute());
            requestedAttributesSet.add(this.getMailVerifiedAttribute());
            requestedAttributesSet.add(this.getNameAttribute());
            String[] requestedAttributes = (String[])requestedAttributesSet.stream().filter(StringUtils::isNotEmpty).toArray(String[]::new);
            ldapOptions.setAttributes(requestedAttributes);
            searchResultMaps = ldapUtil.getAttributesOfMatchingObjects(ldapOptions);
            if (searchResultMaps == null || searchResultMaps.isEmpty()) {
                this.log.debug((Object)"FindUser - User does not exist in the LDAP");
                throw new UsernameRecoveryException("User not found: " + mail);
            }
            this.log.debug((Object)"FindUser - User exists in the LDAP");
        }
        catch (NamingException ex) {
            throw new UsernameRecoveryException("User not found: " + mail);
        }
        return searchResultMaps;
    }

    public void resetPassword(String userId, String newPassword) throws PasswordResetException {
        String currDn = this.getDistinguishedNameFromUserAttributes(userId);
        try {
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
            ldapUtil.resetPassword(currDn, newPassword, this.getDataSource().getPasswordAttribute(), this.getDataSource(), this.enablePingDirectoryDetailedPwdReqField);
        }
        catch (NamingException e) {
            this.log.error((Object)("NamingException calling resetPassword " + e.getMessage()));
            LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getByExplanation(this, e.getExplanation(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
            if (AuthenticationResultEnum.PASSWORD_POLICY_VIOLATED == result.getResultEnum()) {
                throw new PasswordResetException(true, ERROR_MSG_PASSWORD_CONSTRAINT);
            }
            throw new PasswordResetException(result.isRecoverable().booleanValue(), result.getMessageKey(), (Throwable)e);
        }
        catch (LDAPPasswordPolicyViolationException e) {
            String exceptionMsg = "LDAPPasswordPolicyViolationException calling resetPassword. LDAP server response from '" + this.getDataSource().getDescription() + "': " + e.getMessage();
            this.log.error((Object)exceptionMsg);
            LinkedList<Message> pwdReqMetMsgList = new LinkedList<Message>();
            LinkedList<Message> pwdReqNotMetMsgList = new LinkedList<Message>();
            LDAPUtil.getPwdViolationMsgs(pwdReqMetMsgList, pwdReqNotMetMsgList, e);
            throw new PasswordPolicyRequirementResetException(exceptionMsg, pwdReqMetMsgList, pwdReqNotMetMsgList);
        }
    }

    public boolean isPasswordResettable() {
        return this.isPasswordChangeable();
    }

    public boolean unlockAccount(String username) {
        String subjectDn = this.getDistinguishedNameFromUserAttributes(username);
        boolean unlocked = false;
        try {
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
            unlocked = ldapUtil.unlockAccount(subjectDn, this.getDataSource());
        }
        catch (NamingException e) {
            this.log.error((Object)("Error while unlocking an the account is locked. " + e.getMessage()));
        }
        return unlocked;
    }

    public boolean isAccountLocked(String username) {
        String subjectDn = this.getDistinguishedNameFromUserAttributes(username);
        boolean isLocked = false;
        try {
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getConnectionInfo(), (ServiceInformation)this);
            isLocked = ldapUtil.isAccountLocked(subjectDn, this.getDataSource());
        }
        catch (NamingException e) {
            LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getByExplanation(this, e.getMessage(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
            result.raiseException(e, this.getDataSource().getId(), result.getResultEnum());
        }
        return isLocked;
    }

    public boolean isAccountUnlockable() {
        boolean isUnlockable = false;
        try {
            LdapDataSource dataSource = this.getDataSource();
            isUnlockable = LDAPUtil.isAccountUnLockable(dataSource);
            if (!isUnlockable) {
                this.log.warn((Object)("The account unlock feature is disabled for this password credential validator instance as the data source only supports manual account unlock '" + dataSource.getDescription() + "'."));
            }
        }
        catch (Exception e) {
            LDAPPasswordCredentialValidatorResult result = LDAPPasswordCredentialValidatorResult.getByExplanation(this, e.getMessage(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
            result.raiseException(e, this.getDataSource().getId(), result.getResultEnum());
        }
        return isUnlockable;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="The method is private and should stay private")
    private Boolean isAdUserDisabled(AttributeMap attributeMap) {
        String uacAttrValue = attributeMap.getSingleValue("userAccountControl");
        if (StringUtils.isNotBlank((String)uacAttrValue) && ValidationUtil.isValidInt(uacAttrValue)) {
            int uacValue = Integer.parseInt(uacAttrValue);
            return (uacValue & 2) == 2;
        }
        String userAccountDisabledAttrValue = attributeMap.getSingleValue("msDS-UserAccountDisabled");
        if (StringUtils.isNotBlank((String)userAccountDisabledAttrValue)) {
            return Boolean.parseBoolean(userAccountDisabledAttrValue);
        }
        return null;
    }

    public static class CustomAuthorizationError
    implements Serializable {
        private static final long serialVersionUID = 20121113L;
        private final String errorId;
        private final String expr;
        private final String msgKey;

        public CustomAuthorizationError(String errorId, String expr, String msgKey) {
            this.errorId = errorId;
            this.expr = expr;
            this.msgKey = msgKey;
        }

        public String getId() {
            return this.errorId;
        }

        public String getMsgKey() {
            return this.msgKey;
        }

        public String getExpr() {
            return this.expr;
        }

        public boolean matches(String value, boolean isCaseSensitive) {
            if (value == null) {
                return false;
            }
            return Util.wildCardMatch(value, this.expr, isCaseSensitive);
        }
    }
}

