/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.module.connection.ConnectionModuleGlobalConfiguration;
import java.util.List;
import org.sourceid.saml20.domain.ConnectionExpirationData;
import org.sourceid.saml20.domain.ContactInfo;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.LookupableLabel;
import org.sourceid.websso.Protocol;

public class LocalSettings {
    private String entityId;
    private String saml1xId;
    private String wsfedRealm;
    private String saml1xSrcId;
    private boolean disableAutomaticConnectionValidation;
    private int dataStoreValidationInterval;
    private String customGlobalHttpHeaderName;
    private ForwardedHeaderIndex clientIpHeaderIndex;
    private String forwardedHostHeaderName;
    private ForwardedHeaderIndex forwardedHostHeaderIndex;
    private boolean proxyTerminatesHttpsConns;
    private boolean enableClientCertAuth;
    private ClientCertEncodingFormat clientCertEncodingFormat;
    private String clientCertSSLHeaderName;
    private String clientCertChainSSLHeaderName;
    private String idpSloSuccessUrl;
    private boolean confirmSlo;
    private String spSsoSuccessUrl;
    private String spSloSuccessUrl;
    private String idpErrMsg;
    private String baseUrl = "";
    private ContactInfo contactInfo = null;
    private IndexedEndpoints idpArtifactResolutionServices = new IndexedEndpoints();
    private IndexedEndpoints spArtifactResolutionServices = new IndexedEndpoints();
    private EndpointGroup singleSignOnServices = new EndpointGroup();
    private EndpointGroup idpSingleLogoutServices = new EndpointGroup();
    private IndexedEndpoints assertionConsumerServices = new IndexedEndpoints();
    private EndpointGroup spSingleLogoutServices = new EndpointGroup();
    private ConnectionExpirationData connectionExpirationData = new ConnectionExpirationData();
    private String attributeService;
    private String idpInitiateSsoPath;
    private String idpInitiateSloPath;
    private String spInitiateSsoPath;
    private String spInitiateSloPath;
    private String spDefederatePath;
    private String idpWriteCdcPath;
    private String spStartAttrQueryPath;
    private String metadataSigningKeyAlias;
    private String metadataSigningAlgorithm;
    private String metadataSigningMD5Fingerprint;
    private List<ConnectionModuleGlobalConfiguration> connectionModuleGlobalConfigurations = null;
    private IdpDiscovery idpDiscovery = new IdpDiscovery();
    private String requestHeaderNameForCorrelationId;

    public boolean isEnableIdP() {
        return true;
    }

    public boolean isEnableSP() {
        return true;
    }

    public boolean isEnableBrowserSsoProfileIdP() {
        return true;
    }

    public boolean isEnableBrowserSsoProfileSP() {
        return true;
    }

    public boolean isEnableSamlOneOneRp() {
        return true;
    }

    public boolean isEnableSamlOneOneAp() {
        return true;
    }

    public boolean isEnableSamlOneZeroRp() {
        return true;
    }

    public boolean isEnableSamlOneZeroAp() {
        return true;
    }

    public boolean isEnableWsFedIdP() {
        return true;
    }

    public boolean isEnableWsFedSp() {
        return true;
    }

    public boolean isEnableSamlIdP() {
        return true;
    }

    public boolean isEnableSamlSp() {
        return true;
    }

    public boolean isEnableWsTrustIdP() {
        return true;
    }

    public boolean isEnableWsTrustSp() {
        return true;
    }

    public boolean isEnableInboundProvisioning() {
        return true;
    }

    public boolean isEnableOutboundProvisioning() {
        return true;
    }

    public boolean isEnableAttributeQuery() {
        return true;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getIdpSloSuccessUrl() {
        return this.idpSloSuccessUrl;
    }

    public void setIdpSloSuccessUrl(String idpSloSuccessUrl) {
        this.idpSloSuccessUrl = idpSloSuccessUrl;
    }

    public boolean isConfirmSlo() {
        return this.confirmSlo;
    }

    public void setConfirmSlo(boolean confirm) {
        this.confirmSlo = confirm;
    }

    public String getSpSloSuccessUrl() {
        return this.spSloSuccessUrl;
    }

    public void setSpSloSuccessUrl(String spSloSuccessUrl) {
        this.spSloSuccessUrl = spSloSuccessUrl;
    }

    public String getSpSsoSuccessUrl() {
        return this.spSsoSuccessUrl;
    }

    public void setSpSsoSuccessUrl(String spSsoSuccessUrl) {
        this.spSsoSuccessUrl = spSsoSuccessUrl;
    }

    public int getProtocolSessionTimeoutInMinutes() {
        return 72;
    }

    public void setProtocolSessionTimeoutInMinutes(int protocolSessionTimeoutInMinutes) {
    }

    public IndexedEndpoints getIdpArtifactResolutionServices() {
        return this.idpArtifactResolutionServices;
    }

    public void setIdpArtifactResolutionServices(IndexedEndpoints idpArtifactResolutionServices) {
        this.idpArtifactResolutionServices = idpArtifactResolutionServices;
    }

    public IndexedEndpoints getSpArtifactResolutionServices() {
        return this.spArtifactResolutionServices;
    }

    public void setSpArtifactResolutionServices(IndexedEndpoints spArtifactResolutionServices) {
        this.spArtifactResolutionServices = spArtifactResolutionServices;
    }

    public IndexedEndpoints getAssertionConsumerServices() {
        return this.assertionConsumerServices;
    }

    public void setAssertionConsumerServices(IndexedEndpoints assertionConsumerServices) {
        this.assertionConsumerServices = assertionConsumerServices;
    }

    public EndpointGroup getIdpSingleLogoutServices() {
        return this.idpSingleLogoutServices;
    }

    public void setIdpSingleLogoutServices(EndpointGroup idpSingleLogoutServices) {
        this.idpSingleLogoutServices = idpSingleLogoutServices;
    }

    public EndpointGroup getSingleSignOnServices() {
        return this.singleSignOnServices;
    }

    public void setSingleSignOnServices(EndpointGroup singleSignOnServices) {
        this.singleSignOnServices = singleSignOnServices;
    }

    public EndpointGroup getSpSingleLogoutServices() {
        return this.spSingleLogoutServices;
    }

    public void setSpSingleLogoutServices(EndpointGroup spSingleLogoutServices) {
        this.spSingleLogoutServices = spSingleLogoutServices;
    }

    public String getIdpInitiateSsoPath() {
        return this.idpInitiateSsoPath;
    }

    public void setIdpInitiateSsoPath(String idpInitiateSsoPath) {
        this.idpInitiateSsoPath = idpInitiateSsoPath;
    }

    public String getIdpInitiateSloPath() {
        return this.idpInitiateSloPath;
    }

    public void setIdpInitiateSloPath(String idpInitiateSloPath) {
        this.idpInitiateSloPath = idpInitiateSloPath;
    }

    public String getSpInitiateSsoPath() {
        return this.spInitiateSsoPath;
    }

    public void setSpInitiateSsoPath(String spInitiateSsoPath) {
        this.spInitiateSsoPath = spInitiateSsoPath;
    }

    public String getSpInitiateSloPath() {
        return this.spInitiateSloPath;
    }

    public void setSpInitiateSloPath(String spInitiateSloPath) {
        this.spInitiateSloPath = spInitiateSloPath;
    }

    public String getSpDefederatePath() {
        return this.spDefederatePath;
    }

    public void setSpDefederatePath(String spDefederatePath) {
        this.spDefederatePath = spDefederatePath;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(ContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    public IdpDiscovery getIdpDiscovery() {
        return this.idpDiscovery;
    }

    public void setIdpDiscovery(IdpDiscovery idpDiscovery) {
        this.idpDiscovery = idpDiscovery;
    }

    public boolean isEnableIdpDiscovery() {
        return true;
    }

    public String getSaml1xId() {
        return this.saml1xId;
    }

    public void setSaml1xId(String saml1xId) {
        this.saml1xId = saml1xId;
    }

    public String getWsfedRealm() {
        return this.wsfedRealm;
    }

    public void setWsfedRealm(String wsfedRealm) {
        this.wsfedRealm = wsfedRealm;
    }

    public String getSaml1xSrcId() {
        return this.saml1xSrcId;
    }

    public void setSaml1xSrcId(String saml1xSrcId) {
        this.saml1xSrcId = saml1xSrcId;
    }

    public String getIdpErrMsg() {
        return this.idpErrMsg;
    }

    public void setIdpErrMsg(String idpErrMsg) {
        this.idpErrMsg = idpErrMsg;
    }

    public Protocol getDefaultProtocol(boolean isSPConnection) {
        if (isSPConnection) {
            if (this.isEnableSamlIdP()) {
                return Protocol.SAML20;
            }
            if (this.isEnableSamlOneOneAp()) {
                return Protocol.SAML11;
            }
            if (this.isEnableSamlOneZeroAp()) {
                return Protocol.SAML10;
            }
            if (this.isEnableWsFedIdP()) {
                return Protocol.WSFED;
            }
        } else {
            if (this.isEnableSamlSp()) {
                return Protocol.SAML20;
            }
            if (this.isEnableSamlOneOneRp()) {
                return Protocol.SAML11;
            }
            if (this.isEnableSamlOneZeroRp()) {
                return Protocol.SAML10;
            }
            if (this.isEnableWsFedSp()) {
                return Protocol.WSFED;
            }
            if (this.isEnableOIDCSp()) {
                return Protocol.OIDC;
            }
        }
        return null;
    }

    public boolean isEnableProtocolSp(Protocol protocol) {
        return true;
    }

    public boolean isEnableProtocolIdP(Protocol protocol) {
        return true;
    }

    public String getAttributeService() {
        return this.attributeService;
    }

    public void setAttributeService(String attributeService) {
        this.attributeService = attributeService;
    }

    public String getIdpWriteCdcPath() {
        return this.idpWriteCdcPath;
    }

    public void setIdpWriteCdcPath(String idpWriteCdcPath) {
        this.idpWriteCdcPath = idpWriteCdcPath;
    }

    public String getSpStartAttrQueryPath() {
        return this.spStartAttrQueryPath;
    }

    public void setSpStartAttrQueryPath(String spStartAttrQueryPath) {
        this.spStartAttrQueryPath = spStartAttrQueryPath;
    }

    public boolean isEnableX509Discovery() {
        return true;
    }

    public ConnectionExpirationData getConnectionExpirationData() {
        return this.connectionExpirationData;
    }

    public void setConnectionExpirationData(ConnectionExpirationData connectionExpirationData) {
        this.connectionExpirationData = connectionExpirationData;
    }

    public boolean isDisableAutomaticConnectionValidation() {
        return this.disableAutomaticConnectionValidation;
    }

    public void setDisableAutomaticConnectionValidation(boolean disableAutomaticConnectionValidation) {
        this.disableAutomaticConnectionValidation = disableAutomaticConnectionValidation;
    }

    public String getMetadataSigningKeyAlias() {
        return this.metadataSigningKeyAlias;
    }

    public void setMetadataSigningKeyAlias(String metadataSigningKeyAlias) {
        this.metadataSigningKeyAlias = metadataSigningKeyAlias;
    }

    public List<ConnectionModuleGlobalConfiguration> getConnectionModuleGlobalConfigurations() {
        return this.connectionModuleGlobalConfigurations;
    }

    public void setConnectionModuleGlobalConfigurations(List<ConnectionModuleGlobalConfiguration> connectionModuleGlobalConfigurations) {
        this.connectionModuleGlobalConfigurations = connectionModuleGlobalConfigurations;
    }

    public String getMetadataSigningAlgorithm() {
        return this.metadataSigningAlgorithm;
    }

    public void setMetadataSigningAlgorithm(String metadataSigningAlgorithm) {
        this.metadataSigningAlgorithm = metadataSigningAlgorithm;
    }

    public String getMetadataSigningKeyMD5Fingerprint() {
        return this.metadataSigningMD5Fingerprint;
    }

    public void setMetadataSigningKeyMD5Fingerprint(String metadataSigningMD5Fingerprint) {
        this.metadataSigningMD5Fingerprint = metadataSigningMD5Fingerprint;
    }

    public ConnectionModuleGlobalConfiguration getConnectionModuleGlobalConfiguration(Class<? extends ConnectionModuleGlobalConfiguration> configType) {
        ConnectionModuleGlobalConfiguration requestedGlobalConfiguration = null;
        if (this.connectionModuleGlobalConfigurations != null) {
            for (ConnectionModuleGlobalConfiguration globalConfiguration : this.connectionModuleGlobalConfigurations) {
                if (!configType.isInstance(globalConfiguration)) continue;
                requestedGlobalConfiguration = globalConfiguration;
                break;
            }
        }
        return requestedGlobalConfiguration;
    }

    public boolean isInboundProvisioningOnly() {
        return false;
    }

    public int getDataStoreValidationInterval() {
        return this.dataStoreValidationInterval;
    }

    public void setDataStoreValidationInterval(int dataStoreValidationInterval) {
        this.dataStoreValidationInterval = dataStoreValidationInterval;
    }

    public String getCustomGlobalHttpHeaderName() {
        return this.customGlobalHttpHeaderName;
    }

    public void setCustomGlobalHttpHeaderName(String customGlobalHttpHeaderName) {
        this.customGlobalHttpHeaderName = customGlobalHttpHeaderName;
    }

    public ForwardedHeaderIndex getClientIpHeaderIndex() {
        return this.clientIpHeaderIndex;
    }

    public void setClientIpHeaderIndex(ForwardedHeaderIndex clientIpHeaderIndex) {
        this.clientIpHeaderIndex = clientIpHeaderIndex;
    }

    public String getForwardedHostHeaderName() {
        return this.forwardedHostHeaderName;
    }

    public void setForwardedHostHeaderName(String forwardedHostHeaderName) {
        this.forwardedHostHeaderName = forwardedHostHeaderName;
    }

    public ForwardedHeaderIndex getForwardedHostHeaderIndex() {
        return this.forwardedHostHeaderIndex;
    }

    public void setForwardedHostHeaderIndex(ForwardedHeaderIndex forwardedHostHeaderIndex) {
        this.forwardedHostHeaderIndex = forwardedHostHeaderIndex;
    }

    public boolean isProxyTerminatesHttpsConns() {
        return this.proxyTerminatesHttpsConns;
    }

    public void setProxyTerminatesHttpsConns(boolean proxyTerminates) {
        this.proxyTerminatesHttpsConns = proxyTerminates;
    }

    public boolean isEnableFederationHub() {
        return this.isEnableBrowserSsoProfileIdP() && this.isEnableBrowserSsoProfileSP();
    }

    public boolean isEnableClientCertAuth() {
        return this.enableClientCertAuth;
    }

    public void setEnableClientCertAuth(boolean enableClientCertAuth) {
        this.enableClientCertAuth = enableClientCertAuth;
    }

    public ClientCertEncodingFormat getClientCertEncodingFormat() {
        return this.clientCertEncodingFormat;
    }

    public void setClientCertEncodingFormat(ClientCertEncodingFormat clientCertEncodingFormat) {
        this.clientCertEncodingFormat = clientCertEncodingFormat;
    }

    public String getClientCertSSLHeaderName() {
        return this.clientCertSSLHeaderName;
    }

    public void setClientCertSSLHeaderName(String clientCertSSLHeaderName) {
        this.clientCertSSLHeaderName = clientCertSSLHeaderName;
    }

    public String getClientCertChainSSLHeaderName() {
        return this.clientCertChainSSLHeaderName;
    }

    public void setClientCertChainSSLHeaderName(String clientCertChainSSLHeaderName) {
        this.clientCertChainSSLHeaderName = clientCertChainSSLHeaderName;
    }

    public boolean isEnableOIDCSp() {
        return true;
    }

    public String getRequestHeaderNameForCorrelationId() {
        return this.requestHeaderNameForCorrelationId;
    }

    public void setRequestHeaderNameForCorrelationId(String requestHeaderNameForCorrelationId) {
        this.requestHeaderNameForCorrelationId = requestHeaderNameForCorrelationId;
    }

    public static enum ClientCertEncodingFormat implements LookupableLabel
    {
        APACHE_MOD_SSL("Apache mod_ssl"),
        NGINX("NGINX");

        private final String label;

        private ClientCertEncodingFormat(String label) {
            this.label = label;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return super.toString();
        }
    }

    public static enum ForwardedHeaderIndex implements LookupableLabel
    {
        FIRST("Use First Value"),
        LAST("Use Last Value");

        private final String label;

        private ForwardedHeaderIndex(String label) {
            this.label = label;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

