/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.B64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.util.MetaDataInfo;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.PathUtil;

public class MetadataUpdate {
    private static final Log log = LogFactory.getLog(MetadataUpdate.class);
    private String connectionId;
    private String lastUsedMetadata;
    private boolean errorNotificationSent = false;

    public MetadataUpdate(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connId) {
        this.connectionId = connId;
    }

    public String getLastUsedMetadata() {
        return this.lastUsedMetadata;
    }

    public void setLastUsedMetadata(String lastUsedMetadata) {
        this.lastUsedMetadata = lastUsedMetadata;
    }

    public boolean isErrorNotificationSent() {
        return this.errorNotificationSent;
    }

    public void setErrorNotificationSent(boolean errorNotificationSent) {
        this.errorNotificationSent = errorNotificationSent;
    }

    public boolean isSendOutOfSyncNotification(String usedMetadataSha1) {
        boolean sendNotification = true;
        if (StringUtils.isNotBlank((String)this.lastUsedMetadata) && this.lastUsedMetadata.equals(usedMetadataSha1)) {
            sendNotification = false;
        }
        return sendNotification;
    }

    public String toSha1(ConnectionBase currentConnection) {
        String connToString = new String();
        if (currentConnection == null) {
            return connToString;
        }
        PathUtil pathUtil = MetaDataFactory.getLocalMetaData().getPathUtil();
        MetaDataInfo mdi = new MetaDataInfo();
        MetadataImportExportUtil.populateMetaDataInfoWithConnection(mdi, currentConnection);
        if (currentConnection instanceof IdpConnection) {
            mdi.setExportIDPRole(false);
        } else if (currentConnection instanceof SpConnection) {
            mdi.setExportIDPRole(true);
        }
        byte[] dataBytes = MetadataImportExportUtil.getMetaDataRawBytes(mdi, null, null, false, pathUtil, false, true);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            connToString = B64.encode((byte[])md.digest(dataBytes));
        }
        catch (NoSuchAlgorithmException e) {
            log.debug((Object)("Error while converting the metadata connection to SHA1 hash." + e.getMessage()));
        }
        return connToString;
    }
}

