/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.crypto.Cert;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;

public class MetadataUrlCertPair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String url;
    private String certAlias;
    private String name;
    private boolean validateSignature = true;

    public MetadataUrlCertPair() {
    }

    public MetadataUrlCertPair(String id, String url, String certAlias, String name, boolean validateSignature) {
        this.id = id;
        this.url = url;
        this.certAlias = certAlias;
        this.name = name;
        this.validateSignature = validateSignature;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public boolean isValidateSignature() {
        return this.validateSignature;
    }

    public void setValidateSignature(boolean validateSignature) {
        this.validateSignature = validateSignature;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Cert getVerificationCert() {
        PkCertAndConnectionCertManager certManager;
        Set<Cert> certs;
        Cert verificationCert = null;
        if (StringUtils.isNotBlank((String)this.certAlias) && (certs = (certManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager()).getCertsForFeature(this.id)) != null && certs.size() > 0) {
            verificationCert = certs.iterator().next();
        }
        return verificationCert;
    }
}

