/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.NotificationMode;

public class NotificationSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_SMTP_PORT = "25";
    public static final String DEFAULT_SSL_SMTP_PORT = "465";
    public static final String DEFAULT_TIMEOUT = "30";
    public static final String DEFAULT_RETRY_ATTEMPTS = "2";
    public static final String DEFAULT_RETRY_DELAY_MINS = "2";
    public static final int MAX_RETRY_ATTEMPTS = 5;
    public static final int MAX_RETRY_DELAY_MINS = 10;
    public static final int MAX_TIMEOUT = 3600;
    private boolean enableCertificateExpirationNotification;
    private boolean enableEmailNotification;
    private boolean enableAccountChangesNotification;
    private boolean enableMetadataEventNotification;
    private boolean enableThreadPoolExhaustionNotification;
    private boolean enableBulkheadAlertNotification;
    private NotificationMode bulkheadAlertNotificationMode = NotificationMode.LOGGING_ONLY;
    private String notificationPublisherBulkheadAlerts;
    private String bulkheadAlertsTo;
    private boolean bulkheadThreadDump;
    private boolean useSSL;
    private boolean useTLS;
    private boolean verifyHostname = false;
    private boolean allowUtf8MsgHeaders = false;
    private boolean useDebugging;
    private String smtpServer;
    private String smtpPort = "25";
    private String sslSmtpPort = "465";
    private String timeout = "30";
    private String from;
    private String sender;
    private String to;
    private String certificateExpirationTo;
    private String licensingEventTo;
    private String user;
    private String password;
    private String certInitialWarningEvent;
    private String certFinalWarningEvent;
    private NotificationMode certExpirationNotificationMode = NotificationMode.NOTIFICATION_PUBLISHER;
    private String metadataEventTo;
    private String threadPoolExhaustionTo;
    private boolean threadPoolExhaustionThreadDump;
    private NotificationMode threadPoolExhaustionNotificationMode = NotificationMode.LOGGING_ONLY;
    private String emailRetryAttempt = "2";
    private String emailRetryDelay = "2";
    private String notificationPublisherLicensing;
    private String notificationPublisherCertificates;
    private String notificationPublisherMetadata;
    private String notificationPublisherAccountChanges;
    private String notificationPublisherThreadPoolExhaustion;
    private String smsAccountId;
    private String smsAuthToken;
    private String smsFromNumber;
    private String expiringCertUIWarning;
    private String expiredCertThresholdUIWarning;

    public NotificationSettings() {
    }

    public NotificationSettings(NotificationSettings settings) {
        this.enableCertificateExpirationNotification = settings.isEnableCertificateExpirationNotification();
        this.enableEmailNotification = settings.isEnableEmailNotification();
        this.enableAccountChangesNotification = settings.isEnableAccountChangesNotification();
        this.enableMetadataEventNotification = settings.isEnableMetadataEventNotification();
        this.enableThreadPoolExhaustionNotification = settings.isEnableThreadPoolExhaustionNotification();
        this.useSSL = settings.isUseSSL();
        this.useTLS = settings.isUseTLS();
        this.verifyHostname = settings.isVerifyHostname();
        this.useDebugging = settings.isUseDebugging();
        this.allowUtf8MsgHeaders = settings.isAllowUtf8MsgHeaders();
        this.smtpServer = settings.getSmtpServer();
        this.smtpPort = settings.getSmtpPort();
        this.sslSmtpPort = settings.getSslSmtpPort();
        this.timeout = settings.getTimeout();
        this.from = settings.getFrom();
        this.sender = settings.getSender();
        this.to = settings.getTo();
        this.certificateExpirationTo = settings.getCertificateExpirationTo();
        this.licensingEventTo = settings.getLicensingEventTo();
        this.user = settings.getUser();
        this.password = settings.getPassword();
        this.certInitialWarningEvent = settings.getCertInitialWarningEvent();
        this.certFinalWarningEvent = settings.getCertFinalWarningEvent();
        this.certExpirationNotificationMode = settings.getCertExpirationNotificationMode();
        this.metadataEventTo = settings.getMetadataEventTo();
        this.threadPoolExhaustionTo = settings.getThreadPoolExhaustionTo();
        this.threadPoolExhaustionThreadDump = settings.getThreadPoolExhaustionThreadDump();
        this.threadPoolExhaustionNotificationMode = settings.getThreadPoolExhaustionNotificationMode();
        this.emailRetryAttempt = settings.emailRetryAttempt;
        this.emailRetryDelay = settings.emailRetryDelay;
        this.notificationPublisherCertificates = settings.notificationPublisherCertificates;
        this.notificationPublisherLicensing = settings.notificationPublisherLicensing;
        this.notificationPublisherMetadata = settings.notificationPublisherMetadata;
        this.notificationPublisherAccountChanges = settings.notificationPublisherAccountChanges;
        this.notificationPublisherThreadPoolExhaustion = settings.notificationPublisherThreadPoolExhaustion;
        this.notificationPublisherBulkheadAlerts = settings.notificationPublisherBulkheadAlerts;
        this.bulkheadAlertNotificationMode = settings.getBulkheadAlertsNotificationMode();
        this.enableBulkheadAlertNotification = settings.isEnableBulkheadAlertNotification();
        this.bulkheadAlertsTo = settings.getBulkheadAlertsTo();
        this.bulkheadThreadDump = settings.getBulkheadThreadDump();
        this.smsAccountId = settings.getSmsAccountId();
        this.smsAuthToken = settings.getSmsAuthToken();
        this.smsFromNumber = settings.getSmsFromNumber();
        this.expiringCertUIWarning = settings.getExpiringCertUIWarning();
        this.expiredCertThresholdUIWarning = settings.getExpiredCertThresholdUIWarning();
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(String smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public String getCertificateExpirationTo() {
        return this.certificateExpirationTo;
    }

    public void setCertificateExpirationTo(String certificateExpirationTo) {
        this.certificateExpirationTo = certificateExpirationTo;
    }

    public NotificationMode getCertExpirationNotificationMode() {
        return this.certExpirationNotificationMode;
    }

    public void setCertExpirationNotificationMode(NotificationMode certExpirationNotificationMode) {
        this.certExpirationNotificationMode = certExpirationNotificationMode;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String userid) {
        this.user = userid;
    }

    public boolean isEnableEmailNotification() {
        return this.enableEmailNotification;
    }

    public void setEnableEmailNotification(boolean enableEmailNotification) {
        this.enableEmailNotification = enableEmailNotification;
    }

    public boolean isEnableAccountChangesNotification() {
        return this.enableAccountChangesNotification;
    }

    public void setEnableAccountChangesNotification(boolean enableAccountChangesNotification) {
        this.enableAccountChangesNotification = enableAccountChangesNotification;
    }

    public boolean isEnableCertificateExpirationNotification() {
        return this.enableCertificateExpirationNotification;
    }

    public void setEnableCertificateExpirationNotification(boolean enableCertificateExpirationNotification) {
        this.enableCertificateExpirationNotification = enableCertificateExpirationNotification;
    }

    public String getCertFinalWarningEvent() {
        return this.certFinalWarningEvent;
    }

    public void setCertFinalWarningEvent(String certFinalWarningEvent) {
        this.certFinalWarningEvent = certFinalWarningEvent;
    }

    public String getCertInitialWarningEvent() {
        return this.certInitialWarningEvent;
    }

    public void setCertInitialWarningEvent(String certInitialWarningEvent) {
        this.certInitialWarningEvent = certInitialWarningEvent;
    }

    public String getLicensingEventTo() {
        return this.licensingEventTo;
    }

    public void setLicensingEventTo(String licensingEventTo) {
        this.licensingEventTo = licensingEventTo;
    }

    public String getSslSmtpPort() {
        return this.sslSmtpPort;
    }

    public void setSslSmtpPort(String sslSmtpPort) {
        this.sslSmtpPort = sslSmtpPort;
    }

    public boolean isUseDebugging() {
        return this.useDebugging;
    }

    public void setUseDebugging(boolean useDebugging) {
        this.useDebugging = useDebugging;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public boolean isUseTLS() {
        return this.useTLS;
    }

    public void setUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
    }

    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    public void setVerifyHostname(boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getMetadataEventTo() {
        return this.metadataEventTo;
    }

    public void setMetadataEventTo(String metadataEventTo) {
        this.metadataEventTo = metadataEventTo;
    }

    public boolean isEnableMetadataEventNotification() {
        return this.enableMetadataEventNotification;
    }

    public void setEnableMetadataEventNotification(boolean enableMetadataEventNotification) {
        this.enableMetadataEventNotification = enableMetadataEventNotification;
    }

    public String getThreadPoolExhaustionTo() {
        return this.threadPoolExhaustionTo;
    }

    public void setThreadPoolExhaustionTo(String threadPoolExhaustionTo) {
        this.threadPoolExhaustionTo = threadPoolExhaustionTo;
    }

    public boolean getThreadPoolExhaustionThreadDump() {
        return this.threadPoolExhaustionThreadDump;
    }

    public void setThreadPoolExhaustionThreadDump(boolean threadPoolExhaustionThreadDump) {
        this.threadPoolExhaustionThreadDump = threadPoolExhaustionThreadDump;
    }

    public NotificationMode getThreadPoolExhaustionNotificationMode() {
        return this.threadPoolExhaustionNotificationMode;
    }

    public void setThreadPoolExhaustionNotificationMode(NotificationMode threadPoolExhaustionNotificationMode) {
        this.threadPoolExhaustionNotificationMode = threadPoolExhaustionNotificationMode;
    }

    public boolean isEnableThreadPoolExhaustionNotification() {
        return this.enableThreadPoolExhaustionNotification;
    }

    public void setEnableThreadPoolExhaustionNotification(boolean enableThreadPoolExhaustionNotification) {
        this.enableThreadPoolExhaustionNotification = enableThreadPoolExhaustionNotification;
    }

    public void setEmailRetryAttempt(String emailResendAttempt) {
        this.emailRetryAttempt = emailResendAttempt;
    }

    public String getEmailRetryAttempt() {
        return this.emailRetryAttempt;
    }

    public String getEmailRetryDelay() {
        return this.emailRetryDelay;
    }

    public void setEmailRetryDelay(String emailRetryDelay) {
        this.emailRetryDelay = emailRetryDelay;
    }

    public String getSmsAccountId() {
        return this.smsAccountId;
    }

    public void setSmsAccountId(String smsAccountId) {
        this.smsAccountId = smsAccountId;
    }

    public String getSmsAuthToken() {
        return this.smsAuthToken;
    }

    public void setSmsAuthToken(String smsAuthToken) {
        this.smsAuthToken = smsAuthToken;
    }

    public String getSmsFromNumber() {
        return this.smsFromNumber;
    }

    public void setSmsFromNumber(String smsFromNumber) {
        this.smsFromNumber = smsFromNumber;
    }

    public String getNotificationPublisherLicensing() {
        return this.notificationPublisherLicensing;
    }

    public void setNotificationPublisherLicensing(String notificationPublisherLicensing) {
        this.notificationPublisherLicensing = notificationPublisherLicensing;
    }

    public String getNotificationPublisherCertificates() {
        return this.notificationPublisherCertificates;
    }

    public void setNotificationPublisherCertificates(String notificationPublisherCertificates) {
        this.notificationPublisherCertificates = notificationPublisherCertificates;
    }

    public String getNotificationPublisherMetadata() {
        return this.notificationPublisherMetadata;
    }

    public void setNotificationPublisherMetadata(String notificationPublisherMetadata) {
        this.notificationPublisherMetadata = notificationPublisherMetadata;
    }

    public String getNotificationPublisherAccountChanges() {
        return this.notificationPublisherAccountChanges;
    }

    public void setNotificationPublisherAccountChanges(String notificationPublisherAccountChanges) {
        this.notificationPublisherAccountChanges = notificationPublisherAccountChanges;
    }

    public String getNotificationPublisherThreadPoolExhaustion() {
        return this.notificationPublisherThreadPoolExhaustion;
    }

    public void setNotificationPublisherThreadPoolExhaustion(String notificationPublisherThreadPoolExhaustion) {
        this.notificationPublisherThreadPoolExhaustion = notificationPublisherThreadPoolExhaustion;
    }

    public boolean isNotificationEmailSettingsPopulated() {
        return !StringUtils.isBlank((String)this.smtpServer) && !StringUtils.isBlank((String)this.from);
    }

    public boolean isAllowUtf8MsgHeaders() {
        return this.allowUtf8MsgHeaders;
    }

    public void setAllowUtf8MsgHeaders(boolean allowUtf8MsgHeaders) {
        this.allowUtf8MsgHeaders = allowUtf8MsgHeaders;
    }

    public boolean isAtLeastOneNotificationEnabled() {
        return this.enableAccountChangesNotification || this.enableCertificateExpirationNotification || this.enableEmailNotification || this.enableMetadataEventNotification || this.enableThreadPoolExhaustionNotification || this.enableBulkheadAlertNotification;
    }

    public String getExpiringCertUIWarning() {
        return this.expiringCertUIWarning;
    }

    public void setExpiringCertUIWarning(String expiringCertUIWarning) {
        this.expiringCertUIWarning = expiringCertUIWarning;
    }

    public String getExpiredCertThresholdUIWarning() {
        return this.expiredCertThresholdUIWarning;
    }

    public void setExpiredCertThresholdUIWarning(String expiredCertThresholdUIWarning) {
        this.expiredCertThresholdUIWarning = expiredCertThresholdUIWarning;
    }

    public boolean isEnableBulkheadAlertNotification() {
        return this.enableBulkheadAlertNotification;
    }

    public void setEnableBulkheadAlertNotification(boolean enableBulkheadAlertNotification) {
        this.enableBulkheadAlertNotification = enableBulkheadAlertNotification;
    }

    public boolean getBulkheadThreadDump() {
        return this.bulkheadThreadDump;
    }

    public void setBulkheadThreadDump(boolean bulkheadThreadDump) {
        this.bulkheadThreadDump = bulkheadThreadDump;
    }

    public NotificationMode getBulkheadAlertsNotificationMode() {
        return this.bulkheadAlertNotificationMode;
    }

    public void setBulkheadAlertNotificationMode(NotificationMode notificationMode) {
        this.bulkheadAlertNotificationMode = notificationMode;
    }

    public String getNotificationPublisherBulkheadAlerts() {
        return this.notificationPublisherBulkheadAlerts;
    }

    public void setNotificationPublisherBulkheadAlerts(String notificationPublisherBulkheadAlerts) {
        this.notificationPublisherBulkheadAlerts = notificationPublisherBulkheadAlerts;
    }

    public String getBulkheadAlertsTo() {
        return this.bulkheadAlertsTo;
    }

    public void setBulkheadAlertsTo(String bulkheadAlertsTo) {
        this.bulkheadAlertsTo = bulkheadAlertsTo;
    }

    public void clearEmailServerSettings() {
        this.useSSL = false;
        this.useTLS = false;
        this.verifyHostname = false;
        this.allowUtf8MsgHeaders = false;
        this.useDebugging = false;
        this.smtpServer = null;
        this.smtpPort = null;
        this.sslSmtpPort = null;
        this.timeout = null;
        this.from = null;
        this.sender = null;
        this.user = null;
        this.password = null;
        this.emailRetryAttempt = null;
        this.emailRetryDelay = null;
    }
}

