/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OIDCRequestParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Set<String>> paramMap;

    public OIDCRequestParams(Map<String, Object> paramMap) {
        this.paramMap = this.convertToStringSetMap(paramMap);
    }

    public void setParam(String name, Set<String> values) {
        this.paramMap.put(name, values);
    }

    public Map<String, Object> convertToStringObjectMap() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Set<String>> entry : this.paramMap.entrySet()) {
            String key = entry.getKey();
            Set<String> values = entry.getValue();
            if (values == null) {
                resultMap.put(key, null);
                continue;
            }
            if (values.size() == 1) {
                resultMap.put(key, values.stream().findFirst().get());
                continue;
            }
            resultMap.put(key, values.toArray(new String[0]));
        }
        return resultMap;
    }

    public HashMap<String, Set<String>> convertToStringSetMap(Map<String, Object> paramMap) {
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            Object values = entry.getValue();
            HashSet<String> set = new HashSet<String>();
            if (values instanceof String) {
                set.add((String)values);
            } else if (values instanceof String[]) {
                set.addAll(Arrays.asList((String[])values));
            } else {
                throw new RuntimeException("Failed to handle OIDC request parameters.");
            }
            resultMap.put(key, set);
        }
        return resultMap;
    }

    public Map<String, Set<String>> getParamMap() {
        return this.paramMap;
    }
}

