/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.LDAPPasswordCredentialValidatorResult;

public class OracleDirectoryPasswordCredentialValidatorResult
extends LDAPPasswordCredentialValidatorResult {
    private static final long serialVersionUID = 20121119L;
    private static Log log = LogFactory.getLog(OracleDirectoryPasswordCredentialValidatorResult.class);
    private static final Pattern pattern = Pattern.compile("\\[LDAP: error code (\\d+) - (.*)\\]");

    private OracleDirectoryPasswordCredentialValidatorResult(String explanation, AuthenticationResultEnum resultEnum) {
        super(explanation, resultEnum);
    }

    static OracleDirectoryPasswordCredentialValidatorResult getByExplanation(String explanation) {
        explanation = explanation == null ? "" : explanation;
        Matcher matcher = pattern.matcher(explanation);
        String errorCode = "";
        String errorMessage = "";
        if (matcher.matches() && matcher.groupCount() > 0) {
            errorCode = matcher.group(1);
            errorMessage = matcher.group(2);
        } else {
            log.debug((Object)("Unable to parse LDAP return code from explanation: " + explanation));
        }
        AuthenticationResultEnum resultEnum = null;
        block6 : switch (errorCode) {
            case "49": {
                switch (errorMessage) {
                    case "invalid credentials": {
                        resultEnum = AuthenticationResultEnum.INVALID_CREDENTIALS;
                        break;
                    }
                    case "password expired!": {
                        resultEnum = AuthenticationResultEnum.PASSWORD_EXPIRED;
                    }
                }
                break;
            }
            case "32": {
                switch (errorMessage) {
                    case "no such object": {
                        resultEnum = AuthenticationResultEnum.USER_NOT_FOUND;
                    }
                }
                break;
            }
            case "19": {
                switch (errorMessage) {
                    case "Exceed password retry limit. Account locked.": {
                        resultEnum = AuthenticationResultEnum.USER_ACCOUNT_LOCKED;
                        break;
                    }
                    default: {
                        resultEnum = AuthenticationResultEnum.PASSWORD_POLICY_VIOLATED;
                    }
                }
            }
            case "53": {
                switch (errorMessage) {
                    case "Account inactivated. Contact system administrator.": {
                        resultEnum = AuthenticationResultEnum.ACCOUNT_DISABLED;
                        break block6;
                    }
                    case "Password was reset and must be changed.": {
                        resultEnum = AuthenticationResultEnum.USER_MUST_RESET_PASSWORD;
                    }
                }
            }
        }
        if (resultEnum == null) {
            resultEnum = AuthenticationResultEnum.getDefaultValue();
            log.debug((Object)("Unknown response from Oracle Directory server: " + explanation + ".  Using default value: '" + resultEnum.getMessageKey() + "'."));
        }
        return new OracleDirectoryPasswordCredentialValidatorResult(explanation, resultEnum);
    }
}

