/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyErrorType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.LDAPPasswordCredentialValidatorResult;

public class PingDirectoryPasswordCredentialValidatorResult
extends LDAPPasswordCredentialValidatorResult {
    private static final long serialVersionUID = 20121119L;
    private static Log log = LogFactory.getLog(PingDirectoryPasswordCredentialValidatorResult.class);
    private static final Pattern pattern = Pattern.compile("\\[LDAP: error code (\\d+) - (.*)\\]");

    private PingDirectoryPasswordCredentialValidatorResult(String explanation, AuthenticationResultEnum resultEnum) {
        super(explanation, resultEnum);
    }

    static PingDirectoryPasswordCredentialValidatorResult getByExplanation(String explanation, boolean returnDefaultIfNoCaseFound) {
        explanation = explanation == null ? "" : explanation;
        Matcher matcher = pattern.matcher(explanation);
        String errorCode = "";
        String errorMessage = "";
        if (matcher.matches() && matcher.groupCount() > 0) {
            errorCode = matcher.group(1);
            errorMessage = matcher.group(2);
        } else {
            log.debug((Object)("Unable to parse LDAP return code from explanation: " + explanation));
        }
        AuthenticationResultEnum resultEnum = null;
        switch (errorCode) {
            case "49": {
                if (PasswordPolicyErrorType.PASSWORD_EXPIRED.getName().equals(errorMessage)) {
                    resultEnum = AuthenticationResultEnum.PASSWORD_EXPIRED;
                    break;
                }
                if (PasswordPolicyErrorType.ACCOUNT_LOCKED.getName().equals(errorMessage)) {
                    resultEnum = AuthenticationResultEnum.USER_ACCOUNT_LOCKED;
                    break;
                }
                if (errorMessage.contains("no such user exists in the server")) {
                    resultEnum = AuthenticationResultEnum.USER_NOT_FOUND;
                    break;
                }
                if (PasswordPolicyErrorType.CHANGE_AFTER_RESET.getName().equals(errorMessage)) {
                    resultEnum = AuthenticationResultEnum.USER_MUST_RESET_PASSWORD;
                    break;
                }
                if ("account-disabled".equals(errorMessage)) {
                    resultEnum = AuthenticationResultEnum.ACCOUNT_DISABLED;
                    break;
                }
                resultEnum = AuthenticationResultEnum.INVALID_CREDENTIALS;
                break;
            }
            case "53": {
                if ("Password was reset and must be changed.".equals(errorMessage)) {
                    resultEnum = AuthenticationResultEnum.USER_MUST_RESET_PASSWORD;
                    break;
                }
                resultEnum = AuthenticationResultEnum.PASSWORD_POLICY_VIOLATED;
                break;
            }
            case "68": {
                if (!errorMessage.contains("cannot be added because an entry with that name already exists")) break;
                resultEnum = AuthenticationResultEnum.USER_ALREADY_EXISTS;
                break;
            }
            case "19": {
                resultEnum = AuthenticationResultEnum.ATTRIBUTE_CONFLICT;
                break;
            }
            case "21": {
                if (errorMessage.contains("is not a valid telephone number because it does not contain any numeric digits")) {
                    resultEnum = AuthenticationResultEnum.NON_NUMERIC_TELEPHONE_NUMBER;
                    break;
                }
                resultEnum = AuthenticationResultEnum.ATTRIBUTE_VALUE_INVALID;
                break;
            }
            case "91": {
                resultEnum = AuthenticationResultEnum.RETRY_LATER;
                break;
            }
        }
        if (resultEnum == null && returnDefaultIfNoCaseFound) {
            resultEnum = AuthenticationResultEnum.getDefaultValue();
        }
        return new PingDirectoryPasswordCredentialValidatorResult(explanation, resultEnum);
    }
}

