/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sourceid.saml20.domain.ReplicationArchive;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class ReplicationData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String configProfileId;
    private Date configTimestamp;
    private Date automaticConfigTimeStamp;
    private byte[] license;
    private String dataVersion;
    private ReplicationArchive coreArchive;
    private ReplicationArchive baseDeltaArchive;
    private List<ReplicationArchive> deltaArchives = new ArrayList<ReplicationArchive>();
    private List<ReplicationArchive> selectiveArchives = new ArrayList<ReplicationArchive>();

    public ReplicationData() {
    }

    public ReplicationData(ReplicationData copyFrom) {
        this.configProfileId = copyFrom.configProfileId;
        this.configTimestamp = new Date(copyFrom.configTimestamp.getTime());
        this.automaticConfigTimeStamp = copyFrom.getAutomaticConfigTimeStamp() != null ? new Date(copyFrom.getAutomaticConfigTimeStamp().getTime()) : null;
        this.license = copyFrom.license;
        this.dataVersion = copyFrom.dataVersion;
        this.coreArchive = copyFrom.coreArchive;
        this.baseDeltaArchive = copyFrom.baseDeltaArchive;
        if (copyFrom.deltaArchives != null) {
            this.deltaArchives = new ArrayList<ReplicationArchive>(copyFrom.deltaArchives);
        }
        if (copyFrom.selectiveArchives != null) {
            this.selectiveArchives = new ArrayList<ReplicationArchive>(copyFrom.selectiveArchives);
        }
    }

    public ReplicationData(String configProfileId, Date configTimestamp) {
        this.configProfileId = configProfileId;
        this.configTimestamp = configTimestamp;
    }

    public String getConfigProfileId() {
        return this.configProfileId;
    }

    public void setConfigProfileId(String configProfileId) {
        this.configProfileId = configProfileId;
    }

    public Date getConfigTimestamp() {
        return this.configTimestamp;
    }

    public void setConfigTimestamp(Date configTimestamp) {
        this.configTimestamp = configTimestamp;
    }

    public Date getAutomaticConfigTimeStamp() {
        return this.automaticConfigTimeStamp;
    }

    public void setAutomaticConfigTimeStamp(Date automaticConfigTimeStamp) {
        this.automaticConfigTimeStamp = automaticConfigTimeStamp;
    }

    public byte[] getLicense() {
        return this.license;
    }

    public void setLicense(byte[] license) {
        this.license = license;
    }

    public String getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(String dataVersion) {
        this.dataVersion = dataVersion;
    }

    public ReplicationArchive getCoreArchive() {
        return this.coreArchive;
    }

    public void setCoreArchive(ReplicationArchive coreArchive) {
        this.coreArchive = coreArchive;
    }

    public ReplicationArchive getBaseDeltaArchive() {
        return this.baseDeltaArchive;
    }

    public void setBaseDeltaArchive(ReplicationArchive baseArchive) {
        this.baseDeltaArchive = baseArchive;
    }

    public List<ReplicationArchive> getDeltaArchives() {
        return this.deltaArchives;
    }

    public void setDeltaArchives(List<ReplicationArchive> deltaArchives) {
        this.deltaArchives = deltaArchives;
    }

    public List<ReplicationArchive> getSelectiveArchives() {
        return this.selectiveArchives;
    }

    public void setSelectiveArchives(List<ReplicationArchive> selectiveArchives) {
        this.selectiveArchives = selectiveArchives;
    }

    public Date getLatestArchiveTimestamp() {
        return this.getLatestArchiveTimestamp(false);
    }

    public Date getLatestArchiveTimestamp(boolean ignorePartialArchives) {
        Date timestamp = null;
        ArrayList<ReplicationArchive> allArchives = new ArrayList<ReplicationArchive>();
        if (this.coreArchive != null) {
            allArchives.add(this.coreArchive);
        }
        if (this.baseDeltaArchive != null) {
            allArchives.add(this.baseDeltaArchive);
        }
        allArchives.addAll(this.deltaArchives);
        allArchives.addAll(this.selectiveArchives);
        for (ReplicationArchive archive : allArchives) {
            boolean isSelectiveOrPartial = archive.isPartial() || archive.isSelective();
            boolean isPartialIgnored = !ignorePartialArchives || !isSelectiveOrPartial;
            if (!isPartialIgnored || timestamp != null && !archive.getTimestamp().after(timestamp)) continue;
            timestamp = archive.getTimestamp();
        }
        return timestamp;
    }
}

