/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.concurrent.TimeUnit;

public enum SessionTimeUnit {
    MINUTES("Minutes", TimeUnit.MINUTES),
    HOURS("Hours", TimeUnit.HOURS),
    DAYS("Days", TimeUnit.DAYS);

    private String displayName;
    private TimeUnit timeUnit;

    private SessionTimeUnit(String displayName, TimeUnit timeUnit) {
        this.displayName = displayName;
        this.timeUnit = timeUnit;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int toMinutes(int value) {
        return (int)this.timeUnit.toMinutes(value);
    }

    public int fromMinutes(int minutes) {
        return (int)this.timeUnit.convert(minutes, TimeUnit.MINUTES);
    }

    public int getMinutesPerUnit() {
        return (int)this.timeUnit.toMinutes(1L);
    }

    public TimeUnit toTimeUnit() {
        return this.timeUnit;
    }
}

