/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.PluginFipsStatus;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import com.pingidentity.sdk.password.PasswordValidationException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.HashedField;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.HashedTextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.util.log.AttributeMap;

public class SimpleUsernamePasswordCredentialValidator
implements PasswordCredentialValidator {
    private final PluginDescriptor descriptor;
    private static final String TYPE = "Simple Username Password Credential Validator";
    private static final String DESCRIPTION = "This password credential validator provides a means of verifying credentials maintained by PingFederate.";
    private static final String USERNAME_FIELD_NAME = "Username";
    private static final String USERNAME_FIELD_DESCRIPTION = "An individual user name for authentication";
    private static final String USERS_TABLE_NAME = "Users";
    private static final String USERS_TABLE_DESCRIPTION = "A table of valid usernames and passwords";
    private static final String PASSWORD_FIELD_NAME = "Password";
    private static final String PASSWORD_FIELD_DESCRIPTION = "An individual password for authentication";
    private static final String CONFIRM_PASSWORD_FIELD_NAME = "Confirm Password";
    private static final String CONFIRM_PASSWORD_FIELD_DESCRIPTION = "Must match password field";
    private static final String RELAX_PASSWORD_REQUIREMENTS_FIELD_NAME = "Relax Password Requirements";
    private Map<String, HashedField> userNamePassMap;

    public SimpleUsernamePasswordCredentialValidator() {
        GuiConfigDescriptor guiDescriptor = new GuiConfigDescriptor();
        guiDescriptor.setDescription(DESCRIPTION);
        this.addConfigurationFields(guiDescriptor);
        this.descriptor = new PluginDescriptor(TYPE, (ConfigurablePlugin)this, guiDescriptor, "1.0");
        this.descriptor.setAttributeContractSet(Collections.singleton("username"));
        this.descriptor.setSupportsExtendedContract(false);
        this.descriptor.setMetadata(Collections.singletonMap("FipsStatus", PluginFipsStatus.COMPLIANT));
    }

    public void configure(Configuration configuration) {
        Table table = configuration.getTable(USERS_TABLE_NAME);
        this.userNamePassMap = new HashMap<String, HashedField>();
        if (table != null) {
            for (Row row : table.getRows()) {
                String uname = row.getFieldValue(USERNAME_FIELD_NAME);
                HashedField pass = (HashedField)row.getField(PASSWORD_FIELD_NAME);
                this.userNamePassMap.put(uname, pass);
            }
        }
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.descriptor;
    }

    public AttributeMap processPasswordCredential(String username, String password) throws PasswordValidationException {
        HashedField passwordHash = this.userNamePassMap.get(username);
        if (passwordHash == null) {
            throw new PasswordCredentialValidatorAuthnException(AuthenticationResultEnum.USER_NOT_FOUND.isRecoverable(), AuthenticationResultEnum.USER_NOT_FOUND.getMessageKey());
        }
        if (passwordHash.checkSecret(password == null ? "" : password)) {
            AttributeMap attrs = new AttributeMap();
            attrs.put("username", username);
            return attrs;
        }
        throw new PasswordCredentialValidatorAuthnException(AuthenticationResultEnum.INVALID_CREDENTIALS.isRecoverable(), AuthenticationResultEnum.INVALID_CREDENTIALS.getMessageKey());
    }

    private void addConfigurationFields(GuiConfigDescriptor gui) {
        TableDescriptor table = new TableDescriptor(USERS_TABLE_NAME, USERS_TABLE_DESCRIPTION);
        TextFieldDescriptor username = new TextFieldDescriptor(USERNAME_FIELD_NAME, USERNAME_FIELD_DESCRIPTION);
        username.addValidator((FieldValidator)new RequiredFieldValidator());
        username.addValidator(new FieldValidator(){

            public void validate(Field field) throws ValidationException {
                if (!field.getValue().trim().equals(field.getValue())) {
                    throw new ValidationException("'" + field.getLabel() + "' contains leading or trailing space(s). Please delete all those spaces.");
                }
            }
        });
        table.addRowField((FieldDescriptor)username);
        HashedTextFieldDescriptor password = new HashedTextFieldDescriptor(PASSWORD_FIELD_NAME, PASSWORD_FIELD_DESCRIPTION);
        table.addRowField((FieldDescriptor)password);
        HashedTextFieldDescriptor confirmPassword = new HashedTextFieldDescriptor(CONFIRM_PASSWORD_FIELD_NAME, CONFIRM_PASSWORD_FIELD_DESCRIPTION);
        table.addRowField((FieldDescriptor)confirmPassword);
        table.addRowField((FieldDescriptor)new CheckBoxFieldDescriptor(RELAX_PASSWORD_REQUIREMENTS_FIELD_NAME, "Password validation rules are not applied when selected, which allowed for things like PINs to be used as credentials and/or some usernames to not require credentials in the context of this PCV."));
        table.addValidator((RowValidator)new UserRowValidator());
        gui.addTable(table);
        gui.addValidator(new ConfigurationValidator(){

            public void validate(Configuration configuration) throws ValidationException {
                Table table = configuration.getTable(SimpleUsernamePasswordCredentialValidator.USERS_TABLE_NAME);
                List rows = table.getRows();
                if (rows.isEmpty()) {
                    throw new ValidationException("Please add at least one user to the 'Users' table.");
                }
                ArrayList<CallSite> errors = new ArrayList<CallSite>();
                HashSet<String> unames = new HashSet<String>();
                for (Row row : rows) {
                    String uname = row.getFieldValue(SimpleUsernamePasswordCredentialValidator.USERNAME_FIELD_NAME);
                    if (unames.add(uname)) continue;
                    errors.add((CallSite)((Object)("Duplicate user name: " + uname)));
                }
                if (!errors.isEmpty()) {
                    throw new ValidationException(errors);
                }
            }
        });
    }

    private static class UserRowValidator
    implements RowValidator {
        private static final long serialVersionUID = 1L;

        private UserRowValidator() {
        }

        public void validate(FieldList fieldsInRow) throws ValidationException {
            ArrayList<String> errors = new ArrayList<String>();
            HashedField pwdField = (HashedField)fieldsInRow.getField(SimpleUsernamePasswordCredentialValidator.PASSWORD_FIELD_NAME);
            HashedField confirmPwdField = (HashedField)fieldsInRow.getField(SimpleUsernamePasswordCredentialValidator.CONFIRM_PASSWORD_FIELD_NAME);
            RequiredFieldValidator requiredFieldValidator = new RequiredFieldValidator();
            String clearTextPass = pwdField.getPlainTextValue();
            if (!fieldsInRow.getBooleanFieldValue(SimpleUsernamePasswordCredentialValidator.RELAX_PASSWORD_REQUIREMENTS_FIELD_NAME)) {
                try {
                    StringBuilder error;
                    requiredFieldValidator.validate((Field)pwdField);
                    String hashedPass = pwdField.getHashedValue();
                    if (!(clearTextPass == null && hashedPass != null || ValidationUtil.isPasswordValid(clearTextPass, error = new StringBuilder()))) {
                        errors.add(error.toString());
                    }
                }
                catch (ValidationException e) {
                    errors.addAll(e.getErrorMessages());
                }
                try {
                    requiredFieldValidator.validate((Field)confirmPwdField);
                }
                catch (ValidationException e) {
                    errors.addAll(e.getErrorMessages());
                }
            }
            String confirmPassword = confirmPwdField.getPlainTextValue();
            if (clearTextPass == null && confirmPassword != null || clearTextPass != null && !clearTextPass.equals(confirmPassword)) {
                errors.add("Passwords do not match");
            }
            if (!errors.isEmpty()) {
                throw new ValidationException(errors);
            }
        }
    }
}

