/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.websso.Protocol;

public enum SourceContextType {
    TARGET_RESOURCE("context.TargetResource", "Target Resource"),
    OAUTH_SCOPES("context.OAuthScopes", "Scope"),
    OAUTH_AUTHORIZATION_DETAILS("context.OAuthAuthorizationDetails", "Authorization Details"),
    OAUTH_RESOURCES("context.OAuthResources", "Resources"),
    OAUTH_CLIENT("context.ClientId", "Client ID"),
    AUTHN_CTX("context.AuthenticationCtx", "Authentication Context"),
    CLIENT_IP("context.ClientIp", "Client IP"),
    REQUEST_ENDPOINT("context.RequestEndpoint", "Request Endpoint"),
    REQUEST("context.HttpRequest", "HTTP Request"),
    VIRTUAL_SERVER_ID("context.VirtualServerId", "Virtual Server ID"),
    STS_BASIC_AUTH_USERNAME("context.StsBasicAuthUsername", "STS Basic Authentication Username"),
    STS_SSL_CLIENT_CERT_SUBJECT_DN("context.StsSSLClientCertSubjectDN", "STS SSL Client Certificate's Subject DN"),
    STS_SSL_CLIENT_CERT_CHAIN("context.StsSSLClientCertChain", "STS SSL Client Certificate Chain"),
    AUTHENTICATING_AUTHORITY("context.AuthenticatingAuthority", "Authenticating Authority"),
    CLAIMS_LOCALES("context.claimsLocales", "Requested Claims Locales"),
    REQUESTED_USER("context.RequestedUser", "Requested User"),
    ACCESS_TOKEN("context.accessToken", "Access Token"),
    OAUTH_DEFAULT_PERSISTENT_GRANT_LIFETIME("context.DefaultPersistentGrantLifetime", "Default Persistent Grant Lifetime"),
    LOCALE("context.Locale", "Locale"),
    SIGNED_REQUEST_OBJECT_CLAIMS("context.SignedRequestObjectClaims", "Signed Request Object Claims"),
    CHAINED_ATTRIBUTES("context.ChainedAttributes", "Chained Attributes"),
    SP_CONN_ENTITY_ID("context.SpConnEntityId", "SP Connection Entity ID"),
    SAML_AUTHN_REQUEST("context.SamlAuthnRequest", "Incoming SAML Authn Request"),
    SRI("context.sri", "SRI");

    public static final String PREFIX = "context.";
    private static final Map<String, SourceContextType> ID_2_CONTEXT;
    private static final Map<String, SourceContextType> DESCRIPTION_2_CONTEXT;
    private final String id;
    private final String description;

    private SourceContextType(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static SourceContextType getTypeFromId(String id) {
        SourceContextType sourceContextType = ID_2_CONTEXT.get(id);
        if (sourceContextType != null) {
            return sourceContextType;
        }
        throw new IllegalArgumentException("Invalid context id: " + id);
    }

    public static SourceContextType getTypeFromDescription(String description) {
        SourceContextType sourceContextType = DESCRIPTION_2_CONTEXT.get(description);
        if (sourceContextType != null) {
            return sourceContextType;
        }
        throw new IllegalArgumentException("Invalid context description: " + description);
    }

    public static List<SourceContextType> getContextTypesForA2A() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(TARGET_RESOURCE);
        contexts.add(AUTHN_CTX);
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        contexts.add(SRI);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForApc2SpAdapter() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(TARGET_RESOURCE);
        contexts.add(AUTHN_CTX);
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        contexts.add(AUTHENTICATING_AUTHORITY);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForSpBrowserSSOWithAdapters() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(TARGET_RESOURCE);
        contexts.add(AUTHN_CTX);
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        contexts.add(VIRTUAL_SERVER_ID);
        contexts.add(SRI);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForSpBrowserSSOWithC2cContracts() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(TARGET_RESOURCE);
        contexts.add(AUTHN_CTX);
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        contexts.add(VIRTUAL_SERVER_ID);
        contexts.add(AUTHENTICATING_AUTHORITY);
        contexts.add(SRI);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForPluginContracts() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForFragmentInputs() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(REQUESTED_USER);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForIdpBrowserSSO() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(TARGET_RESOURCE);
        contexts.add(AUTHN_CTX);
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        contexts.add(VIRTUAL_SERVER_ID);
        return contexts;
    }

    public static List<SourceContextType> getProtocolDependentContextTypesForIdpBrowserSSO(Protocol protocol) {
        List<SourceContextType> contexts = SourceContextType.getContextTypesForIdpBrowserSSO();
        if (protocol == Protocol.SAML20) {
            contexts.add(AUTHENTICATING_AUTHORITY);
        }
        if (Protocol.OIDC == protocol) {
            contexts.add(ACCESS_TOKEN);
            contexts.remove((Object)VIRTUAL_SERVER_ID);
        }
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForSpXasp() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForExpressProv() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(AUTHN_CTX);
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForOpenIdPolicy() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(OAUTH_CLIENT);
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST_ENDPOINT);
        contexts.add(REQUEST);
        contexts.add(SRI);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForAccessTokenMapping() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(OAUTH_SCOPES);
        contexts.add(OAUTH_AUTHORIZATION_DETAILS);
        contexts.add(OAUTH_CLIENT);
        contexts.add(OAUTH_RESOURCES);
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        contexts.add(SRI);
        contexts.add(OAUTH_DEFAULT_PERSISTENT_GRANT_LIFETIME);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForInboundProv() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForWSTrustTokenProc() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(TARGET_RESOURCE);
        contexts.add(AUTHN_CTX);
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        contexts.add(STS_BASIC_AUTH_USERNAME);
        contexts.add(STS_SSL_CLIENT_CERT_SUBJECT_DN);
        contexts.add(STS_SSL_CLIENT_CERT_CHAIN);
        contexts.add(VIRTUAL_SERVER_ID);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForWsTrustTokenGen() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        contexts.add(STS_BASIC_AUTH_USERNAME);
        contexts.add(STS_SSL_CLIENT_CERT_SUBJECT_DN);
        contexts.add(STS_SSL_CLIENT_CERT_CHAIN);
        contexts.add(VIRTUAL_SERVER_ID);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForWsTrust() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        contexts.add(VIRTUAL_SERVER_ID);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForOAuthWithDefaultPersistentGrantLifetime() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>(SourceContextType.getContextTypesForOAuth());
        contexts.add(OAUTH_DEFAULT_PERSISTENT_GRANT_LIFETIME);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForROPCToGrantMapping() {
        List<SourceContextType> contexts = SourceContextType.getContextTypesForOAuthWithDefaultPersistentGrantLifetime();
        contexts.remove((Object)SRI);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForAuthnPolicy() {
        return Arrays.asList(OAUTH_SCOPES, OAUTH_CLIENT, CLIENT_IP, REQUEST, SP_CONN_ENTITY_ID, VIRTUAL_SERVER_ID, SRI);
    }

    public static List<SourceContextType> getContextTypesForOAuth() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(OAUTH_SCOPES);
        contexts.add(OAUTH_CLIENT);
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        contexts.add(SRI);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForOAuthAccessToken() {
        List<SourceContextType> contexts = SourceContextType.getContextTypesForOAuth();
        contexts.add(OAUTH_RESOURCES);
        contexts.add(OAUTH_AUTHORIZATION_DETAILS);
        return contexts;
    }

    public static List<SourceContextType> getContextTypesForSource2Target() {
        ArrayList<SourceContextType> contexts = new ArrayList<SourceContextType>();
        contexts.add(CLIENT_IP);
        contexts.add(REQUEST);
        contexts.add(STS_BASIC_AUTH_USERNAME);
        contexts.add(STS_SSL_CLIENT_CERT_SUBJECT_DN);
        contexts.add(STS_SSL_CLIENT_CERT_CHAIN);
        return contexts;
    }

    public static Set<String> getContextIds() {
        return ID_2_CONTEXT.keySet();
    }

    public static List<SourceContextType> getUntestableContextTypes() {
        ArrayList<SourceContextType> untestableTypes = new ArrayList<SourceContextType>();
        untestableTypes.add(REQUEST);
        return untestableTypes;
    }

    public static List<SourceContextType> getContextTypesForOAuthWebRedirectFlowMapping() {
        ArrayList<SourceContextType> idpAdapterMappingTypes = new ArrayList<SourceContextType>();
        idpAdapterMappingTypes.add(OAUTH_SCOPES);
        idpAdapterMappingTypes.add(OAUTH_AUTHORIZATION_DETAILS);
        idpAdapterMappingTypes.add(OAUTH_CLIENT);
        idpAdapterMappingTypes.add(CLIENT_IP);
        idpAdapterMappingTypes.add(REQUEST);
        idpAdapterMappingTypes.add(CLAIMS_LOCALES);
        idpAdapterMappingTypes.add(OAUTH_DEFAULT_PERSISTENT_GRANT_LIFETIME);
        idpAdapterMappingTypes.add(SRI);
        return idpAdapterMappingTypes;
    }

    public static List<SourceContextType> getContextTypesForCibaRequestMappings() {
        return Arrays.asList(OAUTH_SCOPES, LOCALE, OAUTH_CLIENT, REQUEST, CLIENT_IP, OAUTH_AUTHORIZATION_DETAILS);
    }

    public static List<SourceContextType> getContextTypesForTokenExchangeProcessorPolicyMappings() {
        return Arrays.asList(OAUTH_SCOPES, OAUTH_CLIENT, REQUEST, CLIENT_IP, OAUTH_AUTHORIZATION_DETAILS);
    }

    public static List<SourceContextType> getContextTypesForOIDCRequestParams() {
        return Arrays.asList(OAUTH_SCOPES, REQUEST, CLIENT_IP, CHAINED_ATTRIBUTES, SAML_AUTHN_REQUEST, SP_CONN_ENTITY_ID, OAUTH_CLIENT, SIGNED_REQUEST_OBJECT_CLAIMS, OAUTH_AUTHORIZATION_DETAILS, SRI);
    }

    static {
        ID_2_CONTEXT = new HashMap<String, SourceContextType>();
        DESCRIPTION_2_CONTEXT = new HashMap<String, SourceContextType>();
        for (SourceContextType sourceContextType : SourceContextType.values()) {
            ID_2_CONTEXT.put(sourceContextType.id, sourceContextType);
            DESCRIPTION_2_CONTEXT.put(sourceContextType.description, sourceContextType);
        }
    }
}

