/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.OgnlHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SimpleConditionEvaluator;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SourceTypeString;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.util.log.AttributeMap;

public class TokenAuthorizationIssuanceCriteriaChecker {
    private static final Log log = LogFactory.getLog(TokenAuthorizationIssuanceCriteriaChecker.class);
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String ISSUANCE_CRITERIA_FAILED = "ACCESS_DENIED";

    public static void checkCriteria(AttributeMap srcAttributes, AttributeMap mappedAttributes, AttributeMap dsAttributes, List<TokenAuthorizationIssuanceCriterion> tokenAuthorizationIssuanceCriteria) throws AuthorizationException {
        HashMap<String, AttributeMap> srcAttributesMap = new HashMap<String, AttributeMap>();
        if (srcAttributes != null) {
            srcAttributesMap.put(null, srcAttributes);
        }
        TokenAuthorizationIssuanceCriteriaChecker.checkCriteria(srcAttributesMap, mappedAttributes, dsAttributes, tokenAuthorizationIssuanceCriteria);
    }

    public static void checkCriteria(HashMap<String, AttributeMap> srcAttributesMap, AttributeMap mappedAttributes, AttributeMap dsAttributes, List<TokenAuthorizationIssuanceCriterion> tokenAuthorizationIssuanceCriteria) throws AuthorizationException {
        block6: for (TokenAuthorizationIssuanceCriterion criterion : tokenAuthorizationIssuanceCriteria) {
            switch (criterion.getAttrSourceType()) {
                case IDP_CONNECTION: 
                case PASSWORD_CREDENTIAL_VALIDATOR: 
                case ADAPTER: 
                case CONTEXT: 
                case ASSERTION: 
                case CLAIMS: 
                case OAUTH_PERSISTENT_GRANT: 
                case TOKEN: 
                case REQUEST: 
                case ATTRIBUTE_QUERY: 
                case ACCOUNT_LINK: 
                case IDENTITY_STORE_USER: 
                case IDENTITY_STORE_GROUP: 
                case FRAGMENT: 
                case INPUTS: 
                case LOCAL_IDENTITY_PROFILE: 
                case AUTHENTICATION_POLICY_CONTRACT: 
                case EXTENDED_CLIENT_METADATA: 
                case EXTENDED_PROPERTIES: 
                case TRACKED_HTTP_PARAMS: 
                case ACTOR_TOKEN: 
                case SUBJECT_TOKEN: 
                case TOKEN_EXCHANGE_PROCESSOR_POLICY: {
                    AttributeMap srcAttributes = srcAttributesMap.get(AttributeMapping.createAttrSourceKey(criterion.getAttrSourceType(), criterion.getAttrSourceId()));
                    TokenAuthorizationIssuanceCriteriaChecker.simpleCompare(srcAttributes, criterion);
                    continue block6;
                }
                case MAPPED_ATTRIBUTES: {
                    TokenAuthorizationIssuanceCriteriaChecker.simpleCompare(mappedAttributes, criterion);
                    continue block6;
                }
                case JDBC_DATA_STORE: 
                case LDAP_DATA_STORE: 
                case OTHER_DATA_STORE: {
                    TokenAuthorizationIssuanceCriterion newCrit = criterion.clone();
                    if (criterion.getAttrSourceId() != null && !criterion.getAttrSourceId().isEmpty()) {
                        newCrit.setAttrName(criterion.getAttrSourceId() + "." + criterion.getAttrName());
                    }
                    TokenAuthorizationIssuanceCriteriaChecker.simpleCompare(dsAttributes, newCrit);
                    continue block6;
                }
                case EXPRESSION: {
                    TokenAuthorizationIssuanceCriteriaChecker.advancedCompare(srcAttributesMap, mappedAttributes, dsAttributes, criterion);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Invalid attribute source type: " + criterion.getAttrSourceType());
        }
    }

    private static void simpleCompare(AttributeMap attributes, TokenAuthorizationIssuanceCriterion taCriterion) throws AuthorizationException {
        if (!SimpleConditionEvaluator.evaluate(attributes, taCriterion)) {
            TokenAuthorizationIssuanceCriteriaChecker.createAuthorizationException(taCriterion, (AttributeValue)attributes.get((Object)taCriterion.getAttrName()));
        }
    }

    private static void advancedCompare(HashMap<String, AttributeMap> srcAttributesMap, AttributeMap mappedAttributes, AttributeMap dsAttributes, TokenAuthorizationIssuanceCriterion taCriterion) throws AuthorizationException {
        try {
            ExpressionManager expressionManager = ExpressionManager.getInstance();
            if (expressionManager.isEvaluateExpressionsOff()) {
                String err = "An OGNL Issuance Criteria is set, but OGNL expressions are disabled. Failing issuance criteria.";
                log.warn((Object)err);
                throw new AuthorizationException("Authorization failed (" + err + ")", err);
            }
            Object parsedExpression = Ognl.parseExpression((String)taCriterion.getExpr());
            OgnlHelper ognlHelper = new OgnlHelper();
            ognlHelper.searchForAllVariableNames(parsedExpression);
            Map<String, Object> combinedAttributes = TokenAuthorizationIssuanceCriteriaChecker.combineAttributeMaps(srcAttributesMap, mappedAttributes, dsAttributes);
            Object results = ognlHelper.processOgnlExpression(parsedExpression, combinedAttributes, combinedAttributes);
            if (results instanceof Boolean) {
                if (results.equals(Boolean.FALSE)) {
                    TokenAuthorizationIssuanceCriteriaChecker.createAuthorizationException(taCriterion, new AttributeValue("false"));
                }
            } else {
                TokenAuthorizationIssuanceCriterion newTaCriterion = taCriterion.clone();
                if (results != null) {
                    newTaCriterion.setErrorResult(results.toString());
                    TokenAuthorizationIssuanceCriteriaChecker.createAuthorizationException(newTaCriterion, new AttributeValue(results.toString()));
                } else {
                    TokenAuthorizationIssuanceCriteriaChecker.createAuthorizationException(newTaCriterion, null);
                }
            }
        }
        catch (OgnlException e) {
            log.error((Object)"Exception occured while trying to resolve ognl expression", (Throwable)e);
            TokenAuthorizationIssuanceCriteriaChecker.createAuthorizationException(taCriterion, new AttributeValue("false (Exception)"));
        }
    }

    private static Map<String, Object> combineAttributeMaps(HashMap<String, AttributeMap> srcAttributesMap, AttributeMap mappedAttributes, AttributeMap dsAttributes) {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, AttributeMap> srcAttrsEntry : srcAttributesMap.entrySet()) {
            String key = srcAttrsEntry.getKey();
            boolean noPrefix = key == null || key.equals("context") || key.equals("subjecttoken") || key.equals("actortoken");
            String friendlyAttrSourceId = null;
            if (key != null && key.startsWith("idp.")) {
                String realAttrSourceId = key.substring("idp.".length());
                IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(realAttrSourceId, false);
                if (idpConn != null) {
                    friendlyAttrSourceId = "idp." + idpConn.getEntityId();
                }
            }
            for (Map.Entry attrEntry : srcAttrsEntry.getValue().entrySet()) {
                String fullSrcKey = noPrefix ? (String)attrEntry.getKey() : (String)(friendlyAttrSourceId == null ? key : friendlyAttrSourceId) + "." + (String)attrEntry.getKey();
                newAttributes.put(fullSrcKey, attrEntry.getValue());
            }
        }
        for (String key : mappedAttributes.keySet()) {
            newAttributes.put("mapped." + key, mappedAttributes.get((Object)key));
        }
        for (String key : dsAttributes.keySet()) {
            newAttributes.put("ds." + key, dsAttributes.get((Object)key));
        }
        return newAttributes;
    }

    private static void createAuthorizationException(TokenAuthorizationIssuanceCriterion taCriterion, AttributeValue attributeValue) throws AuthorizationException {
        StringBuilder sb = new StringBuilder();
        sb.append("Source Type: ").append(SourceTypeString.getTypeString(taCriterion.getAttrSourceType())).append(NEW_LINE);
        if (taCriterion.getAttrSourceType() != SourceType.EXPRESSION) {
            sb.append("Attribute Name: ").append(taCriterion.getAttrName()).append(NEW_LINE);
            sb.append("Condition: ").append(taCriterion.getCondition().getDescription()).append(NEW_LINE);
            sb.append("Comparison Value: ").append(taCriterion.getComparisonValue()).append(NEW_LINE);
        } else {
            sb.append("Expression: {hidden}").append(NEW_LINE);
        }
        sb.append("Actual Value(s): ");
        if (attributeValue == null) {
            sb.append("No Value");
        } else if (attributeValue.isMasked()) {
            sb.append("******");
        } else {
            for (String value : attributeValue.getValues()) {
                sb.append(LogGuard.encode(value)).append(" ");
            }
        }
        log.info((Object)("Authorization failed.  The following criterion was not met..." + NEW_LINE + sb.toString()));
        String errorResult = StringUtils.isEmpty((CharSequence)taCriterion.getErrorResult()) ? ISSUANCE_CRITERIA_FAILED : taCriterion.getErrorResult();
        throw new AuthorizationException(errorResult, errorResult, "ISSUANCE_CRITERIA_FAILED");
    }
}

