/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import org.sourceid.saml20.domain.ConditionType;
import org.sourceid.saml20.domain.SimpleConditionRule;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SourceTypeString;

public class TokenAuthorizationIssuanceCriterion
implements Serializable,
Cloneable,
SimpleConditionRule {
    private static final long serialVersionUID = 20120712L;
    private SourceType attrSourceType = null;
    private String attrSourceId = null;
    private String attrName = null;
    private String expr = null;
    private ConditionType condition = null;
    private String comparisonValue = null;
    private String errorResult = null;

    public TokenAuthorizationIssuanceCriterion clone() {
        TokenAuthorizationIssuanceCriterion clone = new TokenAuthorizationIssuanceCriterion();
        clone.setAttrName(this.attrName);
        clone.setAttrSourceType(this.attrSourceType);
        clone.setAttrSourceId(this.attrSourceId);
        clone.setCondition(this.condition);
        clone.setErrorResult(this.errorResult);
        clone.setComparisonValue(this.comparisonValue);
        clone.setExpr(this.expr);
        return clone;
    }

    public SourceType getAttrSourceType() {
        return this.attrSourceType;
    }

    public String getAttrSourceTypeAsString() {
        return SourceTypeString.getTypeString(this.attrSourceType);
    }

    public void setAttrSourceType(SourceType attrSourceType) {
        this.attrSourceType = attrSourceType;
    }

    public void setAttrSourceTypeAsString(String attrSourceTypeString) {
        this.attrSourceType = SourceTypeString.strToType(attrSourceTypeString);
    }

    public String getAttrSourceId() {
        return this.attrSourceId;
    }

    public void setAttrSourceId(String attrSourceId) {
        this.attrSourceId = attrSourceId;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
    }

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public ConditionType getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionType condition) {
        this.condition = condition;
    }

    public void setConditionById(String conditionId) {
        if (conditionId == null) {
            this.condition = null;
        } else if (ConditionType.MULTIVALUE_CONTAINS.getId().equals(conditionId)) {
            this.condition = ConditionType.MULTIVALUE_CONTAINS;
        } else if (ConditionType.MULTIVALUE_CONTAINS_CASE_INSENSITIVE.getId().equals(conditionId)) {
            this.condition = ConditionType.MULTIVALUE_CONTAINS_CASE_INSENSITIVE;
        } else if (ConditionType.MULTIVALUE_DOES_NOT_CONTAIN.getId().equals(conditionId)) {
            this.condition = ConditionType.MULTIVALUE_DOES_NOT_CONTAIN;
        } else if (ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_CASE_INSENSITIVE.getId().equals(conditionId)) {
            this.condition = ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_CASE_INSENSITIVE;
        } else if (ConditionType.EQUALS.getId().equals(conditionId)) {
            this.condition = ConditionType.EQUALS;
        } else if (ConditionType.EQUALS_CASE_INSENSITIVE.getId().equals(conditionId)) {
            this.condition = ConditionType.EQUALS_CASE_INSENSITIVE;
        } else if (ConditionType.NOT_EQUAL.getId().equals(conditionId)) {
            this.condition = ConditionType.NOT_EQUAL;
        } else if (ConditionType.NOT_EQUAL_CASE_INSENSITIVE.getId().equals(conditionId)) {
            this.condition = ConditionType.NOT_EQUAL_CASE_INSENSITIVE;
        } else if (ConditionType.EQUALS_DN.getId().equals(conditionId)) {
            this.condition = ConditionType.EQUALS_DN;
        } else if (ConditionType.NOT_EQUAL_DN.getId().equals(conditionId)) {
            this.condition = ConditionType.NOT_EQUAL_DN;
        } else if (ConditionType.MULTIVALUE_CONTAINS_DN.getId().equals(conditionId)) {
            this.condition = ConditionType.MULTIVALUE_CONTAINS_DN;
        } else if (ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_DN.getId().equals(conditionId)) {
            this.condition = ConditionType.MULTIVALUE_DOES_NOT_CONTAIN_DN;
        } else {
            throw new IllegalArgumentException("Invalid condition id: " + conditionId);
        }
    }

    public String getComparisonValue() {
        return this.comparisonValue;
    }

    public void setComparisonValue(String value) {
        this.comparisonValue = value;
    }

    public String getErrorResult() {
        return this.errorResult;
    }

    public void setErrorResult(String errorResult) {
        this.errorResult = errorResult;
    }

    public boolean isMarkedForDelete() {
        return false;
    }

    @Override
    public String getConditionField() {
        return this.getAttrName();
    }

    @Override
    public ConditionType getConditionOperator() {
        return this.getCondition();
    }

    @Override
    public String getConditionValue() {
        return this.getComparisonValue();
    }
}

