/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum UserConstants {
    ID("id"),
    EXTERNAL_ID("externalId"),
    SCHEMA_USERS("schema.users"),
    USER_NAME("userName"),
    NAME_FORMATTED("name.formatted"),
    NAME_FAMILY_NAME("name.familyName"),
    NAME_GIVEN_NAME("name.givenName"),
    NAME_MIDDLE_NAME("name.middleName"),
    NAME_HONORIFIC_PREFIX("name.honorificPrefix"),
    NAME_HONORIFIC_SUFFIX("name.honorificSuffix"),
    DISPLAY_NAME("displayName"),
    NICK_NAME("nickName"),
    PROFILE_URL("profileUrl"),
    EMAILS_WORK_TYPE("emails.work.type"),
    EMAILS_WORK_VALUE("emails.work.value"),
    EMAILS_WORK_IS_PRIMARY("emails.work.isPrimary"),
    EMAILS_HOME_TYPE("emails.home.type"),
    EMAILS_HOME_VALUE("emails.home.value"),
    EMAILS_HOME_IS_PRIMARY("emails.home.isPrimary"),
    EMAILS_OTHER_TYPE("emails.other.type"),
    EMAILS_OTHER_VALUE("emails.other.value"),
    EMAILS_OTHER_IS_PRIMARY("emails.other.isPrimary"),
    ADDRESSES_WORK_TYPE("addresses.work.type"),
    ADDRESSES_WORK_STREET_ADDRESS("addresses.work.streetAddress"),
    ADDRESSES_WORK_LOCALITY("addresses.work.locality"),
    ADDRESSES_WORK_REGION("addresses.work.region"),
    ADDRESSES_WORK_POSTAL_CODE("addresses.work.postalCode"),
    ADDRESSES_WORK_COUNTRY("addresses.work.country"),
    ADDRESSES_WORK_FORMATTED("addresses.work.formatted"),
    ADDRESSES_WORK_IS_PRIMARY("addresses.work.isPrimary"),
    ADDRESSES_HOME_TYPE("addresses.home.type"),
    ADDRESSES_HOME_STREET_ADDRESS("addresses.home.streetAddress"),
    ADDRESSES_HOME_LOCALITY("addresses.home.locality"),
    ADDRESSES_HOME_REGION("addresses.home.region"),
    ADDRESSES_HOME_POSTAL_CODE("addresses.home.postalCode"),
    ADDRESSES_HOME_COUNTRY("addresses.home.country"),
    ADDRESSES_HOME_FORMATTED("addresses.home.formatted"),
    ADDRESSES_HOME_IS_PRIMARY("addresses.home.isPrimary"),
    ADDRESSES_OTHER_TYPE("addresses.other.type"),
    ADDRESSES_OTHER_STREET_ADDRESS("addresses.other.streetAddress"),
    ADDRESSES_OTHER_LOCALITY("addresses.other.locality"),
    ADDRESSES_OTHER_REGION("addresses.other.region"),
    ADDRESSES_OTHER_POSTAL_CODE("addresses.other.postalCode"),
    ADDRESSES_OTHER_COUNTRY("addresses.other.country"),
    ADDRESSES_OTHER_FORMATTED("addresses.other.formatted"),
    ADDRESSES_OTHER_IS_PRIMARY("addresses.other.isPrimary"),
    PHONE_NUMBERS_WORK_TYPE("phoneNumbers.work.type"),
    PHONE_NUMBERS_WORK_VALUE("phoneNumbers.work.value"),
    PHONE_NUMBERS_WORK_IS_PRIMARY("phoneNumbers.work.isPrimary"),
    PHONE_NUMBERS_HOME_TYPE("phoneNumbers.home.type"),
    PHONE_NUMBERS_HOME_VALUE("phoneNumbers.home.value"),
    PHONE_NUMBERS_HOME_IS_PRIMARY("phoneNumbers.home.isPrimary"),
    PHONE_NUMBERS_MOBILE_TYPE("phoneNumbers.mobile.type"),
    PHONE_NUMBERS_MOBILE_VALUE("phoneNumbers.mobile.value"),
    PHONE_NUMBERS_MOBILE_IS_PRIMARY("phoneNumbers.mobile.isPrimary"),
    PHONE_NUMBERS_FAX_TYPE("phoneNumbers.fax.type"),
    PHONE_NUMBERS_FAX_VALUE("phoneNumbers.fax.value"),
    PHONE_NUMBERS_FAX_IS_PRIMARY("phoneNumbers.fax.isPrimary"),
    PHONE_NUMBERS_PAGER_TYPE("phoneNumbers.pager.type"),
    PHONE_NUMBERS_PAGER_VALUE("phoneNumbers.pager.value"),
    PHONE_NUMBERS_PAGER_IS_PRIMARY("phoneNumbers.pager.isPrimary"),
    PHONE_NUMBERS_OTHER_TYPE("phoneNumbers.other.type"),
    PHONE_NUMBERS_OTHER_VALUE("phoneNumbers.other.value"),
    PHONE_NUMBERS_OTHER_IS_PRIMARY("phoneNumbers.other.isPrimary"),
    IMS_AIM_TYPE("ims.aim.type"),
    IMS_AIM_VALUE("ims.aim.value"),
    IMS_AIM_IS_PRIMARY("ims.aim.isPrimary"),
    IMS_GTALK_TYPE("ims.gtalk.type"),
    IMS_GTALK_VALUE("ims.gtalk.value"),
    IMS_GTALK_IS_PRIMARY("ims.gtalk.isPrimary"),
    IMS_ICQ_TYPE("ims.icq.type"),
    IMS_ICQ_VALUE("ims.icq.value"),
    IMS_ICQ_IS_PRIMARY("ims.icq.isPrimary"),
    IMS_XMPP_TYPE("ims.xmpp.type"),
    IMS_XMPP_VALUE("ims.xmpp.value"),
    IMS_XMPP_IS_PRIMARY("ims.xmpp.isPrimary"),
    IMS_MSN_TYPE("ims.msn.type"),
    IMS_MSN_VALUE("ims.msn.value"),
    IMS_MSN_IS_PRIMARY("ims.msn.isPrimary"),
    IMS_SKYPE_TYPE("ims.skype.type"),
    IMS_SKYPE_VALUE("ims.skype.value"),
    IMS_SKYPE_IS_PRIMARY("ims.skype.isPrimary"),
    IMS_QQ_TYPE("ims.qq.type"),
    IMS_QQ_VALUE("ims.qq.value"),
    IMS_QQ_IS_PRIMARY("ims.qq.isPrimary"),
    IMS_YAHOO_TYPE("ims.yahoo.type"),
    IMS_YAHOO_VALUE("ims.yahoo.value"),
    IMS_YAHOO_IS_PRIMARY("ims.yahoo.isPrimary"),
    PHOTOS_PHOTO_TYPE("photos.photo.type"),
    PHOTOS_PHOTO_VALUE("photos.photo.value"),
    PHOTOS_PHOTO_IS_PRIMARY("photos.photo.isPrimary"),
    PHOTOS_THUMBNAIL_TYPE("photos.thumbnail.type"),
    PHOTOS_THUMBNAIL_VALUE("photos.thumbnail.value"),
    PHOTOS_THUMBNAIL_IS_PRIMARY("photos.thumbnail.isPrimary"),
    USER_TYPE("userType"),
    TITLE("title"),
    PREFERRED_LANGUAGE("preferredLanguage"),
    LOCALE("locale"),
    TIMEZONE("timezone"),
    ACTIVE("active"),
    PASSWORD("password"),
    META_VERSION("meta.version"),
    META_LOCATION("meta.location"),
    META_CREATED("meta.created"),
    META_LAST_MODIFIED("meta.lastModified");

    private String id;
    private static final Map<String, UserConstants> m;

    private UserConstants(String id) {
        this.id = id;
    }

    public static UserConstants getUserConstant(String strToConvert) {
        return m.get(strToConvert);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public static List<String> getAllIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (UserConstants c : UserConstants.values()) {
            ids.add(c.getId());
        }
        Collections.sort(ids);
        return ids;
    }

    public static List<String> getAllIdsForReadUsers() {
        ArrayList<UserConstants> notReadable = new ArrayList<UserConstants>();
        notReadable.add(PASSWORD);
        notReadable.add(ID);
        notReadable.add(ACTIVE);
        notReadable.add(META_VERSION);
        notReadable.add(META_LOCATION);
        notReadable.add(META_CREATED);
        notReadable.add(META_LAST_MODIFIED);
        ArrayList<String> ids = new ArrayList<String>();
        for (UserConstants c : UserConstants.values()) {
            if (notReadable.contains((Object)c)) continue;
            ids.add(c.getId());
        }
        Collections.sort(ids);
        return ids;
    }

    public static List<String> getAllMappableIdsForWriteUsers() {
        ArrayList<UserConstants> notMappable = new ArrayList<UserConstants>();
        notMappable.add(ID);
        notMappable.add(ACTIVE);
        notMappable.add(META_VERSION);
        notMappable.add(META_LOCATION);
        notMappable.add(META_CREATED);
        notMappable.add(META_LAST_MODIFIED);
        ArrayList<String> ids = new ArrayList<String>();
        for (UserConstants c : UserConstants.values()) {
            if (notMappable.contains((Object)c)) continue;
            ids.add(c.getId());
        }
        Collections.sort(ids);
        return ids;
    }

    public static List<String> getAllMappableIdsForIdentityStorePluginWriteUsers() {
        ArrayList<String> ids = new ArrayList<String>();
        for (UserConstants c : UserConstants.values()) {
            ids.add(c.getId());
        }
        Collections.sort(ids);
        return ids;
    }

    static {
        m = new HashMap<String, UserConstants>();
        for (UserConstants c : UserConstants.values()) {
            m.put(c.toString(), c);
        }
    }
}

