/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.sdk.DeviceSharingType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public enum UserDeviceType {
    PRIVATE("Private"),
    SHARED("Shared"),
    ANY("Any");

    private final String displayName;

    private UserDeviceType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean matches(DeviceSharingType deviceSharingType) {
        switch (this) {
            case PRIVATE: {
                return Arrays.asList(DeviceSharingType.UNSPECIFIED, DeviceSharingType.PRIVATE).contains(deviceSharingType);
            }
            case SHARED: {
                return deviceSharingType == DeviceSharingType.SHARED;
            }
            case ANY: {
                return true;
            }
        }
        throw new ProcessRuntimeException("Unexpected user device value: " + this.name());
    }

    public static List<String> getByDisplayNames(List<UserDeviceType> userDeviceTypes) {
        if (userDeviceTypes == null) {
            return new ArrayList<String>();
        }
        return userDeviceTypes.stream().filter(Objects::nonNull).map(UserDeviceType::getDisplayName).sorted().collect(Collectors.toList());
    }

    public static List<UserDeviceType> getUserDeviceFromDisplayNames(List<String> displayNames) {
        if (displayNames == null) {
            return new ArrayList<UserDeviceType>();
        }
        return displayNames.stream().filter(Objects::nonNull).map(String::toUpperCase).map(UserDeviceType::valueOf).sorted().collect(Collectors.toList());
    }

    public static UserDeviceType getDefaultUserDevice() {
        return PRIVATE;
    }
}

