/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsTrustTokenAttributeContract;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class WsTrustFederatedWspSettings
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, TokenPluginAttributeMapping> assertionToTokenMappings = new HashMap();
    private boolean decryptAssertion;
    private WsTrustTokenAttributeContract attributeContract;
    private String defaultAssertionToTokenMappingsMappingId;
    private boolean isWsTrustVersion13;

    public Collection<TokenPluginAttributeMapping> getAssertionToTokenMappingsMappings() {
        return this.assertionToTokenMappings.values();
    }

    public Set<String> getIncomingTokenGenerators() {
        return this.assertionToTokenMappings.keySet();
    }

    public TokenPluginAttributeMapping getAssertionToTokenMappingByGeneratorId(String generatorId) {
        if (!this.assertionToTokenMappings.containsKey(generatorId)) {
            throw new ProcessRuntimeException("No mapping for generator " + generatorId);
        }
        return this.assertionToTokenMappings.get(generatorId);
    }

    public void setAssertionToTokenMappings(Collection<TokenPluginAttributeMapping> mappingsCollection) {
        this.assertionToTokenMappings.clear();
        for (TokenPluginAttributeMapping mapping : mappingsCollection) {
            this.assertionToTokenMappings.put(mapping.getPluginId(), mapping);
        }
    }

    public WsTrustTokenAttributeContract getAttributeContract() {
        return this.attributeContract;
    }

    public void setAttributeContract(WsTrustTokenAttributeContract attributeContract) {
        this.attributeContract = attributeContract;
    }

    public boolean isDecryptAssertion() {
        return this.decryptAssertion;
    }

    public void setDecryptAssertion(boolean decryptAssertion) {
        this.decryptAssertion = decryptAssertion;
    }

    public String getDefaultAssertionToTokenMappingsMappingId() {
        return this.defaultAssertionToTokenMappingsMappingId;
    }

    public void setDefaultAssertionToTokenMappingsMappingId(String defaultAssertionToTokenMappingsMappingId) {
        this.defaultAssertionToTokenMappingsMappingId = defaultAssertionToTokenMappingsMappingId;
    }

    public boolean isWsTrustVersion13() {
        return this.isWsTrustVersion13;
    }

    public void setWsTrustVersion13(boolean wsTrustVersion13) {
        this.isWsTrustVersion13 = wsTrustVersion13;
    }

    public WsTrustFederatedWspSettings clone() {
        WsTrustFederatedWspSettings clone = new WsTrustFederatedWspSettings();
        clone.assertionToTokenMappings = new HashMap<String, TokenPluginAttributeMapping>(this.assertionToTokenMappings);
        clone.decryptAssertion = this.decryptAssertion;
        clone.attributeContract = this.attributeContract != null ? new WsTrustTokenAttributeContract(this.attributeContract) : null;
        clone.defaultAssertionToTokenMappingsMappingId = this.defaultAssertionToTokenMappingsMappingId;
        clone.isWsTrustVersion13 = this.isWsTrustVersion13;
        return clone;
    }
}

