/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.datasource.tag;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.datasource.tag.DataSourceTag;
import org.sourceid.saml20.domain.datasource.tag.DataSourceTagConfig;
import org.sourceid.saml20.domain.datasource.tag.JdbcInstanceIdentifier;

@ApiModel(description="A JDBC data store's connection URLs and tags configuration. For regional deployments, provide a separate JdbcTagConfig for each region, containing the region-specific connection URL and the corresponding tags.", parent=DataSourceTag.class)
@JsonPropertyOrder(value={"connectionUrl", "tags", "defaultSource"})
public class JdbcTagConfig
implements DataSourceTagConfig,
Serializable,
Cloneable {
    private static final long serialVersionUID = -4152751212696852643L;
    private JdbcInstanceIdentifier identifier;
    private DataSourceTag tagConfig;

    @JsonCreator
    public JdbcTagConfig(@JsonProperty(value="connectionUrl") JdbcInstanceIdentifier identifier, @JsonProperty(value="tags") String tags, @JsonProperty(value="defaultSource") boolean isDefault) {
        this.tagConfig = new DataSourceTag(tags, isDefault);
        this.identifier = identifier;
    }

    @JsonIgnore
    public JdbcInstanceIdentifier getIdentifier() {
        return this.identifier;
    }

    @JsonIgnore
    public Set<String> getTagsHashSet() {
        if (this.tagConfig != null) {
            return this.tagConfig.getTagsHashSet();
        }
        return new HashSet<String>();
    }

    @ApiModelProperty(position=10, value="The location of the JDBC database. ", required=true)
    public String getConnectionUrl() {
        return this.identifier != null ? this.identifier.getJdbcUrl() : "";
    }

    public void setConnectionUrl(String jdbcUrl) {
        this.identifier = new JdbcInstanceIdentifier(jdbcUrl);
    }

    @ApiModelProperty(position=50, value="Tags associated with the connection URL. At runtime, nodes will use the first JdbcTagConfig that has a tag that matches with node.tags in run.properties.")
    public String getTags() {
        if (this.tagConfig != null) {
            if (StringUtils.isEmpty((String)this.tagConfig.getTags())) {
                return null;
            }
            return this.tagConfig.getTags();
        }
        return null;
    }

    @ApiModelProperty(position=60, value="Whether this is the default connection. Defaults to false if not specified.")
    public boolean isDefaultSource() {
        return this.tagConfig != null && this.tagConfig.isDefaultSource();
    }

    public int hashCode() {
        int prime = 31;
        int result = 3;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.tagConfig == null ? 0 : this.tagConfig.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JdbcTagConfig)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public JdbcTagConfig clone() throws CloneNotSupportedException {
        JdbcTagConfig clone = (JdbcTagConfig)super.clone();
        clone.identifier = this.identifier.clone();
        clone.tagConfig = this.tagConfig.clone();
        return clone;
    }
}

