/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.impl;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.Substituter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.DataSourceParameter;

public abstract class AttributeSourceBase
implements AttributeSource,
Serializable,
ServiceInformation {
    private static final long serialVersionUID = 20050515L;
    protected String id;
    protected String description;
    protected String dataSourceId;
    protected Map<String, String> parameterMap = new HashMap<String, String>();
    protected Map<String, String> attributeTypeMap = new HashMap<String, String>();

    public String getServiceName() {
        return "attribute-source";
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSourceId = dataSource.getId();
    }

    @Override
    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    @Override
    public String getDataSourceId() {
        return this.dataSourceId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Map<String, String> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public DataSourceParameter[] getParameterArray() {
        DataSourceParameter[] params = null;
        if (this.parameterMap.size() > 0) {
            params = new DataSourceParameter[this.parameterMap.size()];
            Set<String> keys = this.parameterMap.keySet();
            Iterator<String> iter = keys.iterator();
            int i = 0;
            while (iter.hasNext()) {
                String name = iter.next();
                params[i] = new DataSourceParameter();
                params[i].setName(name);
                params[i].setValue(this.parameterMap.get(name));
                ++i;
            }
        }
        return params;
    }

    @Override
    public void setParameterMap(Map<String, String> parameterMap) {
        this.parameterMap = parameterMap;
    }

    @Override
    public void setParameter(String name, String value) {
        this.parameterMap.put(name, value);
    }

    @Override
    public String getParameter(String name) {
        return this.parameterMap.get(name);
    }

    @Override
    public String removeParameter(String name) {
        return this.parameterMap.remove(name);
    }

    public boolean needMask(Set<String> maskedAttributeNames, String filter) {
        if (!maskedAttributeNames.isEmpty()) {
            for (String subRef : Substituter.parseReferences((String)filter)) {
                if (!maskedAttributeNames.contains(subRef)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, String> getAttributeEncodingTypeMap() {
        return this.attributeTypeMap;
    }

    @Override
    public void setAttributeEncodingType(String name, String type) {
        this.attributeTypeMap.put(name, type);
    }
}

