/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.impl;

import com.pingidentity.common.util.Substituter;
import com.pingidentity.common.util.timers.DSEventTimer;
import com.pingidentity.sources.CustomDataSourceDriver;
import com.pingidentity.sources.CustomDataSourceDriverException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.StringSubstituter;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.SystemAttrLookupException;
import org.sourceid.saml20.domain.impl.AttributeSourceBase;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class CustomAttributeSource
extends AttributeSourceBase {
    private static final long serialVersionUID = 20050515L;
    static final transient Log log = LogFactory.getLog(CustomAttributeSource.class);

    @Override
    public AttributeMap executeAttributeLookup(AttributeMap srcAttrs, Collection<String> attrNames) throws AttrLookupException {
        DataSource dataSrc = this.getDataSource();
        if (dataSrc != null) {
            return this.executeCustomAttributeLookup((CustomDataSource)dataSrc, srcAttrs, attrNames);
        }
        return new AttributeMap();
    }

    @Override
    public DataSource getDataSource() {
        if (!StringUtils.isBlank((String)this.dataSourceId)) {
            DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
            return dataSourceManager.getCustomDataSource(this.dataSourceId);
        }
        return null;
    }

    private AttributeMap executeCustomAttributeLookup(CustomDataSource dataSource, AttributeMap srcAttrs, Collection<String> attrNames) throws AttrLookupException {
        Map result;
        CustomDataSourceDriver attrDriver = dataSource.getDriver();
        if (attrDriver == null) {
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            dsMgr.loadCustomDataSourceDriver(dataSource);
            attrDriver = dataSource.getDriver();
        }
        Set<Map.Entry<String, String>> paramMap = this.getParameterMap().entrySet();
        Iterator<Map.Entry<String, String>> iter = paramMap.iterator();
        ArrayList<Field> configFields = new ArrayList<Field>();
        try {
            while (iter.hasNext()) {
                AttributeMap srcAttrEncoded;
                Map.Entry<String, String> entry;
                String val = Substituter.substituteValues(entry.getValue(), (Map)((srcAttrEncoded = this.getEncodedAttributeMap(srcAttrs, attrDriver, entry = iter.next())).size() > 0 ? srcAttrEncoded : srcAttrs));
                configFields.add(new Field(entry.getKey(), val));
            }
        }
        catch (Substituter.UnknownKeyException e) {
            throw new AttrLookupException("Error occurred while performing an attribute lookup (" + this.getIdForLog() + ")", (Throwable)((Object)e));
        }
        if (log.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("Custom Attr Src search: search attrNames=").append(Arrays.toString(attrNames.toArray()));
            log.debug((Object)msg.toString());
        }
        SimpleFieldList filterConfig = new SimpleFieldList(configFields);
        try (DSEventTimer ignored = DSEventTimer.getOtherInstance(dataSource.getId(), dataSource.getName(), "retrieve-attributes", this);){
            result = attrDriver.retrieveValues(attrNames, filterConfig);
        }
        catch (CustomDataSourceDriverException | RuntimeException e) {
            DSEventTimer.incrementOtherErrors(dataSource.getId());
            throw new SystemAttrLookupException("Error occurred while performing an attribute lookup (" + this.getIdForLog() + ")", e);
        }
        boolean maskAttributeValues = dataSource.isMaskAttributeValues();
        AttributeMap convertedResult = AttrValueSupport.convert((Map)result, (boolean)maskAttributeValues, (boolean)true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Custom Attr Src search result: " + convertedResult));
        }
        return convertedResult;
    }

    private AttributeMap getEncodedAttributeMap(AttributeMap srcAttrs, CustomDataSourceDriver attrDriver, Map.Entry<String, String> entry) {
        AttributeMap substitutionAttrEncoded = new AttributeMap();
        Set sourceAttributeReferences = StringSubstituter.parseReferences((String)entry.getValue());
        if (sourceAttributeReferences.size() > 0) {
            for (String sourceAttributeRef : sourceAttributeReferences) {
                AttributeValue sourceAttrValues = (AttributeValue)srcAttrs.get((Object)sourceAttributeRef);
                if (sourceAttrValues == null) continue;
                ArrayList<String> encodedVals = new ArrayList<String>();
                for (String sourceAttrValue : sourceAttrValues.getValues()) {
                    encodedVals.add(attrDriver.encodeFilterFieldParam(entry.getKey(), sourceAttrValue));
                }
                substitutionAttrEncoded.put(sourceAttributeRef, new AttributeValue(encodedVals));
            }
        }
        return substitutionAttrEncoded;
    }

    @Override
    public String getType() {
        return DataSource.DSType.Other.toString();
    }

    @Override
    public Collection<String> getFilterAttributeReferences() {
        HashSet<String> result = new HashSet<String>();
        Collection<String> paramValues = this.getParameterMap().values();
        for (String value : paramValues) {
            result.addAll(Substituter.parseReferences((String)value));
        }
        return result;
    }

    private String getIdForLog() {
        return this.id != null ? this.id : this.getType();
    }
}

