/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.impl;

import com.pingidentity.common.mgr.SqlFilterManager;
import com.pingidentity.common.util.JDBCHelper;
import com.pingidentity.common.util.Substituter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.SystemAttrLookupException;
import org.sourceid.saml20.domain.impl.AttributeSourceBase;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.sp.provisioning.SqlStatementUtil;
import org.sourceid.websso.profiles.sp.provisioning.handlers.IllegalCharacterSqlInjectionHandler;
import org.sourceid.websso.profiles.sp.provisioning.handlers.JdbcDataHandler;
import org.sourceid.websso.profiles.sp.provisioning.handlers.KeywordSqlInjectionHandler;

public class JdbcAttributeSource
extends AttributeSourceBase {
    private static final long serialVersionUID = 20050515L;
    static final transient Log log = LogFactory.getLog(JdbcAttributeSource.class);

    @Override
    public DataSource getDataSource() {
        if (!StringUtils.isBlank((String)this.dataSourceId)) {
            DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
            return dataSourceManager.getJdbcDataSource(this.dataSourceId);
        }
        return null;
    }

    @Override
    public AttributeMap executeAttributeLookup(AttributeMap srcAttrs, Collection<String> attrNames) throws AttrLookupException {
        DataSource dataSrc = this.getDataSource();
        if (dataSrc != null) {
            SqlFilterManager mgr = SqlFilterManager.getInstance();
            if (mgr.isEnableSqlFilters()) {
                return this.executeJdbcAttributeLookupWithPreparedStatement((JdbcDataSource)dataSrc, srcAttrs, attrNames);
            }
            return this.executeJdbcAttributeLookupWithStatement((JdbcDataSource)dataSrc, srcAttrs, attrNames);
        }
        return new AttributeMap();
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The reported findbug issue is a requirement for this method")
    private AttributeMap executeJdbcAttributeLookupWithPreparedStatement(JdbcDataSource dataSrc, AttributeMap srcAttrs, Collection<String> attrNames) throws AttrLookupException {
        AttributeMap lookupResult = new AttributeMap();
        JDBCHelper jdbcHelper = null;
        try {
            ArrayList<String> substitutedParamValues = new ArrayList<String>();
            String filter = this.getParameter("filter");
            String whereClause = Substituter.substituteValues(filter, (Map)srcAttrs, substitutedParamValues);
            String schemaName = this.getParameter("schema");
            String tableName = this.getParameter("tableName");
            String selectStatement = attrNames != null && attrNames.size() > 0 ? SqlStatementUtil.createSelectForAttributeLookupStatement(schemaName, tableName, attrNames, whereClause) : SqlStatementUtil.createSelectForAttributeLookupStatement(schemaName, tableName, whereClause);
            if (log.isDebugEnabled()) {
                log.debug((Object)("JDBC Attr Src query: '" + selectStatement + "'"));
            }
            jdbcHelper = new JDBCHelper(dataSrc.getJndiName(), this);
            PreparedStatement ps = jdbcHelper.getPreparedStatement(selectStatement);
            int index = 1;
            for (String value : substitutedParamValues) {
                ps.setString(index++, value);
            }
            ps.setQueryTimeout(10);
            ps.execute();
            ResultSet resultSet = ps.getResultSet();
            this.addResultsToAttributeMap(lookupResult, resultSet, dataSrc);
            if (log.isDebugEnabled()) {
                log.debug((Object)("JDBC Attr Src query result: " + lookupResult));
            }
        }
        catch (SQLException | NamingException e) {
            String idForLog = this.id != null ? this.id : this.getType();
            String message = "Error occurred while performing an attribute lookup (" + idForLog + ")";
            throw new SystemAttrLookupException(message, e);
        }
        catch (Substituter.UnknownKeyException ne) {
            String idForLog = this.id != null ? this.id : this.getType();
            String message = "Error occurred while performing an attribute substitution (" + idForLog + ")";
            throw new AttrLookupException(message, (Throwable)((Object)ne));
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return lookupResult;
    }

    ResultInfo validateWhereClauseFromFilter(AttributeMap srcAttrs) throws AttrLookupException, Substituter.UnknownKeyException {
        String filter = this.getParameter("filter");
        String[] tokens = this.getEvaluatedWhereClause(filter, srcAttrs);
        String name = tokens[0];
        String value = tokens[1];
        List<ResultInfo> listForCharCheck = this.createResultInfoListOfOne(name, value);
        JdbcDataHandler processChain = new IllegalCharacterSqlInjectionHandler().setNext(new KeywordSqlInjectionHandler());
        if (!processChain.process(listForCharCheck, new ArrayList<String>())) {
            String error = "The user lookup of attributes failed.";
            log.error((Object)error);
            throw new AttrLookupException(error);
        }
        return listForCharCheck.get(0);
    }

    String[] getEvaluatedWhereClause(String filter, AttributeMap srcAttrs) throws AttrLookupException, Substituter.UnknownKeyException {
        String evaledWhereClause = Substituter.substituteValues(filter, (Map)srcAttrs);
        String[] tokens = evaledWhereClause.split("=");
        if (tokens == null || tokens.length != 2 || StringUtils.isEmpty((String)tokens[0]) || StringUtils.isEmpty((String)tokens[1])) {
            String error = "The user lookup of attributes failed.  " + filter + " is not valid.";
            log.error((Object)error);
            throw new SystemAttrLookupException(error);
        }
        return tokens;
    }

    private AttributeMap executeJdbcAttributeLookupWithStatement(JdbcDataSource dataSrc, AttributeMap srcAttrs, Collection<String> attrNames) throws AttrLookupException {
        AttributeMap lookupResult = new AttributeMap();
        JDBCHelper jdbcHelper = null;
        try {
            String sql = this.getAttributeLookupStatement(srcAttrs, attrNames);
            jdbcHelper = new JDBCHelper(dataSrc.getJndiName(), this);
            ResultSet resultSet = jdbcHelper.getResultSet(sql);
            this.addResultsToAttributeMap(lookupResult, resultSet, dataSrc);
            if (log.isDebugEnabled()) {
                log.debug((Object)("JDBC Attr Src query result: " + lookupResult));
            }
        }
        catch (Substituter.UnknownKeyException | SQLException | NamingException ne) {
            String idForLog = this.id != null ? this.id : this.getType();
            throw new AttrLookupException("Error occured while performing an attribute lookup (" + idForLog + ")", (Throwable)ne);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return lookupResult;
    }

    private void escapeSingleQuote(AttributeMap map) {
        for (Map.Entry e : map.entrySet()) {
            AttributeValue attributeValue = (AttributeValue)e.getValue();
            ArrayList<String> newValue = new ArrayList<String>();
            if (attributeValue.isMultiValue()) {
                for (String s : attributeValue.getValues()) {
                    s = StringEscapeUtils.escapeSql((String)s);
                    newValue.add(s);
                }
            } else {
                String s = attributeValue.getValue();
                s = StringEscapeUtils.escapeSql((String)s);
                newValue.add(s);
            }
            e.setValue(new AttributeValue(newValue));
        }
    }

    String getAttributeLookupStatement(AttributeMap srcAttrs, Collection<String> attrNames) throws Substituter.UnknownKeyException {
        String schemaName = this.getParameter("schema");
        String tableName = this.getParameter("tableName");
        String filter = this.getParameter("filter");
        StringBuffer sb = SqlStatementUtil.createSelectAttributeBaseStatement(schemaName, tableName, attrNames);
        String baseQuery = sb.toString();
        AttributeMap escapedAttrs = (AttributeMap)srcAttrs.clone();
        this.escapeSingleQuote(escapedAttrs);
        sb.append(Substituter.substituteValues(filter, (Map)escapedAttrs));
        String sql = sb.toString();
        if (log.isDebugEnabled()) {
            if (this.needMask(srcAttrs.getMaskedAttributeNames(), filter)) {
                log.debug((Object)("JDBC Attr Src query: '" + baseQuery + filter + "'"));
            } else {
                log.debug((Object)("JDBC Attr Src query: '" + sql + "'"));
            }
        }
        return sql;
    }

    public AttributeMap executeJdbcAttributeLookupWithUniqueId(AttributeMap srcAttrs, Collection<String> attrNames) throws AttrLookupException {
        AttributeMap lookupResult = new AttributeMap();
        JDBCHelper jdbcHelper = null;
        try {
            AttributeValue uniqueIdAttrValue;
            JdbcDataSource jdbcDataSrc = (JdbcDataSource)this.getDataSource();
            jdbcHelper = new JDBCHelper(jdbcDataSrc.getJndiName(), this);
            String schemaName = this.getParameter("schema");
            String tableName = this.getParameter("tableName");
            String uniqueIdColumnName = this.getParameter("filter");
            String uniqueIdColumnValue = null;
            if (!StringUtils.isEmpty((String)uniqueIdColumnName)) {
                uniqueIdAttrValue = (AttributeValue)srcAttrs.get((Object)uniqueIdColumnName);
                if (uniqueIdAttrValue == null || StringUtils.isEmpty((String)uniqueIdAttrValue.getValue())) {
                    String error = "The value for Unique ID for JDBC Express Provisioning is null.";
                    throw new SystemAttrLookupException(error);
                }
            } else {
                String error = "The Unique ID column has not been set for JDBC Express Provisioning.";
                throw new SystemAttrLookupException(error);
            }
            uniqueIdColumnValue = uniqueIdAttrValue.getValue();
            List<ResultInfo> listForCharCheck = this.createResultInfoListOfOne(uniqueIdColumnName, uniqueIdColumnValue);
            JdbcDataHandler processChain = new IllegalCharacterSqlInjectionHandler().setNext(new KeywordSqlInjectionHandler());
            if (!processChain.process(listForCharCheck, new ArrayList<String>())) {
                String error = "The user lookup of attributes failed.";
                log.error((Object)error);
                throw new AttrLookupException(error);
            }
            String selectStatement = SqlStatementUtil.createSelectAllForUniqueIdStatement(schemaName, tableName, uniqueIdColumnName);
            PreparedStatement ps = jdbcHelper.getPreparedStatement(selectStatement);
            ps.setString(1, uniqueIdColumnValue);
            ps.setQueryTimeout(10);
            ps.execute();
            ResultSet resultSet = ps.getResultSet();
            if (resultSet.next()) {
                ResultSetMetaData metaData = resultSet.getMetaData();
                for (int idx = 1; idx <= metaData.getColumnCount(); ++idx) {
                    String columnName = metaData.getColumnName(idx);
                    String columnValue = resultSet.getString(idx);
                    if (columnValue == null) continue;
                    AttributeValue attributeValue = new AttributeValue(columnValue);
                    lookupResult.put(columnName, attributeValue);
                }
            }
            ps.close();
        }
        catch (SQLException | NamingException ne) {
            String idForLog = this.id != null ? this.id : this.getType();
            throw new SystemAttrLookupException("Error occurred while performing an attribute lookup (" + idForLog + ")", ne);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return lookupResult;
    }

    private List<ResultInfo> createResultInfoListOfOne(String columnName, String columnValue) {
        ResultInfo info = new ResultInfo();
        info.setColumnName(columnName);
        info.setValue(Util.stripSingleQuotes(columnValue));
        ArrayList<ResultInfo> list = new ArrayList<ResultInfo>();
        list.add(info);
        return list;
    }

    private void addResultsToAttributeMap(AttributeMap attributeMap, ResultSet resultSet, JdbcDataSource dataSrc) throws SQLException {
        if (resultSet.next()) {
            int i;
            boolean readMultipleRecords = dataSrc.isMultiValueAttributesAllowed();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            ArrayList[] columnsValues = new ArrayList[columnCount];
            for (i = 0; i < columnCount; ++i) {
                columnsValues[i] = new ArrayList();
            }
            do {
                for (int idx = 1; idx <= columnCount; ++idx) {
                    String columnValue = resultSet.getString(idx);
                    if (columnValue == null) continue;
                    columnsValues[idx - 1].add(columnValue.trim());
                }
            } while (resultSet.next() && readMultipleRecords);
            for (i = 1; i <= columnCount; ++i) {
                ArrayList columnValues = columnsValues[i - 1];
                if (columnValues.isEmpty()) continue;
                AttributeValue attributeValue = new AttributeValue((Collection)columnValues);
                String columnName = metaData.getColumnName(i);
                dataSrc.checkSetMasked(attributeValue);
                attributeMap.put(columnName, attributeValue);
            }
        }
    }

    @Override
    public Collection<String> getFilterAttributeReferences() {
        HashSet<String> result = new HashSet<String>();
        String filter = this.getParameter("filter");
        if (filter != null) {
            result.addAll(Substituter.parseReferences((String)filter));
        }
        return result;
    }

    @Override
    public String getType() {
        return DataSource.DSType.JDBC.toString();
    }
}

