/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.mgmt.AbstractAuthManager;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserJwtManagerImpl;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserOAuth2ManagerImpl;

public class AdminAPIAuthManager
extends AbstractAuthManager {
    private static final String AUTHENTICATION_PROPERTY_SEPARATOR = ",";
    private static volatile AdminAPIAuthManager INSTANCE;
    private final List<String> authMethods = this.getPropertyValues(this.getPropertyName());

    private AdminAPIAuthManager() {
    }

    private List<String> getPropertyValues(String property) {
        String propValue = System.getProperty(property, this.getDefaultPropertyValue());
        if (propValue == null || "".equals(propValue.trim())) {
            return Collections.singletonList("native");
        }
        return Arrays.stream(propValue.split(AUTHENTICATION_PROPERTY_SEPARATOR)).map(String::trim).collect(Collectors.toList());
    }

    @Override
    protected boolean isPropertyValid(String property) {
        return true;
    }

    @Override
    protected String getPropertyName() {
        return "pf.admin.api.authentication";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdminAPIAuthManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<AdminAPIAuthManager> clazz = AdminAPIAuthManager.class;
        synchronized (AdminAPIAuthManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new AdminAPIAuthManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public boolean isLdap() {
        return this.authMethods.stream().anyMatch("LDAP"::equalsIgnoreCase);
    }

    @Override
    public boolean isRadius() {
        return this.authMethods.stream().anyMatch("RADIUS"::equalsIgnoreCase);
    }

    @Override
    public boolean isOAuth2() {
        return this.authMethods.stream().anyMatch("OAuth2"::equalsIgnoreCase);
    }

    public boolean isLocalJwt() {
        return this.authMethods.stream().anyMatch("JWT"::equalsIgnoreCase);
    }

    @Override
    public boolean isNative() {
        return this.authMethods.stream().anyMatch("native"::equalsIgnoreCase);
    }

    @Override
    protected String getName() {
        return "Admin API";
    }

    @Override
    protected AdminUserManager initUserManager() {
        if (this.isOAuth2()) {
            return new AdminUserOAuth2ManagerImpl();
        }
        if (this.isLocalJwt()) {
            return new AdminUserJwtManagerImpl();
        }
        return super.initUserManager();
    }

    public AdminUserManager initBasicAuthUserManager() {
        return super.initUserManager();
    }
}

