/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt;

import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.impl.AttributeSourceBase;
import org.sourceid.saml20.domain.impl.CustomAttributeSource;
import org.sourceid.saml20.domain.impl.JdbcAttributeSource;
import org.sourceid.saml20.domain.impl.LdapAttributeSource;

public class AttributeSourceFactory {
    static final String UNSUPPORTED_EXCEPTION = "Only JDBC/RDBMS, LDAP, and drivers created with the CustomAttribute SDK are currently supported.";

    public static AttributeSource getAttributeSource(DataSource dataSource) {
        AttributeSourceBase attrSource = null;
        if (dataSource instanceof JdbcDataSource) {
            attrSource = new JdbcAttributeSource();
        } else if (dataSource instanceof LdapDataSource) {
            attrSource = new LdapAttributeSource();
        } else if (dataSource instanceof CustomDataSource) {
            attrSource = new CustomAttributeSource();
        } else if (dataSource != null) {
            throw new UnsupportedOperationException(UNSUPPORTED_EXCEPTION);
        }
        if (attrSource != null && dataSource != null) {
            if (!StringUtils.isEmpty((String)dataSource.getId())) {
                attrSource.setDataSourceId(dataSource.getId());
            }
            attrSource.setDataSource(dataSource);
        }
        return attrSource;
    }

    public static AttributeSource getAttributeSource(DataSource.DSType type) {
        return AttributeSourceFactory.getAttributeSource(type.toString());
    }

    public static AttributeSource getAttributeSource(String type) {
        return DataSource.DSType.fromName(type).getAttributeSource();
    }

    public static AttributeSource getAttributeSource(String type, String description, String dataSourceId, String attributeSourceId) {
        AttributeSource attrSource = AttributeSourceFactory.getAttributeSource(type);
        if (attrSource != null) {
            attrSource.setDescription(description);
            attrSource.setDataSourceId(dataSourceId);
            attrSource.setId(attributeSourceId);
        }
        return attrSource;
    }

    public static AttributeSource getAttributeSource(DataSource dataSource, String description) {
        AttributeSource attrSource = AttributeSourceFactory.getAttributeSource(dataSource);
        if (attrSource != null) {
            attrSource.setDescription(description);
        }
        return attrSource;
    }
}

