/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt;

import com.pingidentity.crypto.Cert;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sourceid.auth.Authenticator;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.ConnectionListener;
import org.sourceid.saml20.domain.mgmt.impl.ConnectionManagerImpl;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public interface ConnectionManager {
    public static final String DYNAMIC_IDP_CONN_ID = "pingfederate:dynamic:idp:conn:id";
    public static final String DYNAMIC_SP_CONN_ID = "pingfederate:dynamic:sp:conn:id";

    public Collection<SpConnection> searchSpConnections(Integer var1, Integer var2, String var3, ConnectionManagerImpl.ConnectionFilterOptions var4);

    public Collection<IdpConnection> searchIdpConnections(Integer var1, Integer var2, String var3, ConnectionManagerImpl.ConnectionFilterOptions var4);

    public Collection<ConnectionBase> getAllConnections();

    public boolean passesFilterByServerSettings(IdpConnection var1, boolean var2);

    public boolean passesFilterByServerSettings(SpConnection var1, boolean var2);

    public Collection<IdpConnection> getFilteredIdpConnections();

    public Collection<IdpConnection> getFilteredSamlIdpConnections();

    public Collection<IdpConnection> getFilteredWsFedIdpConnections();

    public Collection<IdpConnection> getAllIdpConnections();

    public Collection<ConnectionBase> getFilteredConnections();

    public List<IdpConnection> getIdpConnectionsUsingAdapterInstance(String var1);

    public List<IdpConnection> getIdpConnectionsUsingIdentityStoreProvisionerInstance(String var1);

    public IdpConnection getIdpConnection(String var1);

    public IdpConnection getIdpConnectionBySystemId(String var1);

    public IdpConnection getIdpConnection(Authenticator.AuthnInfo var1);

    public IdpConnection getIdpConnectionWithQuietLog(String var1);

    public boolean isEntityIdInUse(String var1, String var2);

    public void saveIdpConnection(IdpConnection var1);

    public void saveIdpConnection(IdpConnection var1, AdminAuditLogger.Event var2, String var3);

    public void saveIdpConnection(IdpConnection var1, boolean var2, AdminAuditLogger.Event var3);

    public void saveIdpConnections(List<IdpConnection> var1);

    public void deleteIdpConnection(IdpConnection var1);

    public void deleteIdpConnections(List<IdpConnection> var1);

    public Collection<SpConnection> getFilteredSpConnections();

    public Collection<SpConnection> getFilteredSamlSpConnections();

    public Collection<SpConnection> getFilteredWsFedSpConnections();

    public Collection<SpConnection> getAllSpConnections();

    public List<SpConnection> getSpConnectionsUsingAdapterInstance(String var1);

    public SpConnection getSpConnection(String var1);

    public SpConnection getSpConnectionBySystemId(String var1);

    public SpConnection getSpConnectionWithQuietLog(String var1);

    public void saveSpConnection(SpConnection var1);

    public void saveSpConnection(SpConnection var1, AdminAuditLogger.Event var2, String var3);

    public void saveSpConnection(SpConnection var1, boolean var2, AdminAuditLogger.Event var3);

    public void saveSpConnections(List<SpConnection> var1);

    public void deleteSpConnection(SpConnection var1);

    public void deleteSpConnections(List<SpConnection> var1);

    public boolean isEntityIdInUseForSp(String var1, String var2);

    public Set<X509Certificate> getActiveUnanchoredIncomingSslAuthCerts();

    public String basicAuthInUserNameUsedBy(String var1, String var2);

    public String certAuthInCertUsedBy(Cert var1, String var2);

    public String certAuthInSubjectDbUsedBy(String var1, String var2);

    public Collection<Affiliation> getAffiliations();

    public Collection<Affiliation> getAffiliationsUsingSpConnection(String var1);

    public Affiliation getAffiliation(String var1);

    public void saveAffiliation(Affiliation var1);

    public void deleteAffiliation(Affiliation var1);

    public boolean isSourceIdInUse(String var1, String var2, Protocol ... var3);

    public int getIdpConnectionCount();

    public int getSpConnectionCount();

    public int getSpAffiliationCount();

    public boolean isNameInUse(String var1, String var2, Role var3);

    public boolean isIdpConnectionModuleInUse(Class<? extends ConnectionModuleConfiguration> var1);

    public boolean isSpConnectionModuleInUse(Class<? extends ConnectionModuleConfiguration> var1);

    public boolean isWsTrustStsInUse(Role var1);

    public boolean isOAuthInUse();

    public boolean isIdpConnectionInUse(IdpConnection var1);

    public boolean isSpConnectionInUse(SpConnection var1);

    public void addConnectionListener(ConnectionListener var1);

    public void removeConnectionListener(ConnectionListener var1);

    public boolean isSpConnectionApiSupported(SpConnection var1);

    public boolean isIdpConnectionApiSupported(IdpConnection var1);

    public Collection<SpConnection> getFilteredApiSupportedSpConnections(ConnectionManagerImpl.ConnectionFilterOptions var1);

    public Collection<IdpConnection> getFilteredApiSupportedIdpConnections(ConnectionManagerImpl.ConnectionFilterOptions var1);

    public boolean isOIDCProtocolEnabled(IdpConnection var1);
}

