/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.jetty.JettyXMLConfigRegistry;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.mgmt.AdminSslServerPkCertManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdminSslServerKeyManager;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.domain.mgmt.impl.PingX509ExtendedKeyManager;
import org.sourceid.saml20.domain.mgmt.impl.SslServerPkCertManagerImpl;

public class AdminSslServerPkCertManagerImpl
extends SslServerPkCertManagerImpl
implements AdminSslServerPkCertManager {
    private static final String KEY_ACTIVE_ADMIN_CERT_ALIAS = "ActiveAdminServerAlias";
    private static final String KEY_ACTIVE_ADMIN_CERT_ALIASES = "ActiveAdminServerAliases";
    private static final String DEFAULT_ACTIVE_ADMIN_ALIAS = "DefaultActiveAdminServerAlias";

    @Override
    protected void clearAllCaches() {
        this.clearCaches();
        MgmtFactory.getSslServerPkCertManager().clearCaches();
    }

    @Override
    protected String getActiveAlias() {
        return KEY_ACTIVE_ADMIN_CERT_ALIAS;
    }

    @Override
    protected String getActiveAliases() {
        return KEY_ACTIVE_ADMIN_CERT_ALIASES;
    }

    @Override
    protected SslServerPkCertManagerImpl.EffectiveAlias getEffectiveActiveAlias() {
        List<String> activeAdminSslServerAliases;
        SslServerPkCertManagerImpl.EffectiveAlias effectiveAlias = super.getEffectiveActiveAlias();
        String activeAdminSslServerAlias = this.configStore.getStringValue(KEY_ACTIVE_ADMIN_CERT_ALIAS, null);
        if (!StringUtils.isEmpty((String)activeAdminSslServerAlias)) {
            effectiveAlias = new SslServerPkCertManagerImpl.EffectiveAlias(KEY_ACTIVE_ADMIN_CERT_ALIAS, SslServerPkCertManagerImpl.EffectiveAliasType.STRING);
        }
        if ((activeAdminSslServerAliases = this.configStore.getListValue(KEY_ACTIVE_ADMIN_CERT_ALIASES, null)) != null) {
            effectiveAlias = new SslServerPkCertManagerImpl.EffectiveAlias(KEY_ACTIVE_ADMIN_CERT_ALIASES, SslServerPkCertManagerImpl.EffectiveAliasType.LIST);
        }
        return effectiveAlias;
    }

    @Override
    public boolean isAdminSslCertDefined() {
        String adminSslCertAlias = this.configStore.getStringValue(KEY_ACTIVE_ADMIN_CERT_ALIAS, null);
        return adminSslCertAlias != null;
    }

    @Override
    protected String getDefaultAlias() {
        return DEFAULT_ACTIVE_ADMIN_ALIAS;
    }

    @Override
    protected void reloadSslContextFactories() {
        if (!ModeSupport.isConsole()) {
            return;
        }
        try {
            if (!"-1".equals(PropertyInfo.getAdminHttpsPort())) {
                this.log.debug((Object)"Reloading admin SSL context factory");
                SslContextFactory sslContextFactory = (SslContextFactory)JettyXMLConfigRegistry.getInstance().getObject("sslContextFactory");
                this.reloadContextFactory(sslContextFactory);
                this.log.debug((Object)"Finished reloading admin SSL context factory");
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    protected PingX509ExtendedKeyManager getExtendedKeyManager() {
        return AdminSslServerKeyManager.getInstance();
    }
}

