/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.HostnameValidation;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import com.pingidentity.crypto.Password;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.BasePropsAdminUserManager;
import org.sourceid.util.log.AttributeMap;

public class AdminUserManagerLDAPImpl
extends BasePropsAdminUserManager {
    private static final String DN_ATTRIBUTE = "<dn>";
    private static Log log = LogFactory.getLog(AdminUserManagerLDAPImpl.class);
    private static final String ADMIN_USER_LDAP_PROPERTY_FILE = "ldap.properties.file";
    private String serverUrl;
    private LdapInfo.LdapType type;
    private String principal;
    private String credentials;
    private String clientTlsCertificate;
    private String verifyHostname;
    private String searchBase;
    private String searchFilter;
    private int connectTimeout;
    private int readTimeout;
    private Set<String> adminNames = new HashSet<String>();
    private Set<String> cryptoNames = new HashSet<String>();
    private Set<String> auditorNames = new HashSet<String>();
    private Set<String> userAdminNames = new HashSet<String>();
    private Set<String> expressionAdminNames = new HashSet<String>();
    private Set<String> dataCollectionAdminNames = new HashSet<String>();
    private String _roleSearchUserAttribute;
    private String _roleSearchBase;
    private boolean _roleSearchSubtree;
    private String _roleSearchFilter;
    private String _roleSearchAtrribute;
    private Set<String> _roleMapAdmin = new HashSet<String>();
    private Set<String> _roleMapCrypto = new HashSet<String>();
    private Set<String> _roleMapAuditor = new HashSet<String>();
    private Set<String> _roleMapUserAdmin = new HashSet<String>();
    private Set<String> _roleMapExpressionAdmin = new HashSet<String>();
    private Set<String> _roleMapDataCollectionAdmin = new HashSet<String>();
    private LdapDataSource ldapDS;
    private boolean startTLS;

    public AdminUserManagerLDAPImpl() {
        this.init();
    }

    @Override
    public Collection<AdministrativeUser> getUsers() {
        return Collections.emptyList();
    }

    @Override
    public AdministrativeUser getUser(String userName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void saveUsers(Collection<AdministrativeUser> users) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getBasePropertiesFileName() {
        return ADMIN_USER_LDAP_PROPERTY_FILE;
    }

    @Override
    protected String getRolePropertyName(String role) {
        return String.join((CharSequence)".", Arrays.asList("role", "map", role));
    }

    @Override
    public Collection<String> getListOfUserNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changePassword(String userName, String newPassword, boolean changeRequired) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reload() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdministrativeUser authenticate(String username, String password, HttpServletRequest request) throws AdminUserException {
        Set<String> ldapRoles;
        if (!this._initialized) {
            log.error((Object)"LDAP authentication was not correctly initialized, check log for errors");
            throw new AdminUserException(AdminUserException.Code.LDAP_AVAILABILITY);
        }
        AdministrativeUser result = new AdministrativeUser();
        result.setUserName(username);
        result.setPhoneNumber("");
        result.setEmailAddress("");
        result.setDepartment("");
        result.setDescription("");
        result.setActive(true);
        result.setChangeRequired(false);
        AdminUserManagerLDAPImpl adminUserManagerLDAPImpl = this;
        synchronized (adminUserManagerLDAPImpl) {
            String userDN = this.authLDAP(username, password);
            ldapRoles = this.getRoles(username, userDN);
        }
        username = username.trim().toLowerCase();
        this.propagateRoles(username, result, ldapRoles);
        if (!(result.getAdmin() || result.getAdminManager() || result.getCryptoManager() || result.getAuditor())) {
            log.trace((Object)("No PingFederate roles mapped for user: " + username));
        }
        return result;
    }

    void propagateRoles(String username, AdministrativeUser result, Set<String> ldapRoles) {
        result.setAdmin(AdminUserManagerLDAPImpl.hasRole(this.adminNames, this._roleMapAdmin, username, ldapRoles));
        result.setAdminManager(AdminUserManagerLDAPImpl.hasRole(this.userAdminNames, this._roleMapUserAdmin, username, ldapRoles));
        result.setCryptoManager(AdminUserManagerLDAPImpl.hasRole(this.cryptoNames, this._roleMapCrypto, username, ldapRoles));
        result.setExpressionAdmin(AdminUserManagerLDAPImpl.hasRole(this.expressionAdminNames, this._roleMapExpressionAdmin, username, ldapRoles));
        result.setDataCollectionAdmin(AdminUserManagerLDAPImpl.hasRole(this.dataCollectionAdminNames, this._roleMapDataCollectionAdmin, username, ldapRoles));
        result.setAuditor(AdminUserManagerLDAPImpl.hasRole(this.auditorNames, this._roleMapAuditor, username, ldapRoles));
    }

    @Override
    public AdministrativeUser authenticate(HttpServletRequest request) throws AdminUserException {
        throw new UnsupportedOperationException();
    }

    private String authLDAP(String username, String password) throws AdminUserException {
        LDAPUtil ldapUtil;
        if (password == null || password.length() == 0) {
            throw new AdminUserException(AdminUserException.Code.PASSWORD);
        }
        String userDn = this.getUserDn(username);
        try {
            ldapUtil = LDAPUtil.newInstance(this.ldapDS, (ServiceInformation)this);
        }
        catch (NamingException e) {
            log.error((Object)"Unable to create ldap util", (Throwable)e);
            throw new AdminUserException(AdminUserException.Code.LDAP_AVAILABILITY);
        }
        try {
            ldapUtil.authenticate(userDn, password, this.ldapDS);
        }
        catch (Exception ex) {
            log.warn((Object)String.format("User [%s] not authenticated in server [%s]", username, this.serverUrl));
            throw new AdminUserException(AdminUserException.Code.PASSWORD);
        }
        return userDn;
    }

    String getUserDn(String username) throws AdminUserException {
        String userDn;
        LDAPUtil ldapUtil;
        if (!this._initialized) {
            log.error((Object)"LDAP authentication was not correctly initialized, check log for errors");
            throw new AdminUserException(AdminUserException.Code.LDAP_AVAILABILITY);
        }
        try {
            ldapUtil = LDAPUtil.newInstance(this.ldapDS, (ServiceInformation)this);
        }
        catch (NamingException e) {
            log.error((Object)"Unable to create ldap util", (Throwable)e);
            throw new AdminUserException(AdminUserException.Code.LDAP_AVAILABILITY);
        }
        try {
            String escapedUsername = LDAPUtil.encodeFilter(username);
            String formattedFilter = MessageFormat.format(this.searchFilter, escapedUsername);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this.searchBase, formattedFilter, 2);
            ldapOptions.setCount(1);
            List<String> userDns = ldapUtil.getDistinguishedName(ldapOptions);
            if (userDns.isEmpty()) {
                log.debug((Object)String.format("User [%s] not found", username));
                throw new AdminUserException(AdminUserException.Code.USER);
            }
            if (userDns.size() > 1) {
                log.error((Object)String.format("Multiple entries found for user [%s].", username));
                throw new AdminUserException(AdminUserException.Code.USER);
            }
            userDn = userDns.get(0);
        }
        catch (AdminUserException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)String.format("Problem connecting LDAP server [%s]", this.serverUrl), (Throwable)e);
            throw new AdminUserException(AdminUserException.Code.LDAP_AVAILABILITY);
        }
        return userDn;
    }

    @Override
    protected void loadProperties(Properties properties) {
        String filteredServerUrl;
        this.serverUrl = properties.getProperty("ldap.url");
        if (this.serverUrl == null) {
            String s = "LDAP Server URL is not set";
            log.error((Object)s);
            throw new RuntimeException(s);
        }
        String typeStr = properties.getProperty("ldap.type") != null ? properties.getProperty("ldap.type") : "";
        try {
            this.type = LdapInfo.LdapType.valueOf((String)typeStr);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("The property 'ldap.type' is invalid. Please use one of the following values: " + LdapInfo.LdapType.ActiveDirectory.name() + ", " + LdapInfo.LdapType.SunDirectoryServer.name() + ", " + LdapInfo.LdapType.OracleUnifiedDirectory.name() + ", " + LdapInfo.LdapType.PingDirectory.name() + ", " + LdapInfo.LdapType.PingDS.name() + ", " + LdapInfo.LdapType.Generic.name());
        }
        boolean anonymousBinding = Boolean.parseBoolean(properties.getProperty("ldap.anonymousBinding", "false"));
        if (!anonymousBinding) {
            this.principal = properties.getProperty("ldap.username");
            String encodedPwd = properties.getProperty("ldap.password");
            Password password = new Password(encodedPwd);
            this.credentials = password.getStrValue();
            this.clientTlsCertificate = properties.getProperty("ldap.clientTlsCertificate");
            this.startTLS = Boolean.parseBoolean(properties.getProperty("ldap.startTLS", "false").trim());
            if ((StringUtils.isNotEmpty((String)this.principal) || StringUtils.isNotEmpty((String)this.credentials)) && StringUtils.isNotBlank((String)this.clientTlsCertificate)) {
                throw new RuntimeException("Multiple LDAP authentication methods are set");
            }
            if ((StringUtils.isNotEmpty((String)this.principal) || StringUtils.isNotEmpty((String)this.credentials)) && StringUtils.isBlank((String)this.clientTlsCertificate)) {
                if (StringUtils.isEmpty((String)this.principal)) {
                    throw new RuntimeException("Attempting to use LDAP username/password authentication but the property 'ldap.username' was not specified");
                }
                if (StringUtils.isEmpty((String)this.credentials)) {
                    throw new RuntimeException("Attempting to use LDAP username/password authentication but the property 'ldap.password' was not specified");
                }
            } else if (StringUtils.isNotEmpty((String)this.principal) && StringUtils.isNotEmpty((String)this.credentials)) {
                if (this.credentials.equals(encodedPwd) && !SecretReferenceUtil.isSecretReference((String)this.credentials)) {
                    log.warn((Object)"Administrative authentication is not securely configured. The property 'ldap.password' has a plain text value. To improve security, it should be obfuscated.");
                }
            } else if (StringUtils.isNotBlank((String)this.clientTlsCertificate)) {
                if (MgmtFactory.getSslAuthPkCertManager().getPkCert(this.clientTlsCertificate) == null) {
                    throw new RuntimeException("Client TLS Certificate '" + this.clientTlsCertificate + "' was not found in the SSL client keystore");
                }
            } else {
                throw new RuntimeException("An LDAP authentication method is not set");
            }
        }
        this.verifyHostname = properties.getProperty("ldap.verifyHostname");
        this.connectTimeout = this.getTimeout("ldap.connectTimeout", properties);
        this.readTimeout = this.getTimeout("ldap.readTimeout", properties);
        this.searchBase = properties.getProperty("search.base");
        this.searchFilter = properties.getProperty("search.filter");
        this.adminNames = AdminUserManagerLDAPImpl.splitAndNormalize(properties.getProperty("role.admin"));
        this.cryptoNames = AdminUserManagerLDAPImpl.splitAndNormalize(properties.getProperty("role.cryptoManager"));
        this.auditorNames = AdminUserManagerLDAPImpl.splitAndNormalize(properties.getProperty("role.auditor"));
        this.userAdminNames = AdminUserManagerLDAPImpl.splitAndNormalize(properties.getProperty("role.userAdmin"));
        this.expressionAdminNames = AdminUserManagerLDAPImpl.splitAndNormalize(properties.getProperty("role.expressionAdmin"));
        this.dataCollectionAdminNames = AdminUserManagerLDAPImpl.splitAndNormalize(properties.getProperty("role.dataCollectionAdmin"));
        this._roleSearchUserAttribute = properties.getProperty("role.search.user.attribute", "").trim();
        this._roleSearchBase = properties.getProperty("role.search.base", "").trim();
        this._roleSearchSubtree = Boolean.parseBoolean(properties.getProperty("role.search.subtree", "false").trim());
        this._roleSearchFilter = properties.getProperty("role.search.filter", "").trim();
        this._roleSearchAtrribute = properties.getProperty("role.search.attribute", "").toLowerCase().trim();
        this._roleMapAdmin = this.loadRoleMap(properties, "admin");
        this._roleMapCrypto = this.loadRoleMap(properties, "cryptoManager");
        this._roleMapAuditor = this.loadRoleMap(properties, "auditor");
        this._roleMapUserAdmin = this.loadRoleMap(properties, "userAdmin");
        this._roleMapExpressionAdmin = this.loadRoleMap(properties, "expressionAdmin");
        this._roleMapDataCollectionAdmin = this.loadRoleMap(properties, "dataCollectionAdmin");
        if (this._roleSearchUserAttribute.length() == 0 && this._roleSearchAtrribute.length() == 0 && this.adminNames.size() + this.cryptoNames.size() + this.auditorNames.size() + this.userAdminNames.size() == 0) {
            throw new RuntimeException("None of LDAP's users have been specified as a valid PingFederate user and no LDAP based roles have been defined.");
        }
        try {
            HostnameValidation.validateLdapsHostname(this.serverUrl);
            filteredServerUrl = this.filterServerUrl(this.serverUrl);
        }
        catch (URISyntaxException | NamingException e) {
            throw new RuntimeException("Hostname validation failed for: " + this.serverUrl, e);
        }
        this.ldapDS = new LdapDataSource();
        this.ldapDS.setHost(filteredServerUrl);
        this.ldapDS.setLdapType(this.type);
        this.ldapDS.setUseSSL(this.serverUrl.startsWith("ldaps"));
        this.ldapDS.setPrincipal(this.principal);
        this.ldapDS.setCredentials(this.credentials);
        this.ldapDS.setClientTlsCertificate(this.clientTlsCertificate);
        this.ldapDS.setConnTimeoutMillis(this.connectTimeout);
        this.ldapDS.setReadTimeoutMillis(this.readTimeout);
        this.ldapDS.setId("pf-admin-ldap-ds-dYeixW7WJt7cN8d5ixBq");
        this.ldapDS.setUseStartTLS(this.startTLS);
        if (this.ldapDS.getUseSSL() && this.ldapDS.getUseStartTLS()) {
            throw new RuntimeException("The LDAP Connection can either use SSL or StartTLS but not both.");
        }
        if (StringUtils.isNotBlank((String)this.verifyHostname) && Boolean.parseBoolean(this.verifyHostname)) {
            this.ldapDS.setVerifyHost(true);
        }
        if (anonymousBinding) {
            this.ldapDS.setAuthenticationMethod("none");
        } else if (StringUtils.isNotBlank((String)this.principal)) {
            this.ldapDS.setAuthenticationMethod("simple");
        } else {
            this.ldapDS.setAuthenticationMethod("clientTlsCert");
        }
        log.info((Object)("LDAP Server(s): " + this.serverUrl));
        log.info((Object)("StartTLS: " + this.startTLS));
        log.info((Object)("Anonymous Binding: " + anonymousBinding));
        log.info((Object)("Connection Timeout: " + this.connectTimeout));
        log.info((Object)("Read Timeout: " + this.readTimeout));
        log.info((Object)("Principal: " + this.principal));
        log.info((Object)("Search Base: " + this.searchBase));
        log.info((Object)("Search Filter: " + this.searchFilter));
        log.info((Object)("adminNames: " + this.adminNames));
        log.info((Object)("cryptoNames: " + this.cryptoNames));
        log.info((Object)("auditorNames: " + this.auditorNames));
        log.info((Object)("userAdminNames: " + this.userAdminNames));
        log.info((Object)("expressionAdminNames: " + this.expressionAdminNames));
        log.info((Object)("dataCollectionAdminNames: " + this.dataCollectionAdminNames));
        log.info((Object)("Role Search User Attribute: " + this._roleSearchUserAttribute));
        log.info((Object)("Role Search Base: " + this._roleSearchBase));
        log.info((Object)("Role Search Subtree: " + this._roleSearchSubtree));
        log.info((Object)("Role Search Filter: " + this._roleSearchFilter));
        log.info((Object)("Role Search Atrribute: " + this._roleSearchAtrribute));
        log.info((Object)("Role Map Admin: " + this._roleMapAdmin));
        log.info((Object)("Role Map Crypto: " + this._roleMapCrypto));
        log.info((Object)("Role Map Auditor: " + this._roleMapAuditor));
        log.info((Object)("Role Map User Admin: " + this._roleMapUserAdmin));
        log.info((Object)("Role Map Expression Admin: " + this._roleMapExpressionAdmin));
        log.info((Object)("Role Map Data Collection Admin: " + this._roleMapDataCollectionAdmin));
    }

    private int getTimeout(String propertyName, Properties properties) {
        try {
            return Integer.parseInt(properties.getProperty(propertyName));
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid " + propertyName + ", must be an integer: " + properties.getProperty(propertyName)));
            return 0;
        }
    }

    private String filterServerUrl(String serverUrls) throws URISyntaxException {
        String[] filteredUris = LDAPUtil.splitServerUrls(serverUrls);
        StringBuilder sb = new StringBuilder();
        for (String filteredUri : filteredUris) {
            URI uri = new URI(filteredUri);
            sb.append(uri.getRawAuthority()).append(" ");
        }
        return sb.toString().trim();
    }

    Set<String> getRoles(String username, String userDn) throws AdminUserException {
        LDAPUtil ldapUtil;
        if (!this._initialized) {
            log.error((Object)"LDAP authentication was not correctly initialized, check log for errors");
            throw new AdminUserException(AdminUserException.Code.LDAP_AVAILABILITY);
        }
        try {
            ldapUtil = LDAPUtil.newInstance(this.ldapDS, (ServiceInformation)this);
        }
        catch (NamingException e) {
            log.error((Object)"Unable to create ldap util", (Throwable)e);
            throw new AdminUserException(AdminUserException.Code.LDAP_AVAILABILITY);
        }
        HashSet<String> roles = new HashSet<String>();
        try {
            if (this._roleSearchUserAttribute.length() > 0) {
                AttributeMap attributeMap = ldapUtil.getAttributesOfMatchingObject(userDn);
                if (attributeMap != null) {
                    roles.addAll(this.getAttributeValuesFromAttributeMap(attributeMap, this._roleSearchUserAttribute));
                }
            } else if (this._roleSearchAtrribute.length() > 0) {
                int searchScope = this._roleSearchSubtree ? 2 : 1;
                String formattedFilter = MessageFormat.format(this._roleSearchFilter, LDAPUtil.encodeFilter(username), LDAPUtil.encodeFilter(userDn));
                if (DN_ATTRIBUTE.equals(this._roleSearchAtrribute)) {
                    LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this._roleSearchBase, formattedFilter, searchScope);
                    List<AttributeMap> attributeMaps = ldapUtil.getAttributesOfMatchingObjects(ldapOptions);
                    for (AttributeMap attributeMap : attributeMaps) {
                        roles.addAll(this.getAttributeValuesFromAttributeMap(attributeMap, "Subject DN"));
                    }
                } else {
                    LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this._roleSearchBase, formattedFilter, searchScope);
                    List<AttributeMap> attributeMaps = ldapUtil.getAttributesOfMatchingObjects(ldapOptions);
                    for (AttributeMap attributeMap : attributeMaps) {
                        roles.addAll(this.getAttributeValuesFromAttributeMap(attributeMap, this._roleSearchAtrribute));
                    }
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)String.format("A search error has occured while searching for user [%s]", username));
            throw new AdminUserException(AdminUserException.Code.USER);
        }
        if (roles.size() == 0) {
            log.trace((Object)("No roles found in LDAP for user: " + username));
        }
        return roles;
    }

    private Set<String> getAttributeValuesFromAttributeMap(AttributeMap attributeMap, String attribute) {
        HashSet<String> attributeValues = new HashSet<String>();
        AttributeValue attributeValue = (AttributeValue)attributeMap.get((Object)attribute);
        if (attributeValue != null) {
            attributeValues.addAll(attributeValue.getValuesAsCollection());
        }
        return attributeValues;
    }

    private Set<String> loadRoleMap(Properties prop, String roleName) {
        HashSet<String> roles = new HashSet<String>();
        String role = prop.getProperty("role.map." + roleName);
        if (role != null) {
            roles.add(this.normalizeId(role));
        } else {
            roles.addAll(this.loadMultiValueProp(prop, "role.map." + roleName + "."));
        }
        return roles;
    }

    @Override
    protected String normalizeId(String role) {
        if (DN_ATTRIBUTE.equals(this._roleSearchAtrribute)) {
            try {
                return LDAPUtil.normalizedDN(role);
            }
            catch (NamingException e) {
                log.error((Object)("Invalid role, not at Distinguished Name: " + role), (Throwable)e);
                return role;
            }
        }
        return role;
    }
}

