/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.security.InputValidator;
import com.pingidentity.common.security.UsernameRule;
import com.pingidentity.common.util.B64;
import com.pingidentity.crypto.Password;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.auth.radius.RadiusClient;
import org.sourceid.auth.radius.RadiusClientHelper;
import org.sourceid.auth.radius.RadiusResponse;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserManagerLDAPImpl;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.BasePropsAdminUserManager;
import org.sourceid.saml20.domain.mgmt.impl.RadiusAdminUserException;

public class AdminUserManagerRadiusImpl
extends BasePropsAdminUserManager {
    private static final Log log = LogFactory.getLog(AdminUserManagerRadiusImpl.class);
    private static final String HOST_PROPERTY = "host";
    private static final String AUTHENTICATION_PORT_PROPERTY = "authentication.port";
    private static final String AUTHENTICATION_PROTOCOL_PROPERTY = "authentication.protocol";
    private static final String SHARED_SECRET_PROPERTY = "shared.secret";
    private static final String RETRY_COUNT_PROPERTY = "retry.count";
    private static final String TIMEOUT_PROPERTY = "timeout";
    private static final String NAS_IDENTIFIER_PROPERTY = "nas.identifier";
    private static final String USE_LDAP_ROLES_PROPERTY = "use.ldap.roles";
    private static final String ROLE_ATTRIBUTE_CODE_PROPERTY = "role.attribute.code";
    private static final String ROLE_AUDITOR_PROPERTY = "role.auditor";
    private static final String ROLE_CRYPTO_PROPERTY = "role.cryptoManager";
    private static final String ROLE_ADMIN_PROPERTY = "role.admin";
    private static final String ROLE_USERADMIN_PROPERTY = "role.userAdmin";
    private static final String ROLE_EXPRESSIONADMIN_PROPERTY = "role.expressionAdmin";
    private static final String ROLE_DATA_COLLECTION_ADMIN_PROPERTY = "role.dataCollectionAdmin";
    private static final String ROLE_MAP_PROPERTY = "role.map";
    private static final String RADIUS_STATE_PARAM = "radiusState";
    private static final String ADMIN_USER_RADIUS_PROPERTY_FILE = "radius.properties.file";
    private static final String USERNAME = "Username";
    private int roleAttributeCode;
    private Set<String> adminNames;
    private Set<String> cryptoNames;
    private Set<String> auditorNames;
    private Set<String> userAdminNames;
    private Set<String> expressionNames;
    private Set<String> dataCollectionAdminNames;
    private Set<String> adminRoles;
    private Set<String> cryptoRoles;
    private Set<String> auditorRoles;
    private Set<String> userAdminRoles;
    private Set<String> expressionRoles;
    private Set<String> dataCollectionAdminRoles;
    private AdminUserManagerLDAPImpl ldapManager;
    private final List<RadiusClient> radiusClients = new ArrayList<RadiusClient>();

    public AdminUserManagerRadiusImpl() {
        this.init();
    }

    @Override
    public AdministrativeUser authenticate(String username, String password, HttpServletRequest request) throws AdminUserException {
        AdministrativeUser adminUser = null;
        if (StringUtils.isEmpty((String)username)) {
            throw new AdminUserException(AdminUserException.Code.USER);
        }
        InputValidator.validate(USERNAME, username, new UsernameRule());
        if (StringUtils.isEmpty((String)password)) {
            throw new AdminUserException(AdminUserException.Code.PASSWORD);
        }
        byte[] state = B64.decodeToBytes((String)request.getParameter(RADIUS_STATE_PARAM));
        for (RadiusClient radiusClient : this.radiusClients) {
            try {
                RadiusResponse response = RadiusClientHelper.authenticate(radiusClient, username, password, state);
                Set<String> externalRoles = this.getExternalRoles(response, username);
                adminUser = this.buildAdminUser(username, externalRoles);
                break;
            }
            catch (RadiusAdminUserException e) {
                throw e;
            }
            catch (AdminUserException e) {
                if (!this.useLdapRoles()) continue;
                switch (e.getCode()) {
                    case USER: 
                    case LDAP_AVAILABILITY: {
                        throw e;
                    }
                }
            }
        }
        if (adminUser == null) {
            throw new AdminUserException(AdminUserException.Code.RADIUS_AVAILABILITY);
        }
        return adminUser;
    }

    @Override
    public AdministrativeUser authenticate(HttpServletRequest request) throws AdminUserException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getBasePropertiesFileName() {
        return ADMIN_USER_RADIUS_PROPERTY_FILE;
    }

    @Override
    protected String getRolePropertyName(String role) {
        return String.join((CharSequence)".", Arrays.asList("role", "map", role));
    }

    @Override
    protected void loadProperties(Properties props) {
        this.loadRadiusClients(props);
        this.loadLdapManager(props);
        this.loadRoleAttributeCode(props);
        this.adminNames = AdminUserManagerRadiusImpl.splitAndNormalize(props.getProperty(ROLE_ADMIN_PROPERTY));
        this.cryptoNames = AdminUserManagerRadiusImpl.splitAndNormalize(props.getProperty(ROLE_CRYPTO_PROPERTY));
        this.auditorNames = AdminUserManagerRadiusImpl.splitAndNormalize(props.getProperty(ROLE_AUDITOR_PROPERTY));
        this.userAdminNames = AdminUserManagerRadiusImpl.splitAndNormalize(props.getProperty(ROLE_USERADMIN_PROPERTY));
        this.expressionNames = AdminUserManagerRadiusImpl.splitAndNormalize(props.getProperty(ROLE_EXPRESSIONADMIN_PROPERTY));
        this.dataCollectionAdminNames = AdminUserManagerRadiusImpl.splitAndNormalize(props.getProperty(ROLE_DATA_COLLECTION_ADMIN_PROPERTY));
        this.adminRoles = this.loadRoles(props, "admin");
        this.cryptoRoles = this.loadRoles(props, "cryptoManager");
        this.auditorRoles = this.loadRoles(props, "auditor");
        this.userAdminRoles = this.loadRoles(props, "userAdmin");
        this.expressionRoles = this.loadRoles(props, "expressionAdmin");
        this.dataCollectionAdminRoles = this.loadRoles(props, "dataCollectionAdmin");
        log.info((Object)this.toString());
    }

    private void loadLdapManager(Properties props) {
        if (props.containsKey(USE_LDAP_ROLES_PROPERTY) && props.getProperty(USE_LDAP_ROLES_PROPERTY).equalsIgnoreCase(Boolean.TRUE.toString())) {
            this.ldapManager = new AdminUserManagerLDAPImpl();
        }
    }

    private void loadRoleAttributeCode(Properties props) {
        this.roleAttributeCode = AdminUserManagerRadiusImpl.loadIntProperty(props, ROLE_ATTRIBUTE_CODE_PROPERTY, 11);
    }

    private void loadRadiusClients(Properties props) {
        List<String> hosts = null;
        if (!props.containsKey(HOST_PROPERTY) || !StringUtils.isNotBlank((String)props.getProperty(HOST_PROPERTY))) {
            throw new RuntimeException("RADIUS host is not set");
        }
        hosts = Arrays.asList(StringUtils.split((String)props.getProperty(HOST_PROPERTY), (String)" \t"));
        String sharedSecret = null;
        if (props.containsKey(SHARED_SECRET_PROPERTY) && StringUtils.isNotBlank((String)props.getProperty(SHARED_SECRET_PROPERTY))) {
            String secretStr = props.getProperty(SHARED_SECRET_PROPERTY);
            sharedSecret = new Password(secretStr).getStrValue();
            if (secretStr != null && sharedSecret != null && secretStr.equals(sharedSecret)) {
                log.warn((Object)"Administrative authentication is not securely configured. The property 'shared.secret' has a plain text value. To improve security, it should be obfuscated.");
            }
        } else {
            throw new RuntimeException("RADIUS shared secret is not set");
        }
        int authPort = AdminUserManagerRadiusImpl.loadIntProperty(props, AUTHENTICATION_PORT_PROPERTY, 1812);
        RadiusClient.AuthProtocol authProtocol = this.loadAuthProtocol(props);
        String nasIdentifier = StringUtils.defaultIfEmpty((String)props.getProperty(NAS_IDENTIFIER_PROPERTY), (String)"PingFederate");
        int retryCount = AdminUserManagerRadiusImpl.loadIntProperty(props, RETRY_COUNT_PROPERTY, 3);
        int timeout = AdminUserManagerRadiusImpl.loadIntProperty(props, TIMEOUT_PROPERTY, 3000);
        for (String host : hosts) {
            RadiusClient client = new RadiusClient(host, sharedSecret, authPort, authProtocol, nasIdentifier, retryCount, timeout);
            this.radiusClients.add(client);
        }
    }

    static int loadIntProperty(Properties props, String key, int defaultValue) {
        int intProp = defaultValue;
        String defaultValueString = String.valueOf(defaultValue);
        try {
            String prop = StringUtils.defaultIfEmpty((String)props.getProperty(key), (String)defaultValueString).trim();
            intProp = Integer.parseInt(prop);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid property " + key + ", must be an integer: " + props.getProperty(key));
        }
        return intProp;
    }

    private Set<String> getExternalRoles(RadiusResponse response, String username) throws AdminUserException {
        HashSet<String> externalRoles = new HashSet<String>();
        if (this.useLdapRoles()) {
            String userDn = this.ldapManager.getUserDn(username);
            Set<String> ldapRoles = this.ldapManager.getRoles(username, userDn);
            externalRoles.addAll(ldapRoles);
        } else if (response != null) {
            externalRoles.addAll(response.getAttributesByCode(this.roleAttributeCode));
        }
        return externalRoles;
    }

    private Set<String> loadRoles(Properties prop, String roleName) {
        HashSet<String> roles = new HashSet<String>();
        String role = prop.getProperty("role.map." + roleName);
        if (role != null) {
            roles.add(role);
        } else {
            roles.addAll(this.loadMultiValueProp(prop, "role.map." + roleName + "."));
        }
        return roles;
    }

    private RadiusClient.AuthProtocol loadAuthProtocol(Properties props) {
        RadiusClient.AuthProtocol authProtocol = RadiusClient.DEFAULT_AUTH_PROTOCOL;
        if (props.containsKey(AUTHENTICATION_PROTOCOL_PROPERTY)) {
            String authProtocolProperty = props.getProperty(AUTHENTICATION_PROTOCOL_PROPERTY, RadiusClient.AuthProtocol.PAP.toString()).trim();
            if (authProtocolProperty.equalsIgnoreCase(RadiusClient.AuthProtocol.PAP.toString())) {
                authProtocol = RadiusClient.AuthProtocol.PAP;
            } else if (authProtocolProperty.equalsIgnoreCase(RadiusClient.AuthProtocol.CHAP.toString())) {
                authProtocol = RadiusClient.AuthProtocol.CHAP;
            } else {
                throw new RuntimeException("Invalid RADIUS authentication protocol: " + authProtocolProperty);
            }
        }
        return authProtocol;
    }

    private AdministrativeUser buildAdminUser(String username, Set<String> externalRoles) {
        AdministrativeUser admin = new AdministrativeUser();
        admin.setUserName(username);
        admin.setPhoneNumber("");
        admin.setEmailAddress("");
        admin.setDepartment("");
        admin.setDescription("");
        admin.setActive(Boolean.TRUE);
        admin.setChangeRequired(Boolean.FALSE);
        username = username.trim().toLowerCase();
        if (this.useLdapRoles()) {
            this.ldapManager.propagateRoles(username, admin, externalRoles);
        } else {
            admin.setAdmin(AdminUserManagerRadiusImpl.hasRole(this.adminNames, this.adminRoles, username, externalRoles));
            admin.setCryptoManager(AdminUserManagerRadiusImpl.hasRole(this.cryptoNames, this.cryptoRoles, username, externalRoles));
            admin.setAuditor(AdminUserManagerRadiusImpl.hasRole(this.auditorNames, this.auditorRoles, username, externalRoles));
            admin.setAdminManager(AdminUserManagerRadiusImpl.hasRole(this.userAdminNames, this.userAdminRoles, username, externalRoles));
            admin.setExpressionAdmin(AdminUserManagerRadiusImpl.hasRole(this.expressionNames, this.expressionRoles, username, externalRoles));
            admin.setDataCollectionAdmin(AdminUserManagerRadiusImpl.hasRole(this.dataCollectionAdminNames, this.dataCollectionAdminRoles, username, externalRoles));
        }
        return admin;
    }

    private boolean useLdapRoles() {
        return this.ldapManager != null;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("RADIUS Clients", (Object)this.radiusClients.toString());
        builder.append("Use LDAP Roles", this.useLdapRoles());
        builder.append("Role Attribute Code", this.roleAttributeCode);
        builder.append("Admin names", this.adminNames);
        builder.append("Crypto names", this.cryptoNames);
        builder.append("Auditor names", this.auditorNames);
        builder.append("User Admin names", this.userAdminNames);
        builder.append("Role Map Admin", this.adminRoles);
        builder.append("Role Map Crypto", this.cryptoRoles);
        builder.append("Role Map Auditor", this.auditorRoles);
        builder.append("Role Map User Admin", this.userAdminRoles);
        builder.append("Role Map Expression Admin", this.userAdminRoles);
        return builder.toString();
    }
}

