/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.crypto.Password;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.validate.admin.auth.OAuth2AdminApiAuthValidator;
import org.sourceid.openid.connect.domain.OAuthClientConnection;
import org.sourceid.openid.connect.domain.OAuthClientTokenValidateConnection;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.BasePropsAdminUserManager;
import org.sourceid.saml20.domain.util.AdminAuthUtil;
import org.sourceid.saml20.util.SystemUtil;

public class AdminUserOAuth2ManagerImpl
extends BasePropsAdminUserManager {
    private static final String ADMIN_USER_OAUTH2_FILE = "oauth2.properties.file";
    private final Map<String, Set<String>> roleMap = new HashMap<String, Set<String>>();
    private String usernameAttributeName = null;
    private String roleSearchAttributeName = null;
    private OAuthClientTokenValidateConnection connection;
    private static final Log log = LogFactory.getLog(AdminUserOAuth2ManagerImpl.class);

    public AdminUserOAuth2ManagerImpl() {
        this.init();
    }

    @Override
    protected String getBasePropertiesFileName() {
        return ADMIN_USER_OAUTH2_FILE;
    }

    @Override
    protected String getRolePropertyName(String role) {
        return String.join((CharSequence)".", Arrays.asList("role", role));
    }

    @Override
    protected void loadProperties(Properties properties) {
        try {
            String clientId = AdminAuthUtil.getProperty(properties, "client.id", true, "Client ID");
            String secretStr = AdminAuthUtil.getProperty(properties, "client.secret", false, "Client Secret");
            Password clientSecret = new Password(secretStr);
            if (secretStr != null && clientSecret.getStrValue() != null && secretStr.equals(clientSecret.getStrValue()) && !SecretReferenceUtil.isSecretReference((String)secretStr)) {
                log.warn((Object)"Administrative API authentication is not securely configured. The property 'client.secret' has a plain text value. To improve security, it should be obfuscated.");
            }
            String clientAuthnMethod = AdminAuthUtil.getProperty(properties, "client.authn.method", true, "Client authentication method");
            String introspectionEndpoint = AdminAuthUtil.getURLProperty(properties, "introspection.endpoint", true, "Introspection Endpoint");
            HashSet<String> scopes = new HashSet<String>();
            AdminUserOAuth2ManagerImpl.splitAndNormalize(AdminAuthUtil.getProperty(properties, "required.scopes", false, "Scopes"), ' ', scopes, false);
            this.usernameAttributeName = AdminAuthUtil.getProperty(properties, "username.attribute.name", true, "Username Attribute Name");
            this.roleSearchAttributeName = AdminAuthUtil.getProperty(properties, "role.attribute.name", true, "User Attribute Name for determining admin roles");
            this.roleMap.putAll(AdminAuthUtil.getRoleValues(properties));
            this.connection = new OAuthClientTokenValidateConnection(clientId, clientSecret, clientAuthnMethod, scopes, introspectionEndpoint);
            log.info((Object)("Client ID: " + clientId));
            log.info((Object)"Client Secret: ****");
            log.info((Object)("Client authentication method: " + clientAuthnMethod));
            log.info((Object)("Introspection Endpoint: " + introspectionEndpoint));
            log.info((Object)("Scopes: " + scopes));
            log.info((Object)("Username Attribute Name: " + this.usernameAttributeName));
            log.info((Object)("User Attribute Name for determining admin roles: " + this.roleSearchAttributeName));
            OAuth2AdminApiAuthValidator validator = new OAuth2AdminApiAuthValidator(this.connection, this.usernameAttributeName, this.roleSearchAttributeName);
            if (!validator.validate()) {
                throw new RuntimeException();
            }
        }
        catch (RuntimeException e) {
            String errorMsg = "Invalid configuration found in " + System.getProperty(this.getBasePropertiesFileName()) + ".";
            log.debug((Object)errorMsg, (Throwable)e);
            SystemUtil.hardShutdown(errorMsg);
        }
    }

    @Override
    public AdministrativeUser authenticate(String username, String password, HttpServletRequest request) throws AdminUserException {
        log.error((Object)"Unsupported authenticate operation for OAuth2. Username and password cannot be accepted as OAuth2 is the configured API authentication method.");
        throw new AdminUserException(AdminUserException.Code.USER);
    }

    @Override
    public AdministrativeUser authenticate(HttpServletRequest request) throws AdminUserException {
        log.error((Object)"Unsupported authenticate operation for OAuth2. Username and password cannot be accepted as OAuth2 is the configured API authentication method.");
        throw new AdminUserException(AdminUserException.Code.USER);
    }

    @Override
    public Collection<AdministrativeUser> getUsers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, AdministrativeUser> getUsersMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Set<String>> getRoleMap() {
        return this.roleMap;
    }

    @Override
    public String getUsernameAttributeName() {
        return this.usernameAttributeName;
    }

    @Override
    public OAuthClientConnection getConnection() {
        return this.connection;
    }

    @Override
    public String getRoleAttributeName() {
        return this.roleSearchAttributeName;
    }
}

