/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.crypto.Password;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.validate.admin.auth.OIDCAdminAuthValidator;
import org.sourceid.openid.connect.domain.OIDCProviderConnection;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.OIDCRequestParamSetting;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.BasePropsAdminUserManager;
import org.sourceid.saml20.domain.util.AdminAuthUtil;
import org.sourceid.saml20.util.SystemUtil;

public class AdminUserOIDCManagerImpl
extends BasePropsAdminUserManager {
    private static final String ADMIN_USER_OIDC_FILE = "oidc.properties.file";
    private final Map<String, Set<String>> roleMap = new HashMap<String, Set<String>>();
    private String usernameAttributeName = null;
    private String roleSearchAttributeName = null;
    private OIDCProviderConnection connection;
    private static final Log log = LogFactory.getLog(AdminUserOIDCManagerImpl.class);
    public static final String REQUEST_PARAMETER = "request.parameter";
    public static final String REQUEST_PARAMETER_NAME = "request.parameter.name";
    public static final String REQUEST_PARAMETER_DEFAULT_VALUE = "request.parameter.default.value";
    public static final String REQUEST_PARAMETER_OVERRIDABLE = "request.parameter.overridable";

    public AdminUserOIDCManagerImpl() {
        this.init();
    }

    @Override
    protected String getBasePropertiesFileName() {
        return ADMIN_USER_OIDC_FILE;
    }

    @Override
    protected String getRolePropertyName(String role) {
        return String.join((CharSequence)".", Arrays.asList("role", role));
    }

    @Override
    protected void loadProperties(Properties properties) {
        try {
            Password clientSecret;
            String clientId = AdminAuthUtil.getProperty(properties, "client.id", true, "Client ID");
            String secretStr = AdminAuthUtil.getProperty(properties, "client.secret", false, "Client Secret");
            Password password = clientSecret = secretStr == null ? null : new Password(secretStr);
            if (secretStr != null && clientSecret.getStrValue() != null && secretStr.equals(clientSecret.getStrValue()) && !SecretReferenceUtil.isSecretReference((String)secretStr)) {
                log.warn((Object)"Administrative console authentication is not securely configured. The property 'client.secret' has a plain text value. To improve security, it should be obfuscated.");
            }
            String clientAuthnMethod = AdminAuthUtil.getProperty(properties, "client.authn.method", true, "Client authentication method");
            String authorizationEndpoint = AdminAuthUtil.getURLProperty(properties, "authorization.endpoint", true, "Authorization Endpoint");
            String tokenEndpoint = AdminAuthUtil.getURLProperty(properties, "token.endpoint", true, "Token Endpoint");
            String userInfoEndpoint = AdminAuthUtil.getURLProperty(properties, "user.info.endpoint", false, "User Information Endpoint");
            String endSessionEndpoint = AdminAuthUtil.getURLProperty(properties, "end.session.endpoint", false, "End Session Endpoint");
            String issuer = AdminAuthUtil.getProperty(properties, "issuer", true, "Issuer");
            String pushedAuthorizationRequestEndpoint = AdminAuthUtil.getURLProperty(properties, "pushed.authorization.request.endpoint", false, "Pushed Authorization Request Endpoint");
            String audience = AdminAuthUtil.getProperty(properties, "audience", false, "Audience");
            String type = AdminAuthUtil.getProperty(properties, "type", false, "Type");
            ArrayList<String> acrValues = new ArrayList<String>();
            AdminUserOIDCManagerImpl.splitAndNormalize(AdminAuthUtil.getProperty(properties, "acr.values", false, "ACR values"), ' ', acrValues, false);
            HashSet<String> scopes = new HashSet<String>();
            AdminUserOIDCManagerImpl.splitAndNormalize(AdminAuthUtil.getProperty(properties, "scopes", true, "Scopes"), ' ', scopes, false);
            this.usernameAttributeName = AdminAuthUtil.getProperty(properties, "username.attribute.name", true, "Username Attribute Name");
            this.roleSearchAttributeName = AdminAuthUtil.getProperty(properties, "role.attribute.name", true, "User Attribute Name for determining admin roles");
            this.roleMap.putAll(AdminAuthUtil.getRoleValues(properties));
            String pkceString = AdminAuthUtil.getProperty(properties, "enable.proof.key.code.exchange", false, "Enable Proof Key Code Exchange");
            boolean enableProofKeyForCodeExchange = StringUtils.isNotBlank((String)pkceString) ? Boolean.parseBoolean(pkceString) : Boolean.FALSE;
            log.info((Object)("Client ID: " + clientId));
            log.info((Object)"Client Secret: ****");
            log.info((Object)("Client authentication method: " + clientAuthnMethod));
            log.info((Object)("Authorization Endpoint: " + authorizationEndpoint));
            log.info((Object)("Pushed Authorization Request Endpoint: " + pushedAuthorizationRequestEndpoint));
            log.info((Object)("Token Endpoint: " + tokenEndpoint));
            log.info((Object)("Enable Proof Key Code Exchange: " + enableProofKeyForCodeExchange));
            log.info((Object)("User Information Endpoint: " + userInfoEndpoint));
            log.info((Object)("End Session Endpoint: " + endSessionEndpoint));
            log.info((Object)("Issuer: " + issuer));
            log.info((Object)("ACR values: " + acrValues));
            log.info((Object)("Scopes: " + scopes));
            log.info((Object)("Username Attribute Name: " + this.usernameAttributeName));
            log.info((Object)("User Attribute Name for determining admin roles: " + this.roleSearchAttributeName));
            log.info((Object)("Audience: " + audience));
            log.info((Object)("Type: " + type));
            Collection<OIDCRequestParamSetting> requestParameterSettings = this.getRequestParameterProperties(properties);
            this.connection = new OIDCProviderConnection(clientId, authorizationEndpoint, endSessionEndpoint, tokenEndpoint, userInfoEndpoint, issuer, clientSecret, clientAuthnMethod, scopes, acrValues, enableProofKeyForCodeExchange, requestParameterSettings, pushedAuthorizationRequestEndpoint, type, audience);
            OIDCAdminAuthValidator validator = new OIDCAdminAuthValidator();
            if (!(validator.validate(this.connection) && validator.validateValue(this.getUsernameAttributeName(), true, false, "Username claim name") && validator.validateValue(this.getRoleAttributeName(), true, false, "Role Attribute claim name"))) {
                throw new RuntimeException();
            }
        }
        catch (RuntimeException ex) {
            String errorMsg = "Invalid configuration found in " + System.getProperty(this.getBasePropertiesFileName()) + ".";
            log.debug((Object)errorMsg, (Throwable)ex);
            SystemUtil.hardShutdown(errorMsg);
        }
    }

    @Override
    public AdministrativeUser authenticate(String username, String password, HttpServletRequest request) throws AdminUserException {
        log.error((Object)"Unsupported authenticate operation for OIDC. Username and password cannot be accepted by PingFederate and should be redirected to the  configured Openid provider ");
        throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
    }

    @Override
    public AdministrativeUser authenticate(HttpServletRequest request) throws AdminUserException {
        log.error((Object)"Unsupported authenticate operation for OIDC. Username and password cannot be accepted by PingFederate and should be redirected to the  configured Openid provider ");
        throw new AdminUserException(AdminUserException.Code.SSO_ERROR);
    }

    @Override
    public Collection<AdministrativeUser> getUsers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, AdministrativeUser> getUsersMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changePassword(String userName, String newPassword, boolean changeRequired) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> getListOfUserNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AdministrativeUser getUser(String userName) {
        throw new UnsupportedOperationException();
    }

    private Collection<OIDCRequestParamSetting> getRequestParameterProperties(Properties properties) {
        HashMap<String, OIDCRequestParamSetting> reqParamMap = new HashMap<String, OIDCRequestParamSetting>();
        ArrayList<OIDCRequestParamSetting> requestParameters = new ArrayList<OIDCRequestParamSetting>();
        for (String string : properties.stringPropertyNames()) {
            if (string.startsWith(REQUEST_PARAMETER_NAME) && this.isParameterPropertyNameValid(string, REQUEST_PARAMETER_NAME)) {
                this.setRequestParameterName(reqParamMap, string, properties);
                continue;
            }
            if (string.startsWith(REQUEST_PARAMETER_DEFAULT_VALUE) && this.isParameterPropertyNameValid(string, REQUEST_PARAMETER_DEFAULT_VALUE)) {
                this.setRequestParameterDefaultValue(reqParamMap, string, properties);
                continue;
            }
            if (!string.startsWith(REQUEST_PARAMETER_OVERRIDABLE) || !this.isParameterPropertyNameValid(string, REQUEST_PARAMETER_OVERRIDABLE)) continue;
            this.setRequestParameterOverridable(reqParamMap, string, properties);
        }
        for (Map.Entry entry : reqParamMap.entrySet()) {
            String index = ((String)entry.getKey()).substring(1);
            OIDCRequestParamSetting paramSetting = (OIDCRequestParamSetting)entry.getValue();
            requestParameters.add(paramSetting);
            String isOverrideStr = paramSetting.isOverride() == null ? "null (Default to FALSE)" : paramSetting.isOverride().toString();
            log.info((Object)("Request Parameter Name " + index + ": " + paramSetting.getName()));
            log.info((Object)("Request Parameter Default Value " + index + ": " + (paramSetting.getValue() == null ? null : paramSetting.getValue().getValue())));
            log.info((Object)("Request Parameter Overridable " + index + ": " + isOverrideStr));
            if (paramSetting.getValue() == null) {
                paramSetting.setValue(new AttrMappingValue(SourceType.TEXT, null));
            }
            if (paramSetting.isOverride() != null) continue;
            paramSetting.setOverride(false);
        }
        return requestParameters;
    }

    private boolean isParameterPropertyNameValid(String propertyName, String prefix) {
        if (prefix.equals(propertyName) || '.' != propertyName.charAt(prefix.length()) || StringUtils.isBlank((String)propertyName.substring(prefix.length() + 1))) {
            throw new RuntimeException("Invalid property name: " + propertyName);
        }
        return true;
    }

    private void setRequestParameterName(Map<String, OIDCRequestParamSetting> reqParamMap, String propertyName, Properties properties) {
        String name = AdminAuthUtil.getProperty(properties, propertyName, false, propertyName);
        this.updateRequestParameterMap(reqParamMap, propertyName, REQUEST_PARAMETER_NAME).setName(name);
    }

    private void setRequestParameterDefaultValue(Map<String, OIDCRequestParamSetting> reqParamMap, String propertyName, Properties properties) {
        AttrMappingValue defaultValue = new AttrMappingValue(SourceType.TEXT, AdminAuthUtil.getProperty(properties, propertyName, false, propertyName));
        this.updateRequestParameterMap(reqParamMap, propertyName, REQUEST_PARAMETER_DEFAULT_VALUE).setValue(defaultValue);
    }

    private void setRequestParameterOverridable(Map<String, OIDCRequestParamSetting> reqParamMap, String propertyName, Properties properties) {
        String overridableStr = StringUtils.trim((String)AdminAuthUtil.getProperty(properties, propertyName, false, propertyName));
        boolean overridable = Boolean.parseBoolean(overridableStr);
        this.updateRequestParameterMap(reqParamMap, propertyName, REQUEST_PARAMETER_OVERRIDABLE).setOverride(overridable);
    }

    private OIDCRequestParamSetting updateRequestParameterMap(Map<String, OIDCRequestParamSetting> reqParamMap, String propertyName, String propertyPrefix) {
        String key = propertyName.substring(propertyPrefix.length());
        return reqParamMap.computeIfAbsent(key, k -> new OIDCRequestParamSetting());
    }

    @Override
    public Map<String, Set<String>> getRoleMap() {
        return this.roleMap;
    }

    @Override
    public String getUsernameAttributeName() {
        return this.usernameAttributeName;
    }

    @Override
    public OIDCProviderConnection getConnection() {
        return this.connection;
    }

    @Override
    public String getRoleAttributeName() {
        return this.roleSearchAttributeName;
    }
}

