/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.crypto.HashedPassword;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;

public class AdministrativeUser
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final String USER_ADMIN = "UserAdmin";
    private static final String ADMIN = "Admin";
    private static final String CRYPTO_ADMIN = "CryptoAdmin";
    private static final String AUDITOR = "Auditor";
    private static final String EXPRESSION_ADMIN = "ExpressionAdmin";
    private static final String DATA_COLLECTION_ADMIN = "DataCollectionAdmin";
    private String userName;
    private String salt;
    private String hash;
    private String newPassword;
    private String newPasswordConfirm;
    private String phoneNumber;
    private String emailAddress;
    private String department;
    private String description;
    private boolean adminManager;
    private boolean admin;
    private boolean cryptoManager;
    private boolean auditor;
    private boolean expressionAdmin;
    private boolean dataCollectionAdmin;
    private boolean active;
    private boolean changeRequired;
    private boolean deactivateDisabled;
    private boolean flagWarningForUser;
    private boolean isTempUser = false;
    private boolean isLocalAccount = false;
    public static Comparator<AdministrativeUser> COMPARE_BY_NAME_UP = Comparator.comparing(AdministrativeUser::getUserName);

    public boolean equals(Object user) {
        if (user instanceof AdministrativeUser) {
            AdministrativeUser otherUser = (AdministrativeUser)user;
            return this.userName.equalsIgnoreCase(otherUser.getUserName()) && this.isLocalAccount == otherUser.isLocalAccount;
        }
        return false;
    }

    public int hashCode() {
        return this.userName.toLowerCase().hashCode();
    }

    public boolean matches(String password) {
        try {
            HashedPassword hashedPassword = HashedPassword.fromEncodedText(this.hash);
            if (hashedPassword != null && hashedPassword.checkSecret(password)) {
                return true;
            }
        }
        catch (IllegalArgumentException hashedPassword) {
            // empty catch block
        }
        if (this.salt != null) {
            byte[] saltBytes = HexBin.stringToBytes((String)this.salt);
            MessageDigest sha = HashUtil.getMessageDigester((HashAlgorithm)HashAlgorithm.SHA1);
            sha.update(saltBytes);
            sha.update(password.getBytes(StandardCharsets.UTF_8));
            String passwordHash = HexBin.bytesToString((byte[])sha.digest());
            return passwordHash.equals(this.hash);
        }
        return false;
    }

    public void setPassword(String password) {
        HashedPassword hashedPassword = HashedPassword.fromClearText(password);
        this.hash = hashedPassword.toEncodedText();
        this.salt = "";
    }

    public StringBuffer describeUser(boolean rolesOnly) {
        StringBuffer localBuffer = new StringBuffer();
        if (!rolesOnly) {
            localBuffer.append(this.userName);
            localBuffer.append(" | ");
        }
        List<String> roleList = this.getRoleList();
        localBuffer.append(String.join((CharSequence)",", roleList));
        return localBuffer;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPasswordConfirm() {
        return this.newPasswordConfirm;
    }

    public void setNewPasswordConfirm(String newPasswordConfirm) {
        this.newPasswordConfirm = newPasswordConfirm;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean getAdmin() {
        return this.admin;
    }

    public boolean isAdminManager() {
        return this.adminManager;
    }

    public void setAdminManager(boolean adminManager) {
        this.adminManager = adminManager;
    }

    public boolean getAdminManager() {
        return this.adminManager;
    }

    public boolean isAuditor() {
        return this.auditor;
    }

    public void setAuditor(boolean auditor) {
        this.auditor = auditor;
        if (auditor) {
            this.setAdminManager(false);
            this.setAdmin(false);
            this.setCryptoManager(false);
            this.setExpressionAdmin(false);
            this.setDataCollectionAdmin(false);
        }
    }

    public boolean getAuditor() {
        return this.auditor;
    }

    public boolean isCryptoManager() {
        return this.cryptoManager;
    }

    public void setCryptoManager(boolean cryptoManager) {
        this.cryptoManager = cryptoManager;
    }

    public boolean getCryptoManager() {
        return this.cryptoManager;
    }

    public boolean getChangeRequired() {
        return this.changeRequired;
    }

    public void setChangeRequired(boolean changeRequired) {
        this.changeRequired = changeRequired;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public AdministrativeUser getClone() {
        try {
            return (AdministrativeUser)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean getDeactivateDisabled() {
        return this.deactivateDisabled;
    }

    public void setDeactivateDisabled(boolean deactivateDisabled) {
        this.deactivateDisabled = deactivateDisabled;
    }

    public boolean getFlagWarningForUser() {
        return this.flagWarningForUser;
    }

    public void setFlagWarningForUser(boolean flagWarningForUser) {
        this.flagWarningForUser = flagWarningForUser;
    }

    public boolean isTempUser() {
        return this.isTempUser;
    }

    public void setIsTempUser(boolean isTempUser) {
        this.isTempUser = isTempUser;
    }

    public boolean isLocalAccount() {
        return this.isLocalAccount;
    }

    public void setLocalAccount(boolean localAccount) {
        this.isLocalAccount = localAccount;
    }

    public boolean isExpressionAdmin() {
        return this.expressionAdmin;
    }

    public void setExpressionAdmin(boolean expressionAdmin) {
        this.expressionAdmin = expressionAdmin;
    }

    public boolean isDataCollectionAdmin() {
        return this.dataCollectionAdmin;
    }

    public void setDataCollectionAdmin(boolean dataCollectionAdmin) {
        this.dataCollectionAdmin = dataCollectionAdmin;
    }

    public boolean getDataCollectionAdmin() {
        return this.dataCollectionAdmin;
    }

    private List<String> getRoleList() {
        ArrayList<String> roleList = new ArrayList<String>();
        if (this.adminManager) {
            roleList.add(USER_ADMIN);
        }
        if (this.admin) {
            roleList.add(ADMIN);
        }
        if (this.cryptoManager) {
            roleList.add(CRYPTO_ADMIN);
        }
        if (this.auditor) {
            roleList.add(AUDITOR);
        }
        if (this.expressionAdmin) {
            roleList.add(EXPRESSION_ADMIN);
        }
        if (this.dataCollectionAdmin) {
            roleList.add(DATA_COLLECTION_ADMIN);
        }
        return roleList;
    }

    public boolean hasCryptoAdminRoleOnly() {
        return this.hasAllRoles(List.of(CRYPTO_ADMIN));
    }

    public boolean hasUserAdminRoleOnly() {
        return this.hasAllRoles(List.of(USER_ADMIN));
    }

    public boolean hasUserAndCryptoAdminRolesOnly() {
        return this.hasAllRoles(Arrays.asList(CRYPTO_ADMIN, USER_ADMIN));
    }

    private boolean hasAllRoles(List<String> roleNames) {
        if (roleNames == null || roleNames.isEmpty()) {
            return false;
        }
        List<String> roleList = this.getRoleList();
        return roleList.size() == roleNames.size() && roleList.containsAll(roleNames);
    }
}

