/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.crypto.HashedPassword;
import com.pingidentity.jmx.JmxBootstrapper;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.domain.AppAuthMap;

public class AppAuthMapManagerImpl {
    private static final String AUTH_MAP = "AppAuthMap";
    private static final String WS_AUTH = "needAuthnForWebService";
    private static final String SERVICE_SSO_DIRECTORY = "SsoDirectoryService";
    private static final String SERVICE_JMX = "JMX";
    private static final String SERVICE_CONNECTION_MANAGEMENT = "ConnectionManagement";
    private static final String SERVICE_ATTRIBUTE_QUERY = "AttributeQuery";
    private final ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());

    private void prepareForSave(AppAuthMap originalAppMap, AppAuthMap newAppMap) {
        if (StringUtils.isNotBlank((String)newAppMap.getSharedSecret()) && (originalAppMap.getSharedSecret() == null || !originalAppMap.getSharedSecret().equals(newAppMap.getSharedSecret()))) {
            String sharedSecret = HashedPassword.fromClearText(newAppMap.getSharedSecret()).toEncodedText();
            newAppMap.setSharedSecret(sharedSecret);
            newAppMap.setConfirmSharedSecret(sharedSecret);
        }
    }

    public void saveSsoDirectoryServiceMap(AppAuthMap appMap) {
        this.saveSsoDirectoryServiceMap(appMap, false);
    }

    public void saveSsoDirectoryServiceMap(AppAuthMap appMap, boolean isEncryptedSecret) {
        if (!isEncryptedSecret) {
            this.prepareForSave(this.getSsoDirectoryServiceMap(), appMap);
        }
        this.configStore.setMapValue(SERVICE_SSO_DIRECTORY, appMap.getAppAuthMap());
    }

    public void saveJmxMap(AppAuthMap appMap) {
        this.saveJmxMap(appMap, false);
    }

    public void saveJmxMap(AppAuthMap appMap, boolean isEncryptedSecret) {
        if (!isEncryptedSecret) {
            this.prepareForSave(this.getJmxMap(), appMap);
        }
        this.configStore.setMapValue(SERVICE_JMX, appMap.getAppAuthMap());
        JmxBootstrapper.getJmxBootstrapper().reload();
    }

    public void saveConnectionManagementMap(AppAuthMap appMap) {
        this.saveConnectionManagementMap(appMap, false);
    }

    public void saveConnectionManagementMap(AppAuthMap appMap, boolean isEncryptedSecret) {
        if (!isEncryptedSecret) {
            this.prepareForSave(this.getConnectionManagementMap(), appMap);
        }
        this.configStore.setMapValue(SERVICE_CONNECTION_MANAGEMENT, appMap.getAppAuthMap());
    }

    public void saveAttributeQueryMap(AppAuthMap appMap) {
        this.saveAttributeQueryMap(appMap, false);
    }

    public void saveAttributeQueryMap(AppAuthMap appMap, boolean isEncryptedSecret) {
        if (!isEncryptedSecret) {
            this.prepareForSave(this.getAttributeQueryMap(), appMap);
        }
        this.configStore.setMapValue(SERVICE_ATTRIBUTE_QUERY, appMap.getAppAuthMap());
    }

    public AppAuthMap getSsoDirectoryServiceMap() {
        AppAuthMap serviceMap = new AppAuthMap(this.configStore.getMapValue(SERVICE_SSO_DIRECTORY, Collections.EMPTY_MAP));
        return this.handleBackwardsCompatibility(SERVICE_SSO_DIRECTORY, serviceMap);
    }

    public AppAuthMap getJmxMap() {
        return new AppAuthMap(this.configStore.getMapValue(SERVICE_JMX, Collections.EMPTY_MAP));
    }

    public AppAuthMap getConnectionManagementMap() {
        AppAuthMap serviceMap = new AppAuthMap(this.configStore.getMapValue(SERVICE_CONNECTION_MANAGEMENT, Collections.EMPTY_MAP));
        return this.handleBackwardsCompatibility(SERVICE_CONNECTION_MANAGEMENT, serviceMap);
    }

    public AppAuthMap getAttributeQueryMap() {
        AppAuthMap serviceMap = new AppAuthMap(this.configStore.getMapValue(SERVICE_ATTRIBUTE_QUERY, Collections.EMPTY_MAP));
        return this.handleBackwardsCompatibility(SERVICE_ATTRIBUTE_QUERY, serviceMap);
    }

    private AppAuthMap handleBackwardsCompatibility(String service, AppAuthMap appAuthMap) {
        try {
            Map map = this.configStore.getMapValue(AUTH_MAP);
            boolean isNeedAuthnForWebService = this.configStore.getBooleanValue(WS_AUTH);
            if (map.isEmpty()) {
                if (service.equals(SERVICE_SSO_DIRECTORY) && !isNeedAuthnForWebService) {
                    appAuthMap.activate();
                }
            } else if (map.size() == 1) {
                appAuthMap.activate();
                if (service.equals(SERVICE_CONNECTION_MANAGEMENT) || service.equals(SERVICE_ATTRIBUTE_QUERY) || service.equals(SERVICE_SSO_DIRECTORY) && isNeedAuthnForWebService) {
                    Map.Entry entry = map.entrySet().iterator().next();
                    appAuthMap.setId((String)entry.getKey());
                    appAuthMap.setSharedSecret((String)entry.getValue());
                    appAuthMap.setConfirmSharedSecret((String)entry.getValue());
                }
            }
            return appAuthMap;
        }
        catch (NoSuchValueException e) {
            return appAuthMap;
        }
    }

    public void removeLegacyConfigEntries() {
        this.configStore.setMapValue(AUTH_MAP, null);
        this.configStore.setStringValue(WS_AUTH, null);
    }
}

