/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import java.security.InvalidParameterException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.format.ISODateTimeFormat;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.impl.AuthnSessionValidationException;
import org.sourceid.saml20.service.RevokedSriInfo;
import org.sourceid.saml20.service.SessionRegistryException;
import org.sourceid.saml20.service.SessionRevocationService;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.websso.servlet.ExtendedSri;

public class AuthenticationSessionValidator {
    private static Log log = LogFactory.getLog(AuthenticationSessionValidator.class);
    protected SessionRevocationService sessionRevocationService;

    public AuthenticationSessionValidator(SessionRevocationService sessionRevocationService) {
        this.sessionRevocationService = sessionRevocationService;
    }

    public void handleSessionValidation(BearerAccessTokenMgmtPluginInstance atm, String sri) throws AuthnSessionValidationException {
        if (StringUtils.isNotBlank((String)sri)) {
            RevokedSriInfo info;
            ExtendedSri extendedSri;
            try {
                extendedSri = new ExtendedSri(sri);
            }
            catch (InvalidParameterException ex) {
                String errorMsg = "An error occurred while parsing sri '" + sri + "' to validate session";
                throw new AuthnSessionValidationException(AuthnSessionValidationException.Type.SRI_INVALID, errorMsg);
            }
            if (atm.findEffectiveRevocationStatus() && (info = this.sessionRevocationService.getRevokedSriInfo(extendedSri.getSri())) != null) {
                String errorMsg = "User session has been revoked, SRI=" + info.getSri() + ", expiration time=" + ISODateTimeFormat.dateTime().withZoneUTC().print(info.getExpirationTime());
                throw new AuthnSessionValidationException(AuthnSessionValidationException.Type.SESSION_REVOKED, errorMsg);
            }
            if (atm.findEffectiveSessionValidationStatus()) {
                boolean validSession = IdpSessionRegistrySupport.hasValidAuthnSession(sri, atm.findEffectiveUpdateSessionStatus());
                if (!validSession) {
                    String errorMsg = "User session does not have a valid associated session, SRI=" + sri;
                    throw new AuthnSessionValidationException(AuthnSessionValidationException.Type.SESSION_INVALID, errorMsg);
                }
            } else if (atm.findEffectiveUpdateSessionStatus()) {
                try {
                    IdpSessionRegistrySupport.updateLastActivityTime(sri);
                }
                catch (SessionRegistryException ex) {
                    String errorMsg = "An error occurred while attempting to validate session for sri '" + sri + "'";
                    throw new AuthnSessionValidationException(AuthnSessionValidationException.Type.SESSION_REGISTRY_ERROR, errorMsg);
                }
            }
        }
    }
}

