/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.authnselection.ApcAction;
import com.pingidentity.authnselection.ApcMappingAction;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.AuthnSelectorAction;
import com.pingidentity.authnselection.AuthnSelectorVisitor;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.authnselection.AuthnSourceKeyVisitor;
import com.pingidentity.authnselection.FragmentSourceKeyVisitor;
import com.pingidentity.authnselection.LeafNodeVisitor;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.authnselection.NoOpAction;
import com.pingidentity.authnselection.fragment.FragmentAction;
import com.pingidentity.authnselection.xmlbinding.AuthnSelectionConfigDocument;
import com.pingidentity.authnselection.xmlbinding.AuthnSelectionConfigType;
import com.pingidentity.authnselection.xmlbinding.AuthnSelectionTreeType;
import com.pingidentity.authnselection.xmlbinding.AuthnSelectionTreesType;
import com.pingidentity.authnselection.xmlbinding.DefaultAuthnSourcesType;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.pingcommons.util.tree.PreOrderTraversal;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.AuthnSelectorManager;
import org.sourceid.saml20.domain.mgmt.PolicyIdNotFoundException;
import org.sourceid.saml20.domain.mgmt.PolicyIdUniquenessException;
import org.sourceid.saml20.domain.mgmt.PolicyManagerException;
import org.sourceid.saml20.domain.mgmt.PolicyMoveException;
import org.sourceid.saml20.domain.mgmt.PolicyMoveToIdException;
import org.sourceid.saml20.domain.mgmt.PolicyMoveToIndexException;
import org.sourceid.saml20.domain.mgmt.PolicyNameUniquenessException;
import org.sourceid.saml20.domain.mgmt.impl.AbstractPolicyTreeConfigManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.xmlbinding.adapterconf.AdapterSelectorConfigDocument;
import org.sourceid.saml20.xmlbinding.adapterconf.AdapterSelectorContextMapType;
import org.sourceid.saml20.xmlbinding.adapterconf.AdapterSelectorDefaultIds;
import org.sourceid.saml20.xmlbinding.adapterconf.AdapterSelectorMappingType;
import org.sourceid.saml20.xmlbinding.adapterconf.AuthnSourceKeyType;

public class AuthnSelectionConfigManagerImpl
extends AbstractPolicyTreeConfigManager
implements AuthnSelectionConfigManager,
AutoReloadable {
    private static final String LEGACY_FILENAME = "pingfederate-adapter-selector-config.xml";
    private static final String FILENAME = "pingfederate-authn-selection-config.xml";
    private static final String LEGACY_NONE = "--None--";
    private XmlLoader xmlLoader;
    private String directory;
    private AuthnSelectorManager authnSelectorManager;
    private boolean legacyFileLoaded = false;
    protected boolean enableIdpAuthnSelection;
    protected boolean enableSpAuthnSelection;
    protected boolean failIfNoSelection;
    protected List<AuthnSourceKey> defaultAuthnSourceKeys = new ArrayList<AuthnSourceKey>();
    protected List<AuthnSelectionTree> authnSelectionTrees = new LinkedList<AuthnSelectionTree>();
    protected Map<String, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>> apcId2ApcPaths = new HashMap<String, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>>();
    protected Map<String, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>> lipId2LipPaths = new HashMap<String, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>>();
    protected Map<String, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>> apcId2FragmentPaths = new HashMap<String, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>>();
    protected Map<AuthnSourceKey, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>> authnSourceKey2ApcPaths = new HashMap<AuthnSourceKey, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>>();
    protected Map<AuthnSelectionTree, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>> tree2ContinuePaths = new HashMap<AuthnSelectionTree, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>>();
    protected Map<AuthnSelectionTree, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>> tree2RestartPaths = new HashMap<AuthnSelectionTree, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>>();
    protected Map<AuthnSelectionTree, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>> tree2AuthnSelectorPaths = new HashMap<AuthnSelectionTree, LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>>>();
    private long lastModifiedMillis = 0L;

    AuthnSelectionConfigManagerImpl() {
    }

    public AuthnSelectionConfigManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo, Mediator mediator, AuthnSelectorManager authnSelectorManager) {
        this(xmlLoader, sysDirInfo.getDataDirectory(), authnSelectorManager);
    }

    private AuthnSelectionConfigManagerImpl(XmlLoader xmlLoader, String directory, AuthnSelectorManager authnSelectorManager) {
        this.xmlLoader = xmlLoader;
        this.directory = directory;
        this.authnSelectorManager = authnSelectorManager;
        this.loadConfig();
    }

    @Override
    public boolean isEnableIdpAuthnSelection() {
        return this.enableIdpAuthnSelection;
    }

    @Override
    public synchronized void setEnableIdpAuthnSelection(boolean enableIdpAdapterSelection) {
        this.enableIdpAuthnSelection = enableIdpAdapterSelection;
        this.save();
    }

    @Override
    public boolean isEnableSpAuthnSelection() {
        return this.enableSpAuthnSelection;
    }

    @Override
    public synchronized void setEnableSpAuthnSelection(boolean enableSpAdapterSelection) {
        this.enableSpAuthnSelection = enableSpAdapterSelection;
        this.save();
    }

    @Override
    public List<AuthnSourceKey> getDefaultAuthnSourceKeys() {
        return this.defaultAuthnSourceKeys;
    }

    private void reset() {
        this.defaultAuthnSourceKeys.clear();
        this.authnSelectionTrees.clear();
        this.resetMaps();
        this.enableIdpAuthnSelection = false;
        this.failIfNoSelection = false;
    }

    private void resetMaps() {
        this.apcId2ApcPaths.clear();
        this.lipId2LipPaths.clear();
        this.authnSourceKey2ApcPaths.clear();
        this.tree2ContinuePaths.clear();
        this.tree2RestartPaths.clear();
        this.tree2AuthnSelectorPaths.clear();
        this.apcId2FragmentPaths.clear();
    }

    private synchronized void loadConfig() {
        this.reset();
        if (this.xmlLoader.xmlExists(this.directory, FILENAME)) {
            this.doLoadConfig();
        } else if (this.xmlLoader.xmlExists(this.directory, LEGACY_FILENAME)) {
            this.doLoadLegacyConfig();
        }
        this.rebuildTreeCache();
    }

    /*
     * WARNING - void declaration
     */
    private void rebuildTreeCache() {
        for (AuthnSelectionTree authnSelectionTree : this.authnSelectionTrees) {
            Object node32;
            LeafNodeVisitor leafVisitor = new LeafNodeVisitor();
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)authnSelectionTree, (TraversalVisitor)leafVisitor);
            for (Tree.Node node : leafVisitor.getApcNodes()) {
                ApcAction apcAction = (ApcAction)node.getData();
                String string = apcAction.getApcId();
                LinkedList linkedList = this.apcId2ApcPaths.computeIfAbsent(string, k -> new LinkedList());
                LinkedList<Tree.Node> apcPath = new LinkedList<Tree.Node>();
                for (Tree.Node currentNode3 = node; currentNode3 != null; currentNode3 = currentNode3.getParent()) {
                    apcPath.addFirst(currentNode3);
                }
                linkedList.add(apcPath);
            }
            for (Tree.Node<AuthnSelectionAction> node : leafVisitor.getTerminatingFragments()) {
                FragmentAction fragmentAction = (FragmentAction)node.getData();
                String string = fragmentAction.getApcId();
                LinkedList linkedList = this.apcId2FragmentPaths.computeIfAbsent(string, k -> new LinkedList());
                List<Tree.Node> successChildren = node.getChildren().stream().filter(child -> !"Fail".equals(((AuthnSelectionAction)child.getData()).getContext())).collect(Collectors.toList());
                LinkedList apcPath = new LinkedList();
                successChildren.forEach(currentNode -> {
                    while (currentNode != null) {
                        apcPath.addFirst(currentNode);
                        currentNode = currentNode.getParent();
                    }
                    terminatingFragmentPaths.add(apcPath);
                });
            }
            for (Tree.Node node : leafVisitor.getLipNodes()) {
                LocalIdentityMappingAction lipAction = (LocalIdentityMappingAction)node.getData();
                String string = lipAction.getLipId();
                LinkedList linkedList = this.lipId2LipPaths.computeIfAbsent(string, k -> new LinkedList());
                LinkedList<Tree.Node> lipPath = new LinkedList<Tree.Node>();
                for (Tree.Node currentNode2 = node; currentNode2 != null; currentNode2 = currentNode2.getParent()) {
                    lipPath.addFirst(currentNode2);
                }
                linkedList.add(lipPath);
            }
            for (Tree.Node node : leafVisitor.getDoneNodes()) {
                Tree.Node parentNode;
                boolean bl = false;
                for (parentNode = node.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
                    AuthnSelectionAction authnSelectionAction = (AuthnSelectionAction)parentNode.getData();
                    if (authnSelectionAction instanceof AuthnSourceAction) {
                        bl = true;
                        break;
                    }
                    if (!(authnSelectionAction instanceof ApcMappingAction) && !(authnSelectionAction instanceof LocalIdentityMappingAction)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                AuthnSourceKey authnSourceKey = ((AuthnSourceAction)parentNode.getData()).getAuthnSourceKey();
                LinkedList pathsForAnAuthnSource = this.authnSourceKey2ApcPaths.computeIfAbsent(authnSourceKey, k -> new LinkedList());
                LinkedList<Tree.Node> authnSourcePath = new LinkedList<Tree.Node>();
                for (Tree.Node currentNode4 = node; currentNode4 != null; currentNode4 = currentNode4.getParent()) {
                    authnSourcePath.addFirst(currentNode4);
                }
                pathsForAnAuthnSource.add(authnSourcePath);
            }
            LinkedList pathsForContinueLeaf = new LinkedList();
            for (Object node32 : leafVisitor.getContinueNodes()) {
                void var9_34;
                LinkedList<void> linkedList = new LinkedList<void>();
                Tree.Node<AuthnSelectionAction> node = node32;
                while (var9_34 != null) {
                    linkedList.addFirst(var9_34);
                    Tree.Node node2 = var9_34.getParent();
                }
                pathsForContinueLeaf.add(linkedList);
            }
            if (!pathsForContinueLeaf.isEmpty()) {
                this.tree2ContinuePaths.put(authnSelectionTree, pathsForContinueLeaf);
            }
            LinkedList linkedList = new LinkedList();
            node32 = leafVisitor.getRestartNodes().iterator();
            while (node32.hasNext()) {
                Tree.Node node = (Tree.Node)node32.next();
                LinkedList<Tree.Node> linkedList2 = new LinkedList<Tree.Node>();
                for (Tree.Node currentNode2 = node; currentNode2 != null; currentNode2 = currentNode2.getParent()) {
                    linkedList2.addFirst(currentNode2);
                }
                linkedList.add(linkedList2);
            }
            if (!linkedList.isEmpty()) {
                this.tree2RestartPaths.put(authnSelectionTree, linkedList);
            }
            LinkedList pathsForAuthnSelectorWithDoneLeaf = new LinkedList();
            for (Tree.Node node : leafVisitor.getDoneNodes()) {
                AuthenticationSelectorDescriptor descriptor;
                AuthnSelectorAction data;
                String authnSelectorId;
                AuthenticationSelector selector;
                Tree.Node currentNode3 = node;
                if (currentNode3 == null || currentNode3.getParent() == null || !(currentNode3.getParent().getData() instanceof AuthnSelectorAction) || (selector = this.authnSelectorManager.getAuthenticationSelector(authnSelectorId = (data = (AuthnSelectorAction)currentNode3.getParent().getData()).getAuthnSelectorId())) == null || selector.getPluginDescriptor() == null || !(selector.getPluginDescriptor() instanceof AuthenticationSelectorDescriptor) || !(descriptor = (AuthenticationSelectorDescriptor)selector.getPluginDescriptor()).canSelectAuthnSourceResultType()) continue;
                LinkedList<Tree.Node> path = new LinkedList<Tree.Node>();
                while (currentNode3 != null) {
                    path.addFirst(currentNode3);
                    currentNode3 = currentNode3.getParent();
                }
                pathsForAuthnSelectorWithDoneLeaf.addFirst(path);
            }
            if (pathsForAuthnSelectorWithDoneLeaf.isEmpty()) continue;
            this.tree2AuthnSelectorPaths.put(authnSelectionTree, pathsForAuthnSelectorWithDoneLeaf);
        }
    }

    private void doLoadConfig() {
        AuthnSelectionConfigDocument doc = (AuthnSelectionConfigDocument)this.xmlLoader.load(this.directory, FILENAME);
        AuthnSelectionConfigType asConfig = doc.getAuthnSelectionConfig();
        this.lastModifiedMillis = asConfig.getLastModifiedMillis();
        this.enableIdpAuthnSelection = asConfig.getEnableAuthnSelection();
        this.enableSpAuthnSelection = asConfig.getEnableSpAuthnSelection();
        this.failIfNoSelection = asConfig.getFailIfNoSelection();
        DefaultAuthnSourcesType defaults = asConfig.getDefaultAuthnSources();
        if (defaults != null) {
            for (com.pingidentity.authnselection.xmlbinding.AuthnSourceKeyType xmlDefaultAuthnSource : defaults.getAuthnSourceKeyArray()) {
                AuthnSourceKey authnSourceKey = xmlDefaultAuthnSource.getType().equals(AuthnSourceKey.AuthnSourceType.ADAPTER.name()) ? new AdapterAuthnSourceKey(xmlDefaultAuthnSource.getStringValue()) : new IdpConnAuthnSourceKey(xmlDefaultAuthnSource.getStringValue());
                this.defaultAuthnSourceKeys.add(authnSourceKey);
            }
        }
        AuthnSelectionTreesType xmlAsts = asConfig.getAuthnSelectionTrees();
        for (AuthnSelectionTreeType xmlAst : xmlAsts.getAuthnSelectionTreeArray()) {
            AuthnSelectionTree ast = this.parseTreeFromDoc(xmlAst);
            if (ast == null) continue;
            this.authnSelectionTrees.add(ast);
        }
    }

    private void doLoadLegacyConfig() {
        int i;
        this.legacyFileLoaded = true;
        AdapterSelectorConfigDocument doc = (AdapterSelectorConfigDocument)this.xmlLoader.load(this.directory, LEGACY_FILENAME);
        AdapterSelectorConfigDocument.AdapterSelectorConfig adapterSelectorConfig = doc.getAdapterSelectorConfig();
        this.enableIdpAuthnSelection = adapterSelectorConfig.getEnableAdapterSelection();
        this.enableSpAuthnSelection = false;
        this.failIfNoSelection = adapterSelectorConfig.getFailIfNoSelection();
        AdapterSelectorDefaultIds defaults = doc.getAdapterSelectorConfig().getDefaultAdapterIds();
        if (defaults != null) {
            for (i = 0; i < defaults.getAdapterIdArray().length; ++i) {
                AuthnSourceKeyType xmlDefaultAuthnSource = defaults.getAdapterIdArray(i);
                AuthnSourceKey authnSourceKey = xmlDefaultAuthnSource.getType().equals(AuthnSourceKey.AuthnSourceType.ADAPTER.name()) ? new AdapterAuthnSourceKey(xmlDefaultAuthnSource.getStringValue()) : new IdpConnAuthnSourceKey(xmlDefaultAuthnSource.getStringValue());
                this.defaultAuthnSourceKeys.add(authnSourceKey);
            }
        }
        for (i = 0; i < adapterSelectorConfig.getAdapterSelectorMappingArray().length; ++i) {
            AdapterSelectorMappingType rootMapping = adapterSelectorConfig.getAdapterSelectorMappingArray()[i];
            this.authnSelectionTrees.add(new AuthnSelectionTree(this.buildAuthnSelectionActionNode(rootMapping, null)));
        }
    }

    private Tree.Node<AuthnSelectionAction> buildAuthnSelectionActionNode(AdapterSelectorMappingType adapterSelectorMappingType, String context) {
        String authnSelectorId = adapterSelectorMappingType.getAdapterSelectorId();
        AuthnSelectorAction authnSelectorAction = new AuthnSelectorAction(authnSelectorId);
        authnSelectorAction.setContext(context);
        Tree.Node selectorNode = new Tree.Node((Object)authnSelectorAction);
        for (AdapterSelectorContextMapType adapterSelectorContextMapType : adapterSelectorMappingType.getAdapterSelectorContextMapArray()) {
            AuthnSelectionAction childAction;
            String childContext;
            AuthnSourceKey authnSourceKey = StringUtils.isBlank((String)adapterSelectorContextMapType.getAdapterId()) ? null : (adapterSelectorContextMapType.getType().equals(AuthnSourceKey.AuthnSourceType.ADAPTER.name()) ? new AdapterAuthnSourceKey(adapterSelectorContextMapType.getAdapterId()) : new IdpConnAuthnSourceKey(adapterSelectorContextMapType.getAdapterId()));
            if (adapterSelectorContextMapType.getNextSelector() != null) {
                childContext = adapterSelectorContextMapType.getContext();
                selectorNode.addChildNode(this.buildAuthnSelectionActionNode(adapterSelectorContextMapType.getNextSelector(), childContext));
                continue;
            }
            childContext = adapterSelectorContextMapType.getContext();
            if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER && authnSourceKey.getId().equals(LEGACY_NONE)) {
                childAction = new NoOpAction(NoOpAction.Type.CONTINUE);
                childAction.setContext(childContext);
                selectorNode.addChildData((Object)childAction);
                continue;
            }
            childAction = new AuthnSourceAction(authnSourceKey);
            childAction.setContext(childContext);
            Tree.Node childNode = selectorNode.addChildData((Object)childAction);
            NoOpAction successDone = new NoOpAction(NoOpAction.Type.DONE);
            NoOpAction failDone = new NoOpAction(NoOpAction.Type.DONE);
            successDone.setContext("Success");
            failDone.setContext("Fail");
            childNode.addChildData((Object)failDone);
            childNode.addChildData((Object)successDone);
        }
        return selectorNode;
    }

    private synchronized void save() {
        AuthnSelectionConfigDocument doc = AuthnSelectionConfigDocument.Factory.newInstance();
        AuthnSelectionConfigType authnSelectorConfigType = doc.addNewAuthnSelectionConfig();
        this.lastModifiedMillis = System.currentTimeMillis();
        authnSelectorConfigType.setLastModifiedMillis(this.lastModifiedMillis);
        authnSelectorConfigType.setEnableAuthnSelection(this.enableIdpAuthnSelection);
        authnSelectorConfigType.setEnableSpAuthnSelection(this.enableSpAuthnSelection);
        authnSelectorConfigType.setFailIfNoSelection(this.failIfNoSelection);
        AuthnSelectionTreesType xmlAsts = authnSelectorConfigType.addNewAuthnSelectionTrees();
        for (AuthnSelectionTree authnSelectionTree : this.authnSelectionTrees) {
            AuthnSelectionTreeType xmlAst = xmlAsts.addNewAuthnSelectionTree();
            this.convertTreeToXml(authnSelectionTree, xmlAst);
        }
        DefaultAuthnSourcesType xmlDefaultAuthnSources = authnSelectorConfigType.addNewDefaultAuthnSources();
        for (AuthnSourceKey authnSourceKey : this.defaultAuthnSourceKeys) {
            com.pingidentity.authnselection.xmlbinding.AuthnSourceKeyType xmlAuthnSourceKey = xmlDefaultAuthnSources.addNewAuthnSourceKey();
            xmlAuthnSourceKey.setStringValue(authnSourceKey.getId());
            xmlAuthnSourceKey.setType(authnSourceKey.getType().name());
        }
        this.xmlLoader.save(this.directory, FILENAME, (XmlObject)doc);
        if (this.legacyFileLoaded) {
            this.xmlLoader.delete(this.directory, LEGACY_FILENAME);
            this.legacyFileLoaded = false;
        }
    }

    @Override
    public synchronized long getLastModifiedMillis() {
        return this.lastModifiedMillis;
    }

    @Override
    public synchronized List<AuthnSelectionTree> getAuthnSelectionTrees() {
        return Collections.unmodifiableList(this.authnSelectionTrees);
    }

    @Override
    public synchronized AuthnSelectionTree getAuthnSelectionTreeById(String policyId) {
        return this.getAuthnSelectionTrees().stream().filter(authnPolicy -> authnPolicy.isIdMatch(policyId, false)).findFirst().orElse(null);
    }

    @Override
    public synchronized void setAuthnSelectionTrees(List<AuthnSelectionTree> trees) {
        this.authnSelectionTrees.clear();
        this.authnSelectionTrees.addAll(trees);
        this.saveAndRebuildCache();
    }

    @Override
    public synchronized void createAuthnSelectionTree(AuthnSelectionTree authnSelectionTree) throws PolicyManagerException {
        if (authnSelectionTree != null) {
            PolicyManagerException policyManagerException = new PolicyManagerException();
            this.validatePolicyIdUniqueness(authnSelectionTree, policyManagerException);
            this.validatePolicyNameUniqueness(authnSelectionTree, policyManagerException, false);
            if (policyManagerException.hasExceptions()) {
                throw policyManagerException;
            }
            this.authnSelectionTrees.add(authnSelectionTree);
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                this.saveAndRebuildCache();
                auditLoggerScope.log(AdminAuditLogger.Component.AUTH_SELECTION_POLICY, AdminAuditLogger.Event.CREATE);
            }
        }
    }

    @Override
    public synchronized void updateAuthnSelectionTree(AuthnSelectionTree authnSelectionTree) throws PolicyManagerException, PolicyIdNotFoundException {
        if (authnSelectionTree != null) {
            PolicyManagerException policyManagerException = new PolicyManagerException();
            this.validatePolicyNameUniqueness(authnSelectionTree, policyManagerException, true);
            if (policyManagerException.hasExceptions()) {
                throw policyManagerException;
            }
            boolean foundMatchingPolicy = false;
            for (int matchingIndex = 0; matchingIndex < this.authnSelectionTrees.size(); ++matchingIndex) {
                AuthnSelectionTree tree = this.authnSelectionTrees.get(matchingIndex);
                if (!tree.isIdMatch(authnSelectionTree.getId(), false)) continue;
                foundMatchingPolicy = true;
                authnSelectionTree.setId(tree.getId());
                this.authnSelectionTrees.set(matchingIndex, authnSelectionTree);
                break;
            }
            if (foundMatchingPolicy) {
                try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                    this.saveAndRebuildCache();
                    auditLoggerScope.log(AdminAuditLogger.Component.AUTH_SELECTION_POLICY, AdminAuditLogger.Event.MODIFY);
                }
            } else {
                throw new PolicyIdNotFoundException(authnSelectionTree.getId());
            }
        }
    }

    synchronized void validatePolicyIdUniqueness(AuthnSelectionTree authnSelectionTree, PolicyManagerException policyManagerException) {
        boolean hasDuplicatePolicyId = this.authnSelectionTrees.stream().anyMatch(tree -> tree.isIdMatch(authnSelectionTree.getId(), false));
        if (hasDuplicatePolicyId) {
            policyManagerException.addException(new PolicyIdUniquenessException(authnSelectionTree.getId()));
        }
    }

    synchronized void validatePolicyNameUniqueness(AuthnSelectionTree authnSelectionTree, PolicyManagerException policyManagerException, boolean isUpdate) {
        boolean hasDuplicatePolicyName = isUpdate ? this.authnSelectionTrees.stream().filter(tree -> StringUtils.equals((String)tree.getName(), (String)authnSelectionTree.getName())).anyMatch(tree -> !tree.isIdMatch(authnSelectionTree.getId(), true)) : this.authnSelectionTrees.stream().anyMatch(tree -> StringUtils.equals((String)tree.getName(), (String)authnSelectionTree.getName()));
        if (hasDuplicatePolicyName) {
            policyManagerException.addException(new PolicyNameUniquenessException(authnSelectionTree.getName()));
        }
    }

    @Override
    public synchronized boolean removeAuthnSelectionTree(String id) {
        boolean foundMatchingPolicy = false;
        for (int matchingIndex = 0; matchingIndex < this.authnSelectionTrees.size(); ++matchingIndex) {
            AuthnSelectionTree tree = this.authnSelectionTrees.get(matchingIndex);
            if (!tree.isIdMatch(id, false)) continue;
            foundMatchingPolicy = true;
            this.authnSelectionTrees.remove(matchingIndex);
            break;
        }
        if (foundMatchingPolicy) {
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                this.saveAndRebuildCache();
                auditLoggerScope.log(AdminAuditLogger.Component.AUTH_SELECTION_POLICY, AdminAuditLogger.Event.DELETE);
            }
        }
        return foundMatchingPolicy;
    }

    synchronized void saveAndRebuildCache() {
        this.resetMaps();
        this.save();
        this.rebuildTreeCache();
    }

    @Override
    public boolean isFailIfNoSelection() {
        return this.failIfNoSelection;
    }

    @Override
    public synchronized void setFailIfNoSelection(boolean failIfNoSelection) {
        this.failIfNoSelection = failIfNoSelection;
        this.save();
    }

    @Override
    public boolean isAuthnSourceInUse(AuthnSourceKey authnSourceKey) {
        AuthnSourceKeyVisitor authnSourceKeyVisitor = new AuthnSourceKeyVisitor(authnSourceKey);
        for (AuthnSelectionTree authnSelectionTree : this.authnSelectionTrees) {
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)authnSelectionTree, (TraversalVisitor)authnSourceKeyVisitor);
            if (!authnSourceKeyVisitor.isMatch()) continue;
            return true;
        }
        for (AuthnSourceKey defaultAuthnSourceKey : this.defaultAuthnSourceKeys) {
            if (!defaultAuthnSourceKey.equals(authnSourceKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<AuthnSelectionTree> getAuthnSelectionTreesUsingAuthnSource(AuthnSourceKey authnSourceKey) {
        LinkedList<AuthnSelectionTree> treesInUse = new LinkedList<AuthnSelectionTree>();
        for (AuthnSelectionTree authnSelectionTree : this.authnSelectionTrees) {
            AuthnSourceKeyVisitor authnSourceKeyVisitor = new AuthnSourceKeyVisitor(authnSourceKey);
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)authnSelectionTree, (TraversalVisitor)authnSourceKeyVisitor);
            if (!authnSourceKeyVisitor.isMatch()) continue;
            treesInUse.add(authnSelectionTree);
        }
        return treesInUse;
    }

    @Override
    public boolean isFragmentInUse(String fragmentId) {
        for (AuthnSelectionTree authnSelectionTree : this.authnSelectionTrees) {
            FragmentSourceKeyVisitor fragmentSourceKeyVisitor = new FragmentSourceKeyVisitor(fragmentId);
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)authnSelectionTree, (TraversalVisitor)fragmentSourceKeyVisitor);
            if (!fragmentSourceKeyVisitor.isMatch()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<AuthnSelectionTree> getAuthnSelectionTreesUsingFragment(String fragmentId) {
        LinkedList<AuthnSelectionTree> treesInUse = new LinkedList<AuthnSelectionTree>();
        for (AuthnSelectionTree authnSelectionTree : this.authnSelectionTrees) {
            FragmentSourceKeyVisitor fragmentSourceKeyVisitor = new FragmentSourceKeyVisitor(fragmentId);
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)authnSelectionTree, (TraversalVisitor)fragmentSourceKeyVisitor);
            if (!fragmentSourceKeyVisitor.isMatch()) continue;
            treesInUse.add(authnSelectionTree);
        }
        return treesInUse;
    }

    @Override
    public boolean isPolicyContractInUse(String apcId) {
        return this.apcId2ApcPaths.containsKey(apcId);
    }

    @Override
    public boolean isLocalIdentityProfileInUse(String lipId) {
        return this.lipId2LipPaths.containsKey(lipId);
    }

    @Override
    public List<AuthnSelectionTree> getAuthnSelectionTreesUsingPolicyContract(String contractId) {
        LinkedList<AuthnSelectionTree> treesInUse = new LinkedList<AuthnSelectionTree>();
        List<LinkedList<Tree.Node<AuthnSelectionAction>>> paths = this.getAuthnSelectionApcPaths(contractId);
        if (paths == null) {
            return treesInUse;
        }
        HashSet<Tree.Node<AuthnSelectionAction>> rootNodesInUse = new HashSet<Tree.Node<AuthnSelectionAction>>();
        for (LinkedList<Tree.Node<AuthnSelectionAction>> apcPath : paths) {
            if (apcPath.isEmpty()) continue;
            rootNodesInUse.add(apcPath.getFirst());
        }
        if (rootNodesInUse.isEmpty()) {
            return treesInUse;
        }
        for (AuthnSelectionTree authnSelectionTree : this.authnSelectionTrees) {
            if (!rootNodesInUse.contains(authnSelectionTree.getRootNode())) continue;
            treesInUse.add(authnSelectionTree);
        }
        return treesInUse;
    }

    @Override
    public List<AuthnSelectionTree> getAuthnSelectionTreesUsingLocalIdentity(String localIdentityId) {
        LinkedList<AuthnSelectionTree> treesInUse = new LinkedList<AuthnSelectionTree>();
        List<LinkedList<Tree.Node<AuthnSelectionAction>>> paths = this.getAuthnSelectionLipPaths(localIdentityId);
        if (paths == null) {
            return treesInUse;
        }
        HashSet<Tree.Node<AuthnSelectionAction>> rootNodesInUse = new HashSet<Tree.Node<AuthnSelectionAction>>();
        for (LinkedList<Tree.Node<AuthnSelectionAction>> lipPath : paths) {
            if (lipPath.isEmpty()) continue;
            rootNodesInUse.add(lipPath.getFirst());
        }
        if (rootNodesInUse.isEmpty()) {
            return treesInUse;
        }
        for (AuthnSelectionTree authnSelectionTree : this.authnSelectionTrees) {
            if (!rootNodesInUse.contains(authnSelectionTree.getRootNode())) continue;
            treesInUse.add(authnSelectionTree);
        }
        return treesInUse;
    }

    private List<LinkedList<Tree.Node<AuthnSelectionAction>>> getAuthnSelectionLipPaths(String localIdentityId) {
        List lipPaths = this.lipId2LipPaths.get(localIdentityId);
        return lipPaths == null ? null : Collections.unmodifiableList(lipPaths);
    }

    @Override
    public boolean isAuthnSelectorInUse(String authnSelectorId) {
        AuthnSelectorVisitor authnSelectorVisitor = new AuthnSelectorVisitor(authnSelectorId);
        for (AuthnSelectionTree authnSelectionTree : this.authnSelectionTrees) {
            PreOrderTraversal traversal = new PreOrderTraversal();
            traversal.traverse((Tree)authnSelectionTree, (TraversalVisitor)authnSelectorVisitor);
            if (!authnSelectorVisitor.isMatch()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void setDefaultAuthnSourceKeys(List<AuthnSourceKey> defaultAuthnSourceKeys) {
        this.defaultAuthnSourceKeys = defaultAuthnSourceKeys;
        this.save();
    }

    @Override
    public List<LinkedList<Tree.Node<AuthnSelectionAction>>> getAuthnSelectionApcPaths(String apcId) {
        LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>> paths = this.apcId2ApcPaths.get(apcId);
        if (paths == null) {
            return null;
        }
        return Collections.unmodifiableList(paths);
    }

    @Override
    public List<LinkedList<Tree.Node<AuthnSelectionAction>>> getAuthnSelectionTerminatingFragmentPaths(String apcId) {
        LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>> paths = this.apcId2FragmentPaths.get(apcId);
        if (paths == null) {
            return null;
        }
        return Collections.unmodifiableList(paths);
    }

    @Override
    public Set<String> getAuthnSelectionApcIds() {
        HashSet<String> apcIds = new HashSet<String>(this.apcId2ApcPaths.keySet());
        return apcIds;
    }

    @Override
    public List<LinkedList<Tree.Node<AuthnSelectionAction>>> getAuthnSelectionAuthnSourcePaths(AuthnSourceKey authnSourceKey) {
        LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>> paths = this.authnSourceKey2ApcPaths.get(authnSourceKey);
        if (paths == null) {
            return null;
        }
        return Collections.unmodifiableList(paths);
    }

    @Override
    public List<LinkedList<Tree.Node<AuthnSelectionAction>>> getAuthnSelectionContinuePaths(AuthnSelectionTree tree) {
        LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>> paths = this.tree2ContinuePaths.get((Object)tree);
        if (paths == null) {
            return null;
        }
        return Collections.unmodifiableList(paths);
    }

    @Override
    public List<LinkedList<Tree.Node<AuthnSelectionAction>>> getAuthnSelectionRestartPaths(AuthnSelectionTree tree) {
        LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>> paths = this.tree2RestartPaths.get((Object)tree);
        if (paths == null) {
            return null;
        }
        return Collections.unmodifiableList(paths);
    }

    @Override
    public List<LinkedList<Tree.Node<AuthnSelectionAction>>> getAuthnSelectionDonePathsEndingWithAuthnSelectors(AuthnSelectionTree tree) {
        LinkedList<LinkedList<Tree.Node<AuthnSelectionAction>>> paths = this.tree2AuthnSelectorPaths.get((Object)tree);
        if (paths == null) {
            return null;
        }
        return Collections.unmodifiableList(paths);
    }

    @Override
    public synchronized void moveAuthnSelectionTreeToStart(String policyId) throws PolicyMoveException {
        if (this.authnSelectionTrees.size() > 1) {
            this.movePolicyWithIdToIndex(policyId, 0, false);
        }
    }

    @Override
    public synchronized void moveAuthnSelectionTreeToEnd(String policyId) throws PolicyMoveException {
        if (this.authnSelectionTrees.size() > 1) {
            this.movePolicyWithIdToIndex(policyId, this.authnSelectionTrees.size() - 1, true);
        }
    }

    @Override
    public synchronized void moveAuthnSelectionTree(String policyId, String targetPositionPolicyId, boolean isMoveAfter) throws PolicyMoveException {
        int moveToPolicyIndex = -1;
        ListIterator<AuthnSelectionTree> listIter = this.authnSelectionTrees.listIterator();
        while (listIter.hasNext()) {
            int currIndex = listIter.nextIndex();
            AuthnSelectionTree currPolicy = listIter.next();
            if (!currPolicy.isIdMatch(targetPositionPolicyId, false)) continue;
            moveToPolicyIndex = currIndex;
            break;
        }
        if (moveToPolicyIndex == -1) {
            throw new PolicyMoveToIdException("Could not find the target position policy with ID '" + targetPositionPolicyId + "' within the policy tree.", policyId, targetPositionPolicyId);
        }
        this.movePolicyWithIdToIndex(policyId, moveToPolicyIndex, isMoveAfter);
    }

    synchronized void movePolicyWithIdToIndex(String policyId, int targetPositionIndex, boolean isMoveAfter) throws PolicyMoveException {
        try {
            this.authnSelectionTrees.get(targetPositionIndex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new PolicyMoveToIndexException("Could not find the policy at index '" + targetPositionIndex + "' within the policy tree.", policyId, targetPositionIndex);
        }
        AuthnSelectionTree policyToMove = null;
        ListIterator<AuthnSelectionTree> listIter = this.authnSelectionTrees.listIterator();
        while (listIter.hasNext()) {
            int currIndex = listIter.nextIndex();
            AuthnSelectionTree currPolicy = listIter.next();
            if (!currPolicy.isIdMatch(policyId, false)) continue;
            if (currIndex == targetPositionIndex) {
                return;
            }
            policyToMove = currPolicy;
            listIter.remove();
            if (currIndex >= targetPositionIndex) break;
            --targetPositionIndex;
            break;
        }
        if (policyToMove == null) {
            throw new PolicyMoveException("Could not find the policy with ID '" + policyId + "'.", policyId);
        }
        if (isMoveAfter) {
            this.authnSelectionTrees.add(++targetPositionIndex, policyToMove);
        } else {
            this.authnSelectionTrees.add(targetPositionIndex, policyToMove);
        }
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.saveAndRebuildCache();
            auditLoggerScope.log(AdminAuditLogger.Component.AUTH_SELECTION_POLICY, AdminAuditLogger.Event.MODIFY);
        }
    }
}

