/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.ConfigEventType;
import com.pingidentity.configservice.ListenerRegistry;
import com.pingidentity.configservice.Reloadable;
import com.pingidentity.sdk.AdapterSelector;
import com.pingidentity.sdk.AdapterSelectorContext;
import com.pingidentity.sdk.AuthenticationSelector;
import com.pingidentity.sdk.AuthenticationSelectorContext;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.AuthnSelectorManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AuthnSelectorManagementSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.util.domain.Searchable;
import org.sourceid.util.domain.filter.ContainsCriteriaFilter;
import org.sourceid.util.domain.filter.ItemMultiValue;

public class AuthnSelectorManagerImpl
implements AuthnSelectorManager,
AutoReloadable {
    private static final Comparator<AuthnSelectorInstance> COMPARE_BY_NAME_DOWN = (selector1, selector2) -> selector1.getName().compareToIgnoreCase(selector2.getName());
    private final AuthnSelectorManagementSupport pluginMgmtSupport = new AuthnSelectorManagementSupport();

    public AuthnSelectorManagerImpl() {
        this.pluginMgmtSupport.setPluginInstanceFactory(new PluginManagementSupport.PluginInstanceFactory(){

            @Override
            public ConfigurablePluginInstance constructPluginInstance() {
                return new AuthnSelectorInstance();
            }
        });
    }

    public void finishInit() {
        this.pluginMgmtSupport.loadInstanceCaches();
        this.pluginMgmtSupport.earlyLoadConfigurations();
    }

    @Override
    public void registerForReloadEvents(Reloadable reloadable) {
        MgmtFactory.getMediator().registerForReloadEvents(reloadable);
        ListenerRegistry.getInstance().addListener(ConfigEventType.AUTHN_SELECTORS_RELOADED, reloadable, r -> r.reload());
    }

    @Override
    public void reload() {
        this.pluginMgmtSupport.clearInstanceCaches();
        ListenerRegistry.getInstance().notifyListeners(ConfigEventType.AUTHN_SELECTORS_RELOADED);
    }

    @Override
    public Collection<PluginDescriptor> getInstalledDescriptors() {
        Collection<PluginDescriptor> descriptors = this.pluginMgmtSupport.getInstalledPluginDescriptors();
        return descriptors;
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.pluginMgmtSupport.isDuplicateInstanceId(instanceId);
    }

    @Override
    public Collection<AuthnSelectorInstance> getInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getPluginInstances();
        return instances;
    }

    @Override
    public AuthnSelectorInstance getInstance(String instanceId) {
        return (AuthnSelectorInstance)this.pluginMgmtSupport.getPluginInstance(instanceId);
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.savePluginInstance(instance);
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.deletePluginInstance(instance);
    }

    @Override
    public AuthnSelectorInstance newInstance() {
        return new AuthnSelectorInstance();
    }

    @Override
    public void loadConfigurations() {
        this.pluginMgmtSupport.loadConfigurations();
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return false;
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        return false;
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        return false;
    }

    @Override
    public AuthenticationSelector getAuthenticationSelector(String instanceId) {
        ConfigurablePlugin confPlugin = this.pluginMgmtSupport.getPlugin(instanceId);
        if (confPlugin instanceof AdapterSelector) {
            return new LegacyAdapterSelectorWrapper((AdapterSelector)confPlugin);
        }
        return (AuthenticationSelector)confPlugin;
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return false;
    }

    @Override
    public boolean supportsDefaultInstance() {
        return false;
    }

    @Override
    public AuthnSelectorInstance getDefaultInstance() {
        return null;
    }

    @Override
    public void setDefaultInstance(String pluginId) {
    }

    @Override
    public Collection<AuthnSelectorInstance> searchAuthenticationSelectors(Integer page, Integer numberPerPage, String filter) {
        SearchCriteria searchCriteria;
        Searchable<AuthnSelectorInstance> searchable = new Searchable<AuthnSelectorInstance>(){

            @Override
            public SearchResult<AuthnSelectorInstance> search(SearchCriteria searchCriteria) {
                ContainsCriteriaFilter<AuthnSelectorInstance> filter = new ContainsCriteriaFilter<AuthnSelectorInstance>(c -> new ItemMultiValue<AuthnSelectorInstance, String>((AuthnSelectorInstance)c, (K[])new String[]{c.getId(), c.getName()}));
                Collection searchResults = filter.doFilter(searchCriteria.getQuery(), AuthnSelectorManagerImpl.this.getInstances().parallelStream().collect(Collectors.toList()));
                if (searchCriteria.getStartIndex() >= searchResults.size()) {
                    return new SearchResult<AuthnSelectorInstance>(searchCriteria.getStartIndex(), Collections.emptyList());
                }
                searchResults = searchResults.parallelStream().sorted(COMPARE_BY_NAME_DOWN).collect(Collectors.toList());
                if (searchCriteria.getItemsRequested() == -1) {
                    return new SearchResult<AuthnSelectorInstance>(0, new ArrayList(searchResults));
                }
                int fromIndex = searchCriteria.getStartIndex();
                int toIndex = searchCriteria.getStartIndex() + searchCriteria.getItemsRequested() >= searchResults.size() ? searchResults.size() : searchCriteria.getStartIndex() + searchCriteria.getItemsRequested();
                return new SearchResult<AuthnSelectorInstance>(searchCriteria.getStartIndex(), new ArrayList(searchResults).subList(fromIndex, toIndex));
            }
        };
        if (page == null) {
            searchCriteria = new SearchCriteria.Builder().query(filter).build();
        } else {
            int fromIndex = (page - 1) * numberPerPage;
            searchCriteria = new SearchCriteria.Builder(fromIndex, numberPerPage).query(filter).build();
        }
        SearchResult selectorsSearchResult = searchable.search(searchCriteria);
        return selectorsSearchResult.getResults();
    }

    @Override
    public Collection<AuthnSelectorInstance> getVirtualInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getVirtualPlugins();
        return instances;
    }

    @Override
    public Collection<AuthnSelectorInstance> getSelectorsUsingAuthnSource(AuthnSourceKey sourceKey) {
        return InUseDetectionUtil.getInstance().getPluginInstancesUsingAuthnSource(this.getInstances(), sourceKey);
    }

    @Override
    public boolean isAuthnSourceInUse(AuthnSourceKey sourceKey) {
        return !this.getSelectorsUsingAuthnSource(sourceKey).isEmpty();
    }

    @Override
    public <T> Collection<T> getSelectorsOfType(Class<T> type) {
        return this.pluginMgmtSupport.getPluginsOfType(type);
    }

    private static class LegacyAdapterSelectorWrapper
    implements AuthenticationSelector {
        private final AdapterSelector delegate;

        public LegacyAdapterSelectorWrapper(AdapterSelector delegate) {
            this.delegate = delegate;
        }

        public void configure(Configuration configuration) {
            this.delegate.configure(configuration);
        }

        public PluginDescriptor getPluginDescriptor() {
            return this.delegate.getPluginDescriptor();
        }

        public AuthenticationSelectorContext selectContext(HttpServletRequest req, HttpServletResponse resp, Map<AuthenticationSourceKey, String> mappedAuthnSourcesNames, Map<String, Object> extraParameters, String resumePath) {
            HashMap<String, String> adapterIdToName = new HashMap<String, String>();
            for (Map.Entry<AuthenticationSourceKey, String> keyNameEntry : mappedAuthnSourcesNames.entrySet()) {
                AuthenticationSourceKey sourceKey = keyNameEntry.getKey();
                if (sourceKey.getType() != AuthenticationSourceKey.Type.IDP_ADAPTER) continue;
                adapterIdToName.put(keyNameEntry.getKey().getId(), keyNameEntry.getValue());
            }
            AdapterSelectorContext adapterSelectorContext = this.delegate.selectContext(req, resp, adapterIdToName, extraParameters, resumePath);
            return this.toAuthnSelectorContext(adapterSelectorContext);
        }

        public void callback(HttpServletRequest req, HttpServletResponse resp, Map authnIdentifiers, AuthenticationSourceKey authenticationSourceKey, AuthenticationSelectorContext authnSelectorContext) {
            if (authenticationSourceKey.getType() == AuthenticationSourceKey.Type.IDP_ADAPTER) {
                this.delegate.callback(req, resp, authnIdentifiers, authenticationSourceKey.getId(), this.toAdapterSelectorContext(authnSelectorContext));
            }
        }

        private AuthenticationSelectorContext toAuthnSelectorContext(AdapterSelectorContext adapterSelectorContext) {
            AuthenticationSelectorContext authnSelectorContext = new AuthenticationSelectorContext();
            authnSelectorContext.setResult(adapterSelectorContext.getResult());
            authnSelectorContext.setResultType(AuthenticationSelectorContext.ResultType.valueOf((String)adapterSelectorContext.getResultType().name()));
            return authnSelectorContext;
        }

        private AdapterSelectorContext toAdapterSelectorContext(AuthenticationSelectorContext authnSelectorContext) {
            AdapterSelectorContext adapterSelectorContext = new AdapterSelectorContext();
            adapterSelectorContext.setResult(authnSelectorContext.getResult());
            adapterSelectorContext.setResultType(AdapterSelectorContext.ResultType.valueOf((String)authnSelectorContext.getResultType().name()));
            return adapterSelectorContext;
        }
    }
}

