/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.impl.JaxbXmlLoader;
import com.pingidentity.jdbc.WarningsForHsqlDb;
import com.pingidentity.pingcommons.crypto.IDGenerator;
import com.pingidentity.sdk.DeviceSharingType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.ApplicationSessionPolicy;
import org.sourceid.saml20.domain.AuthnSessionPolicy;
import org.sourceid.saml20.domain.AuthnSessionSettings;
import org.sourceid.saml20.domain.GlobalAuthnSessionPolicy;
import org.sourceid.saml20.domain.UserDeviceType;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.AuthnSessionPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.sessions.QuotaPolicy;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.xml.sax.SAXException;

public class AuthnSessionPolicyManagerImpl
implements AuthnSessionPolicyManager,
AutoReloadable {
    private static final String AUTHN_SOURCE_SESSION_POLICIES_FILE = "authn-session-policies.xml";
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.domain.mgmt.impl.AuthnSessionPolicyManagerImpl");
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private ApplicationSessionPolicy applicationPolicy = new ApplicationSessionPolicy();
    private GlobalAuthnSessionPolicy globalPolicy = new GlobalAuthnSessionPolicy();
    private QuotaPolicy quotaPolicy = new QuotaPolicy();
    private final Map<AuthnSourceKey, List<AuthnSessionPolicy>> policiesBySourceKey = new LinkedHashMap<AuthnSourceKey, List<AuthnSessionPolicy>>();
    private final Map<String, AuthnSessionPolicy> policiesById = new HashMap<String, AuthnSessionPolicy>();
    private Optional<Boolean> anyStoredSessionEnabled = Optional.empty();

    public AuthnSessionPolicyManagerImpl() {
        this.loadConfig();
    }

    @Override
    public synchronized boolean hasAuthnSessionConfig() {
        return this.globalPolicy.isEnableSessions() || !this.policiesById.isEmpty();
    }

    @Override
    public synchronized boolean isAnyStoredSessionEnabled() {
        if (this.anyStoredSessionEnabled.isPresent()) {
            return this.anyStoredSessionEnabled.get();
        }
        this.anyStoredSessionEnabled = Optional.of(false);
        if (this.globalPolicy.isEnableSessions() && this.globalPolicy.isPersistentSessions()) {
            this.anyStoredSessionEnabled = Optional.of(true);
        } else {
            for (AuthnSessionPolicy policy : this.policiesById.values()) {
                if (!policy.isEnableSessions() || !policy.isPersistent()) continue;
                this.anyStoredSessionEnabled = Optional.of(true);
            }
        }
        return this.anyStoredSessionEnabled.get();
    }

    @Override
    public synchronized ApplicationSessionPolicy getApplicationPolicy() {
        return new ApplicationSessionPolicy(this.applicationPolicy);
    }

    @Override
    public synchronized void saveApplicationPolicy(ApplicationSessionPolicy appSessionPolicy) {
        this.applicationPolicy = appSessionPolicy;
        this.saveConfig("Application sessions");
    }

    @Override
    public synchronized GlobalAuthnSessionPolicy getGlobalPolicy() {
        return new GlobalAuthnSessionPolicy(this.globalPolicy);
    }

    @Override
    public synchronized void saveGlobalPolicy(GlobalAuthnSessionPolicy settings) {
        this.globalPolicy = new GlobalAuthnSessionPolicy(settings);
        if (!this.globalPolicy.isEnableSessions()) {
            this.globalPolicy.setPersistentSessions(false);
        }
        this.saveConfig("Authentication sessions");
    }

    @Override
    public synchronized QuotaPolicy getQuotaPolicy() {
        return new QuotaPolicy(this.quotaPolicy);
    }

    @Override
    public synchronized void saveQuotaPolicy(QuotaPolicy quotaPolicy) {
        this.quotaPolicy = new QuotaPolicy(quotaPolicy);
        this.saveConfig("Session Quotas");
    }

    @Override
    public synchronized int getTimeoutCapDays() {
        return this.configStore.getIntValue("TimeoutCapDays", 1095);
    }

    @Override
    public synchronized int getTimeoutCapMins() {
        return this.getTimeoutCapDays() * 24 * 60;
    }

    @Override
    public synchronized Collection<AuthnSessionPolicy> getEnabledSourcePolicies() {
        ArrayList<AuthnSessionPolicy> result = new ArrayList<AuthnSessionPolicy>();
        for (List<AuthnSessionPolicy> policies : this.policiesBySourceKey.values()) {
            for (AuthnSessionPolicy policy : policies) {
                switch (policy.getAuthnSourceType()) {
                    case ADAPTER: {
                        if (!MetadataLocalHelper.isEnableIdp(this.localMetaData)) break;
                        result.add(policy);
                        break;
                    }
                    case IDP_CONN: {
                        if (!MetadataLocalHelper.isEnableSp(this.localMetaData)) break;
                        result.add(policy);
                        break;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public synchronized AuthnSessionPolicy getSourcePolicyById(String id) {
        return this.policiesById.get(id);
    }

    @Override
    public synchronized List<AuthnSessionPolicy> getSourcePoliciesBySourceKey(AuthnSourceKey source) {
        return this.policiesBySourceKey.get(source);
    }

    @Override
    public AuthnSessionPolicy getSourcePolicyBySourceKeyAndDeviceType(AuthnSourceKey source, DeviceSharingType deviceSharingType) {
        List<AuthnSessionPolicy> policies = this.policiesBySourceKey.get(source);
        if (CollectionUtils.isNotEmpty(policies)) {
            for (AuthnSessionPolicy policy : policies) {
                if (!policy.isEnableSessions()) {
                    return policy;
                }
                if (policy.getUserDeviceType() == null || !policy.getUserDeviceType().matches(deviceSharingType)) continue;
                return policy;
            }
        }
        return null;
    }

    @Override
    public synchronized List<AuthnSessionSettings> getEffectiveSettings(AuthnSourceKey source) {
        ArrayList<AuthnSessionSettings> settingsList = new ArrayList<AuthnSessionSettings>();
        AuthnSessionSettings settings = new AuthnSessionSettings(this.globalPolicy);
        List<AuthnSessionPolicy> policies = this.getSourcePoliciesBySourceKey(source);
        if (CollectionUtils.isNotEmpty(policies)) {
            for (AuthnSessionPolicy policy : policies) {
                settingsList.add(this.getAuthnSessionSettings(settings, policy));
            }
        } else {
            settingsList.add(settings);
        }
        return settingsList;
    }

    @Override
    public synchronized AuthnSessionSettings getEffectiveSettings(AuthnSourceKey source, DeviceSharingType deviceSharingType) {
        AuthnSessionSettings settings = new AuthnSessionSettings(this.globalPolicy);
        AuthnSessionPolicy policy = this.getSourcePolicyBySourceKeyAndDeviceType(source, deviceSharingType);
        if (policy != null) {
            return this.getAuthnSessionSettings(settings, policy);
        }
        List<AuthnSessionPolicy> policies = this.getSourcePoliciesBySourceKey(source);
        if (CollectionUtils.isNotEmpty(policies) || settings.isEnableSessions() && !settings.getUserDeviceType().matches(deviceSharingType)) {
            settings.setEnableSessions(false);
            return settings;
        }
        return this.getAuthnSessionSettings(settings, null);
    }

    private AuthnSessionSettings getAuthnSessionSettings(AuthnSessionSettings settings, AuthnSessionPolicy policy) {
        AuthnSessionSettings result = new AuthnSessionSettings(settings);
        if (policy != null) {
            result.setEnableSessions(policy.isEnableSessions());
            result.setPersistent(policy.isPersistent());
            if (policy.getUserDeviceType() != null) {
                result.setUserDeviceType(policy.getUserDeviceType());
            }
            if (policy.getIdleTimeoutMins() != null) {
                result.setIdleTimeoutMins(policy.getIdleTimeoutMins());
            }
            if (policy.getMaxTimeoutMins() != null) {
                result.setMaxTimeoutMins(policy.getMaxTimeoutMins());
            }
            result.setAuthnContextSensitive(policy.isAuthnContextSensitive());
        }
        if (!result.hasIdleTimeout() && result.isEnableSessions() && result.isPersistent()) {
            result.setIdleTimeoutMins(this.getTimeoutCapMins());
        }
        return result;
    }

    @Override
    public synchronized void saveSourcePolicy(AuthnSessionPolicy settings) {
        this.addSourcePolicyToMaps(settings);
        this.saveConfig("Authentication session overrides");
    }

    @Override
    public synchronized void saveAllSourcePolicies(Collection<AuthnSessionPolicy> allSettings) {
        this.policiesBySourceKey.clear();
        this.policiesById.clear();
        for (AuthnSessionPolicy settings : allSettings) {
            this.addSourcePolicyToMaps(settings);
        }
        this.saveConfig("Authentication session overrides");
    }

    @Override
    public synchronized void deleteSourcePolicyById(String id) {
        AuthnSessionPolicy removed = this.policiesById.remove(id);
        if (removed != null) {
            this.policiesBySourceKey.remove(removed.getAuthnSourceKey());
            this.saveConfig("Authentication session overrides");
        }
    }

    @Override
    public synchronized void deleteSourcePolicyBySourceKey(AuthnSourceKey source) {
        List<AuthnSessionPolicy> removedPolicies = this.policiesBySourceKey.remove(source);
        if (removedPolicies != null) {
            for (AuthnSessionPolicy removed : removedPolicies) {
                this.policiesById.remove(removed.getId());
            }
            this.saveConfig("Authentication session overrides");
        }
    }

    private synchronized void loadConfig() {
        File file = new File(this.getStorageFileName());
        if (file.exists()) {
            this.anyStoredSessionEnabled = Optional.empty();
            try {
                JaxbXmlLoader<AuthnSessionPolicies> loader = new JaxbXmlLoader<AuthnSessionPolicies>(AuthnSessionPolicies.class);
                AuthnSessionPolicies config = loader.load(MgmtFactory.getSysDirInfo().getDataDirectory(), AUTHN_SOURCE_SESSION_POLICIES_FILE);
                this.applicationPolicy = config.getApplicationPolicy();
                this.globalPolicy = config.getGlobalPolicy();
                this.quotaPolicy = config.getQuotaPolicy();
                this.policiesBySourceKey.clear();
                this.policiesById.clear();
                for (AuthnSessionPolicy settings : config.getSourcePolicies().getPolicies()) {
                    this.addSourcePolicyToMaps(settings);
                }
            }
            catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("Unexpected error deserializing config from file", e);
            }
        }
    }

    @Override
    public int getLongestStoredSessionIdleTimeoutMins() {
        int result = 0;
        GlobalAuthnSessionPolicy globalPolicy = this.getGlobalPolicy();
        if (globalPolicy.isEnableSessions() && globalPolicy.isPersistentSessions()) {
            result = this.getEffectiveIdleTimeoutMins(globalPolicy.getIdleTimeoutMins(), globalPolicy.getMaxTimeoutMins());
        }
        for (AuthnSessionPolicy policy : this.getEnabledSourcePolicies()) {
            AuthnSessionSettings settings;
            int effectiveIdleTimeoutMins;
            if (!policy.isEnableSessions() || !policy.isPersistent() || (effectiveIdleTimeoutMins = this.getEffectiveIdleTimeoutMins((settings = this.getAuthnSessionSettings(new AuthnSessionSettings(globalPolicy), policy)).getIdleTimeoutMins(), settings.getMaxTimeoutMins())) <= result) continue;
            result = effectiveIdleTimeoutMins;
        }
        return result;
    }

    private int getEffectiveIdleTimeoutMins(int idleTimeoutMins, int maxTimeoutMins) {
        if (idleTimeoutMins == -1) {
            idleTimeoutMins = this.getTimeoutCapMins();
        }
        if (maxTimeoutMins != -1 && maxTimeoutMins < idleTimeoutMins) {
            idleTimeoutMins = maxTimeoutMins;
        }
        return idleTimeoutMins;
    }

    private void addSourcePolicyToMaps(AuthnSessionPolicy settings) {
        List<AuthnSessionPolicy> filteredList;
        if (settings.getId() == null) {
            settings.setId(IDGenerator.rndAlphaNumeric((int)25));
        }
        if (!settings.isEnableSessions()) {
            settings.setPersistent(false);
        } else if (settings.getUserDeviceType() == null) {
            settings.setUserDeviceType(UserDeviceType.getDefaultUserDevice());
        }
        if (this.policiesById.get(settings.getId()) != null && CollectionUtils.isNotEmpty(filteredList = this.policiesBySourceKey.get(settings.getAuthnSourceKey()))) {
            filteredList.removeIf(sessionPolicy -> sessionPolicy.getId().equals(settings.getId()));
        }
        this.policiesBySourceKey.computeIfAbsent(settings.getAuthnSourceKey(), key -> new ArrayList()).add(settings);
        this.policiesById.put(settings.getId(), settings);
    }

    private String getStorageFileName() {
        String dataDirectory = MgmtFactory.getSysDirInfo().getDataDirectory();
        return dataDirectory + File.separator + AUTHN_SOURCE_SESSION_POLICIES_FILE;
    }

    private synchronized void saveConfig(String auditMessage) {
        this.anyStoredSessionEnabled = Optional.empty();
        AuthnSessionPolicies config = new AuthnSessionPolicies();
        config.setApplicationPolicy(this.applicationPolicy);
        config.setGlobalPolicy(this.globalPolicy);
        config.setQuotaPolicy(this.quotaPolicy);
        List<AuthnSessionPolicy> authnSessionPolicies = this.policiesBySourceKey.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        config.getSourcePolicies().setPolicies(authnSessionPolicies);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            JaxbXmlLoader<AuthnSessionPolicies> loader = new JaxbXmlLoader<AuthnSessionPolicies>(AuthnSessionPolicies.class);
            loader.save(MgmtFactory.getSysDirInfo().getDataDirectory(), AUTHN_SOURCE_SESSION_POLICIES_FILE, config);
            auditLoggerScope.log(AdminAuditLogger.Component.SESSION_POLICIES, AdminAuditLogger.Event.MODIFY, auditMessage);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unexpected error serializing config to file", e);
        }
        MgmtFactory.getSingleThreadedExecutor().execute(() -> WarningsForHsqlDb.getInstance().logWarningsForHsqlDbUse());
    }

    public static class SourcePolicies {
        private Collection<AuthnSessionPolicy> policies = new ArrayList<AuthnSessionPolicy>();

        @XmlElement(name="policy")
        public Collection<AuthnSessionPolicy> getPolicies() {
            return this.policies;
        }

        public void setPolicies(Collection<AuthnSessionPolicy> sourceSettings) {
            this.policies = sourceSettings;
        }
    }

    @XmlRootElement
    public static class AuthnSessionPolicies {
        private ApplicationSessionPolicy applicationPolicy = new ApplicationSessionPolicy();
        private GlobalAuthnSessionPolicy globalPolicy = new GlobalAuthnSessionPolicy();
        private SourcePolicies sourcePolicies = new SourcePolicies();
        private QuotaPolicy quotaPolicy = new QuotaPolicy();

        public ApplicationSessionPolicy getApplicationPolicy() {
            return this.applicationPolicy;
        }

        public void setApplicationPolicy(ApplicationSessionPolicy appPolicy) {
            this.applicationPolicy = appPolicy;
        }

        public GlobalAuthnSessionPolicy getGlobalPolicy() {
            return this.globalPolicy;
        }

        public void setGlobalPolicy(GlobalAuthnSessionPolicy globalSettings) {
            this.globalPolicy = globalSettings;
        }

        public SourcePolicies getSourcePolicies() {
            return this.sourcePolicies;
        }

        public void setSourcePolicies(SourcePolicies sourcePolicies) {
            this.sourcePolicies = sourcePolicies;
        }

        public QuotaPolicy getQuotaPolicy() {
            return this.quotaPolicy;
        }

        public void setQuotaPolicy(QuotaPolicy quotaPolicy) {
            this.quotaPolicy = quotaPolicy;
        }
    }
}

