/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.captcha.util.CaptchaProviderUtil;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import java.util.Collection;
import org.sourceid.saml20.domain.CaptchaProviderInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.CaptchaProviderPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.mgmt.impl.PluginMgmtConfigSupport;

public class CaptchaProviderPluginManagerImpl
implements CaptchaProviderPluginManager,
AutoReloadable {
    public static final String BASE_NAME = "captcha-providers";
    private final PluginManagementSupport pluginMgmtSupport = new PluginManagementSupport("captcha-providers", new PluginMgmtConfigSupport("captcha-providers"), true, AdminAuditLogger.Component.CAPTCHA_PROVIDER);

    public CaptchaProviderPluginManagerImpl(Mediator mediator) {
        this.pluginMgmtSupport.setPluginInstanceFactory(this::newInstance);
    }

    @Override
    public CaptchaProvider getCaptchaProvider(String instanceId) {
        return (CaptchaProvider)this.pluginMgmtSupport.getPlugin(instanceId);
    }

    public void finishInit() {
        this.pluginMgmtSupport.loadInstanceCaches();
        this.pluginMgmtSupport.earlyLoadConfigurations();
    }

    @Override
    public Collection<PluginDescriptor> getInstalledDescriptors() {
        return this.pluginMgmtSupport.getInstalledPluginDescriptors();
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.pluginMgmtSupport.isDuplicateInstanceId(instanceId);
    }

    @Override
    public Collection<CaptchaProviderInstance> getInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getPluginInstances();
        return instances;
    }

    @Override
    public CaptchaProviderInstance getInstance(String instanceId) {
        return (CaptchaProviderInstance)this.pluginMgmtSupport.getPluginInstance(instanceId);
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        if (instance != null) {
            CaptchaProviderInstance savingInstance = (CaptchaProviderInstance)instance;
            this.pluginMgmtSupport.savePluginInstance(savingInstance);
        }
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.pluginMgmtSupport.deletePluginInstance(instance);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return this.isPluginInUseInternally(pluginId) || this.isPluginInUseExternally(pluginId);
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        return false;
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        if (pluginId == null) {
            return false;
        }
        boolean isInUse = MgmtFactory.getIdpAdapterManager().getInstances().stream().anyMatch(adapter -> CaptchaProviderUtil.isAdapterUsingCaptchaProvider(adapter, pluginId));
        if (!isInUse) {
            isInUse = MgmtFactory.getLocalIdentityProfileManager().getProfiles().stream().anyMatch(lip -> CaptchaProviderUtil.isLipUsingCaptchaProvider(lip, pluginId));
        }
        return isInUse;
    }

    @Override
    public CaptchaProviderInstance newInstance() {
        return new CaptchaProviderInstance();
    }

    @Override
    public void loadConfigurations() {
        this.pluginMgmtSupport.loadConfigurations();
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return false;
    }

    @Override
    public boolean supportsDefaultInstance() {
        return true;
    }

    @Override
    public CaptchaProviderInstance getDefaultInstance() {
        return (CaptchaProviderInstance)this.pluginMgmtSupport.getDefaultInstance();
    }

    @Override
    public Collection<CaptchaProviderInstance> getVirtualInstances() {
        Collection<ConfigurablePluginInstance> instances = this.pluginMgmtSupport.getVirtualPlugins();
        return instances;
    }

    @Override
    public void setDefaultInstance(String pluginId) {
        this.pluginMgmtSupport.setDefaultInstance(pluginId);
    }
}

