/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;

public class CertModifiedTimeTracker {
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig("cert-time-tracking");

    public static synchronized void trackCertModifiedTime(String alias) {
        if (!configStore.getKeys().contains(alias)) {
            Instant currentTime = Instant.now();
            configStore.setLongValue(alias, currentTime.getEpochSecond());
        }
    }

    public static synchronized Calendar getCertModifiedTime(String alias) {
        try {
            long modifiedTimestamp = configStore.getLongValue(alias);
            return new XmlCalendar(new Date(1000L * modifiedTimestamp));
        }
        catch (NoSuchValueException e) {
            return null;
        }
    }

    public static synchronized void deleteCertModifiedTime(String alias) {
        configStore.clearValue(alias);
    }
}

