/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.ClusterSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ClusterSettingsManagerImpl
implements ClusterSettingsManager,
AutoReloadable {
    private static final String CONFIG_STORE_NAME = "cluster-replication-settings";
    private static final String SELECTIVE_REPL_FOR_CONNECTIONS_KEY = "EnableSelectiveReplicationForConnections";
    private static final String SELECTIVE_REPL_FOR_CLIENTS_KEY = "EnableSelectiveReplicationForClients";
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig("cluster-replication-settings");

    @Override
    public boolean isEnableSelectiveReplicationForConnections() {
        boolean isCluster = MgmtFactory.getMediator().isDistributable();
        return isCluster && configStore.getBooleanValue(SELECTIVE_REPL_FOR_CONNECTIONS_KEY, false);
    }

    @Override
    public boolean isEnableSelectiveReplicationForClients() {
        boolean managerSupportsSelectiveReplication = MgmtFactory.getClientManager().supportsSelectiveReplication();
        boolean isCluster = MgmtFactory.getMediator().isDistributable();
        return managerSupportsSelectiveReplication && isCluster && configStore.getBooleanValue(SELECTIVE_REPL_FOR_CLIENTS_KEY, false);
    }

    @Override
    public boolean isConfigForSelectiveReplicationForClientsEnabled() {
        return configStore.getBooleanValue(SELECTIVE_REPL_FOR_CLIENTS_KEY, false);
    }

    @Override
    public void setEnableSelectiveReplicationForConnections(boolean enabled) {
        configStore.setBooleanValue(SELECTIVE_REPL_FOR_CONNECTIONS_KEY, enabled);
    }

    @Override
    public void setEnableSelectiveReplicationForClients(boolean enabled) {
        configStore.setBooleanValue(SELECTIVE_REPL_FOR_CLIENTS_KEY, enabled);
    }
}

