/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.CollectSupportDataManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.CsdArchiveInfo;
import org.sourceid.saml20.domain.mgmt.impl.CsdCollectionTask;
import org.sourceid.saml20.domain.mgmt.impl.CsdFetchTask;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.mgmt.impl.Mode;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.service.impl.grouprpc.BaseGroupRpc;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;
import org.sourceid.util.collectsupportdata.CsdArchive;
import org.sourceid.util.collectsupportdata.CsdArchiveStatus;
import org.sourceid.util.collectsupportdata.CsdArguments;
import org.sourceid.util.collectsupportdata.CsdSettings;

public class CollectSupportDataManagerImpl
extends BaseGroupRpc
implements CollectSupportDataManager,
AutoReloadable {
    private static final Log log = LogFactory.getLog(CollectSupportDataManagerImpl.class);
    private final ConfigStore configStore;
    private final NodeIndexRegistry nodeIndexRegistry;
    private final Map<String, CsdArchive> collectedArchives;
    private final Map<String, CsdArchiveInfo> archivesInProgress;
    private int collectionTimeoutMinutes;
    private static final String RUN_COLLECT_SUPPORT_DATA_METHOD_NAME = "runCollectSupportData";
    private static final Class<?>[] RUN_COLLECT_SUPPORT_DATA_SIG = new Class[]{CsdArguments.class};
    private static final String NOTIFY_COLLECTION_FINISHED_METHOD_NAME = "notifyCollectionFinished";
    private static final Class<?>[] NOTIFY_COLLECTION_FINISHED_SIG = new Class[]{String.class, Address.class};
    private static final String DOWNLOAD_ARCHIVE_METHOD_NAME = "retrieveArchive";
    private static final Class<?>[] DOWNLOAD_ARCHIVE_SIG = new Class[]{String.class};
    private static final String ENCRYPT_ARCHIVE = "EncryptArchive";
    private static final String TRUNCATE_LOGS = "TruncateLogs";
    private static final String FILE_HEAD_COLLECTION_SIZE = "FileHeadCollectionSize";
    private static final String FILE_TAIL_COLLECTION_SIZE = "FileTailCollectionSize";
    private static final String ROLLED_LOG_COUNT = "RolledLogCount";
    private static final String COLLECT_EXPENSIVE_DATA = "CollectExpensiveData";
    private static final String INCLUDE_BINARY_FILES = "IncludeBinaryFiles";
    private static final String NUM_HEARTBEAT_SAMPLES = "NumHeartbeatSamples";
    private static final String INTERVAL_BETWEEN_SAMPLES = "IntervalBetweenSamples";
    private static final String REPORT_COUNT = "ReportCount";
    private static final String REPORT_INTERVAL = "ReportInterval";
    private static final String COLLECTION_TIMEOUT = "CollectionTimeoutMinutes";

    public CollectSupportDataManagerImpl() {
        this(ConfigStoreFarm.getConfig(CollectSupportDataManagerImpl.class), MgmtFactory.getNodeIndexRegistry());
    }

    public CollectSupportDataManagerImpl(ConfigStore configStore, NodeIndexRegistry nodeIndexRegistry) {
        super(ModeSupport.isDistributable());
        this.configStore = configStore;
        this.nodeIndexRegistry = nodeIndexRegistry;
        this.collectedArchives = new HashMap<String, CsdArchive>();
        this.archivesInProgress = new HashMap<String, CsdArchiveInfo>();
        this.loadSettings();
    }

    private void saveSettings(CsdSettings csdSettings) {
        this.configStore.setBooleanValue(ENCRYPT_ARCHIVE, csdSettings.isEncryptArchive());
        this.configStore.setBooleanValue(TRUNCATE_LOGS, csdSettings.isTruncateLogs());
        if (csdSettings.getFileHeadCollectionKBSize() != null) {
            this.configStore.setLongValue(FILE_HEAD_COLLECTION_SIZE, csdSettings.getFileHeadCollectionKBSize());
        }
        if (csdSettings.getFileTailCollectionKBSize() != null) {
            this.configStore.setLongValue(FILE_TAIL_COLLECTION_SIZE, csdSettings.getFileTailCollectionKBSize());
        }
        if (csdSettings.getRolledLogCount() != null) {
            this.configStore.setLongValue(ROLLED_LOG_COUNT, csdSettings.getRolledLogCount());
        }
        this.configStore.setBooleanValue(COLLECT_EXPENSIVE_DATA, csdSettings.isCollectExpensiveData());
        this.configStore.setBooleanValue(INCLUDE_BINARY_FILES, csdSettings.isIncludeBinaryFiles());
        if (csdSettings.getNumHeartbeatSamples() != null) {
            this.configStore.setLongValue(NUM_HEARTBEAT_SAMPLES, csdSettings.getNumHeartbeatSamples());
        }
        if (csdSettings.getIntervalBetweenHeartbeatSamples() != null) {
            this.configStore.setLongValue(INTERVAL_BETWEEN_SAMPLES, csdSettings.getIntervalBetweenHeartbeatSamples());
        }
        if (csdSettings.getReportCount() != null) {
            this.configStore.setLongValue(REPORT_COUNT, csdSettings.getReportCount());
        }
        if (csdSettings.getReportInterval() != null) {
            this.configStore.setLongValue(REPORT_INTERVAL, csdSettings.getReportInterval());
        }
    }

    private CsdSettings loadSettings() {
        this.collectionTimeoutMinutes = this.configStore.getIntValue(COLLECTION_TIMEOUT, 10);
        CsdSettings csdSettings = new CsdSettings();
        csdSettings.setTruncateLogs(this.configStore.getBooleanValue(TRUNCATE_LOGS, false));
        csdSettings.setEncryptArchive(this.configStore.getBooleanValue(ENCRYPT_ARCHIVE, false));
        csdSettings.setCollectExpensiveData(this.configStore.getBooleanValue(COLLECT_EXPENSIVE_DATA, false));
        csdSettings.setIncludeBinaryFiles(this.configStore.getBooleanValue(INCLUDE_BINARY_FILES, false));
        csdSettings.setFileHeadCollectionKBSize(this.configStore.getLongValue(FILE_HEAD_COLLECTION_SIZE, 100L));
        csdSettings.setFileTailCollectionKBSize(this.configStore.getLongValue(FILE_TAIL_COLLECTION_SIZE, 900L));
        csdSettings.setRolledLogCount(this.configStore.getLongValue(ROLLED_LOG_COUNT, 0L));
        csdSettings.setNumHeartbeatSamples(this.configStore.getLongValue(NUM_HEARTBEAT_SAMPLES, 5L));
        csdSettings.setIntervalBetweenHeartbeatSamples(this.configStore.getLongValue(INTERVAL_BETWEEN_SAMPLES, 1L));
        csdSettings.setReportCount(this.configStore.getLongValue(REPORT_COUNT, 10L));
        csdSettings.setReportInterval(this.configStore.getLongValue(REPORT_INTERVAL, 1L));
        return csdSettings;
    }

    @Override
    public CsdSettings getSettings() {
        return this.loadSettings();
    }

    @Override
    public List<CsdArchiveInfo> collectSupportData(CsdSettings settings) {
        Vector<Address> addresses = this.getNodeAddresses(settings);
        this.saveSettings(settings);
        CsdArguments arguments = this.createCsdCmdLineArguments(settings);
        this.cleanupPreviousArchives(settings);
        RspList rspList = this.callRemoteMethods(addresses, RUN_COLLECT_SUPPORT_DATA_METHOD_NAME, (Class[])RUN_COLLECT_SUPPORT_DATA_SIG, true, 20000, arguments);
        ArrayList<CsdArchiveInfo> archiveInfos = new ArrayList<CsdArchiveInfo>();
        for (Map.Entry entry : rspList.entrySet()) {
            CsdArchiveInfo info = (CsdArchiveInfo)((Rsp)entry.getValue()).getValue();
            info.setAddress(((Address)entry.getKey()).toString());
            info.setNodeIndex(((CsdArchiveInfo)((Rsp)entry.getValue()).getValue()).getNodeIndex());
            archiveInfos.add(info);
            this.archivesInProgress.put(info.getArchiveId(), info);
        }
        return archiveInfos;
    }

    private void cleanupPreviousArchives(CsdSettings settings) {
        ArrayList<String> existingArchives = new ArrayList<String>();
        List<Integer> nodeIndices = this.getNodeIndices(settings);
        for (Integer nodeIndex : nodeIndices) {
            for (Map.Entry<String, CsdArchive> collectedArchive : this.collectedArchives.entrySet()) {
                if (collectedArchive.getValue().getNodeIndex() != nodeIndex.intValue()) continue;
                existingArchives.add(collectedArchive.getKey());
            }
        }
        for (String archiveId : existingArchives) {
            this.collectedArchives.remove(archiveId);
            this.archivesInProgress.remove(archiveId);
        }
        this.removeFailedArchives();
    }

    private Vector<Address> getNodeAddresses(CsdSettings settings) {
        if (settings.getNodeTypeToCollect() != null) {
            switch (settings.getNodeTypeToCollect()) {
                case STANDALONE: {
                    return this.nodeIndexRegistry.getNodes().stream().filter(node -> node.getMode().equals((Object)Mode.STANDALONE)).map(Node::getAddress).collect(Collectors.toCollection(Vector::new));
                }
                case ENGINES: {
                    return this.nodeIndexRegistry.getNodes().stream().filter(node -> node.getMode().equals((Object)Mode.CLUSTERED_ENGINE)).map(Node::getAddress).collect(Collectors.toCollection(Vector::new));
                }
                case ADMINS: {
                    return this.nodeIndexRegistry.getNodes().stream().filter(node -> node.getMode().equals((Object)Mode.CLUSTERED_CONSOLE)).map(Node::getAddress).collect(Collectors.toCollection(Vector::new));
                }
                case ALL: {
                    return this.nodeIndexRegistry.getNodes().stream().map(Node::getAddress).collect(Collectors.toCollection(Vector::new));
                }
            }
        }
        return this.nodeIndexRegistry.getAddresses(settings.getNodesToCollect().stream().mapToInt(Integer::intValue).toArray());
    }

    private List<Integer> getNodeIndices(CsdSettings settings) {
        if (settings.getNodeTypeToCollect() != null) {
            switch (settings.getNodeTypeToCollect()) {
                case STANDALONE: {
                    return this.nodeIndexRegistry.getNodes().stream().filter(node -> node.getMode().equals((Object)Mode.STANDALONE)).map(Node::getIndex).collect(Collectors.toList());
                }
                case ENGINES: {
                    return this.nodeIndexRegistry.getNodes().stream().filter(node -> node.getMode().equals((Object)Mode.CLUSTERED_ENGINE)).map(Node::getIndex).collect(Collectors.toList());
                }
                case ADMINS: {
                    return this.nodeIndexRegistry.getNodes().stream().filter(node -> node.getMode().equals((Object)Mode.CLUSTERED_CONSOLE)).map(Node::getIndex).collect(Collectors.toList());
                }
                case ALL: {
                    return this.nodeIndexRegistry.getNodes().stream().map(Node::getIndex).collect(Collectors.toList());
                }
            }
        }
        return settings.getNodesToCollect();
    }

    @Override
    public void notifyCollectionFinished(String archiveId) {
        log.info((Object)"Notifying collection finished");
        Address consoleNodeAddress = this.getConsoleNodeAddress();
        if (consoleNodeAddress != null) {
            Vector<Address> consoleNodeVector = new Vector<Address>();
            consoleNodeVector.add(consoleNodeAddress);
            this.callRemoteMethods(consoleNodeVector, NOTIFY_COLLECTION_FINISHED_METHOD_NAME, (Class[])NOTIFY_COLLECTION_FINISHED_SIG, false, 10000, archiveId, this.getLocalAddress());
        } else {
            log.info((Object)"No active console node is running. Cannot notify collection finished");
        }
    }

    @Override
    public void retrieveArchive(String archiveId, Address nodeToFetchFrom) {
        log.info((Object)("Retrieving archive " + archiveId + " from " + nodeToFetchFrom));
        Vector<Address> target = new Vector<Address>();
        target.add(nodeToFetchFrom);
        RspList response = this.callRemoteMethods(target, DOWNLOAD_ARCHIVE_METHOD_NAME, (Class[])DOWNLOAD_ARCHIVE_SIG, true, 100000, archiveId);
        CsdArchive csdArchive = (CsdArchive)response.getFirst();
        if (csdArchive == null || csdArchive.getArchiveData() == null || csdArchive.getArchiveData().length == 0) {
            log.error((Object)"CSD Archive was not retrieved successfully.");
            this.archivesInProgress.get(archiveId).setStatus(CsdArchiveStatus.FAILED);
        } else {
            log.info((Object)("Finished downloading archive from " + nodeToFetchFrom));
            this.archivesInProgress.get(archiveId).setStatus(CsdArchiveStatus.COMPLETED);
            this.collectedArchives.put(archiveId, csdArchive);
        }
    }

    @Override
    public CsdArchive getArchive(String archiveId) {
        return this.collectedArchives.get(archiveId);
    }

    @Override
    public CsdArchiveInfo getArchiveInfo(String archiveId) {
        CsdArchiveInfo archiveInfo = this.archivesInProgress.get(archiveId);
        if (archiveInfo != null) {
            this.checkArchiveTimeout(archiveInfo);
        }
        return archiveInfo;
    }

    @Override
    public List<CsdArchiveInfo> getArchiveStatuses() {
        this.archivesInProgress.forEach((archiveId, archiveInfo) -> this.checkArchiveTimeout((CsdArchiveInfo)archiveInfo));
        return new ArrayList<CsdArchiveInfo>(this.archivesInProgress.values());
    }

    private void checkArchiveTimeout(CsdArchiveInfo archiveInfo) {
        if (archiveInfo.getStatus().equals((Object)CsdArchiveStatus.IN_PROGRESS)) {
            Instant collectionStartTime = archiveInfo.getTimestamp().toInstant();
            if (Instant.now().isAfter(collectionStartTime.plus((long)this.collectionTimeoutMinutes, ChronoUnit.MINUTES))) {
                log.info((Object)("Archive " + archiveInfo.getArchiveId() + " collection has timed out after " + this.collectionTimeoutMinutes + " minutes."));
                archiveInfo.setStatus(CsdArchiveStatus.FAILED);
            }
        }
    }

    private Address getConsoleNodeAddress() {
        for (Node node : this.nodeIndexRegistry.getNodes()) {
            if (!node.isConsole() && !node.getMode().equals((Object)Mode.STANDALONE)) continue;
            return node.getAddress();
        }
        return null;
    }

    private void removeFailedArchives() {
        this.archivesInProgress.entrySet().removeIf(entry -> ((CsdArchiveInfo)entry.getValue()).getStatus().equals((Object)CsdArchiveStatus.FAILED));
    }

    private CsdArguments createCsdCmdLineArguments(CsdSettings csdSettings) {
        CsdArguments domainArguments = new CsdArguments();
        if (!csdSettings.isTruncateLogs()) {
            domainArguments.addBooleanFlag("noTruncate");
        }
        if (csdSettings.isEncryptArchive()) {
            domainArguments.addBooleanFlag("encrypt");
        }
        if (csdSettings.isCollectExpensiveData()) {
            domainArguments.addBooleanFlag("collectExpensiveData");
        }
        if (csdSettings.isIncludeBinaryFiles()) {
            domainArguments.addBooleanFlag("includeBinaryFiles");
        }
        if (csdSettings.getFileHeadCollectionKBSize() != null) {
            domainArguments.addArgument("fileHeadCollectionKBSize", String.valueOf(csdSettings.getFileHeadCollectionKBSize()));
        }
        if (csdSettings.getFileTailCollectionKBSize() != null) {
            domainArguments.addArgument("fileTailCollectionKBSize", String.valueOf(csdSettings.getFileTailCollectionKBSize()));
        }
        if (StringUtils.isNotEmpty((String)csdSettings.getEncryptionPassphrase())) {
            domainArguments.addArgument("encryptionPassphrase", csdSettings.getEncryptionPassphrase());
        }
        if (StringUtils.isNotEmpty((String)csdSettings.getComment())) {
            domainArguments.addArgument("comment", csdSettings.getComment());
        }
        if (csdSettings.getNumHeartbeatSamples() != null) {
            domainArguments.addArgument("numHeartbeatSamples", String.valueOf(csdSettings.getNumHeartbeatSamples()));
        }
        if (csdSettings.getIntervalBetweenHeartbeatSamples() != null) {
            domainArguments.addArgument("intervalBetweenSamples", String.valueOf(csdSettings.getIntervalBetweenHeartbeatSamples()));
        }
        if (csdSettings.getRolledLogCount() != null) {
            domainArguments.addArgument("rolledLogCount", String.valueOf(csdSettings.getRolledLogCount()));
        }
        if (csdSettings.getReportCount() != null) {
            domainArguments.addArgument("reportCount", String.valueOf(csdSettings.getReportCount()));
        }
        if (csdSettings.getReportInterval() != null) {
            domainArguments.addArgument("reportInterval", String.valueOf(csdSettings.getReportInterval()));
        }
        return domainArguments;
    }

    public static class CsdRequestHandler
    implements RpcTarget {
        private final SysDirInfo sysDirInfo = MgmtFactory.getSysDirInfo();
        private final Mediator mediator = MgmtFactory.getMediator();

        @Override
        public CsdArchiveInfo runCollectSupportData(CsdArguments csdArgs) {
            String archiveId = RandomStringUtils.randomAlphanumeric((int)10);
            Thread thread = new Thread(new CsdCollectionTask(archiveId, csdArgs));
            thread.start();
            NodeIndexRegistry nodeIndexRegistry = MgmtFactory.getNodeIndexRegistry();
            CsdArchiveInfo archiveInfo = new CsdArchiveInfo();
            archiveInfo.setAddress(nodeIndexRegistry.getLocalNodeAddress().toString());
            archiveInfo.setMode(this.mediator.getMode());
            archiveInfo.setNodeIndex(String.valueOf(nodeIndexRegistry.getLocalNodeIndex()));
            archiveInfo.setArchiveId(archiveId);
            archiveInfo.setTimestamp(new Date());
            archiveInfo.setStatus(CsdArchiveStatus.IN_PROGRESS);
            return archiveInfo;
        }

        @Override
        public void notifyCollectionFinished(String archiveId, Address fromAddress) {
            log.info((Object)("Received notification that collection is finished " + archiveId + " from " + fromAddress));
            Thread thread = new Thread(new CsdFetchTask(fromAddress, archiveId));
            thread.start();
        }

        @Override
        public CsdArchive retrieveArchive(String archiveId) {
            log.info((Object)("Retrieving CSD archive " + archiveId));
            String archivePath = this.sysDirInfo.getInstanceDataDirectory() + "/" + archiveId;
            File archiveFile = new File(archivePath);
            byte[] data = new byte[]{};
            try {
                data = FileUtils.readFileToByteArray((File)archiveFile);
            }
            catch (IOException e) {
                log.error((Object)"Error reading archive file", (Throwable)e);
            }
            this.deleteArchive(archiveFile);
            NodeIndexRegistry nodeIndexRegistry = MgmtFactory.getNodeIndexRegistry();
            int nodeIndex = nodeIndexRegistry.getLocalNodeIndex();
            return new CsdArchive(data, archiveId, nodeIndex);
        }

        private void deleteArchive(File archiveFile) {
            if (!archiveFile.delete()) {
                log.error((Object)("Failed to delete CSD archive file " + archiveFile.getName()));
            }
        }
    }

    public static interface RpcTarget {
        public CsdArchiveInfo runCollectSupportData(CsdArguments var1);

        public void notifyCollectionFinished(String var1, Address var2);

        public CsdArchive retrieveArchive(String var1);
    }
}

