/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AbstractListenerRegistry;
import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.ConfigEventType;
import com.pingidentity.crypto.Cert;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleGlobalConfiguration;
import com.pingidentity.module.connection.ConnectionModuleManager;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.auth.Authenticator;
import org.sourceid.common.Util;
import org.sourceid.common.soap.soap11.SoapClient;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.config.SoapAuthStore;
import org.sourceid.config.SoapAuthStoreFactory;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.ConfigAbstract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.IdentityStoreProvisionerInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.InCertAuthInfo;
import org.sourceid.saml20.domain.IncomingBindings;
import org.sourceid.saml20.domain.ReplicationRecord;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.UrlToTargetMapping;
import org.sourceid.saml20.domain.UrlToTargetMappings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.ConnectionListener;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.DNtoIdPMappingsManager;
import org.sourceid.saml20.domain.mgmt.MetadataUpdateSettingManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;
import org.sourceid.saml20.domain.mgmt.ReplicationStateManager;
import org.sourceid.saml20.domain.mgmt.impl.PkCertManagerBase;
import org.sourceid.saml20.domain.mgmt.impl.ServerX509TrustManager;
import org.sourceid.saml20.domain.scim.ScimUserProvisioning;
import org.sourceid.saml20.domain.util.SelectiveReplicationConnectionValidator;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.partner.ConnectionDb;
import org.sourceid.saml20.metadata.partner.ConnectionDbEntry;
import org.sourceid.saml20.metadata.partner.ConnectionUtil;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.util.domain.Searchable;
import org.sourceid.util.domain.filter.ContainsCriteriaFilter;
import org.sourceid.util.domain.filter.ItemMultiValue;
import org.sourceid.websso.Protocol;

public class ConnectionManagerImpl
implements ConnectionManager,
AutoReloadable {
    private ConnectionUtil connectionUtil = new ConnectionUtil();
    private MetadataDirectory metadataDirectory;
    private MetadataLocal metadataLocal;
    private static final Log log = LogFactory.getLog(ConnectionManagerImpl.class);
    private boolean quietLog;
    private final transient MetadataUpdateSettingManager metadataSettingManager = MgmtFactory.getMetadataUpdateSettingManager();
    private final ReplicationStateManager replicationStateManager = MgmtFactory.getReplicationStateManager();
    private static final Comparator<SpConnection> COMPARE_BY_NAME_DOWN_SP = (connection1, connection2) -> connection1.getName().compareToIgnoreCase(connection2.getName());
    private static final Comparator<IdpConnection> COMPARE_BY_NAME_DOWN_IDP = (connection1, connection2) -> connection1.getName().compareToIgnoreCase(connection2.getName());
    private static final Set<Protocol> SUPPORTED_PROTOCOLS_IN_API_SP_CONNS = new HashSet<Protocol>();
    private static final Set<Protocol> SUPPORTED_PROTOCOLS_IN_API_IDP_CONNS;
    private static final ConnectionListenerRegistry listenerRegistry;

    public void setMetadataDirectory(MetadataDirectory metadataDirectory) {
        this.metadataDirectory = metadataDirectory;
    }

    public void setMetadataLocal(MetadataLocal metadataLocal) {
        this.metadataLocal = metadataLocal;
    }

    @Override
    public Collection<IdpConnection> getFilteredSamlIdpConnections() {
        return this.getIdpConnections(true, true);
    }

    @Override
    public Collection<IdpConnection> getFilteredIdpConnections() {
        return this.getIdpConnections(false, true);
    }

    @Override
    public Collection<IdpConnection> getAllIdpConnections() {
        return this.getIdpConnections(false, false);
    }

    protected Collection<IdpConnection> getIdpConnections(boolean samlOnly, boolean filterByServerSettings) {
        List<String> idpEntityIds = this.metadataDirectory.getIdpEntityIds();
        return idpEntityIds.stream().map(this::getIdpConnection).filter(idpConn -> !filterByServerSettings || this.passesFilterByServerSettings((IdpConnection)idpConn, samlOnly)).collect(Collectors.toList());
    }

    @Override
    public boolean passesFilterByServerSettings(IdpConnection idpConnection, boolean samlOnly) {
        if (idpConnection.isBrowserSsoProfileConfigured()) {
            switch (idpConnection.getProtocol()) {
                case SAML20: {
                    if (!this.metadataLocal.getEnableSaml20Sp()) break;
                    return true;
                }
                case SAML11: {
                    if (!this.metadataLocal.getEnableSaml11Rp()) break;
                    return true;
                }
                case SAML10: {
                    if (!this.metadataLocal.getEnableSaml10Rp()) break;
                    return true;
                }
                case WSFED: {
                    if (samlOnly || !this.metadataLocal.getEnableWsFedSp()) break;
                    return true;
                }
                case OIDC: {
                    if (!this.metadataLocal.getEnableOIDCSp()) break;
                    return true;
                }
            }
        }
        if (!samlOnly) {
            if (idpConnection.doesWsTrustSettingsExist() && this.metadataLocal.getEnableSpWsTrustSts()) {
                return true;
            }
            if (idpConnection.doesOAuthSettingsExist() && MgmtFactory.getAuthzServerManager().isEnableOAuth()) {
                return true;
            }
            if (idpConnection.doesInboundProvisioningExist() && this.metadataLocal.getEnableInboundProvisioning()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<IdpConnection> getIdpConnectionsUsingAdapterInstance(String instanceId) {
        ArrayList<IdpConnection> idpConns = new ArrayList<IdpConnection>();
        Collection<IdpConnection> idpConnections = this.getFilteredIdpConnections();
        for (IdpConnection idp : idpConnections) {
            for (TargetAttributeMapping targetAttributeMapping : idp.getTargetAttributeMappings()) {
                if (instanceId == null || !instanceId.equals(targetAttributeMapping.getAdapterInstanceId())) continue;
                idpConns.add(idp);
            }
        }
        return idpConns;
    }

    @Override
    public List<IdpConnection> getIdpConnectionsUsingIdentityStoreProvisionerInstance(String instanceId) {
        ArrayList<IdpConnection> idpConns = new ArrayList<IdpConnection>();
        Collection<IdpConnection> idpConnections = this.getFilteredIdpConnections();
        for (IdpConnection idp : idpConnections) {
            IdentityStoreProvisionerInstance instance;
            ScimUserProvisioning inboundProvisioning = idp.getInboundProvisioning();
            if (inboundProvisioning == null || (instance = inboundProvisioning.getIdentityStoreProvisioner()) == null || !instance.getId().equals(instanceId)) continue;
            idpConns.add(idp);
        }
        return idpConns;
    }

    @Override
    public List<SpConnection> getSpConnectionsUsingAdapterInstance(String instanceId) {
        ArrayList<SpConnection> spConns = new ArrayList<SpConnection>();
        Collection<SpConnection> spConnections = this.getFilteredSpConnections();
        for (SpConnection sp : spConnections) {
            boolean isConnAlreadyAdded = false;
            for (AdapterToAssertionMapping mapping : sp.getAdapterMappings()) {
                if (instanceId == null || !instanceId.equals(mapping.getAdapterInstanceId()) || isConnAlreadyAdded) continue;
                isConnAlreadyAdded = true;
                spConns.add(sp);
            }
        }
        return spConns;
    }

    @Override
    public boolean isSourceIdInUse(String sourceid, String expectingEntityId, Protocol ... protocols) {
        byte[] bytes = HexBin.stringToBytes((String)sourceid);
        try {
            String foundEntityId = this.metadataDirectory.getEntityId(bytes, protocols);
            return !foundEntityId.equals(expectingEntityId);
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    @Override
    public IdpConnection getIdpConnectionWithQuietLog(String entityId) {
        this.quietLog = true;
        IdpConnection idpConn = this.getIdpConnection(entityId);
        this.quietLog = false;
        return idpConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdpConnection getIdpConnection(String entityId) {
        IdpConnection idpConnection;
        try {
            ConnectionManagerImpl connectionManagerImpl = this;
            synchronized (connectionManagerImpl) {
                IdpConnection liveIdpConn = this.metadataDirectory.getIdpConnectionMetadata(entityId);
                idpConnection = new IdpConnection(liveIdpConn);
                this.setSoapAuthIn(idpConnection);
                this.setSoapAuthOut(idpConnection);
            }
        }
        catch (ConfigurationException ex) {
            idpConnection = null;
        }
        return idpConnection;
    }

    @Override
    public IdpConnection getIdpConnectionBySystemId(String id) {
        IdpConnection idpConnection = this.metadataDirectory.getIdpConnectionBySystemId(id, false);
        if (idpConnection != null) {
            return this.getIdpConnection(idpConnection.getEntityId());
        }
        return null;
    }

    @Override
    public IdpConnection getIdpConnection(Authenticator.AuthnInfo authnInfo) {
        IdpConnection idpConnection;
        ConnectionDb connectionDb = MgmtFactory.getConnectionDb();
        if (authnInfo.getId() == null) {
            return null;
        }
        String entityId = Role.decodeToEntityId(authnInfo.getId());
        ConnectionDbEntry dbEntry = connectionDb.getEntryByEntityId(Role.IDP, entityId);
        if (dbEntry != null && (idpConnection = this.getIdpConnectionBySystemId(dbEntry.getId())) != null && idpConnection.doesInboundProvisioningExist() && idpConnection.isActive()) {
            return idpConnection;
        }
        return null;
    }

    @Override
    public int getIdpConnectionCount() {
        return this.getFilteredIdpConnections().size();
    }

    @Override
    public int getSpConnectionCount() {
        return this.getFilteredSpConnections().size();
    }

    @Override
    public int getSpAffiliationCount() {
        List<String> affiliationIds = this.metadataDirectory.getAffiliationIds();
        return affiliationIds != null && affiliationIds.size() > 0 ? affiliationIds.size() : 0;
    }

    @Override
    public boolean isEntityIdInUse(String entityId, String id) {
        IdpConnection idpConnection = this.metadataDirectory.getIdpConnection(entityId, false);
        return idpConnection != null && !idpConnection.getId().equals(id);
    }

    @Override
    public synchronized void saveIdpConnection(IdpConnection idpConnection) {
        this.saveConnections(Collections.singletonList(idpConnection), Role.IDP, true);
    }

    @Override
    public synchronized void saveIdpConnection(IdpConnection idpConnection, AdminAuditLogger.Event auditEvent, String auditMessage) {
        this.saveConnections(Collections.singletonList(idpConnection), Role.IDP, true, auditEvent, auditMessage);
    }

    @Override
    public void saveIdpConnection(IdpConnection idpConnection, boolean manualReplication, AdminAuditLogger.Event auditEvent) {
        this.saveConnections(Collections.singletonList(idpConnection), Role.IDP, manualReplication, auditEvent, null);
    }

    private void saveConnections(List<? extends ConnectionBase> connections, Role role, boolean manualReplication) {
        this.saveConnections(connections, role, manualReplication, null, null);
    }

    private void saveConnections(List<? extends ConnectionBase> connections, Role role, boolean manualReplication, AdminAuditLogger.Event auditEvent, String auditMessage) {
        ArrayList<ConnectionBase> newConnections = new ArrayList<ConnectionBase>();
        HashMap<String, ConnectionBase> existingConnections = new HashMap<String, ConnectionBase>();
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            for (ConnectionBase connectionBase : connections) {
                ConnectionBase existingConnection = this.metadataDirectory.getConnection(connectionBase.getId());
                if (existingConnection == null) {
                    newConnections.add(connectionBase);
                } else {
                    existingConnections.put(existingConnection.getEntityId(), existingConnection);
                }
                this.prepareConnectionForSave(connectionBase, manualReplication);
            }
            this.saveConnectionModules(connections, role);
            if (role == Role.IDP) {
                this.metadataDirectory.saveIdpConnections(connections);
            } else {
                this.metadataDirectory.saveSpConnections(connections);
            }
            this.checkAndPerformSelectiveReplication(connections, existingConnections, role);
            connections.forEach(this::removeDependencyErrors);
            connections.forEach(this::reloadConnBasedPluginOverrides);
            for (ConnectionBase connectionBase : connections) {
                auditLoggerScope.log(role == Role.IDP ? AdminAuditLogger.Component.IDP_CONNECTION : AdminAuditLogger.Component.SP_CONNECTION, auditEvent != null ? auditEvent : (newConnections.contains(connectionBase) ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY), auditMessage != null ? auditMessage : connectionBase.getEntityId());
            }
        }
        ServerX509TrustManager.getX509TrustManager().reload();
        SoapClient.flushClientsCache();
        this.notifyConnectionsSaved(connections, newConnections);
    }

    private void checkAndPerformSelectiveReplication(List<? extends ConnectionBase> connections, Map<String, ConnectionBase> existingConnections, Role role) {
        if (MgmtFactory.getClusterSettingsManager().isEnableSelectiveReplicationForConnections()) {
            ArrayList<ConnectionBase> connectionsToReplicate = new ArrayList<ConnectionBase>();
            for (ConnectionBase connectionBase : connections) {
                SelectiveReplicationConnectionValidator selectiveReplicationValidator = new SelectiveReplicationConnectionValidator(connectionBase);
                boolean validForSelectiveReplication = false;
                if (role == Role.SP) {
                    validForSelectiveReplication = selectiveReplicationValidator.checkSelectiveReplicationSpConnection();
                } else if (role == Role.IDP) {
                    validForSelectiveReplication = selectiveReplicationValidator.checkSelectiveReplicationIdpConnection();
                }
                if (validForSelectiveReplication) {
                    connectionsToReplicate.add(connectionBase);
                    connectionBase.setSelectiveReplicationTime((Calendar)new XmlCalendar(new Date()));
                    continue;
                }
                this.addConnectionToUnreplicatedData(connectionBase, existingConnections, role);
            }
            if (!connectionsToReplicate.isEmpty()) {
                Collection<ReplicationRecord> records = this.metadataDirectory.createSelectiveReplicationRecords(connectionsToReplicate);
                MgmtFactory.getMediator().applySelectiveReplicationRecords(records, this.metadataDirectory);
                if (role == Role.IDP) {
                    this.metadataDirectory.saveIdpConnections(connections);
                } else {
                    this.metadataDirectory.saveSpConnections(connections);
                }
                try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                    for (ConnectionBase connToReplicate : connectionsToReplicate) {
                        auditLoggerScope.log(AdminAuditLogger.Component.CLUSTER_MANAGEMENT, AdminAuditLogger.Event.SELECTIVE_REPLICATE, connToReplicate.getEntityId());
                    }
                }
            }
        }
    }

    private void addConnectionToUnreplicatedData(ConnectionBase connection, Map<String, ConnectionBase> existingConnections, Role role) {
        if (existingConnections.containsKey(connection.getEntityId())) {
            String existingName = existingConnections.get(connection.getEntityId()).getName();
            String existingId = existingConnections.get(connection.getEntityId()).getEntityId();
            this.replicationStateManager.addUnreplicatedData(role.toString(), existingName, existingId, connection.getName(), connection.getEntityId());
        } else {
            this.replicationStateManager.addUnreplicatedData(role.toString(), connection.getName(), connection.getEntityId());
        }
    }

    private void reloadConnBasedPluginOverrides(ConnectionBase conn) {
        MgmtFactory.getAdapterManager().reloadConnBasedPluginOverrides(conn);
        MgmtFactory.getTokenProcessorManager().reloadConnBasedPluginOverrides(conn);
        MgmtFactory.getTokenGeneratorManager().reloadConnBasedPluginOverrides(conn);
    }

    private void removeConnBasedPluginOverrides(ConnectionBase conn) {
        MgmtFactory.getAdapterManager().removeConnBasedPluginOverrides(conn);
        MgmtFactory.getTokenProcessorManager().removeConnBasedPluginOverrides(conn);
        MgmtFactory.getTokenGeneratorManager().removeConnBasedPluginOverrides(conn);
    }

    @Override
    public synchronized void saveIdpConnections(List<IdpConnection> idpConnections) {
        this.saveConnections(idpConnections, Role.IDP, true);
    }

    @Override
    public synchronized void saveSpConnections(List<SpConnection> spConnections) {
        this.saveConnections(spConnections, Role.SP, true);
    }

    private void removeDependencyErrors(ConnectionBase connection) {
        String connectionId = connection.getId();
        AffectedItemType affectedType = connection.getRoleType() == Role.IDP ? AffectedItemType.IDP_CONN : AffectedItemType.SP_CONN;
        MgmtFactory.getDependencyErrorManager().remove(connectionId, affectedType);
    }

    private void prepareConnectionForSave(ConnectionBase connection, boolean manualReplication) {
        ConnectionBase previousConnectionDef = this.metadataDirectory.getConnection(connection.getId());
        if (previousConnectionDef != null && !previousConnectionDef.getEntityId().equals(connection.getEntityId())) {
            this.cleanupSoapAuthInfo(previousConnectionDef);
            this.deleteConnectionModules(previousConnectionDef);
            this.removeConnBasedPluginOverrides(previousConnectionDef);
        }
        if (previousConnectionDef != null) {
            connection.setFileSystemPath(previousConnectionDef.getFileSystemPath());
        }
        if (manualReplication) {
            connection.setLastModified((Calendar)new XmlCalendar(new Date()));
        }
        this.saveConnectionCerts(connection);
        this.saveSoapAuthInfo(connection, manualReplication);
        if (connection.getProtocol() == Protocol.OIDC) {
            connection.getEnabledProfiles().setIdpInitiatedSLOEnabled(false);
            connection.getEnabledProfiles().setSpInitiatedSLOEnabled(false);
        }
        if (connection.getId() == null) {
            connection.assignId();
        }
    }

    private void saveConnectionCerts(ConnectionBase connection) {
        ConnectionCerts dsigCerts = connection.getDsigVerificationCerts();
        Set<Cert> allVerificationCertsToSave = dsigCerts.getAllVerificationCerts();
        Cert encryptionCert = connection.getEncryptionSettings().getEncryptionCert();
        if (encryptionCert != null) {
            encryptionCert = this.getCertCheckSetAlias(allVerificationCertsToSave, encryptionCert);
            allVerificationCertsToSave.add(encryptionCert);
        }
        connection.getEncryptionSettings().setEncryptionCert(encryptionCert);
        this.fixCertAliases(allVerificationCertsToSave);
        ArrayList<Cert> activeVerificationCerts = new ArrayList<Cert>();
        for (Cert cert : dsigCerts.getActiveVerificationCerts()) {
            Cert activeCert = this.getCertCheckSetAlias(allVerificationCertsToSave, cert);
            activeVerificationCerts.add(activeCert);
        }
        dsigCerts.setVerificationCerts(activeVerificationCerts, allVerificationCertsToSave);
    }

    private void fixCertAliases(Set<Cert> certs) {
        if (certs != null) {
            for (Cert cert : certs) {
                this.fixAlias(cert);
            }
        }
    }

    private void fixAlias(Cert cert) {
        if (StringUtils.isBlank((String)cert.getAlias())) {
            cert.setAlias(this.generateNewAlias());
        }
    }

    private String generateNewAlias() {
        return PkCertManagerBase.generateNewAlias();
    }

    @Override
    public synchronized void deleteIdpConnection(IdpConnection idpConnection) {
        this.deleteIdpConnections(Collections.singletonList(idpConnection));
    }

    @Override
    public synchronized void deleteIdpConnections(List<IdpConnection> idpConnections) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            for (IdpConnection idpConnection : idpConnections) {
                this.prepareIdpConnectionForDelete(idpConnection);
            }
            this.metadataDirectory.deleteConnections(idpConnections);
            this.deleteConnectionModules(idpConnections, Role.IDP);
            idpConnections.forEach(this::removeConnBasedPluginOverrides);
            for (IdpConnection idpConnection : idpConnections) {
                auditLoggerScope.log(AdminAuditLogger.Component.IDP_CONNECTION, AdminAuditLogger.Event.DELETE, idpConnection.getEntityId());
            }
        }
        this.checkAndPerformDeleteReplication(idpConnections);
        ServerX509TrustManager.getX509TrustManager().reload();
        SoapClient.flushClientsCache();
        this.notifyConnectionsDeleted(idpConnections);
    }

    private void prepareIdpConnectionForDelete(IdpConnection idpConnection) {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        ContextUtil ctxUtil = new ContextUtil();
        String contextValue = ctxUtil.buildQualifiedId("authz_req", new OAuthSourceId(OAuthSourceId.Type.IDP_CONNECTION, idpConnection.getId()));
        authzServerManager.deleteUserKeyToAccessTokenMappingsForContext(contextValue);
        this.cleanupSoapAuthInfo(idpConnection);
        this.metadataSettingManager.deleteMetadataUpdateSettings(idpConnection.getId());
        MgmtFactory.getAuthnSessionPolicyManager().deleteSourcePolicyBySourceKey(new IdpConnAuthnSourceKey(idpConnection.getId()));
    }

    private void saveSoapAuthInfo(ConnectionBase connection, boolean manualReplication) {
        SoapAuthInfo soapAuthOut;
        SoapAuthStore soapAuthStore = SoapAuthStoreFactory.getSoapAuthStore();
        SoapAuthInfo incomingSoapAuth = connection.getSoapAuthIn();
        if (incomingSoapAuth != null) {
            PkCertAndConnectionCertManager sslAuthPkCertManager = (PkCertAndConnectionCertManager)MgmtFactory.getSslAuthPkCertManager();
            ConnectionCerts clientAuthCerts = connection.getClientAuthCerts();
            Set<Cert> allVerificationCerts = clientAuthCerts.getAllVerificationCerts();
            String entityId = connection.getEntityId();
            Role role = connection.getRoleType();
            if (manualReplication) {
                sslAuthPkCertManager.saveCertsForConnection(allVerificationCerts, entityId, role);
            }
            allVerificationCerts = sslAuthPkCertManager.getCertsForConnection(entityId, role);
            Cert activeVerificationCert = clientAuthCerts.getActiveVerificationCert();
            if (activeVerificationCert != null) {
                for (Cert c : allVerificationCerts) {
                    if (!c.getX509Certificate().equals(activeVerificationCert.getX509Certificate())) continue;
                    X509Certificate x5 = c.getX509Certificate();
                    String alias = c.getAlias();
                    SoapAuthInfo.CertAuthInfo certAuthInfo = new SoapAuthInfo.CertAuthInfo(null, null, x5, alias);
                    incomingSoapAuth.setCertAuthInfo(certAuthInfo);
                }
            }
            if (manualReplication) {
                soapAuthStore.setIncoming(incomingSoapAuth);
            }
        }
        if ((soapAuthOut = connection.getSoapAuthOut()) != null && manualReplication) {
            soapAuthStore.setOutgoing(soapAuthOut);
        }
    }

    private void setSoapAuthIn(ConnectionBase connection) {
        SoapAuthInfo.CertAuthInfo certAuthInfo;
        Role roleType = connection.getRoleType();
        String entityId = connection.getEntityId();
        SoapAuthInfo soapAuthIn = this.getSoapAuthIn(entityId, roleType);
        SoapAuthInfo soapAuthInfo = soapAuthIn = soapAuthIn != null ? soapAuthIn.clone() : new SoapAuthInfo(connection.getEncodedEntityId());
        if (soapAuthIn.isHasCertEntry() && !(certAuthInfo = soapAuthIn.getCertAuthInfo()).isAnchored()) {
            PkCertAndConnectionCertManager sslAuthPkCertManager = (PkCertAndConnectionCertManager)MgmtFactory.getSslAuthPkCertManager();
            Set<Cert> certsForConnection = sslAuthPkCertManager.getCertsForConnection(entityId, roleType);
            Cert active = null;
            for (Cert c : certsForConnection) {
                if (c.getAlias() == null) {
                    if (!c.getX509Certificate().equals(certAuthInfo.getCert())) continue;
                    active = c;
                    break;
                }
                if (!c.getAlias().equals(certAuthInfo.getAlias())) continue;
                active = c;
                break;
            }
            ConnectionCerts connectionCerts = new ConnectionCerts();
            connectionCerts.setVerificationCerts((ArrayList<Cert>)(active == null ? null : new ArrayList<Object>(Collections.singletonList(active))), certsForConnection);
            soapAuthIn.setCertAuthInfo(new InCertAuthInfo(connectionCerts));
        }
        connection.setSoapAuthIn(soapAuthIn);
    }

    private SoapAuthInfo getSoapAuthIn(String entityId, Role role) {
        SoapAuthStore soapAuthStore = SoapAuthStoreFactory.getSoapAuthStore();
        String encodedId = role.encode(entityId);
        return soapAuthStore.getIncoming(encodedId);
    }

    private void setSoapAuthOut(ConnectionBase connection) {
        String encodedId;
        SoapAuthStore soapAuthStore = SoapAuthStoreFactory.getSoapAuthStore();
        SoapAuthInfo outgoing = soapAuthStore.getOutgoing(encodedId = connection.getEncodedEntityId());
        connection.setSoapAuthOut(outgoing == null ? new SoapAuthInfo(encodedId) : outgoing.clone());
    }

    private void cleanupSoapAuthInfo(ConnectionBase connection) {
        SoapAuthStore soapAuthStore = SoapAuthStoreFactory.getSoapAuthStore();
        String encodedId = connection.getEncodedEntityId();
        SoapAuthInfo emptyInfo = new SoapAuthInfo(encodedId);
        soapAuthStore.setIncoming(emptyInfo);
        soapAuthStore.setOutgoing(emptyInfo);
        PkCertAndConnectionCertManager sslAuthPkCertManager = (PkCertAndConnectionCertManager)MgmtFactory.getSslAuthPkCertManager();
        Set<Cert> certs = Collections.emptySet();
        sslAuthPkCertManager.saveCertsForConnection(certs, connection.getEntityId(), connection.getRoleType());
    }

    @Override
    public boolean isSpConnectionApiSupported(SpConnection conn) {
        return conn.isBrowserSsoProfileConfigured() && SUPPORTED_PROTOCOLS_IN_API_SP_CONNS.contains(conn.getProtocol()) || conn.doesWsTrustSettingsExist() || conn.getConnectionModuleConfigurations() != null && !conn.getConnectionModuleConfigurations().isEmpty();
    }

    @Override
    public boolean isIdpConnectionApiSupported(IdpConnection conn) {
        return (conn.isBrowserSsoProfileConfigured() || conn.doesOIDCRPSettingsExist() || conn.doesWsTrustSettingsExist() || conn.getOAuthSettings() != null && conn.getOAuthSettings().getOAuthAssertionGrantAttributeContract() != null || conn.doesInboundProvisioningExist()) && SUPPORTED_PROTOCOLS_IN_API_IDP_CONNS.contains(conn.getProtocol());
    }

    @Override
    public boolean isOIDCProtocolEnabled(IdpConnection connection) {
        if (connection != null && connection.getProtocol() == Protocol.OIDC) {
            return this.metadataLocal.getEnableOIDCSp();
        }
        return true;
    }

    @Override
    public Collection<SpConnection> getFilteredSpConnections() {
        return this.getSpConnections(false, true);
    }

    @Override
    public Collection<SpConnection> getFilteredApiSupportedSpConnections(ConnectionFilterOptions filterOptions) {
        Stream<SpConnection> stream = this.getFilteredSpConnections().parallelStream().filter(this::isSpConnectionApiSupported);
        if (filterOptions != null) {
            if (filterOptions.hasC2cMappings()) {
                Predicate<SpConnection> hasC2cMappingsPredicate = spConnection -> spConnection.getC2cMappings() != null && spConnection.getC2cMappings().size() > 0;
                stream = stream.filter(hasC2cMappingsPredicate);
            }
            if (filterOptions.isSaml20Only()) {
                Predicate<SpConnection> isSaml20OnlyPredicate = spConnection -> spConnection.isBrowserSsoProfileConfigured() && spConnection.getProtocol() == Protocol.SAML20;
                stream = stream.filter(isSaml20OnlyPredicate);
            }
            if (filterOptions.isSamlOnly()) {
                Function<SpConnection, Boolean> isSamlConnection = spConnection -> spConnection.getProtocol() == Protocol.SAML20 || spConnection.getProtocol() == Protocol.SAML11 || spConnection.getProtocol() == Protocol.SAML10;
                Predicate<SpConnection> isSamlOnlyPredicate = spConnection -> spConnection.isBrowserSsoProfileConfigured() && (Boolean)isSamlConnection.apply((SpConnection)spConnection) != false;
                stream = stream.filter(isSamlOnlyPredicate);
            }
        }
        return stream.collect(Collectors.toList());
    }

    @Override
    public Collection<IdpConnection> getFilteredApiSupportedIdpConnections(ConnectionFilterOptions filterOptions) {
        Predicate<IdpConnection> predicate = idpConnection -> this.isIdpConnectionApiSupported((IdpConnection)idpConnection) && this.isOIDCProtocolEnabled((IdpConnection)idpConnection);
        Stream<IdpConnection> stream = this.getFilteredIdpConnections().parallelStream().filter(predicate);
        if (filterOptions != null) {
            if (filterOptions.isIdpOrSpInitSSO()) {
                Predicate<IdpConnection> idpOrSpInitSsoPredicate = idpConnection -> idpConnection.getEnabledProfiles().isIdpInitiatedSSOEnabled() || idpConnection.getEnabledProfiles().isSpInitiatedSSOEnabled();
                stream = stream.filter(idpOrSpInitSsoPredicate);
            }
            if (filterOptions.isSpInitSSO()) {
                Predicate<IdpConnection> spInitSsoPredicate = idpConnection -> idpConnection.getEnabledProfiles().isSpInitiatedSSOEnabled();
                stream = stream.filter(spInitSsoPredicate);
            }
            if (filterOptions.isSamlOnly()) {
                Function<IdpConnection, Boolean> isSamlConnection = idpConnection -> idpConnection.getProtocol() == Protocol.SAML20 || idpConnection.getProtocol() == Protocol.SAML11 || idpConnection.getProtocol() == Protocol.SAML10;
                Predicate<IdpConnection> isSamlOnlyPredicate = idpConnection -> idpConnection.isBrowserSsoProfileConfigured() && (Boolean)isSamlConnection.apply((IdpConnection)idpConnection) != false;
                stream = stream.filter(isSamlOnlyPredicate);
            }
        }
        return stream.collect(Collectors.toList());
    }

    @Override
    public Collection<SpConnection> getFilteredSamlSpConnections() {
        return this.getSpConnections(true, true);
    }

    @Override
    public Collection<IdpConnection> getFilteredWsFedIdpConnections() {
        ArrayList<IdpConnection> result = new ArrayList<IdpConnection>();
        for (ConnectionDbEntry entry : this.getWsfedDBEntriesForRole(Role.IDP)) {
            IdpConnection conn = this.getIdpConnectionBySystemId(entry.getId());
            if (conn == null || !this.passesFilterByServerSettings(conn, false)) continue;
            result.add(conn);
        }
        return result;
    }

    private Collection<ConnectionDbEntry> getWsfedDBEntriesForRole(Role role) {
        ConnectionDb connectionDb = MgmtFactory.getConnectionDb();
        return connectionDb.getEntriesByProtocolAndRole(Protocol.WSFED, role);
    }

    @Override
    public Collection<SpConnection> getFilteredWsFedSpConnections() {
        ArrayList<SpConnection> result = new ArrayList<SpConnection>();
        for (ConnectionDbEntry entry : this.getWsfedDBEntriesForRole(Role.SP)) {
            SpConnection conn = this.getSpConnectionBySystemId(entry.getId());
            if (conn == null || !this.passesFilterByServerSettings(conn, false)) continue;
            result.add(conn);
        }
        return result;
    }

    @Override
    public Collection<SpConnection> getAllSpConnections() {
        return this.getSpConnections(false, false);
    }

    Collection<SpConnection> getSpConnections(boolean samlOnly, boolean filterByServerSettings) {
        List<String> spEntityIds = this.metadataDirectory.getSpEntityIds();
        return spEntityIds.stream().map(this::getSpConnection).filter(spConn -> !filterByServerSettings || this.passesFilterByServerSettings((SpConnection)spConn, samlOnly)).collect(Collectors.toList());
    }

    @Override
    public boolean passesFilterByServerSettings(SpConnection spConnection, boolean samlOnly) {
        if (spConnection.isBrowserSsoProfileConfigured()) {
            switch (spConnection.getProtocol()) {
                case SAML20: {
                    if (!this.metadataLocal.getEnableSaml20IdP()) break;
                    return true;
                }
                case SAML11: {
                    if (!this.metadataLocal.getEnableSaml11Ap()) break;
                    return true;
                }
                case SAML10: {
                    if (!this.metadataLocal.getEnableSaml10Ap()) break;
                    return true;
                }
                case WSFED: {
                    if (samlOnly || !this.metadataLocal.getEnableWsFedIdP()) break;
                    return true;
                }
            }
        }
        if (!samlOnly) {
            if (spConnection.doesWsTrustSettingsExist() && this.metadataLocal.getEnableIdpWsTrustSts()) {
                return true;
            }
            HashSet<String> enabledModules = new HashSet<String>();
            ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
            for (ConnectionModuleGlobalConfiguration moduleGlobalConfig : moduleSupport.getGlobalConfigurations()) {
                if (!moduleGlobalConfig.isEnabledInGui()) continue;
                enabledModules.add(moduleGlobalConfig.getModuleId());
            }
            if (spConnection.getConnectionModuleConfigurations() != null) {
                for (ConnectionModuleConfiguration moduleConfig : spConnection.getConnectionModuleConfigurations()) {
                    if (!enabledModules.contains(moduleConfig.getModuleId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isIdpConnectionModuleInUse(Class<? extends ConnectionModuleConfiguration> moduleConfigurationClass) {
        Collection<IdpConnection> idpConns = this.getIdpConnections(true, false);
        for (IdpConnection idpConnection : idpConns) {
            if (idpConnection.getModuleConfiguration(moduleConfigurationClass) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSpConnectionModuleInUse(Class<? extends ConnectionModuleConfiguration> moduleConfigurationClass) {
        Collection<SpConnection> spConns = this.getSpConnections(true, false);
        for (SpConnection s : spConns) {
            if (s.getModuleConfiguration(moduleConfigurationClass) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Affiliation> getAffiliations() {
        List<String> affiliationIds = this.metadataDirectory.getAffiliationIds();
        ArrayList<Affiliation> affiliations = new ArrayList<Affiliation>();
        for (String affiliationId : affiliationIds) {
            Affiliation affiliation = this.getAffiliation(affiliationId);
            affiliations.add(affiliation);
        }
        return affiliations;
    }

    @Override
    public Collection<Affiliation> getAffiliationsUsingSpConnection(String entityId) {
        ArrayList<Affiliation> inUseAffiliations = new ArrayList<Affiliation>();
        if (this.getSpConnection(entityId) != null) {
            for (Affiliation affiliation : this.getAffiliations()) {
                List<String> members = affiliation.getMembers();
                if (!entityId.equals(affiliation.getAffiliationOwnerId()) && (members == null || !members.contains(entityId))) continue;
                inUseAffiliations.add(affiliation);
            }
        }
        return inUseAffiliations;
    }

    @Override
    public Affiliation getAffiliation(String affiliationId) {
        Affiliation liveAffiliation = this.metadataDirectory.getAffiliation(affiliationId);
        EntityDescriptorType entityDescType = this.connectionUtil.toEntityDescriptorType(liveAffiliation);
        Affiliation affiliationCopy = this.connectionUtil.toAffiliation(entityDescType);
        return affiliationCopy;
    }

    @Override
    public void saveAffiliation(Affiliation affiliation) {
        affiliation.setLastModified((Calendar)new XmlCalendar(new Date()));
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.metadataDirectory.saveAffiliation(affiliation);
            auditLoggerScope.log(AdminAuditLogger.Component.AFFILIATION, affiliation.getId() != null ? AdminAuditLogger.Event.MODIFY : AdminAuditLogger.Event.CREATE, affiliation.getAffiliationId());
        }
    }

    @Override
    public void deleteAffiliation(Affiliation affiliation) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.metadataDirectory.deleteAffiliation(affiliation);
            auditLoggerScope.log(AdminAuditLogger.Component.AFFILIATION, AdminAuditLogger.Event.DELETE, affiliation.getAffiliationId());
        }
    }

    @Override
    public SpConnection getSpConnectionWithQuietLog(String entityId) {
        this.quietLog = true;
        SpConnection spConn = this.getSpConnection(entityId);
        this.quietLog = false;
        return spConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpConnection getSpConnection(String entityId) {
        SpConnection spConnection;
        try {
            ConnectionManagerImpl connectionManagerImpl = this;
            synchronized (connectionManagerImpl) {
                SpConnection liveSpConn = this.metadataDirectory.getSpConnectionMetadata(entityId);
                spConnection = new SpConnection(liveSpConn);
                this.setSoapAuthIn(spConnection);
                this.setSoapAuthOut(spConnection);
            }
            if (!spConnection.usesBindingsOutbound("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01") && spConnection.getLastModified().before(new GregorianCalendar(2007, 4, 27))) {
                IncomingBindings currentBindings = spConnection.getIncomingBindings();
                currentBindings.setSoapBinding(false);
                spConnection.setIncomingBindings(currentBindings);
            }
        }
        catch (ConfigurationException ex) {
            spConnection = null;
        }
        return spConnection;
    }

    @Override
    public SpConnection getSpConnectionBySystemId(String id) {
        SpConnection spConnection = this.metadataDirectory.getSpConnectionBySystemId(id, false);
        if (spConnection != null) {
            return this.getSpConnection(spConnection.getEntityId());
        }
        return null;
    }

    @Override
    public synchronized void saveSpConnection(SpConnection spConnection) {
        this.saveConnections(Collections.singletonList(spConnection), Role.SP, true);
    }

    @Override
    public synchronized void saveSpConnection(SpConnection spConnection, AdminAuditLogger.Event auditEvent, String auditMessage) {
        this.saveConnections(Collections.singletonList(spConnection), Role.SP, true, auditEvent, auditMessage);
    }

    @Override
    public void saveSpConnection(SpConnection spConnection, boolean manualReplication, AdminAuditLogger.Event auditEvent) {
        this.saveConnections(Collections.singletonList(spConnection), Role.SP, manualReplication, auditEvent, null);
    }

    @Override
    public synchronized void deleteSpConnection(SpConnection spConnection) {
        this.deleteSpConnections(Collections.singletonList(spConnection));
    }

    private void prepareSpConnectionForDelete(SpConnection spConnection) {
        this.cleanupSoapAuthInfo(spConnection);
        this.metadataSettingManager.deleteMetadataUpdateSettings(spConnection.getId());
    }

    @Override
    public synchronized void deleteSpConnections(List<SpConnection> spConnections) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            for (SpConnection spConnection : spConnections) {
                this.prepareSpConnectionForDelete(spConnection);
            }
            this.metadataDirectory.deleteConnections(spConnections);
            this.deleteConnectionModules(spConnections, Role.SP);
            spConnections.forEach(this::removeConnBasedPluginOverrides);
            for (SpConnection spConnection : spConnections) {
                auditLoggerScope.log(AdminAuditLogger.Component.SP_CONNECTION, AdminAuditLogger.Event.DELETE, spConnection.getEntityId());
            }
        }
        this.checkAndPerformDeleteReplication(spConnections);
        ServerX509TrustManager.getX509TrustManager().reload();
        SoapClient.flushClientsCache();
        this.notifyConnectionsDeleted(spConnections);
    }

    private void checkAndPerformDeleteReplication(List<? extends ConnectionBase> connections) {
        if (MgmtFactory.getClusterSettingsManager().isEnableSelectiveReplicationForConnections()) {
            List<String> connectionsToDelete = connections.stream().map(ConfigAbstract::getId).collect(Collectors.toList());
            Collection<ReplicationRecord> records = this.metadataDirectory.createSelectiveReplicationRecordsForDelete(connectionsToDelete);
            MgmtFactory.getMediator().applySelectiveReplicationRecords(records, this.metadataDirectory);
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                for (ConnectionBase connectionBase : connections) {
                    auditLoggerScope.log(AdminAuditLogger.Component.CLUSTER_MANAGEMENT, AdminAuditLogger.Event.SELECTIVE_REPLICATE, connectionBase.getEntityId());
                }
            }
        }
    }

    @Override
    public Set<X509Certificate> getActiveUnanchoredIncomingSslAuthCerts() {
        HashSet<X509Certificate> tempSet = new HashSet<X509Certificate>();
        Set<SoapAuthInfo> soapAuthInfo = SoapAuthStoreFactory.getSoapAuthStore().getAllIncomingCerts();
        SoapAuthInfo.CertAuthInfo certAuthInfo = null;
        for (SoapAuthInfo incomingSoapAuth : soapAuthInfo) {
            X509Certificate cert;
            certAuthInfo = incomingSoapAuth.getCertAuthInfo();
            if (certAuthInfo == null || certAuthInfo.isAnchored() || (cert = certAuthInfo.getCert()) == null) continue;
            tempSet.add(cert);
        }
        return tempSet;
    }

    @Override
    public String basicAuthInUserNameUsedBy(String uname, String contextId) {
        String usedBy = null;
        for (ConnectionBase conn : this.getAllConnections()) {
            SoapAuthInfo authIn = conn.getSoapAuthIn();
            if (authIn == null || !authIn.isHasBasicEntry() || conn.getId().equals(contextId)) continue;
            SoapAuthInfo.BasicAuthInfo basicAuthInfo = authIn.getBasicAuthInfo();
            String userName = basicAuthInfo.getUsername();
            if (uname == null || !uname.equals(userName)) continue;
            usedBy = conn.getEntityId();
            break;
        }
        return usedBy;
    }

    @Override
    public String certAuthInSubjectDbUsedBy(String dn, String contextId) {
        dn = dn == null ? null : Util.canonicalizeX500DN(dn);
        String usedBy = null;
        for (ConnectionBase conn : this.getAllConnections()) {
            SoapAuthInfo.CertAuthInfo certAuthInfo;
            SoapAuthInfo authIn = conn.getSoapAuthIn();
            if (authIn == null || !authIn.isHasCertEntry() || conn.getId().equals(contextId) || (certAuthInfo = authIn.getCertAuthInfo()).getAlias() != null) continue;
            String subjectDn = certAuthInfo.getSubjectDN();
            String string = subjectDn = subjectDn == null ? null : Util.canonicalizeX500DN(subjectDn);
            if (dn == null || !dn.equals(subjectDn)) continue;
            usedBy = conn.getEntityId();
            break;
        }
        return usedBy;
    }

    @Override
    public String certAuthInCertUsedBy(Cert cert, String contextId) {
        String usedBy = null;
        for (ConnectionBase conn : this.getAllConnections()) {
            SoapAuthInfo.CertAuthInfo certAuthInfo;
            SoapAuthInfo authIn = conn.getSoapAuthIn();
            if (authIn == null || !authIn.isHasCertEntry() || conn.getId().equals(contextId) || (certAuthInfo = authIn.getCertAuthInfo()).isAnchored()) continue;
            X509Certificate x509 = certAuthInfo.getCert();
            if (cert == null || !cert.getX509Certificate().equals(x509)) continue;
            usedBy = conn.getEntityId();
            break;
        }
        return usedBy;
    }

    @Override
    public boolean isNameInUse(String name, String id, Role role) {
        ConnectionBase conn;
        Collection<ConnectionBase> conns = null;
        conns = role == Role.IDP ? this.metadataDirectory.getIdpConnectionsByName(name) : this.metadataDirectory.getSpConnectionsByName(name);
        return !conns.isEmpty() && !StringUtils.equals((String)id, (String)(conn = conns.iterator().next()).getId());
    }

    @Override
    public Collection<ConnectionBase> getAllConnections() {
        LinkedList<ConnectionBase> connections = new LinkedList<ConnectionBase>();
        connections.addAll(this.getIdpConnections(false, false));
        connections.addAll(this.getSpConnections(false, false));
        return connections;
    }

    @Override
    public boolean isEntityIdInUseForSp(String entityId, String id) {
        SpConnection spConnection = this.metadataDirectory.getSpConnection(entityId, false);
        return spConnection != null && !spConnection.getId().equals(id);
    }

    private Cert getCertCheckSetAlias(Collection<Cert> certsForConnection, Cert current) {
        if (current != null && StringUtils.isBlank((String)current.getAlias())) {
            for (Cert c : certsForConnection) {
                X509Certificate activeX509 = current.getX509Certificate();
                if (!c.getX509Certificate().equals(activeX509)) continue;
                current = c;
            }
        }
        return current;
    }

    @Override
    public boolean isWsTrustStsInUse(Role role) {
        Collection<ConnectionBase> conns = role == Role.IDP ? this.getIdpConnections(false, false) : this.getSpConnections(false, false);
        return conns.parallelStream().anyMatch(ConnectionBase::doesWsTrustSettingsExist);
    }

    @Override
    public boolean isOAuthInUse() {
        Collection<IdpConnection> conns = this.getIdpConnections(false, false);
        for (IdpConnection conn : conns) {
            if (conn.getSsoToOAuthAttrMapping() == null && conn.getOAuthSettings() == null) continue;
            return true;
        }
        return false;
    }

    private void saveConnectionModules(List<? extends ConnectionBase> connections, Role role) {
        HashMap mapConfigsToSave = new HashMap();
        HashMap mapConfigsToDelete = new HashMap();
        for (ConnectionBase connectionBase : connections) {
            List<ConnectionModuleConfiguration> connectionModuleConfigurations = connectionBase.getConnectionModuleConfigurations();
            if (connectionModuleConfigurations == null) continue;
            for (ConnectionModuleConfiguration moduleConfig : connectionModuleConfigurations) {
                Class<?> clazz = moduleConfig.getClass();
                if (!mapConfigsToSave.containsKey(clazz)) {
                    mapConfigsToSave.put(clazz, new ArrayList());
                }
                if (!mapConfigsToDelete.containsKey(clazz)) {
                    mapConfigsToDelete.put(clazz, new ArrayList());
                }
                ((List)mapConfigsToSave.get(clazz)).add(moduleConfig);
                String originalEntityId = connectionBase.getEntityIdOnDisk();
                if (originalEntityId == null || originalEntityId.equals(connectionBase.getEntityId())) continue;
                ((List)mapConfigsToDelete.get(clazz)).add(originalEntityId);
            }
        }
        for (Map.Entry entry : mapConfigsToSave.entrySet()) {
            ConnectionModuleSupport support = ConnectionModuleSupport.getInstance();
            ConnectionModuleManager moduleManager = support.getManager((Class)entry.getKey(), role);
            List configsToDelete = (List)mapConfigsToDelete.get(entry.getKey());
            if (configsToDelete != null && !configsToDelete.isEmpty()) {
                moduleManager.deleteConfigurations(configsToDelete);
            }
            moduleManager.saveConfigurations((List)entry.getValue());
        }
    }

    private void deleteConnectionModules(ConnectionBase connection) {
        List<ConnectionModuleConfiguration> connectionModuleConfigurations = connection.getConnectionModuleConfigurations();
        if (connectionModuleConfigurations != null) {
            for (ConnectionModuleConfiguration moduleConfig : connectionModuleConfigurations) {
                if (moduleConfig != null) {
                    ConnectionModuleSupport support = ConnectionModuleSupport.getInstance();
                    ConnectionModuleManager moduleManager = support.getManager(moduleConfig.getClass(), connection.getRoleType());
                    moduleManager.deleteConfiguration(connection.getEntityId());
                    continue;
                }
                log.warn((Object)"NULL module detected. Deletion skipped.");
            }
        }
    }

    private void deleteConnectionModules(List<? extends ConnectionBase> connections, Role role) {
        HashMap mapConfigsToDelete = new HashMap();
        for (ConnectionBase connectionBase : connections) {
            List<ConnectionModuleConfiguration> connectionModuleConfigurations = connectionBase.getConnectionModuleConfigurations();
            if (connectionModuleConfigurations == null) continue;
            for (ConnectionModuleConfiguration moduleConfig : connectionModuleConfigurations) {
                if (moduleConfig != null) {
                    Class<?> clazz = moduleConfig.getClass();
                    if (!mapConfigsToDelete.containsKey(clazz)) {
                        mapConfigsToDelete.put(clazz, new ArrayList());
                    }
                    ((List)mapConfigsToDelete.get(clazz)).add(connectionBase.getEntityId());
                    continue;
                }
                log.warn((Object)"NULL module detected. Deletion skipped.");
            }
        }
        for (Map.Entry entry : mapConfigsToDelete.entrySet()) {
            ConnectionModuleSupport support = ConnectionModuleSupport.getInstance();
            ConnectionModuleManager moduleManager = support.getManager((Class)entry.getKey(), role);
            List configsToDelete = (List)mapConfigsToDelete.get(entry.getKey());
            if (configsToDelete == null || configsToDelete.isEmpty()) continue;
            moduleManager.deleteConfigurations(configsToDelete);
        }
    }

    @Override
    public boolean isIdpConnectionInUse(IdpConnection conn) {
        DNtoIdPMappingsManager idpMappingsMgr = MgmtFactory.getDNtoIdPMappingsManager();
        if (idpMappingsMgr.isConnectionInUseByMapping(conn)) {
            return true;
        }
        IdpConnAuthnSourceKey sourceKey = new IdpConnAuthnSourceKey(conn.getId());
        return MgmtFactory.getAuthnSelectionConfigManager().isAuthnSourceInUse(sourceKey) || MgmtFactory.getPolicyFragmentManager().isAuthnSourceInUse(sourceKey) || MgmtFactory.getAuthnSelectorManager().isAuthnSourceInUse(sourceKey);
    }

    @Override
    public boolean isSpConnectionInUse(SpConnection conn) {
        if (!this.getAffiliationsUsingSpConnection(conn.getEntityId()).isEmpty()) {
            return true;
        }
        UrlToTargetMappings targetUrlMappings = MgmtFactory.getLocalSettingsManager().getUrlToAdapterMapping();
        for (UrlToTargetMapping targetUrlMapping : targetUrlMappings.getMappings()) {
            if (targetUrlMapping.getTargetType() != TargetSessionId.TargetSessionType.SP_CONN || !targetUrlMapping.getTargetId().equals(conn.getId()) || conn.getC2cMappings().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        listenerRegistry.addListener(listener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener listener) {
        listenerRegistry.removeListener(listener);
    }

    protected <T extends ConnectionBase> void notifyConnectionsSaved(Collection<T> conns, Collection<ConnectionBase> newConnections) {
        MgmtFactory.getSingleThreadedExecutor().execute(() -> {
            for (ConnectionBase conn : conns) {
                listenerRegistry.notifyConnectionSaved(conn, newConnections.contains(conn));
            }
        });
    }

    protected <T extends ConnectionBase> void notifyConnectionsDeleted(Collection<T> conns) {
        MgmtFactory.getSingleThreadedExecutor().execute(() -> {
            for (ConnectionBase conn : conns) {
                listenerRegistry.notifyConnectionDeleted(conn);
            }
        });
    }

    @Override
    public Collection<ConnectionBase> getFilteredConnections() {
        Collection<IdpConnection> idpConnections = this.getFilteredIdpConnections();
        Collection<SpConnection> spConnections = this.getFilteredSpConnections();
        ArrayList<ConnectionBase> connections = new ArrayList<ConnectionBase>();
        if (idpConnections != null) {
            for (IdpConnection idpConnection : idpConnections) {
                connections.add(idpConnection);
            }
        }
        if (spConnections != null) {
            for (SpConnection spConnection : spConnections) {
                connections.add(spConnection);
            }
        }
        return connections;
    }

    @Override
    public Collection<SpConnection> searchSpConnections(Integer page, Integer numberPerPage, String filter, final ConnectionFilterOptions filterOptions) {
        SearchCriteria searchCriteria;
        Searchable<SpConnection> searchable = new Searchable<SpConnection>(){

            @Override
            public SearchResult<SpConnection> search(SearchCriteria searchCriteria) {
                ContainsCriteriaFilter<SpConnection> filter = new ContainsCriteriaFilter<SpConnection>(c -> new ItemMultiValue<SpConnection, String>((SpConnection)c, (K[])new String[]{c.getEntityId(), c.getName()}));
                Collection searchResults = filter.doFilter(searchCriteria.getQuery(), ConnectionManagerImpl.this.getFilteredApiSupportedSpConnections(filterOptions).parallelStream().collect(Collectors.toList()));
                if (searchCriteria.getStartIndex() >= searchResults.size()) {
                    return new SearchResult<SpConnection>(searchCriteria.getStartIndex(), Collections.emptyList());
                }
                searchResults = searchResults.parallelStream().sorted(COMPARE_BY_NAME_DOWN_SP).collect(Collectors.toList());
                if (searchCriteria.getItemsRequested() == -1) {
                    return new SearchResult<SpConnection>(0, new ArrayList(searchResults));
                }
                int fromIndex = searchCriteria.getStartIndex();
                int toIndex = searchCriteria.getStartIndex() + searchCriteria.getItemsRequested() >= searchResults.size() ? searchResults.size() : searchCriteria.getStartIndex() + searchCriteria.getItemsRequested();
                return new SearchResult<SpConnection>(searchCriteria.getStartIndex(), new ArrayList(searchResults).subList(fromIndex, toIndex));
            }
        };
        if (page == null) {
            searchCriteria = new SearchCriteria.Builder().query(filter).build();
        } else {
            int fromIndex = (page - 1) * numberPerPage;
            searchCriteria = new SearchCriteria.Builder(fromIndex, numberPerPage).query(filter).build();
        }
        SearchResult spConnectionSearchResult = searchable.search(searchCriteria);
        return spConnectionSearchResult.getResults();
    }

    @Override
    public Collection<IdpConnection> searchIdpConnections(Integer page, Integer numberPerPage, String filter, final ConnectionFilterOptions filterOptions) {
        SearchCriteria searchCriteria;
        Searchable<IdpConnection> searchable = new Searchable<IdpConnection>(){

            @Override
            public SearchResult<IdpConnection> search(SearchCriteria searchCriteria) {
                ContainsCriteriaFilter<IdpConnection> filter = new ContainsCriteriaFilter<IdpConnection>(c -> new ItemMultiValue<IdpConnection, String>((IdpConnection)c, (K[])new String[]{c.getEntityId(), c.getName()}));
                Collection searchResults = filter.doFilter(searchCriteria.getQuery(), ConnectionManagerImpl.this.getFilteredApiSupportedIdpConnections(filterOptions).parallelStream().collect(Collectors.toList()));
                if (searchCriteria.getStartIndex() >= searchResults.size()) {
                    return new SearchResult<IdpConnection>(searchCriteria.getStartIndex(), Collections.emptyList());
                }
                searchResults = searchResults.parallelStream().sorted(COMPARE_BY_NAME_DOWN_IDP).collect(Collectors.toList());
                if (searchCriteria.getItemsRequested() == -1) {
                    return new SearchResult<IdpConnection>(0, new ArrayList(searchResults));
                }
                int fromIndex = searchCriteria.getStartIndex();
                int toIndex = searchCriteria.getStartIndex() + searchCriteria.getItemsRequested() >= searchResults.size() ? searchResults.size() : searchCriteria.getStartIndex() + searchCriteria.getItemsRequested();
                return new SearchResult<IdpConnection>(searchCriteria.getStartIndex(), new ArrayList(searchResults).subList(fromIndex, toIndex));
            }
        };
        if (page == null) {
            searchCriteria = new SearchCriteria.Builder().query(filter).build();
        } else {
            int fromIndex = (page - 1) * numberPerPage;
            searchCriteria = new SearchCriteria.Builder(fromIndex, numberPerPage).query(filter).build();
        }
        SearchResult idpConnectionSearchResult = searchable.search(searchCriteria);
        return idpConnectionSearchResult.getResults();
    }

    static {
        SUPPORTED_PROTOCOLS_IN_API_SP_CONNS.add(Protocol.SAML20);
        SUPPORTED_PROTOCOLS_IN_API_SP_CONNS.add(Protocol.SAML11);
        SUPPORTED_PROTOCOLS_IN_API_SP_CONNS.add(Protocol.SAML10);
        SUPPORTED_PROTOCOLS_IN_API_SP_CONNS.add(Protocol.WSFED);
        SUPPORTED_PROTOCOLS_IN_API_IDP_CONNS = new HashSet<Protocol>();
        SUPPORTED_PROTOCOLS_IN_API_IDP_CONNS.add(Protocol.SAML20);
        SUPPORTED_PROTOCOLS_IN_API_IDP_CONNS.add(Protocol.SAML11);
        SUPPORTED_PROTOCOLS_IN_API_IDP_CONNS.add(Protocol.SAML10);
        SUPPORTED_PROTOCOLS_IN_API_IDP_CONNS.add(Protocol.WSFED);
        SUPPORTED_PROTOCOLS_IN_API_IDP_CONNS.add(Protocol.OIDC);
        listenerRegistry = new ConnectionListenerRegistry();
    }

    private static class ConnectionListenerRegistry
    extends AbstractListenerRegistry {
        private ConnectionListenerRegistry() {
        }

        public void addListener(ConnectionListener listener) {
            this.doAddListener(ConfigEventType.CONNECTION_UPDATED, listener, null);
        }

        public void removeListener(ConnectionListener listener) {
            this.doRemoveListener(ConfigEventType.CONNECTION_UPDATED, listener);
        }

        public void notifyConnectionSaved(ConnectionBase connection, boolean newConnection) {
            this.doNotifyListeners(ConfigEventType.CONNECTION_UPDATED, l -> l.onConnectionSaved(connection, newConnection));
        }

        public void notifyConnectionDeleted(ConnectionBase connection) {
            this.doNotifyListeners(ConfigEventType.CONNECTION_UPDATED, l -> l.onConnectionDeleted(connection));
        }
    }

    public static class ConnectionFilterOptions {
        private boolean idpOrSpInitSSO;
        private boolean spInitSSO;
        private boolean hasC2cMappings;
        private boolean saml20Only;
        private boolean samlOnly;

        public boolean isSpInitSSO() {
            return this.spInitSSO;
        }

        public void setSpInitSSO(boolean spInitSSO) {
            this.spInitSSO = spInitSSO;
        }

        public boolean isIdpOrSpInitSSO() {
            return this.idpOrSpInitSSO;
        }

        public void setIdpOrSpInitSSO(boolean idpOrSpInitSSO) {
            this.idpOrSpInitSSO = idpOrSpInitSSO;
        }

        public boolean hasC2cMappings() {
            return this.hasC2cMappings;
        }

        public void setHasC2cMappings(boolean hasC2cMappings) {
            this.hasC2cMappings = hasC2cMappings;
        }

        public boolean isSaml20Only() {
            return this.saml20Only;
        }

        public void setSaml20Only(boolean saml20Only) {
            this.saml20Only = saml20Only;
        }

        public boolean isSamlOnly() {
            return this.samlOnly;
        }

        public void setSamlOnly(boolean samlOnly) {
            this.samlOnly = samlOnly;
        }
    }
}

