/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.crypto.DSignRotationService;
import com.pingidentity.crypto.DSignRotationTask;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.x2006.x01.keypairRotations.PkCertRotationType;
import com.pingidentity.x2006.x01.keypairRotations.PkCertRotations;
import com.pingidentity.x2006.x01.keypairRotations.PkCertRotationsDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.mgmt.impl.ConfigManagerBase;

public class DSignRotationSettingsManagerImpl
extends ConfigManagerBase
implements DSignRotationSettingsManager {
    private static Log log = LogFactory.getLog(DSignRotationSettingsManagerImpl.class);
    private static final String PK_CERT_ROTATION_SETTING_XML_FILE_NAME = "pingfederate-pk-cert-rotation.xml";
    private DSignRotationService digitalCertRotationService;
    private final Map<String, DSignRotationSetting> rotationSettingMap = new HashMap<String, DSignRotationSetting>();
    private Timer digitalCertRotationTaskTimer = new Timer();
    private PkCertManager dsignPkCertManager = MgmtFactory.getDsigPkCertManager();

    public DSignRotationSettingsManagerImpl() {
        this.reload();
    }

    private PkCertRotationsDocument getDoc() {
        String dataDir = this.sysDirInfo.getDataDirectory();
        return (PkCertRotationsDocument)this.xmlLoader.load(dataDir, PK_CERT_ROTATION_SETTING_XML_FILE_NAME);
    }

    @Override
    public synchronized void reload() {
        this.reloadFromXml();
    }

    @Override
    public synchronized void startDigitalCertRotationTask() {
        if (this.digitalCertRotationService != null) {
            this.digitalCertRotationService.cancel();
            this.digitalCertRotationService = null;
        }
        DSignRotationTask dsignDecryptionCertRotationTask = new DSignRotationTask(this);
        this.digitalCertRotationService = this.makeDigitalSignatureCertRotationService("DigitalSignatureCertRotationService", this.dsignPkCertManager, dsignDecryptionCertRotationTask, this.digitalCertRotationTaskTimer);
        this.digitalCertRotationService.start();
    }

    private void reloadFromXml() {
        PkCertRotationType[] pkCerkRotationTypes;
        this.rotationSettingMap.clear();
        PkCertRotationsDocument pkCertRotationsDoc = this.getDoc();
        PkCertRotations pkCertRotations = pkCertRotationsDoc.getPkCertRotations();
        for (PkCertRotationType rotationType : pkCerkRotationTypes = pkCertRotations.getPkCertRotationTypeArray()) {
            String certAlias = rotationType.getCertificateAlias();
            DSignRotationSetting rotationSetting = this.rotationSettingToType(certAlias, rotationType);
            this.rotationSettingMap.put(certAlias, rotationSetting);
        }
    }

    protected synchronized DSignRotationService makeDigitalSignatureCertRotationService(String taskName, PkCertManager certManager, DSignRotationTask rotationTask, Timer timer) {
        return new DSignRotationService(taskName, certManager, rotationTask, timer);
    }

    @Override
    public synchronized Collection<DSignRotationSetting> getRotationSettings() {
        ArrayList<DSignRotationSetting> rotationSettings = new ArrayList<DSignRotationSetting>(this.rotationSettingMap.values());
        return rotationSettings;
    }

    @Override
    public synchronized DSignRotationSetting getRotationSetting(String certAlias) {
        if (StringUtils.isEmpty((String)certAlias)) {
            return null;
        }
        DSignRotationSetting rotationSetting = this.rotationSettingMap.get(certAlias);
        return rotationSetting;
    }

    @Override
    public synchronized void addRotationSetting(DSignRotationSetting keypairRotationSetting) {
        if (keypairRotationSetting == null) {
            return;
        }
        String certAlias = keypairRotationSetting.getCertAlias();
        DSignRotationSetting existingRotationSetting = this.getRotationSetting(certAlias);
        if (existingRotationSetting == null) {
            log.debug((Object)"Adding a new Certificate Rotation Setting.");
            PkCertRotationsDocument pkCertRotationsDoc = this.getDoc();
            PkCertRotations pkCertRotations = pkCertRotationsDoc.getPkCertRotations();
            PkCertRotationType pkCertRotationType = pkCertRotations.addNewPkCertRotationType();
            this.generatePkCertRotationTypeValues(keypairRotationSetting, pkCertRotationType);
            this.saveDSignRotationSettings(pkCertRotationsDoc, AdminAuditLogger.Event.CREATE, certAlias);
        } else {
            this.updateRotationSettings(keypairRotationSetting);
        }
    }

    @Override
    public synchronized boolean deleteRotationSetting(DSignRotationSetting keypairRotationSetting) {
        boolean deleted = false;
        if (keypairRotationSetting != null) {
            PkCertRotationsDocument pkCertRotationsDoc = this.getDoc();
            PkCertRotations pkCertRotations = pkCertRotationsDoc.getPkCertRotations();
            PkCertRotationType[] pkCerkRotationSettings = pkCertRotations.getPkCertRotationTypeArray();
            String certAlias = keypairRotationSetting.getCertAlias();
            PkCertRotationType[] updatedPkCerkRotations = new PkCertRotationType[pkCerkRotationSettings.length];
            int addedCount = 0;
            for (int i = 0; i < pkCerkRotationSettings.length; ++i) {
                String pkCertAlias = pkCerkRotationSettings[i].getCertificateAlias();
                if (certAlias.equals(pkCertAlias)) {
                    log.debug((Object)"Deleting an existing Certificate Rotation Setting");
                    deleted = true;
                    continue;
                }
                updatedPkCerkRotations[addedCount] = pkCerkRotationSettings[i];
                ++addedCount;
            }
            pkCertRotations.setPkCertRotationTypeArray(updatedPkCerkRotations);
            this.saveDSignRotationSettings(pkCertRotationsDoc, AdminAuditLogger.Event.DELETE, certAlias);
        }
        return deleted;
    }

    private synchronized void saveDSignRotationSettings(PkCertRotationsDocument pkCertRotationsDoc, AdminAuditLogger.Event event, String certAlias) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.xmlLoader.save(this.sysDirInfo.getDataDirectory(), PK_CERT_ROTATION_SETTING_XML_FILE_NAME, (XmlObject)pkCertRotationsDoc);
            auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE_ROTATION, event, "Dsign Certificate Rotation - " + this.lookupSubjectDn(certAlias));
        }
        this.reloadFromXml();
    }

    private String lookupSubjectDn(String certAlias) {
        PkCert cert = this.dsignPkCertManager.getPkCert(certAlias);
        if (cert != null) {
            return cert.getX509Certificate().getSubjectDN().toString();
        }
        return certAlias;
    }

    @Override
    public synchronized boolean deleteRotationSettingForAlias(String certAlias) {
        boolean deleted = false;
        if (certAlias != null) {
            PkCertRotationsDocument pkCertRotationsDoc = this.getDoc();
            PkCertRotations pkCertRotations = pkCertRotationsDoc.getPkCertRotations();
            PkCertRotationType[] pkCerkRotationSettings = pkCertRotations.getPkCertRotationTypeArray();
            ArrayList<PkCertRotationType> updatedPkCerkRotations = new ArrayList<PkCertRotationType>();
            for (int i = 0; i < pkCerkRotationSettings.length; ++i) {
                String pkCertAlias = pkCerkRotationSettings[i].getCertificateAlias();
                if (certAlias.equals(pkCertAlias)) {
                    log.debug((Object)"Deleting an existing Certificate Rotation Setting.");
                    deleted = true;
                    continue;
                }
                updatedPkCerkRotations.add(pkCerkRotationSettings[i]);
            }
            PkCertRotationType[] updatedPkCerkRotationsArray = new PkCertRotationType[updatedPkCerkRotations.size()];
            pkCertRotations.setPkCertRotationTypeArray(updatedPkCerkRotations.toArray(updatedPkCerkRotationsArray));
            this.saveDSignRotationSettings(pkCertRotationsDoc, AdminAuditLogger.Event.DELETE, certAlias);
        }
        return deleted;
    }

    @Override
    public synchronized void updateRotationSettings(DSignRotationSetting keypairRotationSetting) {
        if (keypairRotationSetting != null) {
            PkCertRotationsDocument pkCertRotationsDoc = this.getDoc();
            PkCertRotations pkCertRotations = pkCertRotationsDoc.getPkCertRotations();
            PkCertRotationType[] pkCerkRotationSettingsType = pkCertRotations.getPkCertRotationTypeArray();
            String certAlias = keypairRotationSetting.getCertAlias();
            for (int i = 0; i < pkCerkRotationSettingsType.length; ++i) {
                if (!pkCerkRotationSettingsType[i].getCertificateAlias().equals(certAlias)) continue;
                log.debug((Object)"Updating an existing Certificate Rotation Setting.");
                this.generatePkCertRotationTypeValues(keypairRotationSetting, pkCerkRotationSettingsType[i]);
                break;
            }
            pkCertRotations.setPkCertRotationTypeArray(pkCerkRotationSettingsType);
            this.saveDSignRotationSettings(pkCertRotationsDoc, keypairRotationSetting.isEnableCertRotation() ? AdminAuditLogger.Event.MODIFY : AdminAuditLogger.Event.DEACTIVATE, certAlias);
        }
    }

    private void generatePkCertRotationTypeValues(DSignRotationSetting keypairRotationSetting, PkCertRotationType pkCertRotationType) {
        String signatureAlgorithm = keypairRotationSetting.getSignatureAlgorithm();
        int validityDays = keypairRotationSetting.getValidityPeriodDays();
        int activationBufferMins = keypairRotationSetting.getActivationBufferMins();
        int keySize = keypairRotationSetting.getKeySize();
        int rotationBufferMins = keypairRotationSetting.getRotationBufferMins();
        String certAlias = keypairRotationSetting.getCertAlias();
        String keyAlgorithm = keypairRotationSetting.getKeyAlgorithm();
        String pendingCertAlias = keypairRotationSetting.getPendingCertAlias();
        String enableCertRotantion = String.valueOf(keypairRotationSetting.isEnableCertRotation());
        pkCertRotationType.setActivationBufferMins(activationBufferMins);
        pkCertRotationType.setCertificateAlias(certAlias);
        pkCertRotationType.setKeySize(keySize);
        pkCertRotationType.setRotationBufferMins(rotationBufferMins);
        pkCertRotationType.setSignatureAlgorithm(signatureAlgorithm);
        pkCertRotationType.setValidityPeriodDays(validityDays);
        pkCertRotationType.setKeyAlgorithm(keyAlgorithm);
        pkCertRotationType.setPendingCertAlias(pendingCertAlias);
        pkCertRotationType.setEnableCertRotation(enableCertRotantion);
    }

    private DSignRotationSetting rotationSettingToType(String certAlias, PkCertRotationType pkCerkRotationType) {
        String signatureAlgorithm = pkCerkRotationType.getSignatureAlgorithm();
        int validityDays = pkCerkRotationType.getValidityPeriodDays();
        int activationBufferMins = pkCerkRotationType.getActivationBufferMins();
        int keySize = pkCerkRotationType.getKeySize();
        int rotationBufferMins = pkCerkRotationType.getRotationBufferMins();
        String keyAlgo = pkCerkRotationType.getKeyAlgorithm();
        String pendingCertAlias = pkCerkRotationType.getPendingCertAlias();
        boolean enableCertRotation = Boolean.parseBoolean(pkCerkRotationType.getEnableCertRotation());
        DSignRotationSetting rotationSetting = new DSignRotationSetting(certAlias, enableCertRotation);
        rotationSetting.setActivationBufferMins(activationBufferMins);
        rotationSetting.setKeySize(keySize);
        rotationSetting.setRotationBufferMins(rotationBufferMins);
        rotationSetting.setSignatureAlgorithm(signatureAlgorithm);
        rotationSetting.setValidityPeriodDays(validityDays);
        rotationSetting.setKeyAlgorithm(keyAlgo);
        rotationSetting.setPendingCertAlias(pendingCertAlias);
        rotationSetting.setEnableCertRotation(enableCertRotation);
        return rotationSetting;
    }
}

