/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.AbstractNioFileWatcher;
import com.pingidentity.common.util.KerberosConfigUtil;
import com.pingidentity.configservice.SysDirInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.ClusterSettingsManager;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProviderManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;

public class DataDirWatcher
extends AbstractNioFileWatcher {
    private final Log log = LogFactory.getLog(this.getClass());
    private AtomicLong lastModified = new AtomicLong(0L);
    private Set<File> excludedFiles;
    private boolean clientSelectiveReplicationEnabled = false;
    private boolean connectionSelectiveReplicationEnabled = false;

    public DataDirWatcher(File file) {
        super(file, true, false, false);
        this.scanForLastModified();
    }

    @Override
    public Set<File> getExcludedFiles() {
        if (this.excludedFiles == null || this.clusterSettingsUpdated()) {
            SysDirInfo sysDirInfo = MgmtFactory.getSysDirInfo();
            Mediator mediator = MgmtFactory.getMediator();
            DeltaReplicationProviderManager replProviderManager = MgmtFactory.getDeltaReplicationProviderManager();
            this.excludedFiles = new HashSet<File>();
            this.excludedFiles.addAll(mediator.getExcludedDataFiles());
            this.excludedFiles.add(new File(mediator.getDataDirFile(), "update"));
            this.excludedFiles.add(new File(mediator.getDataDirFile(), "pingfederate-dependency-errors.xml"));
            this.excludedFiles.add(new File(sysDirInfo.getConfigStoreDir(), "org.sourceid.util.license.Synchronizer.xml"));
            this.excludedFiles.add(KerberosConfigUtil.getKrb5ConfFile());
            this.excludedFiles.addAll(replProviderManager.getReplicationProviders().stream().map(provider -> new File(mediator.getDataDirFile(), provider.getManagedDirectoryName())).collect(Collectors.toSet()));
            if (this.connectionSelectiveReplicationEnabled) {
                this.excludedFiles.add(new File(mediator.getDataDirFile(), "connections"));
                this.excludedFiles.add(new File(mediator.getDataDirFile(), "sourceid-soap-auth.xml"));
                this.excludedFiles.add(new File(mediator.getDataDirFile(), "module"));
                this.excludedFiles.add(new File(mediator.getDataDirFile(), "config-store/com.pingidentity.draft.mgmt.DraftManagerImpl.xml"));
                this.excludedFiles.add(new File(mediator.getDataDirFile(), "config-store/org.sourceid.saml20.domain.mgmt.impl.SslAuthPkCertManager.xml"));
            }
            if (this.clientSelectiveReplicationEnabled) {
                this.excludedFiles.add(new File(mediator.getDataDirFile(), "oauth-clients"));
            }
            SysDirInfo dirInfo = GlobalRegistry.getService(SysDirInfo.class);
            this.excludedFiles.add(new File(dirInfo.getLocalDataDirectory()));
            this.excludedFiles.add(new File(mediator.getDataDirFile(), "admin-api-config.xml"));
        }
        return this.excludedFiles;
    }

    @Override
    protected void fileChanged(File file, WatchEvent<?> watchEvent) {
        if (!file.isDirectory() || this.isIncludeDirTimestamps()) {
            this.updateLastModified(file.lastModified());
            this.log.debug((Object)("File modified: " + new Date(file.lastModified()) + " - " + file.getAbsolutePath()));
        }
    }

    public long getLastModified() {
        return this.lastModified.get();
    }

    public void scanForLastModified() {
        this.log.debug((Object)("Scanning for most recent modified file/dir in " + this.getFile().getAbsolutePath()));
        try {
            Files.walkFileTree(this.getFile().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (DataDirWatcher.this.getExcludedFiles().contains(dir.toFile())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (dir.toFile().isDirectory() && DataDirWatcher.this.isIncludeDirTimestamps()) {
                        DataDirWatcher.this.updateLastModified(dir.toFile().lastModified());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    File file = path.toFile();
                    if (DataDirWatcher.this.getExcludedFiles().contains(file)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (file.isHidden()) {
                        return FileVisitResult.CONTINUE;
                    }
                    DataDirWatcher.this.updateLastModified(file.lastModified());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.log.error((Object)("Error finding most recently modified file in " + this.getFile().getAbsolutePath()), (Throwable)e);
        }
        finally {
            this.log.debug((Object)("Done scanning for most recent modified file/dir in " + this.getFile().getAbsolutePath()));
        }
    }

    private boolean updateLastModified(long value) {
        value = (value / 1000L + 1L) * 1000L;
        long oldValue = this.lastModified.get();
        while (value > oldValue) {
            if (this.lastModified.compareAndSet(oldValue, value)) {
                return true;
            }
            oldValue = this.lastModified.get();
        }
        return false;
    }

    private boolean clusterSettingsUpdated() {
        ClusterSettingsManager clusterSettingsManager = MgmtFactory.getClusterSettingsManager();
        boolean clusterSettingsUpdated = false;
        if (this.connectionSelectiveReplicationEnabled != clusterSettingsManager.isEnableSelectiveReplicationForConnections()) {
            this.connectionSelectiveReplicationEnabled = clusterSettingsManager.isEnableSelectiveReplicationForConnections();
            clusterSettingsUpdated = true;
        }
        if (this.clientSelectiveReplicationEnabled != clusterSettingsManager.isEnableSelectiveReplicationForClients()) {
            this.clientSelectiveReplicationEnabled = clusterSettingsManager.isEnableSelectiveReplicationForClients();
            clusterSettingsUpdated = true;
        }
        return clusterSettingsUpdated;
    }
}

