/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.SysDirInfo;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Timer;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.mgmt.impl.DataSourceManagerImpl;

public abstract class DataSourceDeployer {
    private Log log = LogFactory.getLog(this.getClass());
    protected Timer timer;
    protected DataSourceManagerImpl dataSourceManager;

    public DataSourceDeployer(DataSourceManagerImpl dataSourceManager) throws Exception {
        this.dataSourceManager = dataSourceManager;
        this.timer = new Timer(this.getClass().getName() + " closeDataSource timer", true);
    }

    protected abstract void undeployDatasource(String var1);

    protected abstract void closeDataSource(DataSource var1);

    protected abstract void deployDatasource(JdbcDataSource var1);

    public void deploy() {
        this.process();
    }

    public void deploy(JdbcDataSource dataSource) {
        this.process(dataSource);
    }

    public void redeploy(JdbcDataSource dataSource) {
        this.process(dataSource);
    }

    protected void modifyProvisioner() {
        SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
        File provisionerRestartFile = new File(sysDirInfo.getModuleDir(), "provisioner-notify.txt");
        if (provisionerRestartFile.exists()) {
            this.log.debug((Object)("Touch " + provisionerRestartFile.getAbsolutePath()));
            Date now = new Date();
            provisionerRestartFile.setLastModified(now.getTime());
        } else if (new File(provisionerRestartFile.getParent()).exists()) {
            try {
                this.log.debug((Object)("Create " + provisionerRestartFile.getAbsolutePath()));
                provisionerRestartFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create file " + provisionerRestartFile, e);
            }
        }
    }

    private void process() {
        this.processDataSources();
    }

    private void process(JdbcDataSource dataSource) {
        this.processDataSource(dataSource);
    }

    private void processDataSources() {
        try {
            for (JdbcDataSource dataSource : this.dataSourceManager.getJdbcDataSources()) {
                this.deployDatasource(dataSource);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Problem with datasource deployment.", (Throwable)e);
        }
        finally {
            this.modifyProvisioner();
        }
    }

    private void processDataSource(JdbcDataSource dataSource) {
        try {
            this.deployDatasource(dataSource);
        }
        catch (Exception e) {
            this.log.error((Object)"Problem with datasource deployment.", (Throwable)e);
        }
        finally {
            this.modifyProvisioner();
        }
    }

    protected String replaceSystemProperties(String value) {
        int loc;
        String key = null;
        String replacement = null;
        while ((loc = value.indexOf("${")) > -1) {
            key = value.substring(loc + 2, value.indexOf("}", loc));
            replacement = System.getProperty(key);
            value = value.replace(value.substring(loc, value.indexOf("}", loc) + 1), replacement == null ? key : replacement);
        }
        return value;
    }
}

