/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleManager;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ValidationUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdapterManagerImpl;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.wstrust.handlers.WSTrustLicenseChecker;

public class DataValidator {
    private Log log = LogFactory.getLog(this.getClass());

    public List<String> validate() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            ConfigStore adapterConfigStore = ConfigStoreFarm.getConfig(AdapterManagerImpl.class);
            Map idpAdapterInstanceMap = adapterConfigStore.getMapValue("IdpAuthnAdapterInstances", Collections.EMPTY_MAP);
            this.checkIfPluginExists(errorMessages, idpAdapterInstanceMap, "adapter");
            Map spAdapterInstanceMap = adapterConfigStore.getMapValue("SpAuthnAdapterInstances", Collections.EMPTY_MAP);
            this.checkIfPluginExists(errorMessages, spAdapterInstanceMap, "adapter");
            ConfigStore tokenGeneratorConfigStore = ConfigStoreFarm.getConfig("token-generators");
            Map tokenGeneratorInstanceMap = tokenGeneratorConfigStore.getMapValue("token-generators", Collections.EMPTY_MAP);
            this.checkIfPluginExists(errorMessages, tokenGeneratorInstanceMap, "token generator");
            ConfigStore tokenProcessorConfigStore = ConfigStoreFarm.getConfig("token-processors");
            Map tokenProcessorInstanceMap = tokenProcessorConfigStore.getMapValue("token-processors", Collections.EMPTY_MAP);
            this.checkIfPluginExists(errorMessages, tokenProcessorInstanceMap, "token processor");
            ConfigStore identityStoreProvisionerConfigStore = ConfigStoreFarm.getConfig("identity-store-provisioners");
            Map identityStorePluginInstanceMap = identityStoreProvisionerConfigStore.getMapValue("identity-store-provisioners", Collections.EMPTY_MAP);
            this.checkIfPluginExists(errorMessages, identityStorePluginInstanceMap, "identity store plugin");
            ConfigStore authenticationSelectorConfigStore = ConfigStoreFarm.getConfig("adapter-selectors");
            Map authenticationSelectorPluginInstanceMap = authenticationSelectorConfigStore.getMapValue("adapter-selectors", Collections.EMPTY_MAP);
            this.checkIfPluginExists(errorMessages, authenticationSelectorPluginInstanceMap, "authentication selector");
            ConfigStore clientRegPluginConfigStore = ConfigStoreFarm.getConfig("dynamic-client-registration");
            Map clientRegPluginConfigStorePluginInstanceMap = clientRegPluginConfigStore.getMapValue("dynamic-client-registration", Collections.EMPTY_MAP);
            this.checkIfPluginExists(errorMessages, clientRegPluginConfigStorePluginInstanceMap, "client registration policy");
            ConfigStore oobPluginConfigStore = ConfigStoreFarm.getConfig("oob-auth-plugins");
            Map oobPluginInstanceMap = oobPluginConfigStore.getMapValue("oob-auth-plugins", Collections.emptyMap());
            this.checkIfPluginExists(errorMessages, oobPluginInstanceMap, "out-of-band authentication plugin");
            ConfigStore notifPublisherPluginConfigStore = ConfigStoreFarm.getConfig("notification-sender");
            Map notifPublisherPluginInstanceMap = notifPublisherPluginConfigStore.getMapValue("notification-sender", Collections.emptyMap());
            this.checkIfPluginExists(errorMessages, notifPublisherPluginInstanceMap, "notification publisher plugin");
            ConfigStore authzDetailProcessorConfigStore = ConfigStoreFarm.getConfig("authorization-detail-processors");
            Map authzDetailProcessorPluginInstanceMap = authzDetailProcessorConfigStore.getMapValue("authorization-detail-processors", Collections.emptyMap());
            this.checkIfPluginExists(errorMessages, authzDetailProcessorPluginInstanceMap, "authorization detail processor plugin");
            ConfigStore secretManagerConfigStore = ConfigStoreFarm.getConfig("secret-managers");
            Map secretManagerPluginInstanceMap = secretManagerConfigStore.getMapValue("secret-managers", Collections.emptyMap());
            this.checkIfPluginExists(errorMessages, secretManagerPluginInstanceMap, "secret manager plugin");
            ConfigStore captchaProviderConfigStore = ConfigStoreFarm.getConfig("captcha-providers");
            Map captchaProviderPluginInstanceMap = captchaProviderConfigStore.getMapValue("captcha-providers", Collections.emptyMap());
            this.checkIfPluginExists(errorMessages, captchaProviderPluginInstanceMap, "risk provider plugin");
            this.checkIfDataStoreDriversExist(errorMessages);
            this.checkIfReferencedCertificateExists(errorMessages);
            if (MgmtFactory.getMediator().isConsole()) {
                this.validateAgainstLicense(errorMessages);
                this.validateModuleDependencies(errorMessages);
            }
        }
        catch (Exception ex) {
            errorMessages.add("An error occurred while validating the data archive. Validation did not complete.  See server log for more details.");
            this.log.error((Object)"Data archive validation error.", (Throwable)ex);
        }
        return errorMessages;
    }

    private void checkIfPluginExists(List<String> errorMessages, Map pluginInstanceMap, String pluginType) {
        for (Object key : pluginInstanceMap.keySet()) {
            String pluginId = (String)key;
            String pluginClassName = (String)pluginInstanceMap.get(pluginId);
            if (ValidationUtil.isValidClassName(pluginClassName)) continue;
            errorMessages.add("The '" + pluginId + "' " + pluginType + "'s jar file is missing or not loaded. (" + pluginClassName + ")");
        }
    }

    private void validateModuleDependencies(List<String> errorMessages) {
        this.validateModuleDependencies(errorMessages, Role.IDP);
        this.validateModuleDependencies(errorMessages, Role.SP);
    }

    private void validateModuleDependencies(List<String> errorMessages, Role role) {
        Collection<Object> connections = Collections.emptyList();
        if (role == Role.IDP) {
            connections = MgmtFactory.getConnectionManager().getAllIdpConnections();
        } else if (role == Role.SP) {
            connections = MgmtFactory.getConnectionManager().getAllSpConnections();
        }
        ArrayList connectionModuleConfigurationClasses = new ArrayList();
        for (ConnectionBase connectionBase : connections) {
            List<ConnectionModuleConfiguration> list = connectionBase.getConnectionModuleConfigurations();
            if (list == null) continue;
            for (ConnectionModuleConfiguration moduleConfiguration : list) {
                Class<?> connectionModuleConfigurationClass = moduleConfiguration.getClass();
                if (connectionModuleConfigurationClasses.contains(connectionModuleConfigurationClass)) continue;
                connectionModuleConfigurationClasses.add(connectionModuleConfigurationClass);
            }
        }
        ConnectionModuleSupport connectionModuleSupport = ConnectionModuleSupport.getInstance();
        for (Class clazz : connectionModuleConfigurationClasses) {
            ConnectionModuleManager connectionModuleManager = connectionModuleSupport.getManager(clazz, role);
            List<String> moduleErrorMessages = connectionModuleManager.validateDependencies();
            if (moduleErrorMessages == null || moduleErrorMessages.isEmpty()) continue;
            errorMessages.addAll(moduleErrorMessages);
        }
    }

    private void checkIfDataStoreDriversExist(List<String> errorMessages) {
        this.checkIfJdbcDataStoreDriversExist(errorMessages);
        this.checkIfCustomDataStoreDriversExist(errorMessages);
    }

    private void checkIfJdbcDataStoreDriversExist(List<String> errorMessages) {
        Collection<JdbcDataSource> jdbcDataStores = MgmtFactory.getDataSourceManager().getJdbcDataSources();
        for (JdbcDataSource dataStore : jdbcDataStores) {
            String driverClassName = dataStore.getDriverClass();
            String description = dataStore.getDescription();
            if (ValidationUtil.isValidClassName(driverClassName)) continue;
            errorMessages.add("The '" + description + "' JDBC Data Store's jar file is missing or not loaded. (" + driverClassName + ")");
        }
    }

    private void checkIfCustomDataStoreDriversExist(List<String> errorMessages) {
        Collection<CustomDataSource> customDataStores = MgmtFactory.getDataSourceManager().getXmlCustomDataSources();
        for (CustomDataSource dataStore : customDataStores) {
            String driverClassName = dataStore.getDriverClassName();
            String description = dataStore.getDescription();
            if (ValidationUtil.isValidClassName(driverClassName)) continue;
            errorMessages.add("The '" + description + "' Custom Data Store's jar file is missing or not loaded. (" + driverClassName + ")");
        }
    }

    private void checkIfReferencedCertificateExists(List<String> errorMessages) throws IOException {
        File runPropFile = new File(PropertyInfo.getRunPropertiesLocation());
        String authPropFileName = System.getProperty("ldap.properties.file");
        Properties props = new Properties();
        File authPropFile = new File(runPropFile.getParent(), authPropFileName);
        try (FileInputStream inputStream = new FileInputStream(authPropFile);
             InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
            props.load(reader);
        }
        String clientTlsCertificate = props.getProperty("ldap.clientTlsCertificate");
        if (StringUtils.isNotBlank((String)clientTlsCertificate) && MgmtFactory.getSslAuthPkCertManager().getPkCert(clientTlsCertificate) == null) {
            errorMessages.add("Certificate '" + clientTlsCertificate + "' referenced in '" + authPropFile.getName() + "' was not found in the SSL client keystore");
        }
    }

    private void validateAgainstLicense(List<String> errorMessages) {
        this.validateConnectionsAgainstLicense(errorMessages, Role.IDP);
        this.validateConnectionsAgainstLicense(errorMessages, Role.SP);
    }

    private void validateConnectionsAgainstLicense(List<String> errorMessages, Role role) {
        Collection<Object> connections = Collections.emptyList();
        if (role == Role.IDP) {
            connections = MgmtFactory.getConnectionManager().getAllIdpConnections();
        } else if (role == Role.SP) {
            connections = MgmtFactory.getConnectionManager().getAllSpConnections();
        }
        for (ConnectionBase connectionBase : connections) {
            List<ConnectionModuleConfiguration> moduleConfigurations;
            if (connectionBase.doesWsTrustSettingsExist() && !WSTrustLicenseChecker.isEnabled()) {
                errorMessages.add("Connection '" + connectionBase.getName() + "' is configured to use WS-Trust STS. However, this feature is not enabled via license.");
            }
            if ((moduleConfigurations = connectionBase.getConnectionModuleConfigurations()) == null) continue;
            ConnectionModuleSupport connectionModuleSupport = ConnectionModuleSupport.getInstance();
            for (ConnectionModuleConfiguration moduleConfiguration : moduleConfigurations) {
                ConnectionModuleManager connectionModuleManager = connectionModuleSupport.getManager(moduleConfiguration.getClass(), role);
                if (connectionModuleManager.isEnabledInLicense()) continue;
                errorMessages.add("Connection '" + connectionBase.getName() + "' is configured to use " + connectionModuleManager.getDescription() + ". However, this feature is not enabled via license.");
            }
        }
    }
}

