/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProvider;
import org.sourceid.saml20.domain.mgmt.DeltaReplicationProviderManager;

public class DeltaReplicationProviderManagerImpl
implements DeltaReplicationProviderManager {
    private Map<String, DeltaReplicationProvider> replicationProviders = new ConcurrentHashMap<String, DeltaReplicationProvider>();

    @Override
    public void registerReplicationProvider(DeltaReplicationProvider provider) {
        this.replicationProviders.put(provider.getManagedDirectoryName(), provider);
    }

    @Override
    public Collection<DeltaReplicationProvider> getReplicationProviders() {
        return new ArrayList<DeltaReplicationProvider>(this.replicationProviders.values());
    }

    @Override
    public DeltaReplicationProvider getReplicationProvider(String managedDir) {
        return this.replicationProviders.get(managedDir);
    }

    @Override
    public DeltaReplicationProvider getReplicationProviderByPartialEntryId(String entryId) {
        if (entryId == null) {
            return null;
        }
        return this.replicationProviders.values().stream().filter(provider -> provider.isValidPartialEntry(entryId)).findFirst().orElse(null);
    }

    @Override
    public DeltaReplicationProvider getReplicationProviderByEntryId(String entryId) {
        if (entryId == null) {
            return null;
        }
        return this.replicationProviders.values().stream().filter(provider -> entryId.startsWith(provider.getManagedDirectoryName() + "/")).findFirst().orElse(null);
    }
}

