/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.common.util.PropertyInfo;
import java.security.KeyStore;
import org.sourceid.saml20.domain.mgmt.impl.PkCertAndConnectionCertManagerBase;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class DsigPkCertManager
extends PkCertAndConnectionCertManagerBase {
    @Override
    protected KeyStore getKeystore() {
        return this.certService.getDsigKeystore();
    }

    @Override
    protected KeyStore getHSMKeystore() {
        return this.certService.getDsigHSMKeystore();
    }

    @Override
    protected String getHSMKeystoreName() {
        return PropertyInfo.HSM_MODE.OFF != PropertyInfo.getHSMMode() ? this.coreConfig.getDsigHSMKeystoreName() : null;
    }

    @Override
    protected String getPrivateKeyPassword(String alias) {
        return this.coreConfig.getDsigPrivateKeyPassword(alias);
    }

    @Override
    protected String getHSMPrivateKeyPassword(String alias) {
        return this.coreConfig.getDsigHSMPrivateKeyPassword(alias);
    }

    @Override
    protected void setPrivateKeyPassword(String alias, String password) {
        this.coreConfig.setDsigPrivateKeyPassword(alias, password);
    }

    @Override
    protected void setHSMPrivateKeyPassword(String alias, String password) {
        this.coreConfig.setDsigHSMPrivateKeyPassword(alias, password);
    }

    @Override
    protected void writeKeyStore(KeyStore keystore) {
        this.certService.writeDsigKeystore(keystore);
    }

    @Override
    protected void writeHSMKeyStore(KeyStore keystore) {
        this.certService.writeDsigHSMKeystore(keystore);
    }

    @Override
    public boolean isInUseById(String id) {
        return InUseDetectionUtil.getInstance().isDsigCertInUse(id);
    }
}

