/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.ConfigEventListener;
import com.pingidentity.configservice.Reloadable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.util.domain.Searchable;
import org.sourceid.util.domain.filter.ContainsCriteriaFilter;
import org.sourceid.util.domain.filter.ItemMultiValue;

public class IdpAdapterManagerImpl
implements IdpAdapterManager,
AutoReloadable {
    AdapterManager adapterMgr = MgmtFactory.getAdapterManager();
    private static final Comparator<IdpAuthnAdapterInstance> COMPARE_BY_NAME_DOWN = (adapter1, adapter2) -> adapter1.getName().compareToIgnoreCase(adapter2.getName());

    @Override
    public Collection<IdpAuthnAdapterDescriptor> getInstalledDescriptors() {
        return this.adapterMgr.getInstalledIdpAuthnAdapterDescriptors();
    }

    @Override
    public boolean isDuplicateId(String instanceId) {
        return this.adapterMgr.isDuplicateInstanceId(instanceId);
    }

    @Override
    public Collection<IdpAuthnAdapterInstance> getInstances() {
        return this.adapterMgr.getIdpAuthnAdapterInstances();
    }

    @Override
    public Collection<IdpAuthnAdapterInstance> getNonConnectionBasedInstances() {
        return this.adapterMgr.getIdpAuthnAdapterNonConnectionBasedInstances();
    }

    @Override
    public IdpAuthnAdapterInstance getInstance(String instanceId) {
        return this.adapterMgr.getIdpAuthnAdapterInstance(instanceId);
    }

    @Override
    public void saveInstance(ConfigurablePluginInstance instance) {
        this.adapterMgr.saveIdpAuthnAdapterInstance(instance);
    }

    @Override
    public void deleteInstance(ConfigurablePluginInstance instance) {
        this.adapterMgr.deleteIdpAuthnAdapterInstance(instance);
    }

    @Override
    public boolean isPluginInUse(String pluginId) {
        return this.adapterMgr.isIdpAuthnAdapterInstanceInUse(pluginId);
    }

    @Override
    public boolean isPluginInUseInternally(String pluginId) {
        return this.adapterMgr.isIdpAuthnAdapterInstanceInUseInternally(pluginId);
    }

    @Override
    public boolean isPluginInUseExternally(String pluginId) {
        return this.adapterMgr.isIdpAuthnAdapterInstanceInUseExternally(pluginId);
    }

    @Override
    public IdpAuthnAdapterInstance newInstance() {
        return new IdpAuthnAdapterInstance();
    }

    @Override
    public void loadConfigurations() {
        this.adapterMgr.loadIdpAdapterConfigurations();
    }

    @Override
    public void registerForReloadEvents(Reloadable reloadable) {
        this.adapterMgr.registerForIdpReloadEvents(reloadable);
    }

    @Override
    public void registerForConfigEvents(ConfigEventListener listener) {
        this.adapterMgr.registerForConfigEvents(listener);
    }

    @Override
    public void reload() {
        this.adapterMgr.reloadIdpAdapters();
    }

    @Override
    public boolean supportsPluginHierarchies() {
        return true;
    }

    @Override
    public IdpAuthnAdapterInstance getInstanceWithConnectionOverride(String instanceId, String connectionId) {
        return this.adapterMgr.getIdpAuthnAdapterInstanceWithConnectionOverride(instanceId, connectionId);
    }

    @Override
    public IdpAuthnAdapterInstance getInstance(AuthnSourceKey authnSourceKey) {
        if (authnSourceKey instanceof AdapterAuthnSourceKey) {
            AdapterAuthnSourceKey adapterAuthnSourceKey = (AdapterAuthnSourceKey)authnSourceKey;
            return this.getInstanceWithConnectionOverride(adapterAuthnSourceKey.getId(), adapterAuthnSourceKey.getConnectionId());
        }
        return null;
    }

    @Override
    public List<IdpAuthnAdapterInstance> getCBPOInstances(String instanceId) {
        return this.adapterMgr.getIdpCBPOInstances(instanceId);
    }

    @Override
    public boolean supportsDefaultInstance() {
        return false;
    }

    @Override
    public IdpAuthnAdapterInstance getDefaultInstance() {
        return null;
    }

    @Override
    public void setDefaultInstance(String pluginId) {
    }

    @Override
    public Collection<IdpAuthnAdapterInstance> searchIdpAdapters(Integer page, Integer numberPerPage, String filter) {
        SearchCriteria searchCriteria;
        Searchable<IdpAuthnAdapterInstance> searchable = new Searchable<IdpAuthnAdapterInstance>(){

            @Override
            public SearchResult<IdpAuthnAdapterInstance> search(SearchCriteria searchCriteria) {
                ContainsCriteriaFilter<IdpAuthnAdapterInstance> filter = new ContainsCriteriaFilter<IdpAuthnAdapterInstance>(c -> new ItemMultiValue<IdpAuthnAdapterInstance, String>((IdpAuthnAdapterInstance)c, (K[])new String[]{c.getId(), c.getName()}));
                Collection searchResults = filter.doFilter(searchCriteria.getQuery(), IdpAdapterManagerImpl.this.getNonConnectionBasedInstances().parallelStream().collect(Collectors.toList()));
                if (searchCriteria.getStartIndex() >= searchResults.size()) {
                    return new SearchResult<IdpAuthnAdapterInstance>(searchCriteria.getStartIndex(), Collections.emptyList());
                }
                searchResults = searchResults.parallelStream().sorted(COMPARE_BY_NAME_DOWN).collect(Collectors.toList());
                if (searchCriteria.getItemsRequested() == -1) {
                    return new SearchResult<IdpAuthnAdapterInstance>(0, new ArrayList(searchResults));
                }
                int fromIndex = searchCriteria.getStartIndex();
                int toIndex = searchCriteria.getStartIndex() + searchCriteria.getItemsRequested() >= searchResults.size() ? searchResults.size() : searchCriteria.getStartIndex() + searchCriteria.getItemsRequested();
                return new SearchResult<IdpAuthnAdapterInstance>(searchCriteria.getStartIndex(), new ArrayList(searchResults).subList(fromIndex, toIndex));
            }
        };
        if (page == null) {
            searchCriteria = new SearchCriteria.Builder().query(filter).build();
        } else {
            int fromIndex = (page - 1) * numberPerPage;
            searchCriteria = new SearchCriteria.Builder(fromIndex, numberPerPage).query(filter).build();
        }
        SearchResult adaptersSearchResult = searchable.search(searchCriteria);
        return adaptersSearchResult.getResults();
    }

    @Override
    public Collection<IdpAuthnAdapterInstance> getVirtualInstances() {
        return this.adapterMgr.getIdpAuthnAdapterVirtualInstances();
    }
}

