/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.mgmt.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;

public class JwtIssuer {
    private final String issuerId;
    private final String issuer;
    private final String audience;
    private final String jwksUri;
    private final Collection<String> requiredScopes;
    private final String usernameAttribute;
    private final String roleSearchAttribute;

    public JwtIssuer(String issuerId, String issuer, String audience, String jwksUri, Collection<String> requiredScopes, String usernameAttribute, String roleSearchAttribute) {
        this.issuerId = issuerId;
        this.issuer = issuer;
        this.audience = audience;
        this.jwksUri = jwksUri;
        this.requiredScopes = requiredScopes;
        this.usernameAttribute = usernameAttribute;
        this.roleSearchAttribute = roleSearchAttribute;
    }

    public JwtIssuer(JwtIssuer copy) {
        this.issuerId = copy.issuerId;
        this.issuer = copy.issuer;
        this.audience = copy.audience;
        this.jwksUri = copy.jwksUri;
        this.requiredScopes = copy.requiredScopes;
        this.usernameAttribute = copy.usernameAttribute;
        this.roleSearchAttribute = copy.roleSearchAttribute;
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public Collection<String> getRequiredScopes() {
        return Collections.unmodifiableCollection(this.requiredScopes);
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public String getRoleSearchAttribute() {
        return this.roleSearchAttribute;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator()).append("\tIssuer ID: ").append(StringUtils.defaultIfEmpty((String)this.issuerId, (String)"")).append(System.lineSeparator()).append("\tIssuer: ").append(StringUtils.defaultIfEmpty((String)this.issuer, (String)"")).append(System.lineSeparator()).append("\tAudience: ").append(StringUtils.defaultIfEmpty((String)this.audience, (String)"")).append(System.lineSeparator()).append("\tJWKS Endpoint: ").append(StringUtils.defaultIfEmpty((String)this.jwksUri, (String)"")).append(System.lineSeparator()).append("\tRequired Scopes: ").append(this.requiredScopes).append(System.lineSeparator()).append("\tUsername Attribute: ").append(StringUtils.defaultIfEmpty((String)this.usernameAttribute, (String)"")).append(System.lineSeparator()).append("\tRole Search Attribute: ").append(StringUtils.defaultIfEmpty((String)this.roleSearchAttribute, (String)""));
        return sb.toString();
    }
}

